/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.undo;

import tim.prune.I18nManager;
import tim.prune.UpdateMessageBroker;
import tim.prune.data.AudioClip;
import tim.prune.data.DataPoint;
import tim.prune.data.TrackInfo;
import tim.prune.undo.UndoException;
import tim.prune.undo.UndoOperation;

public class UndoDeleteAudio
implements UndoOperation {
    private int _audioIndex = -1;
    private AudioClip _audio = null;
    private int _pointIndex = -1;
    private DataPoint _point = null;

    public UndoDeleteAudio(AudioClip audioClip, int n, DataPoint dataPoint, int n2) {
        this._audio = audioClip;
        this._audioIndex = n;
        this._point = dataPoint;
        this._pointIndex = n2;
    }

    public String getDescription() {
        return String.valueOf(I18nManager.getText("undo.removeaudio")) + " " + this._audio.getName();
    }

    public void performUndo(TrackInfo trackInfo) throws UndoException {
        trackInfo.getAudioList().addAudio(this._audio, this._audioIndex);
        if (this._point != null) {
            if (!trackInfo.getTrack().insertPoint(this._point, this._pointIndex)) {
                throw new UndoException(this.getDescription());
            }
        } else {
            UpdateMessageBroker.informSubscribers();
        }
        this._audio.setDataPoint(this._point);
        if (this._point != null) {
            this._point.setAudio(this._audio);
        }
    }
}

