/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.gui;

import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import tim.prune.App;
import tim.prune.DataSubscriber;
import tim.prune.FunctionLibrary;
import tim.prune.GenericFunction;
import tim.prune.I18nManager;
import tim.prune.UpdateMessageBroker;
import tim.prune.config.Config;
import tim.prune.data.AudioClip;
import tim.prune.data.Photo;
import tim.prune.data.RecentFile;
import tim.prune.data.RecentFileList;
import tim.prune.data.Selection;
import tim.prune.data.Track;
import tim.prune.data.TrackInfo;
import tim.prune.function.RearrangeWaypointsFunction;
import tim.prune.gui.FunctionLauncher;
import tim.prune.gui.IconManager;
import tim.prune.gui.RecentFileTrigger;

public class MenuManager
implements DataSubscriber {
    private App _app = null;
    private Track _track = null;
    private Selection _selection = null;
    private JMenuItem _sendGpsItem = null;
    private JMenuItem _saveItem = null;
    private JMenuItem _exportKmlItem = null;
    private JMenuItem _exportGpxItem = null;
    private JMenuItem _exportPovItem = null;
    private JMenuItem _exportSvgItem = null;
    private JMenu _recentFileMenu = null;
    private JMenuItem _undoItem = null;
    private JMenuItem _clearUndoItem = null;
    private JMenuItem _editPointItem = null;
    private JMenuItem _editWaypointNameItem = null;
    private JMenuItem _deletePointItem = null;
    private JMenuItem _deleteRangeItem = null;
    private JMenuItem _cropTrackItem = null;
    private JMenuItem _compressItem = null;
    private JMenuItem _markRectangleItem = null;
    private JMenuItem _deleteMarkedPointsItem = null;
    private JMenuItem _interpolateItem = null;
    private JMenuItem _averageItem = null;
    private JMenuItem _selectAllItem = null;
    private JMenuItem _selectNoneItem = null;
    private JMenuItem _selectStartItem = null;
    private JMenuItem _selectEndItem = null;
    private JMenuItem _findWaypointItem = null;
    private JMenuItem _duplicatePointItem = null;
    private JMenuItem _reverseItem = null;
    private JMenuItem _addTimeOffsetItem = null;
    private JMenuItem _addAltitudeOffsetItem = null;
    private JMenuItem _mergeSegmentsItem = null;
    private JMenu _rearrangeMenu = null;
    private JMenuItem _cutAndMoveItem = null;
    private JMenuItem _convertNamesToTimesItem = null;
    private JMenuItem _deleteFieldValuesItem = null;
    private JCheckBoxMenuItem _mapCheckbox = null;
    private JMenuItem _show3dItem = null;
    private JMenu _browserMapMenu = null;
    private JMenuItem _chartItem = null;
    private JMenuItem _getGpsiesItem = null;
    private JMenuItem _uploadGpsiesItem = null;
    private JMenuItem _lookupSrtmItem = null;
    private JMenuItem _lookupWikipediaItem = null;
    private JMenuItem _downloadOsmItem = null;
    private JMenuItem _distanceItem = null;
    private JMenuItem _fullRangeDetailsItem = null;
    private JMenuItem _saveExifItem = null;
    private JMenuItem _photoPopupItem = null;
    private JMenuItem _selectNoPhotoItem = null;
    private JMenuItem _connectPhotoItem = null;
    private JMenuItem _removePhotoItem = null;
    private JMenuItem _disconnectPhotoItem = null;
    private JMenuItem _correlatePhotosItem = null;
    private JMenuItem _rearrangePhotosItem = null;
    private JMenuItem _rotatePhotoLeft = null;
    private JMenuItem _rotatePhotoRight = null;
    private JMenuItem _ignoreExifThumb = null;
    private JMenuItem _connectAudioItem = null;
    private JMenuItem _disconnectAudioItem = null;
    private JMenuItem _removeAudioItem = null;
    private JMenuItem _correlateAudiosItem = null;
    private JMenuItem _selectNoAudioItem = null;
    private JCheckBoxMenuItem _onlineCheckbox = null;
    private JCheckBoxMenuItem _autosaveSettingsCheckbox = null;
    private ActionListener _openFileAction = null;
    private ActionListener _addPhotoAction = null;
    private ActionListener _saveAction = null;
    private ActionListener _undoAction = null;
    private ActionListener _editPointAction = null;
    private ActionListener _deletePointAction = null;
    private ActionListener _selectStartAction = null;
    private ActionListener _selectEndAction = null;
    private JButton _saveButton = null;
    private JButton _undoButton = null;
    private JButton _editPointButton = null;
    private JButton _deletePointButton = null;
    private JButton _deleteRangeButton = null;
    private JButton _cutAndMoveButton = null;
    private JButton _selectStartButton = null;
    private JButton _selectEndButton = null;
    private JButton _connectButton = null;
    private static final int[] KEY_EVENTS = new int[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90};

    public MenuManager(App app, TrackInfo trackInfo) {
        this._app = app;
        this._track = trackInfo.getTrack();
        this._selection = trackInfo.getSelection();
    }

    public JMenuBar createMenuBar() {
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu(I18nManager.getText("menu.file"));
        MenuManager.setAltKey(jMenu, "altkey.menu.file");
        JMenuItem jMenuItem = new JMenuItem(I18nManager.getText("function.open"));
        MenuManager.setShortcut(jMenuItem, "shortcut.menu.file.open");
        this._openFileAction = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MenuManager.this._app.openFile();
            }
        };
        jMenuItem.addActionListener(this._openFileAction);
        jMenu.add(jMenuItem);
        JMenuItem jMenuItem2 = MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_IMPORTBABEL);
        jMenu.add(jMenuItem2);
        JMenuItem jMenuItem3 = new JMenuItem(I18nManager.getText("menu.file.addphotos"));
        this._addPhotoAction = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MenuManager.this._app.addPhotos();
            }
        };
        jMenuItem3.addActionListener(this._addPhotoAction);
        jMenu.add(jMenuItem3);
        JMenuItem jMenuItem4 = MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_LOAD_AUDIO);
        jMenu.add(jMenuItem4);
        this._recentFileMenu = new JMenu(I18nManager.getText("menu.file.recentfiles"));
        this._recentFileMenu.setEnabled(false);
        jMenu.add(this._recentFileMenu);
        jMenu.addSeparator();
        JMenuItem jMenuItem5 = MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_GPSLOAD);
        MenuManager.setShortcut(jMenuItem5, "shortcut.menu.file.load");
        jMenu.add(jMenuItem5);
        this._sendGpsItem = MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_GPSSAVE, false);
        jMenu.add(this._sendGpsItem);
        jMenu.addSeparator();
        this._saveItem = new JMenuItem(I18nManager.getText("menu.file.save"), 83);
        MenuManager.setShortcut(this._saveItem, "shortcut.menu.file.save");
        this._saveAction = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MenuManager.this._app.saveFile();
            }
        };
        this._saveItem.addActionListener(this._saveAction);
        this._saveItem.setEnabled(false);
        jMenu.add(this._saveItem);
        this._exportKmlItem = MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_KMLEXPORT, false);
        jMenu.add(this._exportKmlItem);
        this._exportGpxItem = MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_GPXEXPORT, false);
        jMenu.add(this._exportGpxItem);
        this._exportPovItem = MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_POVEXPORT, false);
        jMenu.add(this._exportPovItem);
        this._exportSvgItem = MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_SVGEXPORT, false);
        jMenu.add(this._exportSvgItem);
        jMenu.addSeparator();
        JMenuItem jMenuItem6 = new JMenuItem(I18nManager.getText("menu.file.exit"));
        jMenuItem6.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MenuManager.this._app.exit();
            }
        });
        jMenu.add(jMenuItem6);
        jMenuBar.add(jMenu);
        JMenu jMenu2 = new JMenu(I18nManager.getText("menu.track"));
        MenuManager.setAltKey(jMenu2, "altkey.menu.track");
        this._undoItem = new JMenuItem(I18nManager.getText("menu.track.undo"));
        MenuManager.setShortcut(this._undoItem, "shortcut.menu.track.undo");
        this._undoAction = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MenuManager.this._app.beginUndo();
            }
        };
        this._undoItem.addActionListener(this._undoAction);
        this._undoItem.setEnabled(false);
        jMenu2.add(this._undoItem);
        this._clearUndoItem = new JMenuItem(I18nManager.getText("menu.track.clearundo"));
        this._clearUndoItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MenuManager.this._app.clearUndo();
            }
        });
        this._clearUndoItem.setEnabled(false);
        jMenu2.add(this._clearUndoItem);
        jMenu2.addSeparator();
        this._compressItem = MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_COMPRESS, false);
        MenuManager.setShortcut(this._compressItem, "shortcut.menu.edit.compress");
        jMenu2.add(this._compressItem);
        this._markRectangleItem = new JMenuItem(I18nManager.getText("menu.track.markrectangle"));
        this._markRectangleItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MenuManager.this._app.setCurrentMode(App.AppMode.DRAWRECT);
                UpdateMessageBroker.informSubscribers();
            }
        });
        this._markRectangleItem.setEnabled(false);
        jMenu2.add(this._markRectangleItem);
        this._deleteMarkedPointsItem = new JMenuItem(I18nManager.getText("menu.track.deletemarked"));
        this._deleteMarkedPointsItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MenuManager.this._app.finishCompressTrack();
            }
        });
        this._deleteMarkedPointsItem.setEnabled(false);
        jMenu2.add(this._deleteMarkedPointsItem);
        jMenu2.addSeparator();
        this._rearrangeMenu = new JMenu(I18nManager.getText("menu.track.rearrange"));
        this._rearrangeMenu.setEnabled(false);
        JMenuItem jMenuItem7 = new JMenuItem(I18nManager.getText("menu.track.rearrange.start"));
        jMenuItem7.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FunctionLibrary.FUNCTION_REARRANGE_WAYPOINTS.rearrangeWaypoints(RearrangeWaypointsFunction.Rearrange.TO_START);
            }
        });
        jMenuItem7.setEnabled(true);
        this._rearrangeMenu.add(jMenuItem7);
        JMenuItem jMenuItem8 = new JMenuItem(I18nManager.getText("menu.track.rearrange.end"));
        jMenuItem8.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FunctionLibrary.FUNCTION_REARRANGE_WAYPOINTS.rearrangeWaypoints(RearrangeWaypointsFunction.Rearrange.TO_END);
            }
        });
        jMenuItem8.setEnabled(true);
        this._rearrangeMenu.add(jMenuItem8);
        JMenuItem jMenuItem9 = new JMenuItem(I18nManager.getText("menu.track.rearrange.nearest"));
        jMenuItem9.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FunctionLibrary.FUNCTION_REARRANGE_WAYPOINTS.rearrangeWaypoints(RearrangeWaypointsFunction.Rearrange.TO_NEAREST);
            }
        });
        jMenuItem9.setEnabled(true);
        this._rearrangeMenu.add(jMenuItem9);
        jMenu2.add(this._rearrangeMenu);
        this._getGpsiesItem = MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_GET_GPSIES, false);
        jMenu2.add(this._getGpsiesItem);
        this._uploadGpsiesItem = MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_UPLOAD_GPSIES, false);
        jMenu2.add(this._uploadGpsiesItem);
        this._lookupSrtmItem = MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_LOOKUP_SRTM, false);
        jMenu2.add(this._lookupSrtmItem);
        this._lookupWikipediaItem = MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_LOOKUP_WIKIPEDIA, false);
        jMenu2.add(this._lookupWikipediaItem);
        JMenuItem jMenuItem10 = MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_SEARCH_WIKIPEDIA);
        jMenu2.add(jMenuItem10);
        this._downloadOsmItem = MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_DOWNLOAD_OSM, false);
        jMenu2.add(this._downloadOsmItem);
        jMenuBar.add(jMenu2);
        JMenu jMenu3 = new JMenu(I18nManager.getText("menu.range"));
        MenuManager.setAltKey(jMenu3, "altkey.menu.range");
        this._selectAllItem = new JMenuItem(I18nManager.getText("menu.range.all"));
        MenuManager.setShortcut(this._selectAllItem, "shortcut.menu.range.all");
        this._selectAllItem.setEnabled(false);
        this._selectAllItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MenuManager.this._selection.selectRange(0, MenuManager.this._track.getNumPoints() - 1);
            }
        });
        jMenu3.add(this._selectAllItem);
        this._selectNoneItem = new JMenuItem(I18nManager.getText("menu.range.none"));
        this._selectNoneItem.setEnabled(false);
        this._selectNoneItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MenuManager.this._app.selectNone();
            }
        });
        jMenu3.add(this._selectNoneItem);
        jMenu3.addSeparator();
        this._selectStartItem = new JMenuItem(I18nManager.getText("menu.range.start"));
        this._selectStartItem.setEnabled(false);
        this._selectStartAction = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MenuManager.this._selection.selectRangeStart();
            }
        };
        this._selectStartItem.addActionListener(this._selectStartAction);
        jMenu3.add(this._selectStartItem);
        this._selectEndItem = new JMenuItem(I18nManager.getText("menu.range.end"));
        this._selectEndItem.setEnabled(false);
        this._selectEndAction = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MenuManager.this._selection.selectRangeEnd();
            }
        };
        this._selectEndItem.addActionListener(this._selectEndAction);
        jMenu3.add(this._selectEndItem);
        jMenu3.addSeparator();
        this._deleteRangeItem = MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_DELETE_RANGE, false);
        jMenu3.add(this._deleteRangeItem);
        this._cropTrackItem = MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_CROP_TRACK, false);
        jMenu3.add(this._cropTrackItem);
        this._reverseItem = new JMenuItem(I18nManager.getText("menu.range.reverse"));
        this._reverseItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MenuManager.this._app.reverseRange();
            }
        });
        this._reverseItem.setEnabled(false);
        jMenu3.add(this._reverseItem);
        this._addTimeOffsetItem = MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_ADD_TIME_OFFSET, false);
        jMenu3.add(this._addTimeOffsetItem);
        this._addAltitudeOffsetItem = MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_ADD_ALTITUDE_OFFSET, false);
        jMenu3.add(this._addAltitudeOffsetItem);
        this._mergeSegmentsItem = new JMenuItem(I18nManager.getText("menu.range.mergetracksegments"));
        this._mergeSegmentsItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MenuManager.this._app.mergeTrackSegments();
            }
        });
        this._mergeSegmentsItem.setEnabled(false);
        jMenu3.add(this._mergeSegmentsItem);
        this._deleteFieldValuesItem = MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_DELETE_FIELD_VALUES, false);
        jMenu3.add(this._deleteFieldValuesItem);
        jMenu3.addSeparator();
        this._interpolateItem = MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_INTERPOLATE, false);
        jMenu3.add(this._interpolateItem);
        this._averageItem = new JMenuItem(I18nManager.getText("menu.range.average"));
        this._averageItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MenuManager.this._app.averageSelection();
            }
        });
        this._averageItem.setEnabled(false);
        jMenu3.add(this._averageItem);
        this._cutAndMoveItem = new JMenuItem(I18nManager.getText("menu.range.cutandmove"));
        this._cutAndMoveItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MenuManager.this._app.cutAndMoveSelection();
            }
        });
        this._cutAndMoveItem.setEnabled(false);
        jMenu3.add(this._cutAndMoveItem);
        this._convertNamesToTimesItem = MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_CONVERT_NAMES_TO_TIMES, false);
        jMenu3.add(this._convertNamesToTimesItem);
        jMenuBar.add(jMenu3);
        JMenu jMenu4 = new JMenu(I18nManager.getText("menu.point"));
        MenuManager.setAltKey(jMenu4, "altkey.menu.point");
        this._editPointItem = new JMenuItem(I18nManager.getText("menu.point.editpoint"));
        this._editPointAction = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MenuManager.this._app.editCurrentPoint();
            }
        };
        this._editPointItem.addActionListener(this._editPointAction);
        this._editPointItem.setEnabled(false);
        jMenu4.add(this._editPointItem);
        this._editWaypointNameItem = MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_EDIT_WAYPOINT_NAME, false);
        jMenu4.add(this._editWaypointNameItem);
        this._deletePointItem = new JMenuItem(I18nManager.getText("menu.point.deletepoint"));
        this._deletePointAction = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MenuManager.this._app.deleteCurrentPoint();
            }
        };
        this._deletePointItem.addActionListener(this._deletePointAction);
        this._deletePointItem.setEnabled(false);
        this._deletePointItem.setAccelerator(KeyStroke.getKeyStroke(127, 0));
        jMenu4.add(this._deletePointItem);
        jMenu4.addSeparator();
        this._findWaypointItem = MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_FIND_WAYPOINT, false);
        jMenu4.add(this._findWaypointItem);
        this._duplicatePointItem = MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_DUPLICATE_POINT, false);
        jMenu4.add(this._duplicatePointItem);
        JMenuItem jMenuItem11 = MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_PASTE_COORDINATES);
        jMenu4.add(jMenuItem11);
        jMenuBar.add(jMenu4);
        JMenu jMenu5 = new JMenu(I18nManager.getText("menu.view"));
        MenuManager.setAltKey(jMenu5, "altkey.menu.view");
        this._mapCheckbox = new JCheckBoxMenuItem(I18nManager.getText("menu.map.showmap"), false);
        this._mapCheckbox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Config.setConfigBoolean("prune.showmap", MenuManager.this._mapCheckbox.isSelected());
                UpdateMessageBroker.informSubscribers((byte)64);
            }
        });
        jMenu5.add(this._mapCheckbox);
        JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(I18nManager.getText("menu.view.showsidebars"));
        jCheckBoxMenuItem.setSelected(true);
        jCheckBoxMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MenuManager.this._app.toggleSidebars();
            }
        });
        jCheckBoxMenuItem.setAccelerator(KeyStroke.getKeyStroke(122, 0));
        jMenu5.add(jCheckBoxMenuItem);
        this._show3dItem = MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_3D, false);
        jMenu5.add(this._show3dItem);
        this._browserMapMenu = new JMenu(I18nManager.getText("menu.view.browser"));
        this._browserMapMenu.setEnabled(false);
        JMenuItem jMenuItem12 = new JMenuItem(I18nManager.getText("menu.view.browser.google"));
        jMenuItem12.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MenuManager.this._app.showExternalMap(0);
            }
        });
        this._browserMapMenu.add(jMenuItem12);
        JMenuItem jMenuItem13 = new JMenuItem(I18nManager.getText("menu.view.browser.openstreetmap"));
        jMenuItem13.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MenuManager.this._app.showExternalMap(1);
            }
        });
        this._browserMapMenu.add(jMenuItem13);
        JMenuItem jMenuItem14 = new JMenuItem(I18nManager.getText("menu.view.browser.mapquest"));
        jMenuItem14.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MenuManager.this._app.showExternalMap(2);
            }
        });
        this._browserMapMenu.add(jMenuItem14);
        JMenuItem jMenuItem15 = new JMenuItem(I18nManager.getText("menu.view.browser.yahoo"));
        jMenuItem15.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MenuManager.this._app.showExternalMap(3);
            }
        });
        this._browserMapMenu.add(jMenuItem15);
        JMenuItem jMenuItem16 = new JMenuItem(I18nManager.getText("menu.view.browser.bing"));
        jMenuItem16.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MenuManager.this._app.showExternalMap(4);
            }
        });
        this._browserMapMenu.add(jMenuItem16);
        jMenu5.add(this._browserMapMenu);
        this._chartItem = MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_CHARTS, false);
        jMenu5.add(this._chartItem);
        this._distanceItem = MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_DISTANCES, false);
        jMenu5.add(this._distanceItem);
        this._fullRangeDetailsItem = MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_FULL_RANGE_DETAILS, false);
        jMenu5.add(this._fullRangeDetailsItem);
        jMenuBar.add(jMenu5);
        JMenu jMenu6 = new JMenu(I18nManager.getText("menu.photo"));
        MenuManager.setAltKey(jMenu6, "altkey.menu.photo");
        jMenuItem3 = new JMenuItem(I18nManager.getText("menu.file.addphotos"));
        jMenuItem3.addActionListener(this._addPhotoAction);
        jMenu6.add(jMenuItem3);
        this._saveExifItem = new JMenuItem(I18nManager.getText("menu.photo.saveexif"));
        this._saveExifItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MenuManager.this._app.saveExif();
            }
        });
        this._saveExifItem.setEnabled(false);
        jMenu6.add(this._saveExifItem);
        this._selectNoPhotoItem = new JMenuItem(I18nManager.getText("menu.range.none"));
        this._selectNoPhotoItem.setEnabled(false);
        this._selectNoPhotoItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MenuManager.this._app.getTrackInfo().selectPhoto(-1);
            }
        });
        jMenu6.add(this._selectNoPhotoItem);
        jMenu6.addSeparator();
        this._connectPhotoItem = MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_CONNECT_TO_POINT, false);
        jMenu6.add(this._connectPhotoItem);
        this._disconnectPhotoItem = MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_DISCONNECT_PHOTO, false);
        jMenu6.add(this._disconnectPhotoItem);
        this._removePhotoItem = MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_REMOVE_PHOTO, false);
        jMenu6.add(this._removePhotoItem);
        this._rotatePhotoLeft = MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_ROTATE_PHOTO_LEFT, false);
        jMenu6.add(this._rotatePhotoLeft);
        this._rotatePhotoRight = MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_ROTATE_PHOTO_RIGHT, false);
        jMenu6.add(this._rotatePhotoRight);
        this._photoPopupItem = MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_PHOTO_POPUP, false);
        jMenu6.add(this._photoPopupItem);
        this._ignoreExifThumb = MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_IGNORE_EXIF_THUMB, false);
        jMenu6.add(this._ignoreExifThumb);
        jMenu6.addSeparator();
        this._correlatePhotosItem = MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_CORRELATE_PHOTOS, false);
        jMenu6.add(this._correlatePhotosItem);
        this._rearrangePhotosItem = MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_REARRANGE_PHOTOS, false);
        jMenu6.add(this._rearrangePhotosItem);
        jMenuBar.add(jMenu6);
        JMenu jMenu7 = new JMenu(I18nManager.getText("menu.audio"));
        MenuManager.setAltKey(jMenu7, "altkey.menu.audio");
        jMenuItem4 = MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_LOAD_AUDIO);
        jMenu7.add(jMenuItem4);
        this._selectNoAudioItem = new JMenuItem(I18nManager.getText("menu.range.none"));
        this._selectNoAudioItem.setEnabled(false);
        this._selectNoAudioItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MenuManager.this._app.getTrackInfo().selectAudio(-1);
            }
        });
        jMenu7.add(this._selectNoAudioItem);
        jMenu7.addSeparator();
        this._connectAudioItem = MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_CONNECT_TO_POINT, false);
        jMenu7.add(this._connectAudioItem);
        this._disconnectAudioItem = MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_DISCONNECT_AUDIO, false);
        jMenu7.add(this._disconnectAudioItem);
        this._removeAudioItem = MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_REMOVE_AUDIO, false);
        jMenu7.add(this._removeAudioItem);
        jMenu7.addSeparator();
        this._correlateAudiosItem = MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_CORRELATE_AUDIOS, false);
        jMenu7.add(this._correlateAudiosItem);
        jMenuBar.add(jMenu7);
        JMenu jMenu8 = new JMenu(I18nManager.getText("menu.settings"));
        MenuManager.setAltKey(jMenu8, "altkey.menu.settings");
        JMenuItem jMenuItem17 = MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_SET_MAP_BG);
        jMenu8.add(jMenuItem17);
        this._onlineCheckbox = new JCheckBoxMenuItem(I18nManager.getText("menu.settings.onlinemode"));
        this._onlineCheckbox.setSelected(Config.getConfigBoolean("prune.onlinemode"));
        this._onlineCheckbox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = MenuManager.this._onlineCheckbox.isSelected();
                Config.setConfigBoolean("prune.onlinemode", bl);
                if (bl) {
                    UpdateMessageBroker.informSubscribers();
                }
            }
        });
        jMenu8.add(this._onlineCheckbox);
        jMenu8.add(MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_SET_DISK_CACHE));
        jMenu8.addSeparator();
        jMenu8.add(MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_SET_KMZ_IMAGE_SIZE));
        jMenu8.add(MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_SET_PATHS));
        jMenu8.add(MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_SET_COLOURS));
        jMenu8.add(MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_SET_LINE_WIDTH));
        jMenu8.add(MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_SET_LANGUAGE));
        jMenu8.addSeparator();
        jMenu8.add(MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_SAVECONFIG));
        this._autosaveSettingsCheckbox = new JCheckBoxMenuItem(I18nManager.getText("menu.settings.autosave"), false);
        this._autosaveSettingsCheckbox.setSelected(Config.getConfigBoolean("prune.autosavesettings"));
        this._autosaveSettingsCheckbox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Config.setConfigBoolean("prune.autosavesettings", MenuManager.this._autosaveSettingsCheckbox.isSelected());
            }
        });
        jMenu8.add(this._autosaveSettingsCheckbox);
        jMenuBar.add(jMenu8);
        JMenu jMenu9 = new JMenu(I18nManager.getText("menu.help"));
        MenuManager.setAltKey(jMenu9, "altkey.menu.help");
        JMenuItem jMenuItem18 = MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_HELP);
        MenuManager.setShortcut(jMenuItem18, "shortcut.menu.help.help");
        jMenu9.add(jMenuItem18);
        jMenu9.add(MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_SHOW_KEYS));
        jMenu9.add(MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_ABOUT));
        jMenu9.add(MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_CHECK_VERSION));
        jMenuBar.add(jMenu9);
        return jMenuBar;
    }

    private static JMenuItem makeMenuItem(GenericFunction genericFunction, boolean bl) {
        JMenuItem jMenuItem = MenuManager.makeMenuItem(genericFunction);
        jMenuItem.setEnabled(bl);
        return jMenuItem;
    }

    private static JMenuItem makeMenuItem(GenericFunction genericFunction) {
        JMenuItem jMenuItem = new JMenuItem(I18nManager.getText(genericFunction.getNameKey()));
        jMenuItem.addActionListener(new FunctionLauncher(genericFunction));
        return jMenuItem;
    }

    private static void setAltKey(JMenu jMenu, String string) {
        int n;
        String string2 = I18nManager.getText(string);
        if (string2 != null && string2.length() == 1 && (n = string2.charAt(0) - 65) >= 0 && n < 26) {
            jMenu.setMnemonic(KEY_EVENTS[n]);
        }
    }

    private static void setShortcut(JMenuItem jMenuItem, String string) {
        int n;
        String string2 = I18nManager.getText(string);
        if (string2 != null && string2.length() == 1 && (n = string2.charAt(0) - 65) >= 0 && n < 26) {
            jMenuItem.setAccelerator(KeyStroke.getKeyStroke(KEY_EVENTS[n], Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        }
    }

    public JToolBar createToolBar() {
        JToolBar jToolBar = new JToolBar();
        JButton jButton = new JButton(IconManager.getImageIcon("add_textfile_icon.png"));
        jButton.setToolTipText(I18nManager.getText("function.open"));
        jButton.addActionListener(this._openFileAction);
        jToolBar.add(jButton);
        JButton jButton2 = new JButton(IconManager.getImageIcon("add_photo_icon.png"));
        jButton2.setToolTipText(I18nManager.getText("menu.file.addphotos"));
        jButton2.addActionListener(this._addPhotoAction);
        jToolBar.add(jButton2);
        this._saveButton = new JButton(IconManager.getImageIcon("save_icon.gif"));
        this._saveButton.setToolTipText(I18nManager.getText("menu.file.save"));
        this._saveButton.addActionListener(this._saveAction);
        this._saveButton.setEnabled(false);
        jToolBar.add(this._saveButton);
        this._undoButton = new JButton(IconManager.getImageIcon("undo_icon.gif"));
        this._undoButton.setToolTipText(I18nManager.getText("menu.track.undo"));
        this._undoButton.addActionListener(this._undoAction);
        this._undoButton.setEnabled(false);
        jToolBar.add(this._undoButton);
        this._editPointButton = new JButton(IconManager.getImageIcon("edit_point_icon.gif"));
        this._editPointButton.setToolTipText(I18nManager.getText("menu.point.editpoint"));
        this._editPointButton.addActionListener(this._editPointAction);
        this._editPointButton.setEnabled(false);
        jToolBar.add(this._editPointButton);
        this._deletePointButton = new JButton(IconManager.getImageIcon("delete_point_icon.gif"));
        this._deletePointButton.setToolTipText(I18nManager.getText("menu.point.deletepoint"));
        this._deletePointButton.addActionListener(this._deletePointAction);
        this._deletePointButton.setEnabled(false);
        jToolBar.add(this._deletePointButton);
        this._deleteRangeButton = new JButton(IconManager.getImageIcon("delete_range_icon.gif"));
        this._deleteRangeButton.setToolTipText(I18nManager.getText("function.deleterange"));
        this._deleteRangeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FunctionLibrary.FUNCTION_DELETE_RANGE.begin();
            }
        });
        this._deleteRangeButton.setEnabled(false);
        jToolBar.add(this._deleteRangeButton);
        this._cutAndMoveButton = new JButton(IconManager.getImageIcon("cut_and_move.gif"));
        this._cutAndMoveButton.setToolTipText(I18nManager.getText("menu.range.cutandmove"));
        this._cutAndMoveButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MenuManager.this._app.cutAndMoveSelection();
            }
        });
        this._cutAndMoveButton.setEnabled(false);
        jToolBar.add(this._cutAndMoveButton);
        this._selectStartButton = new JButton(IconManager.getImageIcon("set_start_icon.png"));
        this._selectStartButton.setToolTipText(I18nManager.getText("menu.range.start"));
        this._selectStartButton.addActionListener(this._selectStartAction);
        this._selectStartButton.setEnabled(false);
        jToolBar.add(this._selectStartButton);
        this._selectEndButton = new JButton(IconManager.getImageIcon("set_end_icon.png"));
        this._selectEndButton.setToolTipText(I18nManager.getText("menu.range.end"));
        this._selectEndButton.addActionListener(this._selectEndAction);
        this._selectEndButton.setEnabled(false);
        jToolBar.add(this._selectEndButton);
        this._connectButton = new JButton(IconManager.getImageIcon("link.gif"));
        this._connectButton.setToolTipText(I18nManager.getText(FunctionLibrary.FUNCTION_CONNECT_TO_POINT.getNameKey()));
        this._connectButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FunctionLibrary.FUNCTION_CONNECT_TO_POINT.begin();
            }
        });
        this._connectButton.setEnabled(false);
        jToolBar.add(this._connectButton);
        jToolBar.setFloatable(false);
        return jToolBar;
    }

    public void informFileLoaded() {
        this._sendGpsItem.setEnabled(true);
        this._saveItem.setEnabled(true);
        this._undoItem.setEnabled(true);
        this._compressItem.setEnabled(true);
        this._deleteMarkedPointsItem.setEnabled(false);
    }

    public void dataUpdated(byte by) {
        block6: {
            RecentFileList recentFileList;
            int n;
            boolean bl = this._track != null && this._track.getNumPoints() > 0;
            this._sendGpsItem.setEnabled(bl);
            this._saveItem.setEnabled(bl);
            this._saveButton.setEnabled(bl);
            this._exportKmlItem.setEnabled(bl);
            this._exportGpxItem.setEnabled(bl);
            this._exportPovItem.setEnabled(bl);
            this._exportSvgItem.setEnabled(bl);
            this._compressItem.setEnabled(bl);
            this._markRectangleItem.setEnabled(bl);
            this._deleteMarkedPointsItem.setEnabled(bl && this._track.hasMarkedPoints());
            this._rearrangeMenu.setEnabled(bl && this._track.hasTrackPoints() && this._track.hasWaypoints());
            this._selectAllItem.setEnabled(bl);
            this._selectNoneItem.setEnabled(bl);
            this._show3dItem.setEnabled(bl);
            this._chartItem.setEnabled(bl);
            this._browserMapMenu.setEnabled(bl);
            this._distanceItem.setEnabled(bl);
            this._getGpsiesItem.setEnabled(bl);
            this._uploadGpsiesItem.setEnabled(bl && this._track.hasTrackPoints());
            this._lookupSrtmItem.setEnabled(bl);
            this._lookupWikipediaItem.setEnabled(bl);
            this._downloadOsmItem.setEnabled(bl);
            this._findWaypointItem.setEnabled(bl && this._track.hasWaypoints());
            boolean bl2 = !this._app.getUndoStack().isEmpty();
            this._undoItem.setEnabled(bl2);
            this._undoButton.setEnabled(bl2);
            this._clearUndoItem.setEnabled(bl2);
            boolean bl3 = bl && this._selection.getCurrentPointIndex() >= 0;
            this._editPointItem.setEnabled(bl3);
            this._editPointButton.setEnabled(bl3);
            this._editWaypointNameItem.setEnabled(bl3);
            this._deletePointItem.setEnabled(bl3);
            this._deletePointButton.setEnabled(bl3);
            this._selectStartItem.setEnabled(bl3);
            this._selectStartButton.setEnabled(bl3);
            this._selectEndItem.setEnabled(bl3);
            this._selectEndButton.setEnabled(bl3);
            this._duplicatePointItem.setEnabled(bl3);
            boolean bl4 = this._app.getTrackInfo().getPhotoList().getNumPhotos() > 0;
            this._saveExifItem.setEnabled(bl4 && this._app.getTrackInfo().getPhotoList().hasMediaWithFile());
            Photo photo = this._app.getTrackInfo().getCurrentPhoto();
            boolean bl5 = photo != null;
            AudioClip audioClip = this._app.getTrackInfo().getCurrentAudio();
            boolean bl6 = audioClip != null;
            boolean bl7 = bl5 && bl3 && photo.getDataPoint() == null || bl6 && bl3 && audioClip.getDataPoint() == null;
            this._connectPhotoItem.setEnabled(bl5 && bl3 && photo.getDataPoint() == null);
            this._connectButton.setEnabled(bl7);
            this._disconnectPhotoItem.setEnabled(bl5 && photo.getDataPoint() != null);
            this._correlatePhotosItem.setEnabled(bl4 && bl);
            this._rearrangePhotosItem.setEnabled(bl4 && bl && this._track.getNumPoints() > 1);
            this._removePhotoItem.setEnabled(bl5);
            this._rotatePhotoLeft.setEnabled(bl5);
            this._rotatePhotoRight.setEnabled(bl5);
            this._photoPopupItem.setEnabled(bl5);
            this._ignoreExifThumb.setEnabled(bl5 && photo.getExifThumbnail() != null);
            this._selectNoPhotoItem.setEnabled(bl5);
            boolean bl8 = this._app.getTrackInfo().getAudioList().getNumAudios() > 0;
            this._selectNoAudioItem.setEnabled(bl6);
            this._removeAudioItem.setEnabled(bl6);
            this._connectAudioItem.setEnabled(bl6 && bl3 && audioClip.getDataPoint() == null);
            this._disconnectAudioItem.setEnabled(bl6 && this._app.getTrackInfo().getCurrentAudio().getDataPoint() != null);
            this._correlateAudiosItem.setEnabled(bl8 && bl);
            boolean bl9 = bl && this._selection.hasRangeSelected();
            this._deleteRangeItem.setEnabled(bl9);
            this._deleteRangeButton.setEnabled(bl9);
            this._cropTrackItem.setEnabled(bl9);
            this._interpolateItem.setEnabled(bl9);
            this._averageItem.setEnabled(bl9);
            this._mergeSegmentsItem.setEnabled(bl9);
            this._reverseItem.setEnabled(bl9);
            this._addTimeOffsetItem.setEnabled(bl9);
            this._addAltitudeOffsetItem.setEnabled(bl9);
            this._convertNamesToTimesItem.setEnabled(bl9 && this._track.hasWaypoints());
            this._deleteFieldValuesItem.setEnabled(bl9);
            this._fullRangeDetailsItem.setEnabled(bl9);
            boolean bl10 = bl9 && bl3 && (this._selection.getCurrentPointIndex() < this._selection.getStart() || this._selection.getCurrentPointIndex() > this._selection.getEnd() + 1);
            this._cutAndMoveItem.setEnabled(bl10);
            this._cutAndMoveButton.setEnabled(bl10);
            boolean bl11 = Config.getConfigBoolean("prune.showmap");
            if (this._mapCheckbox.isSelected() != bl11) {
                this._mapCheckbox.setSelected(bl11);
            }
            boolean bl12 = (n = (recentFileList = Config.getRecentFileList()).getNumEntries()) > 0;
            this._recentFileMenu.setEnabled(bl12);
            if (!bl12) break block6;
            int n2 = this._recentFileMenu.getMenuComponentCount();
            if (n2 == n) {
                int n3 = 0;
                while (n3 < n) {
                    JMenuItem jMenuItem = this._recentFileMenu.getItem(n3);
                    jMenuItem.setText(recentFileList.getFile(n3) == null ? "" : recentFileList.getFile(n3).getFile().getName());
                    jMenuItem.setToolTipText(recentFileList.getFile(n3) == null ? null : recentFileList.getFile(n3).getFile().getAbsolutePath());
                    ++n3;
                }
            } else {
                this._recentFileMenu.removeAll();
                int n4 = 0;
                while (n4 < recentFileList.getSize()) {
                    RecentFile recentFile = recentFileList.getFile(n4);
                    if (recentFile != null && recentFile.isValid()) {
                        JMenuItem jMenuItem = new JMenuItem(recentFile.getFile().getName());
                        jMenuItem.setToolTipText(recentFile.getFile().getAbsolutePath());
                        jMenuItem.addActionListener(new RecentFileTrigger(this._app, n4));
                        this._recentFileMenu.add(jMenuItem);
                    }
                    ++n4;
                }
            }
        }
    }

    public void actionCompleted(String string) {
    }
}

