/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function.cache;

public class RowInfo {
    private int _zoom = -1;
    private int _minZoom = -1;
    private int _maxZoom = -1;
    private int _numTiles = 0;
    private long _totalSize = 0L;
    private boolean _unexpected = false;

    public void setZoom(int n) {
        this._zoom = n;
    }

    public void addZoom(int n) {
        if (this._minZoom < 0 || this._minZoom > n) {
            this._minZoom = n;
        }
        if (this._maxZoom < n) {
            this._maxZoom = n;
        }
    }

    public int getZoom() {
        return this._zoom;
    }

    public String getZoomRange() {
        if (this._minZoom < 0 && this._maxZoom < 0) {
            return "";
        }
        if (this._minZoom == this._maxZoom || this._maxZoom < 0) {
            return "" + this._minZoom;
        }
        if (this._minZoom < 0) {
            return "" + this._maxZoom;
        }
        return this._minZoom + " - " + this._maxZoom;
    }

    public void addTile(long l) {
        this.addTiles(1, l);
    }

    public void addTiles(int n, long l) {
        this._numTiles += n;
        this._totalSize += l;
    }

    public int getNumTiles() {
        return this._numTiles;
    }

    public long getTotalSize() {
        return this._totalSize;
    }

    public void foundUnexpected() {
        this._unexpected = true;
    }

    public boolean wasUnexpected() {
        return this._unexpected;
    }

    public void addRow(RowInfo rowInfo) {
        if (rowInfo == null) {
            return;
        }
        this._numTiles += rowInfo._numTiles;
        this._totalSize += rowInfo._totalSize;
        if (rowInfo._minZoom > 0) {
            this.addZoom(rowInfo._minZoom);
        }
        if (rowInfo._maxZoom > 0) {
            this.addZoom(rowInfo._maxZoom);
        }
        if (rowInfo._zoom > 0) {
            this.addZoom(rowInfo._zoom);
        }
        this._unexpected = this._unexpected || rowInfo._unexpected;
    }
}

