/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import tim.prune.App;
import tim.prune.GenericFunction;
import tim.prune.I18nManager;
import tim.prune.data.DataPoint;
import tim.prune.data.SourceInfo;
import tim.prune.data.Track;
import tim.prune.load.TrackNameList;

public class SelectTracksFunction
extends GenericFunction {
    private Track _track = null;
    private SourceInfo _sourceInfo = null;
    private TrackNameList _trackNameList = null;
    private JDialog _dialog = null;
    private JList _trackList = null;

    public SelectTracksFunction(App app, Track track, SourceInfo sourceInfo, TrackNameList trackNameList) {
        super(app);
        this._track = track;
        this._sourceInfo = sourceInfo;
        this._trackNameList = trackNameList;
    }

    public void begin() {
        this._dialog = new JDialog((Frame)this._parentFrame, I18nManager.getText("function.open"));
        this._dialog.setLocationRelativeTo(this._parentFrame);
        this._dialog.getContentPane().add(this.makeContents());
        this._dialog.pack();
        this._dialog.setVisible(true);
        this.selectAll();
    }

    private Component makeContents() {
        Object object;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)new JLabel(I18nManager.getText("dialog.selecttracks.intro")), "North");
        int n = this._trackNameList.getNumTracks();
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            object = this._trackNameList.getTrackName(n2);
            if (object == null || ((String)object).equals("")) {
                object = I18nManager.getText("dialog.selecttracks.noname");
            }
            stringArray[n2] = String.valueOf(object) + " (" + this._trackNameList.getNumPointsInTrack(n2) + ")";
            ++n2;
        }
        this._trackList = new JList<String>(stringArray);
        this._trackList.setSelectionMode(2);
        jPanel.add((Component)new JScrollPane(this._trackList), "Center");
        JButton jButton = new JButton(I18nManager.getText("button.selectall"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SelectTracksFunction.this.selectAll();
            }
        });
        object = new JPanel();
        ((Container)object).add(jButton);
        jPanel.add((Component)object, "East");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(2));
        JButton jButton2 = new JButton(I18nManager.getText("button.ok"));
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SelectTracksFunction.this.finish();
            }
        });
        jPanel2.add(jButton2);
        JButton jButton3 = new JButton(I18nManager.getText("button.cancel"));
        jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SelectTracksFunction.this._dialog.dispose();
                SelectTracksFunction.this._app.informNoDataLoaded();
            }
        });
        jPanel2.add(jButton3);
        jPanel.add((Component)jPanel2, "South");
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 15));
        return jPanel;
    }

    public String getNameKey() {
        return "dialog.selecttracks";
    }

    private void selectAll() {
        this._trackList.setSelectionInterval(0, this._trackNameList.getNumTracks() - 1);
    }

    private void finish() {
        this._dialog.dispose();
        int[] nArray = this._trackList.getSelectedIndices();
        if (nArray.length == this._trackNameList.getNumTracks()) {
            this._app.informDataLoaded(this._track, this._sourceInfo);
        } else {
            int n;
            boolean[] blArray = new boolean[this._trackNameList.getNumTracks()];
            int n2 = 0;
            while (n2 < nArray.length) {
                blArray[nArray[n2]] = true;
                ++n2;
            }
            n2 = 0;
            int n3 = -1;
            int n4 = this._track.getNumPoints();
            boolean[] blArray2 = new boolean[n4];
            int n5 = 0;
            while (n5 < n4) {
                n = this._trackNameList.getStartIndex(n3 + 1);
                if (n5 == n) {
                    ++n3;
                }
                if (n3 < 0 || blArray[n3] || this._track.getPoint(n5).isWaypoint()) {
                    blArray2[n5] = true;
                    ++n2;
                }
                ++n5;
            }
            if (n2 <= 0) {
                this._app.informNoDataLoaded();
            } else {
                DataPoint[] dataPointArray = new DataPoint[n2];
                n = 0;
                int n6 = 0;
                while (n6 < n4) {
                    if (blArray2[n6]) {
                        dataPointArray[n] = this._track.getPoint(n6);
                        ++n;
                    }
                    ++n6;
                }
                Track track = new Track(this._track.getFieldList(), dataPointArray);
                this._sourceInfo.setPointIndices(blArray2);
                this._app.informDataLoaded(track, this._sourceInfo);
            }
        }
    }
}

