/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function;

import javax.swing.JOptionPane;
import tim.prune.App;
import tim.prune.GenericFunction;
import tim.prune.I18nManager;
import tim.prune.data.DataPoint;
import tim.prune.data.Track;
import tim.prune.undo.UndoInterpolate;
import tim.prune.undo.UndoOperation;

public class InterpolateFunction
extends GenericFunction {
    public InterpolateFunction(App app) {
        super(app);
    }

    public String getNameKey() {
        return "function.interpolate";
    }

    public void begin() {
        Object object;
        Object object2;
        int n = this._app.getTrackInfo().getSelection().getStart();
        int n2 = this._app.getTrackInfo().getSelection().getEnd();
        boolean bl = false;
        if (!InterpolateFunction.selectedRangeHasTrackpoints(this._app.getTrackInfo().getTrack(), n, n2)) {
            int n3 = JOptionPane.showConfirmDialog(this._parentFrame, I18nManager.getText("dialog.interpolate.betweenwaypoints"), I18nManager.getText(this.getNameKey()), 0);
            if (n3 == 1) {
                return;
            }
            bl = true;
        }
        if ((object2 = JOptionPane.showInputDialog(this._parentFrame, I18nManager.getText("dialog.interpolate.parameter.text"), I18nManager.getText(this.getNameKey()), 3, null, null, "")) == null) {
            return;
        }
        int n4 = InterpolateFunction.parseNumber(object2);
        if (n4 <= 0 || n4 > 1000) {
            this._app.showErrorMessage(this.getNameKey(), "error.interpolate.invalidparameter");
            return;
        }
        if (n < 0 || n2 < 0 || n2 <= n) {
            return;
        }
        Track track = this._app.getTrackInfo().getTrack();
        int n5 = (n2 - n) * n4;
        int n6 = track.getNumPoints() + n5;
        DataPoint[] dataPointArray = track.cloneContents();
        DataPoint[] dataPointArray2 = new DataPoint[n6];
        System.arraycopy(dataPointArray, 0, dataPointArray2, 0, n);
        int n7 = n;
        DataPoint dataPoint = null;
        int n8 = n;
        while (n8 <= n2) {
            DataPoint dataPoint2 = this._app.getTrackInfo().getTrack().getPoint(n8);
            if (dataPoint != null && (dataPoint2.isWaypoint() && bl || !dataPoint2.isWaypoint() && !dataPoint2.getSegmentStart())) {
                object = dataPoint.interpolate(dataPoint2, n4);
                System.arraycopy(object, 0, dataPointArray2, n7, n4);
                n7 += n4;
            }
            dataPointArray2[n7] = dataPoint2;
            ++n7;
            if (!dataPoint2.isWaypoint() || bl) {
                dataPoint = dataPoint2;
            } else if (!dataPoint2.isWaypoint()) {
                dataPoint = null;
            }
            ++n8;
        }
        n8 = n7 - n2 - 1;
        System.arraycopy(dataPointArray, n2, dataPointArray2, n7 - 1, track.getNumPoints() - n2);
        int n9 = track.getNumPoints() + n8;
        if (n9 != dataPointArray2.length) {
            object = new DataPoint[n9];
            System.arraycopy(dataPointArray2, 0, object, 0, n9);
            dataPointArray2 = object;
        }
        object = new UndoInterpolate(this._app.getTrackInfo(), n8);
        if (track.replaceContents(dataPointArray2)) {
            this._app.completeFunction((UndoOperation)object, I18nManager.getText("confirm.interpolate"));
            this._app.getTrackInfo().getSelection().selectRange(n, n2 + n8);
        }
    }

    private static boolean selectedRangeHasTrackpoints(Track track, int n, int n2) {
        int n3 = n;
        while (n3 <= n2) {
            DataPoint dataPoint = track.getPoint(n3);
            if (dataPoint != null && !dataPoint.isWaypoint()) {
                return true;
            }
            ++n3;
        }
        return false;
    }

    private static int parseNumber(Object object) {
        int n = 0;
        if (object != null) {
            try {
                n = Integer.parseInt(object.toString());
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return n;
    }
}

