/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function;

import java.io.File;
import tim.prune.App;
import tim.prune.GenericFunction;
import tim.prune.I18nManager;
import tim.prune.UpdateMessageBroker;
import tim.prune.data.AudioClip;
import tim.prune.data.MediaObject;
import tim.prune.data.Photo;
import tim.prune.data.Track;
import tim.prune.function.Cancellable;
import tim.prune.load.MediaHelper;
import tim.prune.load.MediaLoadProgressDialog;
import tim.prune.undo.UndoLoadAudios;
import tim.prune.undo.UndoLoadPhotos;

public class AsyncMediaLoader
extends GenericFunction
implements Runnable,
Cancellable {
    private File _zipFile = null;
    private String[] _linkArray = null;
    private Track _track = null;
    private File _sourceFile = null;
    private boolean _cancelled = false;

    public AsyncMediaLoader(App app, File file, String[] stringArray, Track track, File file2) {
        super(app);
        this._zipFile = file;
        this._linkArray = stringArray;
        this._track = track;
        this._sourceFile = file2;
    }

    public void begin() {
        this._cancelled = false;
        if (this._linkArray != null) {
            new Thread(this).start();
        }
    }

    public void cancel() {
        this._cancelled = true;
    }

    public String getNameKey() {
        return "function.asyncmediaload";
    }

    public void run() {
        int n = 0;
        int n2 = 0;
        while (n2 < this._linkArray.length) {
            if (this._linkArray[n2] != null) {
                ++n;
            }
            ++n2;
        }
        if (n <= 0) {
            return;
        }
        MediaLoadProgressDialog mediaLoadProgressDialog = new MediaLoadProgressDialog(this._app.getFrame(), this);
        MediaObject[] mediaObjectArray = new MediaObject[n];
        int n3 = 0;
        int n4 = 0;
        while (n4 < this._linkArray.length && !this._cancelled) {
            if (this._linkArray[n4] != null) {
                MediaObject mediaObject = MediaHelper.createMediaObject(this._zipFile, this._linkArray[n4], this._sourceFile);
                if (mediaObject != null) {
                    this._track.getPoint(n4).attachMedia(mediaObject);
                    mediaObject.setOriginalStatus(MediaObject.Status.TAGGED);
                    mediaObject.setCurrentStatus(MediaObject.Status.TAGGED);
                    mediaObjectArray[n3] = mediaObject;
                    if (!this._app.isBusyLoading()) {
                        mediaLoadProgressDialog.showProgress(n3, n);
                    }
                    ++n3;
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
            ++n4;
        }
        mediaLoadProgressDialog.close();
        this.waitUntilAppReady();
        n4 = 0;
        int n5 = 0;
        n3 = 0;
        while (n3 < n) {
            MediaObject mediaObject = mediaObjectArray[n3];
            if (mediaObject != null && this._track.containsPoint(mediaObject.getDataPoint())) {
                if (mediaObject instanceof Photo) {
                    this._app.getTrackInfo().getPhotoList().addPhoto((Photo)mediaObject);
                    ++n4;
                } else if (mediaObject instanceof AudioClip) {
                    this._app.getTrackInfo().getAudioList().addAudio((AudioClip)mediaObject);
                    ++n5;
                }
            }
            ++n3;
        }
        if (n4 > 0) {
            this._app.completeFunction(new UndoLoadPhotos(n4, 0), n4 + " " + I18nManager.getText(n4 == 1 ? "confirm.jpegload.single" : "confirm.jpegload.multi"));
        }
        if (n5 > 0) {
            this._app.completeFunction(new UndoLoadAudios(n5), I18nManager.getText("confirm.audioload"));
        }
        UpdateMessageBroker.informSubscribers((byte)1);
    }

    private void waitUntilAppReady() {
        long l = 500L;
        while (this._app.isBusyLoading()) {
            try {
                Thread.sleep(l);
            }
            catch (InterruptedException interruptedException) {}
            l = (long)((double)l * 1.2);
        }
    }
}

