/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import tim.prune.I18nManager;
import tim.prune.function.SetMapBgFunction;
import tim.prune.gui.map.CloudmadeMapSource;
import tim.prune.gui.map.MapSource;
import tim.prune.gui.map.MapSourceLibrary;
import tim.prune.gui.map.OsmMapSource;

public class AddMapSourceDialog {
    private SetMapBgFunction _parent = null;
    private JDialog _addDialog = null;
    private JRadioButton[] _sourceTypeRadios = null;
    private JPanel _cards = null;
    private MapSource _originalSource = null;
    private JTextField _oNameField = null;
    private JTextField _baseUrlField = null;
    private JTextField _topUrlField = null;
    private JRadioButton[] _baseTypeRadios = null;
    private JRadioButton[] _topTypeRadios = null;
    private JComboBox _oZoomCombo = null;
    private JTextField _cNameField = null;
    private JTextField _cStyleField = null;
    private JComboBox _cZoomCombo = null;
    private JButton _okButton = null;
    private static final String[] FILE_TYPES = new String[]{"png", "jpg", "gif"};

    public AddMapSourceDialog(JDialog jDialog, SetMapBgFunction setMapBgFunction) {
        this._parent = setMapBgFunction;
        this._addDialog = new JDialog(jDialog, I18nManager.getText("dialog.addmapsource.title"), true);
        this._addDialog.add(this.makeDialogComponents());
        this._addDialog.setLocationRelativeTo(jDialog);
        this._addDialog.pack();
    }

    private Component makeDialogComponents() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        ButtonGroup buttonGroup = new ButtonGroup();
        jPanel2.setLayout(new GridLayout(1, 0));
        this._sourceTypeRadios = new JRadioButton[2];
        this._sourceTypeRadios[0] = new JRadioButton("Openstreetmap");
        buttonGroup.add(this._sourceTypeRadios[0]);
        jPanel2.add(this._sourceTypeRadios[0]);
        this._sourceTypeRadios[1] = new JRadioButton("Cloudmade");
        buttonGroup.add(this._sourceTypeRadios[1]);
        jPanel2.add(this._sourceTypeRadios[1]);
        this._sourceTypeRadios[0].setSelected(true);
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AddMapSourceDialog.this.onRadioClicked();
            }
        };
        this._sourceTypeRadios[0].addActionListener(actionListener);
        this._sourceTypeRadios[1].addActionListener(actionListener);
        jPanel2.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel.add((Component)jPanel2, "North");
        this._cards = new JPanel();
        this._cards.setLayout(new CardLayout());
        KeyAdapter keyAdapter = new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                super.keyReleased(keyEvent);
                AddMapSourceDialog.this.enableOK();
            }
        };
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout());
        jPanel3.setBorder(BorderFactory.createEmptyBorder(6, 3, 4, 3));
        JPanel jPanel4 = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel4.setLayout(gridBagLayout);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.ipadx = 3;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        gridBagConstraints.anchor = 23;
        jPanel4.add((Component)new JLabel(I18nManager.getText("dialog.addmapsource.sourcename")), gridBagConstraints);
        this._oNameField = new JTextField(18);
        this._oNameField.addKeyListener(keyAdapter);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        jPanel4.add((Component)this._oNameField, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel4.add((Component)new JLabel(I18nManager.getText("dialog.addmapsource.layer1url")), gridBagConstraints);
        this._baseUrlField = new JTextField(18);
        this._baseUrlField.addKeyListener(keyAdapter);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        jPanel4.add((Component)this._baseUrlField, gridBagConstraints);
        this._baseTypeRadios = new JRadioButton[3];
        buttonGroup = new ButtonGroup();
        int n = 0;
        while (n < 3) {
            this._baseTypeRadios[n] = new JRadioButton(FILE_TYPES[n]);
            buttonGroup.add(this._baseTypeRadios[n]);
            gridBagConstraints.gridx = 2 + n;
            gridBagConstraints.weightx = 0.0;
            jPanel4.add((Component)this._baseTypeRadios[n], gridBagConstraints);
            ++n;
        }
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        jPanel4.add((Component)new JLabel(I18nManager.getText("dialog.addmapsource.layer2url")), gridBagConstraints);
        this._topUrlField = new JTextField(18);
        this._topUrlField.addKeyListener(keyAdapter);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        jPanel4.add((Component)this._topUrlField, gridBagConstraints);
        this._topTypeRadios = new JRadioButton[3];
        buttonGroup = new ButtonGroup();
        n = 0;
        while (n < 3) {
            this._topTypeRadios[n] = new JRadioButton(FILE_TYPES[n]);
            buttonGroup.add(this._topTypeRadios[n]);
            gridBagConstraints.gridx = 2 + n;
            gridBagConstraints.weightx = 0.0;
            jPanel4.add((Component)this._topTypeRadios[n], gridBagConstraints);
            ++n;
        }
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        jPanel4.add((Component)new JLabel(I18nManager.getText("dialog.addmapsource.maxzoom")), gridBagConstraints);
        this._oZoomCombo = new JComboBox();
        n = 10;
        while (n <= 20) {
            this._oZoomCombo.addItem("" + n);
            ++n;
        }
        gridBagConstraints.gridx = 1;
        jPanel4.add((Component)this._oZoomCombo, gridBagConstraints);
        jPanel3.add((Component)jPanel4, "North");
        this._cards.add((Component)jPanel3, "card1");
        JPanel jPanel5 = new JPanel();
        jPanel5.setBorder(BorderFactory.createEmptyBorder(6, 3, 4, 3));
        jPanel5.setLayout(new BorderLayout());
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new GridLayout(0, 2, 5, 5));
        jPanel6.add(new JLabel(I18nManager.getText("dialog.addmapsource.sourcename")));
        this._cNameField = new JTextField(18);
        this._cNameField.addKeyListener(keyAdapter);
        jPanel6.add(this._cNameField);
        jPanel6.add(new JLabel(I18nManager.getText("dialog.addmapsource.cloudstyle")));
        this._cStyleField = new JTextField(18);
        this._cStyleField.addKeyListener(keyAdapter);
        jPanel6.add(this._cStyleField);
        jPanel6.add(new JLabel(I18nManager.getText("dialog.addmapsource.maxzoom")));
        this._cZoomCombo = new JComboBox();
        int n2 = 10;
        while (n2 <= 20) {
            this._cZoomCombo.addItem("" + n2);
            ++n2;
        }
        jPanel6.add(this._cZoomCombo);
        jPanel5.add((Component)jPanel6, "North");
        this._cards.add((Component)jPanel5, "card2");
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new BorderLayout());
        jPanel7.add((Component)this._cards, "North");
        jPanel.add((Component)jPanel7, "Center");
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout(new FlowLayout(2));
        this._okButton = new JButton(I18nManager.getText("button.ok"));
        ActionListener actionListener2 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AddMapSourceDialog.this.finish();
            }
        };
        this._okButton.addActionListener(actionListener2);
        jPanel8.add(this._okButton);
        JButton jButton = new JButton(I18nManager.getText("button.cancel"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AddMapSourceDialog.this._addDialog.dispose();
            }
        });
        jPanel8.add(jButton);
        jPanel.add((Component)jPanel8, "South");
        return jPanel;
    }

    public void showDialog(MapSource mapSource) {
        this._originalSource = mapSource;
        this.populateFields();
    }

    private void clearAllFields() {
        this._oNameField.setText("");
        this._baseUrlField.setText("");
        this._baseTypeRadios[0].setSelected(true);
        this._topUrlField.setText("");
        this._topTypeRadios[0].setSelected(true);
        this._oZoomCombo.setSelectedIndex(8);
        this._cNameField.setText("");
        this._cStyleField.setText("");
        this._cZoomCombo.setSelectedIndex(8);
        this._okButton.setEnabled(false);
        int n = 0;
        while (n < 2) {
            this._sourceTypeRadios[n].setEnabled(true);
            ++n;
        }
        this._addDialog.setVisible(true);
    }

    private void populateFields() {
        OsmMapSource osmMapSource;
        if (this._originalSource == null) {
            this.clearAllFields();
            return;
        }
        boolean bl = false;
        try {
            osmMapSource = (CloudmadeMapSource)this._originalSource;
            bl = true;
            this._cNameField.setText(osmMapSource.getName());
            this._cStyleField.setText(((CloudmadeMapSource)osmMapSource).getStyle());
            this._cZoomCombo.setSelectedIndex(AddMapSourceDialog.getZoomIndex(osmMapSource.getMaxZoomLevel()));
            this._sourceTypeRadios[1].setSelected(true);
        }
        catch (ClassCastException classCastException) {}
        if (!bl) {
            try {
                osmMapSource = (OsmMapSource)this._originalSource;
                bl = true;
                this._oNameField.setText(osmMapSource.getName());
                this._baseUrlField.setText(osmMapSource.getBaseUrl(0));
                int n = AddMapSourceDialog.getBaseType(osmMapSource.getFileExtension(0));
                this._baseTypeRadios[n].setSelected(true);
                this._topUrlField.setText(osmMapSource.getNumLayers() == 0 ? "" : osmMapSource.getBaseUrl(1));
                int n2 = AddMapSourceDialog.getBaseType(osmMapSource.getFileExtension(1));
                this._topTypeRadios[n2].setSelected(true);
                this._oZoomCombo.setSelectedIndex(AddMapSourceDialog.getZoomIndex(osmMapSource.getMaxZoomLevel()));
                this._sourceTypeRadios[0].setSelected(true);
            }
            catch (ClassCastException classCastException) {}
        }
        int n = 0;
        while (n < 2) {
            this._sourceTypeRadios[n].setEnabled(false);
            ++n;
        }
        this.onRadioClicked();
        this._okButton.setEnabled(false);
        this._addDialog.setVisible(true);
    }

    private void onRadioClicked() {
        CardLayout cardLayout = (CardLayout)this._cards.getLayout();
        if (this._sourceTypeRadios[0].isSelected()) {
            cardLayout.first(this._cards);
        } else {
            cardLayout.last(this._cards);
        }
        this.enableOK();
    }

    private void enableOK() {
        boolean bl = false;
        if (this._sourceTypeRadios[0].isSelected()) {
            bl = this.isOsmPanelOk();
        }
        if (this._sourceTypeRadios[1].isSelected()) {
            bl = this.isCloudPanelOk();
        }
        this._okButton.setEnabled(bl);
    }

    private boolean isOsmPanelOk() {
        boolean bl = this._oNameField.getText().trim().length() > 1;
        String string = null;
        String string2 = null;
        String string3 = this._baseUrlField.getText().trim();
        string = MapSource.fixBaseUrl(string3);
        if (string3.length() > 0 && string == null) {
            bl = false;
        }
        String string4 = this._topUrlField.getText().trim();
        string2 = MapSource.fixBaseUrl(string4);
        if (string4.length() > 0 && string2 == null) {
            bl = false;
        }
        return bl && (string != null || string2 != null);
    }

    private boolean isCloudPanelOk() {
        boolean bl = this._cNameField.getText().trim().length() > 1;
        int n = 0;
        try {
            n = Integer.parseInt(this._cStyleField.getText());
        }
        catch (NumberFormatException numberFormatException) {}
        return bl && n > 0;
    }

    private void finish() {
        String string;
        OsmMapSource osmMapSource = null;
        String string2 = string = this._originalSource == null ? null : this._originalSource.getName();
        if (this._sourceTypeRadios[0].isSelected()) {
            String string3 = AddMapSourceDialog.getValidSourcename(this._oNameField.getText(), string);
            String string4 = this._baseUrlField.getText().trim();
            String string5 = this.getFileExtension(this._baseTypeRadios);
            String string6 = this._topUrlField.getText().trim();
            String string7 = this.getFileExtension(this._topTypeRadios);
            osmMapSource = new OsmMapSource(string3, string4, string5, string6, string7, this._oZoomCombo.getSelectedIndex() + 10);
        } else if (this._sourceTypeRadios[1].isSelected()) {
            String string8 = AddMapSourceDialog.getValidSourcename(this._cNameField.getText(), string);
            osmMapSource = new CloudmadeMapSource(string8, this._cStyleField.getText(), this._cZoomCombo.getSelectedIndex() + 10);
        }
        if (osmMapSource != null) {
            if (this._originalSource == null) {
                MapSourceLibrary.addSource(osmMapSource);
            } else {
                MapSourceLibrary.editSource(this._originalSource, osmMapSource);
            }
            this._parent.updateList();
            this._addDialog.setVisible(false);
        }
    }

    private static String getValidSourcename(String string, String string2) {
        String string3 = string;
        string3 = string3 == null ? "" : string3.trim();
        if (string3.equals("")) {
            string3 = I18nManager.getText("dialog.addmapsource.noname");
        }
        if ((string2 == null || !string2.equals(string3)) && MapSourceLibrary.hasSourceName(string3)) {
            int n = 1;
            while (MapSourceLibrary.hasSourceName(String.valueOf(string3) + n)) {
                ++n;
            }
            string3 = String.valueOf(string3) + n;
        }
        return string3;
    }

    private String getFileExtension(JRadioButton[] jRadioButtonArray) {
        if (jRadioButtonArray != null) {
            int n = 0;
            while (n < jRadioButtonArray.length) {
                if (jRadioButtonArray[n] != null && jRadioButtonArray[n].isSelected()) {
                    return FILE_TYPES[n];
                }
                ++n;
            }
        }
        return FILE_TYPES[0];
    }

    private static int getBaseType(String string) {
        int n = 0;
        while (n < FILE_TYPES.length) {
            if (FILE_TYPES[n].equals(string)) {
                return n;
            }
            ++n;
        }
        return 0;
    }

    private static int getZoomIndex(int n) {
        return Math.max(0, n - 10);
    }
}

