/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.data;

import tim.prune.config.Config;
import tim.prune.data.Altitude;
import tim.prune.data.DataPoint;
import tim.prune.data.Distance;
import tim.prune.data.Field;
import tim.prune.data.SpeedValue;
import tim.prune.data.Timestamp;
import tim.prune.data.Track;

public abstract class SpeedCalculator {
    public static void calculateSpeed(Track track, int n, SpeedValue speedValue) {
        if (track == null || n < 0 || speedValue == null) {
            System.err.println("Cannot calculate speed for index " + n);
            return;
        }
        speedValue.setInvalid();
        DataPoint dataPoint = track.getPoint(n);
        if (dataPoint == null) {
            return;
        }
        boolean bl = false;
        double d = 0.0;
        String string = dataPoint.getFieldValue(Field.SPEED);
        try {
            d = Double.parseDouble(string);
            bl = true;
        }
        catch (Exception exception) {}
        if (!bl && dataPoint.hasTimestamp() && !dataPoint.isWaypoint()) {
            boolean bl2;
            double d2 = 0.0;
            int n2 = n - 1;
            DataPoint dataPoint2 = null;
            DataPoint dataPoint3 = dataPoint;
            Timestamp timestamp = dataPoint.getTimestamp();
            boolean bl3 = false;
            if (!dataPoint.getSegmentStart()) {
                do {
                    boolean bl4 = (dataPoint2 = track.getPoint(n2)) != null && dataPoint2.hasTimestamp() && !dataPoint2.getTimestamp().isAfter(dataPoint.getTimestamp());
                    boolean bl5 = bl2 = bl4 && !dataPoint2.isWaypoint();
                    if (bl2) {
                        d2 += DataPoint.calculateRadiansBetween(dataPoint2, dataPoint3);
                        timestamp = dataPoint2.getTimestamp();
                    }
                    bl3 = dataPoint2 == null || dataPoint2.hasTimestamp() && !dataPoint2.getTimestamp().isEqual(dataPoint.getTimestamp()) || dataPoint2.getSegmentStart();
                    --n2;
                    if (dataPoint2 == null || dataPoint2.isWaypoint()) continue;
                    dataPoint3 = dataPoint2;
                } while (!bl3);
            }
            Timestamp timestamp2 = dataPoint.getTimestamp();
            dataPoint3 = dataPoint;
            n2 = n + 1;
            do {
                boolean bl6;
                bl2 = (dataPoint2 = track.getPoint(n2)) != null && dataPoint2.hasTimestamp() && !dataPoint2.getTimestamp().isBefore(dataPoint.getTimestamp());
                boolean bl7 = bl6 = bl2 && !dataPoint2.isWaypoint() && !dataPoint2.getSegmentStart();
                if (bl6) {
                    d2 += DataPoint.calculateRadiansBetween(dataPoint2, dataPoint3);
                    timestamp2 = dataPoint2.getTimestamp();
                }
                bl3 = dataPoint2 == null || dataPoint2.hasTimestamp() && !dataPoint2.getTimestamp().isEqual(dataPoint.getTimestamp()) || dataPoint2.getSegmentStart();
                ++n2;
                if (dataPoint2 == null || dataPoint2.isWaypoint()) continue;
                dataPoint3 = dataPoint2;
            } while (!bl3);
            long l = timestamp2.getMillisecondsSince(timestamp);
            if (l >= 1000L) {
                double d3 = Distance.convertRadiansToDistance(d2);
                d = d3 / (double)l * 1000.0 * 60.0 * 60.0;
                bl = true;
            }
        }
        if (bl) {
            speedValue.setValue(d);
        }
    }

    public static void calculateVerticalSpeed(Track track, int n, SpeedValue speedValue) {
        if (track == null || n < 0 || speedValue == null) {
            System.err.println("Cannot calculate vert speed for index " + n);
            return;
        }
        speedValue.setInvalid();
        DataPoint dataPoint = track.getPoint(n);
        boolean bl = false;
        double d = 0.0;
        if (dataPoint != null) {
            String string = dataPoint.getFieldValue(Field.VERTICAL_SPEED);
            try {
                d = Double.parseDouble(string);
                bl = true;
            }
            catch (Exception exception) {}
        }
        if (!bl && dataPoint != null && dataPoint.hasTimestamp() && dataPoint.hasAltitude() && !dataPoint.isWaypoint()) {
            int n2 = n - 1;
            DataPoint dataPoint2 = null;
            Timestamp timestamp = dataPoint.getTimestamp();
            Altitude altitude = dataPoint.getAltitude();
            boolean bl2 = false;
            if (!dataPoint.getSegmentStart()) {
                do {
                    boolean bl3;
                    boolean bl4 = (dataPoint2 = track.getPoint(n2)) != null && dataPoint2.hasTimestamp() && !dataPoint2.getTimestamp().isAfter(dataPoint.getTimestamp());
                    boolean bl5 = bl3 = bl4 && !dataPoint2.isWaypoint();
                    if (bl3) {
                        timestamp = dataPoint2.getTimestamp();
                        if (dataPoint2.hasAltitude()) {
                            altitude = dataPoint2.getAltitude();
                        }
                    }
                    bl2 = dataPoint2 == null || dataPoint2.hasTimestamp() && !dataPoint2.getTimestamp().isEqual(dataPoint.getTimestamp()) || dataPoint2.getSegmentStart();
                    --n2;
                } while (!bl2);
            }
            Timestamp timestamp2 = dataPoint.getTimestamp();
            Altitude altitude2 = dataPoint.getAltitude();
            n2 = n + 1;
            do {
                boolean bl6;
                boolean bl7 = (dataPoint2 = track.getPoint(n2)) != null && dataPoint2.hasTimestamp() && !dataPoint2.getTimestamp().isBefore(dataPoint.getTimestamp());
                boolean bl8 = bl6 = bl7 && !dataPoint2.isWaypoint() && !dataPoint2.getSegmentStart();
                if (bl6) {
                    timestamp2 = dataPoint2.getTimestamp();
                    if (dataPoint2.hasAltitude()) {
                        altitude2 = dataPoint2.getAltitude();
                    }
                }
                bl2 = dataPoint2 == null || dataPoint2.hasTimestamp() && !dataPoint2.getTimestamp().isEqual(dataPoint.getTimestamp()) || dataPoint2.getSegmentStart();
                ++n2;
            } while (!bl2);
            long l = timestamp2.getMillisecondsSince(timestamp);
            if (l >= 1000L) {
                double d2 = (altitude2.getMetricValue() - altitude.getMetricValue()) * Config.getUnitSet().getVerticalSpeedUnit().getMultFactorFromStd();
                d = d2 / (double)l * 1000.0;
                bl = true;
            }
        }
        if (bl) {
            speedValue.setValue(d);
        }
    }
}

