/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.correlate;

import java.text.NumberFormat;
import java.util.ArrayList;
import javax.swing.table.AbstractTableModel;
import tim.prune.I18nManager;
import tim.prune.correlate.MediaPreviewTableRow;
import tim.prune.data.Unit;
import tim.prune.data.UnitSetLibrary;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MediaPreviewTableModel
extends AbstractTableModel {
    private String _firstColumnHeading = null;
    private ArrayList<MediaPreviewTableRow> _list = new ArrayList();
    private Unit _distanceUnits = UnitSetLibrary.UNITS_KILOMETRES;
    private static final NumberFormat FORMAT_ONE_DP = NumberFormat.getNumberInstance();

    static {
        FORMAT_ONE_DP.setMaximumFractionDigits(1);
        FORMAT_ONE_DP.setMinimumFractionDigits(1);
    }

    public MediaPreviewTableModel(String string) {
        this._firstColumnHeading = I18nManager.getText(string);
    }

    @Override
    public int getColumnCount() {
        return 5;
    }

    @Override
    public String getColumnName(int n) {
        if (n == 0) {
            return this._firstColumnHeading;
        }
        if (n == 1) {
            return I18nManager.getText("fieldname.timestamp");
        }
        if (n == 2) {
            return I18nManager.getText("dialog.correlate.select.timediff");
        }
        if (n == 3) {
            return I18nManager.getText("fieldname.distance");
        }
        return I18nManager.getText("dialog.correlate.options.correlate");
    }

    @Override
    public int getRowCount() {
        return this._list.size();
    }

    public MediaPreviewTableRow getRow(int n) {
        return this._list.get(n);
    }

    @Override
    public Object getValueAt(int n, int n2) {
        MediaPreviewTableRow mediaPreviewTableRow = this._list.get(n);
        if (n2 == 0) {
            return mediaPreviewTableRow.getMedia().getName();
        }
        if (n2 == 1) {
            if (mediaPreviewTableRow.getMedia().hasTimestamp()) {
                return mediaPreviewTableRow.getMedia().getTimestamp().getText();
            }
            return "";
        }
        if (n2 == 2) {
            if (mediaPreviewTableRow.getPointPair().isValid()) {
                return mediaPreviewTableRow.getTimeDiff().getDescription();
            }
            return "";
        }
        if (n2 == 3) {
            if (mediaPreviewTableRow.getPointPair().isValid()) {
                return FORMAT_ONE_DP.format(mediaPreviewTableRow.getDistance(this._distanceUnits));
            }
            return "";
        }
        return mediaPreviewTableRow.getCorrelateFlag();
    }

    public void setDistanceUnits(Unit unit) {
        this._distanceUnits = unit;
    }

    public void reset() {
        this._list.clear();
    }

    public void addRow(MediaPreviewTableRow mediaPreviewTableRow) {
        this._list.add(mediaPreviewTableRow);
    }

    @Override
    public Class<?> getColumnClass(int n) {
        if (n == 4) {
            return Boolean.class;
        }
        return super.getColumnClass(n);
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        if (n2 == 4) {
            return true;
        }
        return super.isCellEditable(n, n2);
    }

    public boolean hasAnySelected() {
        int n = 0;
        while (n < this.getRowCount()) {
            if (this.getRow(n).getCorrelateFlag().booleanValue()) {
                return true;
            }
            ++n;
        }
        return false;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        MediaPreviewTableRow mediaPreviewTableRow;
        if (n2 == 4 && (mediaPreviewTableRow = this.getRow(n)).getPointPair().isValid()) {
            mediaPreviewTableRow.setCorrelateFlag((Boolean)object);
        }
    }
}

