/*
==========================================================================

Project:   gpctool - a graphical user interface and development 
           environment for the gpc generic polygon clipper library.

File:      psdump.c
Author:    Alan Murta (email: gpc@cs.man.ac.uk)
Version:   1.01
Date:      11th April 1999

Copyright: (C) 1997-1999, Advanced Interfaces Group,
           University of Manchester.

           This software is free for non-commercial use. It may be copied,
           modified, and redistributed provided that this copyright notice
           is preserved on all copies. The intellectual property rights of
           the algorithms used reside with the University of Manchester
           Advanced Interfaces Group.

           You may not use this software, in whole or in part, in support
           of any commercial product without the express consent of the
           author.

           There is no warranty or other guarantee of fitness of this
           software for any purpose. It is provided solely "as is".

==========================================================================
*/


#include "gpc.h"
#include "appl.h"

#define IMAGE_SCALE    80.0
#define X_OFFSET     -400.0
#define Y_OFFSET     -400.0


void postscript_preamble(FILE *psfile)
{
  fprintf(psfile, "%%!\n");
  fprintf(psfile, "%% Generated by gpctool\n");
  fprintf(psfile, "2 setlinejoin\n");
}


void postscript_end(FILE *psfile)
{
  fprintf(psfile, "showpage\n");
}


void postscript_mark_vertices(FILE *psfile, gpc_polygon *p, double linewidth)
{
  int    c, v;

  for (c= 0; c < p->num_contours; c++)
  {
    for (v= 0; v < p->contour[c].num_vertices; v++)
    {
      fprintf(psfile, "newpath\n");
      fprintf(psfile, "  %4.2lf %4.2lf 4 0 360 arc\n",
          layout.ps_x_offset + layout.ps_scale *p->contour[c].vertex[v].x,
          layout.ps_y_offset + layout.ps_scale *p->contour[c].vertex[v].y);
      fprintf(psfile, "closepath\n");
      fprintf(psfile, "gsave\n");
      fprintf(psfile, "1 setgray\n");
      fprintf(psfile, "fill\n");
      fprintf(psfile, "grestore\n");
      fprintf(psfile, "0 setgray\n");
      fprintf(psfile, "%4.2lf setlinewidth\n", linewidth);
      fprintf(psfile, "stroke\n");
    }
  }
}


void postscript_polygon_outline(FILE *psfile, gpc_polygon *p, double linewidth,
                                int solidline)
{
  int    c, v;

  for (c= 0; c < p->num_contours; c++)
  {
    fprintf(psfile, "newpath\n");
    fprintf(psfile, "  %4.2lf %4.2lf moveto\n",
        layout.ps_x_offset + layout.ps_scale *p->contour[c].vertex[0].x,
        layout.ps_y_offset + layout.ps_scale *p->contour[c].vertex[0].y);
    for (v= 1; v < p->contour[c].num_vertices; v++)
      fprintf(psfile, "  %4.2lf %4.2lf lineto\n",
          layout.ps_x_offset + layout.ps_scale *p->contour[c].vertex[v].x,
          layout.ps_y_offset + layout.ps_scale *p->contour[c].vertex[v].y);
    fprintf(psfile, "closepath\n");
    fprintf(psfile, "0 setgray\n");

    fprintf(psfile, "gsave\n");
    if (!solidline)
      fprintf(psfile, "[5 4] 0 setdash\n");

    fprintf(psfile, "%4.2lf setlinewidth\n", linewidth);
    fprintf(psfile, "stroke\n");
    fprintf(psfile, "grestore\n");
  }
}


void postscript_tristrip_fill(FILE *psfile, gpc_tristrip *t, double grey)
{
  int    s, v;

  for (s= 0; s < t->num_strips; s++)
  {
    for (v= 0; v < (t->strip[s].num_vertices - 2); v++)
    {
      fprintf(psfile, "newpath\n");
      fprintf(psfile, "  %4.2lf %4.2lf moveto\n",
          layout.ps_x_offset + layout.ps_scale *t->strip[s].vertex[v].x,
          layout.ps_y_offset + layout.ps_scale *t->strip[s].vertex[v].y);
      fprintf(psfile, "  %4.2lf %4.2lf lineto\n",
          layout.ps_x_offset + layout.ps_scale *t->strip[s].vertex[v + 1].x,
          layout.ps_y_offset + layout.ps_scale *t->strip[s].vertex[v + 1].y);
      fprintf(psfile, "  %4.2lf %4.2lf lineto\n",
          layout.ps_x_offset + layout.ps_scale *t->strip[s].vertex[v + 2].x,
          layout.ps_y_offset + layout.ps_scale *t->strip[s].vertex[v + 2].y);
      fprintf(psfile, "closepath\n");
      fprintf(psfile, "gsave\n");
      fprintf(psfile, "%4.2lf setgray\n", grey);
      fprintf(psfile, "fill\n");
      fprintf(psfile, "grestore\n");
      fprintf(psfile, "0.5 setlinewidth\n");
      fprintf(psfile, "%4.2lf setgray\n", grey);
      fprintf(psfile, "stroke\n");
      fprintf(psfile, "0 setgray\n");
    }
  }
}











