/*
==========================================================================

Project:   gpctool - a graphical user interface and development 
           environment for the gpc generic polygon clipper library.

File:      gpctool.c
Author:    Alan Murta (email: gpc@cs.man.ac.uk)
Version:   1.01
Date:      11th April 1999

Copyright: (C) 1997-1999, Advanced Interfaces Group,
           University of Manchester.

           This software is free for non-commercial use. It may be copied,
           modified, and redistributed provided that this copyright notice
           is preserved on all copies. The intellectual property rights of
           the algorithms used reside with the University of Manchester
           Advanced Interfaces Group.

           You may not use this software, in whole or in part, in support
           of any commercial product without the express consent of the
           author.

           There is no warranty or other guarantee of fitness of this
           software for any purpose. It is provided solely "as is".

==========================================================================
*/

/* Form definition file generated with fdesign. */

#include "forms.h"
#include <stdlib.h>
#include "gpctool.h"
#include "gpc.h"

FD_gpctool *create_form_gpctool(void)
{
  FL_OBJECT *obj;
  FD_gpctool *fdui = (FD_gpctool *) fl_calloc(1, sizeof(*fdui));

  fdui->gpctool = fl_bgn_form(FL_NO_BOX, 170, 880);
  obj = fl_add_box(FL_UP_BOX,0,0,170,880,"");
  obj = fl_add_labelframe(FL_ENGRAVED_FRAME,20,352,132,164,"Operation");
    fl_set_object_lsize(obj,FL_NORMAL_SIZE);
    fl_set_object_lstyle(obj,FL_BOLD_STYLE);
  obj = fl_add_labelframe(FL_ENGRAVED_FRAME,20,680,132,92,"Results");
    fl_set_object_lsize(obj,FL_NORMAL_SIZE);
    fl_set_object_lstyle(obj,FL_BOLD_STYLE);
  obj = fl_add_labelframe(FL_ENGRAVED_FRAME,20,52,132,132,"Subject polygon");
    fl_set_object_lsize(obj,FL_NORMAL_SIZE);
    fl_set_object_lstyle(obj,FL_BOLD_STYLE);
  obj = fl_add_labelframe(FL_ENGRAVED_FRAME,20,204,132,132,"Clip polygon");
    fl_set_object_lsize(obj,FL_NORMAL_SIZE);
    fl_set_object_lstyle(obj,FL_BOLD_STYLE);
  obj = fl_add_button(FL_NORMAL_BUTTON,32,832,110,30,"Quit");
    fl_set_object_lsize(obj,FL_NORMAL_SIZE);
    fl_set_object_callback(obj,quit_request,0);
  obj = fl_add_button(FL_NORMAL_BUTTON,32,792,110,30,"Reset");
    fl_set_object_lsize(obj,FL_NORMAL_SIZE);
    fl_set_object_callback(obj,reset_request,0);
  obj = fl_add_button(FL_NORMAL_BUTTON,32,220,110,30,"Sketch");
    fl_set_object_lsize(obj,FL_NORMAL_SIZE);
    fl_set_object_callback(obj,sketch_polygon,0);
  obj = fl_add_button(FL_NORMAL_BUTTON,32,256,110,30,"Load");
    fl_set_object_lsize(obj,FL_NORMAL_SIZE);
    fl_set_object_callback(obj,load_polygon,0);
  obj = fl_add_button(FL_NORMAL_BUTTON,32,292,110,30,"Save");
    fl_set_object_lsize(obj,FL_NORMAL_SIZE);
    fl_set_object_callback(obj,save_polygon,0);
  obj = fl_add_button(FL_NORMAL_BUTTON,32,732,110,30,"Save");
    fl_set_object_lsize(obj,FL_NORMAL_SIZE);
    fl_set_object_callback(obj,save_polygon,2);
  obj = fl_add_button(FL_NORMAL_BUTTON,32,696,110,30,"Dump PostScript");
    fl_set_object_lsize(obj,FL_NORMAL_SIZE);
    fl_set_object_callback(obj,dump_psfile,3);
  obj = fl_add_button(FL_NORMAL_BUTTON,32,68,110,30,"Sketch");
    fl_set_object_lsize(obj,FL_NORMAL_SIZE);
    fl_set_object_callback(obj,sketch_polygon,1);
  obj = fl_add_button(FL_NORMAL_BUTTON,32,104,110,30,"Load");
    fl_set_object_lsize(obj,FL_NORMAL_SIZE);
    fl_set_object_callback(obj,load_polygon,1);
  obj = fl_add_button(FL_NORMAL_BUTTON,32,140,110,30,"Save");
    fl_set_object_lsize(obj,FL_NORMAL_SIZE);
    fl_set_object_callback(obj,save_polygon,1);
  obj = fl_add_button(FL_NORMAL_BUTTON,60,10,90,30,"gpctool");
    fl_set_object_boxtype(obj,FL_NO_BOX);
    fl_set_object_lcolor(obj,FL_INACTIVE);
    fl_set_object_lsize(obj,FL_HUGE_SIZE);
    fl_set_object_lalign(obj,FL_ALIGN_RIGHT|FL_ALIGN_INSIDE);
    fl_set_object_lstyle(obj,FL_TIMESBOLDITALIC_STYLE+FL_ENGRAVED_STYLE);
    fl_set_object_callback(obj,version_request,0);

  fdui->clip_type = fl_bgn_group();
  obj = fl_add_labelframe(FL_ENGRAVED_FRAME,20,536,132,124,"Result type");
    fl_set_object_lsize(obj,FL_NORMAL_SIZE);
    fl_set_object_lstyle(obj,FL_BOLD_STYLE);
  fdui->clip_polygon = obj = fl_add_lightbutton(FL_RADIO_BUTTON,32,548,110,30,"Polygon");
    fl_set_object_lsize(obj,FL_NORMAL_SIZE);
    fl_set_object_callback(obj,set_clip_type,1);
  fdui->clip_tristrip = obj = fl_add_lightbutton(FL_RADIO_BUTTON,32,584,110,30,"Tristrip");
    fl_set_object_lsize(obj,FL_NORMAL_SIZE);
    fl_set_object_callback(obj,set_clip_type,2);
  fdui->clip_both = obj = fl_add_lightbutton(FL_RADIO_BUTTON,32,620,110,30,"Both");
    fl_set_object_lsize(obj,FL_NORMAL_SIZE);
    fl_set_object_callback(obj,set_clip_type,3);
  fl_end_group();


  fdui->op_type = fl_bgn_group();
  fdui->op_difference = obj = fl_add_lightbutton(FL_RADIO_BUTTON,32,368,110,30,"Difference");
    fl_set_object_lsize(obj,FL_NORMAL_SIZE);
    fl_set_object_callback(obj,set_op,GPC_DIFF);
  fdui->op_intersection = obj = fl_add_lightbutton(FL_RADIO_BUTTON,32,404,110,30,"Intersection");
    fl_set_object_lsize(obj,FL_NORMAL_SIZE);
    fl_set_object_callback(obj,set_op,GPC_INT);
  fdui->op_xor = obj = fl_add_lightbutton(FL_RADIO_BUTTON,32,440,110,30,"Exclusive or");
    fl_set_object_lsize(obj,FL_NORMAL_SIZE);
    fl_set_object_callback(obj,set_op,GPC_XOR);
  fdui->op_union = obj = fl_add_lightbutton(FL_RADIO_BUTTON,32,476,110,30,"Union");
    fl_set_object_lsize(obj,FL_NORMAL_SIZE);
    fl_set_object_callback(obj,set_op,GPC_UNION);
  fl_end_group();

  fl_end_form();

  fdui->gpctool->fdui = fdui;

  return fdui;
}
/*---------------------------------------*/

