<?php
/**
 * Copyright 2007 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
# Generated by the protocol buffer compiler. DO NOT EDIT!
# source: google/appengine/api/servers/servers_service.proto

namespace dummy {
  require_once 'google/appengine/runtime/proto/ProtocolMessage.php';
}
namespace google\appengine\ServersServiceError {
  class ErrorCode {
    const OK = 0;
    const INVALID_SERVER = 1;
    const INVALID_VERSION = 2;
    const INVALID_INSTANCES = 3;
    const TRANSIENT_ERROR = 4;
    const UNEXPECTED_STATE = 5;
  }
}
namespace google\appengine {
  class ServersServiceError extends \google\net\ProtocolMessage {
    public function clear() {
    }
    public function byteSizePartial() {
      $res = 0;
      return $res;
    }
    public function outputPartial($out) {
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      return $res;
    }
  }
}
namespace google\appengine {
  class GetServersRequest extends \google\net\ProtocolMessage {
    public function clear() {
    }
    public function byteSizePartial() {
      $res = 0;
      return $res;
    }
    public function outputPartial($out) {
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      return $res;
    }
  }
}
namespace google\appengine {
  class GetServersResponse extends \google\net\ProtocolMessage {
    private $server = array();
    public function getServerSize() {
      return sizeof($this->server);
    }
    public function getServerList() {
      return $this->server;
    }
    public function getServer($idx) {
      return $this->server[$idx];
    }
    public function setServer($idx, $val) {
      $this->server[$idx] = $val;
      return $this;
    }
    public function addServer($val) {
      $this->server[] = $val;
      return $this;
    }
    public function clearServer() {
      $this->server = array();
    }
    public function clear() {
      $this->clearServer();
    }
    public function byteSizePartial() {
      $res = 0;
      $this->checkProtoArray($this->server);
      $res += 1 * sizeof($this->server);
      foreach ($this->server as $value) {
        $res += $this->lengthString(strlen($value));
      }
      return $res;
    }
    public function outputPartial($out) {
      $this->checkProtoArray($this->server);
      foreach ($this->server as $value) {
        $out->putVarInt32(10);
        $out->putPrefixedString($value);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 10:
            $length = $d->getVarInt32();
            $this->addServer(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      foreach ($x->getServerList() as $v) {
        $this->addServer($v);
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (sizeof($this->server) !== sizeof($x->server)) return false;
      foreach (array_map(null, $this->server, $x->server) as $v) {
        if ($v[0] !== $v[1]) return false;
      }
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      foreach ($this->server as $value) {
        $res .= $prefix . "server: " . $this->debugFormatString($value) . "\n";
      }
      return $res;
    }
  }
}
namespace google\appengine {
  class GetVersionsRequest extends \google\net\ProtocolMessage {
    public function getServer() {
      if (!isset($this->server)) {
        return '';
      }
      return $this->server;
    }
    public function setServer($val) {
      $this->server = $val;
      return $this;
    }
    public function clearServer() {
      unset($this->server);
      return $this;
    }
    public function hasServer() {
      return isset($this->server);
    }
    public function clear() {
      $this->clearServer();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->server)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->server));
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->server)) {
        $out->putVarInt32(10);
        $out->putPrefixedString($this->server);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 10:
            $length = $d->getVarInt32();
            $this->setServer(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasServer()) {
        $this->setServer($x->getServer());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->server) !== isset($x->server)) return false;
      if (isset($this->server) && $this->server !== $x->server) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->server)) {
        $res .= $prefix . "server: " . $this->debugFormatString($this->server) . "\n";
      }
      return $res;
    }
  }
}
namespace google\appengine {
  class GetVersionsResponse extends \google\net\ProtocolMessage {
    private $version = array();
    public function getVersionSize() {
      return sizeof($this->version);
    }
    public function getVersionList() {
      return $this->version;
    }
    public function getVersion($idx) {
      return $this->version[$idx];
    }
    public function setVersion($idx, $val) {
      $this->version[$idx] = $val;
      return $this;
    }
    public function addVersion($val) {
      $this->version[] = $val;
      return $this;
    }
    public function clearVersion() {
      $this->version = array();
    }
    public function clear() {
      $this->clearVersion();
    }
    public function byteSizePartial() {
      $res = 0;
      $this->checkProtoArray($this->version);
      $res += 1 * sizeof($this->version);
      foreach ($this->version as $value) {
        $res += $this->lengthString(strlen($value));
      }
      return $res;
    }
    public function outputPartial($out) {
      $this->checkProtoArray($this->version);
      foreach ($this->version as $value) {
        $out->putVarInt32(10);
        $out->putPrefixedString($value);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 10:
            $length = $d->getVarInt32();
            $this->addVersion(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      foreach ($x->getVersionList() as $v) {
        $this->addVersion($v);
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (sizeof($this->version) !== sizeof($x->version)) return false;
      foreach (array_map(null, $this->version, $x->version) as $v) {
        if ($v[0] !== $v[1]) return false;
      }
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      foreach ($this->version as $value) {
        $res .= $prefix . "version: " . $this->debugFormatString($value) . "\n";
      }
      return $res;
    }
  }
}
namespace google\appengine {
  class GetDefaultVersionRequest extends \google\net\ProtocolMessage {
    public function getServer() {
      if (!isset($this->server)) {
        return '';
      }
      return $this->server;
    }
    public function setServer($val) {
      $this->server = $val;
      return $this;
    }
    public function clearServer() {
      unset($this->server);
      return $this;
    }
    public function hasServer() {
      return isset($this->server);
    }
    public function clear() {
      $this->clearServer();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->server)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->server));
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->server)) {
        $out->putVarInt32(10);
        $out->putPrefixedString($this->server);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 10:
            $length = $d->getVarInt32();
            $this->setServer(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasServer()) {
        $this->setServer($x->getServer());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->server) !== isset($x->server)) return false;
      if (isset($this->server) && $this->server !== $x->server) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->server)) {
        $res .= $prefix . "server: " . $this->debugFormatString($this->server) . "\n";
      }
      return $res;
    }
  }
}
namespace google\appengine {
  class GetDefaultVersionResponse extends \google\net\ProtocolMessage {
    public function getVersion() {
      if (!isset($this->version)) {
        return '';
      }
      return $this->version;
    }
    public function setVersion($val) {
      $this->version = $val;
      return $this;
    }
    public function clearVersion() {
      unset($this->version);
      return $this;
    }
    public function hasVersion() {
      return isset($this->version);
    }
    public function clear() {
      $this->clearVersion();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->version)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->version));
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->version)) {
        $out->putVarInt32(10);
        $out->putPrefixedString($this->version);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 10:
            $length = $d->getVarInt32();
            $this->setVersion(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      if (!isset($this->version)) return 'version';
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasVersion()) {
        $this->setVersion($x->getVersion());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->version) !== isset($x->version)) return false;
      if (isset($this->version) && $this->version !== $x->version) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->version)) {
        $res .= $prefix . "version: " . $this->debugFormatString($this->version) . "\n";
      }
      return $res;
    }
  }
}
namespace google\appengine {
  class GetNumInstancesRequest extends \google\net\ProtocolMessage {
    public function getServer() {
      if (!isset($this->server)) {
        return '';
      }
      return $this->server;
    }
    public function setServer($val) {
      $this->server = $val;
      return $this;
    }
    public function clearServer() {
      unset($this->server);
      return $this;
    }
    public function hasServer() {
      return isset($this->server);
    }
    public function getVersion() {
      if (!isset($this->version)) {
        return '';
      }
      return $this->version;
    }
    public function setVersion($val) {
      $this->version = $val;
      return $this;
    }
    public function clearVersion() {
      unset($this->version);
      return $this;
    }
    public function hasVersion() {
      return isset($this->version);
    }
    public function clear() {
      $this->clearServer();
      $this->clearVersion();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->server)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->server));
      }
      if (isset($this->version)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->version));
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->server)) {
        $out->putVarInt32(10);
        $out->putPrefixedString($this->server);
      }
      if (isset($this->version)) {
        $out->putVarInt32(18);
        $out->putPrefixedString($this->version);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 10:
            $length = $d->getVarInt32();
            $this->setServer(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 18:
            $length = $d->getVarInt32();
            $this->setVersion(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasServer()) {
        $this->setServer($x->getServer());
      }
      if ($x->hasVersion()) {
        $this->setVersion($x->getVersion());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->server) !== isset($x->server)) return false;
      if (isset($this->server) && $this->server !== $x->server) return false;
      if (isset($this->version) !== isset($x->version)) return false;
      if (isset($this->version) && $this->version !== $x->version) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->server)) {
        $res .= $prefix . "server: " . $this->debugFormatString($this->server) . "\n";
      }
      if (isset($this->version)) {
        $res .= $prefix . "version: " . $this->debugFormatString($this->version) . "\n";
      }
      return $res;
    }
  }
}
namespace google\appengine {
  class GetNumInstancesResponse extends \google\net\ProtocolMessage {
    public function getInstances() {
      if (!isset($this->instances)) {
        return "0";
      }
      return $this->instances;
    }
    public function setInstances($val) {
      if (is_double($val)) {
        $this->instances = sprintf('%0.0F', $val);
      } else {
        $this->instances = $val;
      }
      return $this;
    }
    public function clearInstances() {
      unset($this->instances);
      return $this;
    }
    public function hasInstances() {
      return isset($this->instances);
    }
    public function clear() {
      $this->clearInstances();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->instances)) {
        $res += 1;
        $res += $this->lengthVarInt64($this->instances);
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->instances)) {
        $out->putVarInt32(8);
        $out->putVarInt64($this->instances);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 8:
            $this->setInstances($d->getVarInt64());
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      if (!isset($this->instances)) return 'instances';
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasInstances()) {
        $this->setInstances($x->getInstances());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->instances) !== isset($x->instances)) return false;
      if (isset($this->instances) && !$this->integerEquals($this->instances, $x->instances)) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->instances)) {
        $res .= $prefix . "instances: " . $this->debugFormatInt64($this->instances) . "\n";
      }
      return $res;
    }
  }
}
namespace google\appengine {
  class SetNumInstancesRequest extends \google\net\ProtocolMessage {
    public function getServer() {
      if (!isset($this->server)) {
        return '';
      }
      return $this->server;
    }
    public function setServer($val) {
      $this->server = $val;
      return $this;
    }
    public function clearServer() {
      unset($this->server);
      return $this;
    }
    public function hasServer() {
      return isset($this->server);
    }
    public function getVersion() {
      if (!isset($this->version)) {
        return '';
      }
      return $this->version;
    }
    public function setVersion($val) {
      $this->version = $val;
      return $this;
    }
    public function clearVersion() {
      unset($this->version);
      return $this;
    }
    public function hasVersion() {
      return isset($this->version);
    }
    public function getInstances() {
      if (!isset($this->instances)) {
        return "0";
      }
      return $this->instances;
    }
    public function setInstances($val) {
      if (is_double($val)) {
        $this->instances = sprintf('%0.0F', $val);
      } else {
        $this->instances = $val;
      }
      return $this;
    }
    public function clearInstances() {
      unset($this->instances);
      return $this;
    }
    public function hasInstances() {
      return isset($this->instances);
    }
    public function clear() {
      $this->clearServer();
      $this->clearVersion();
      $this->clearInstances();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->server)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->server));
      }
      if (isset($this->version)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->version));
      }
      if (isset($this->instances)) {
        $res += 1;
        $res += $this->lengthVarInt64($this->instances);
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->server)) {
        $out->putVarInt32(10);
        $out->putPrefixedString($this->server);
      }
      if (isset($this->version)) {
        $out->putVarInt32(18);
        $out->putPrefixedString($this->version);
      }
      if (isset($this->instances)) {
        $out->putVarInt32(24);
        $out->putVarInt64($this->instances);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 10:
            $length = $d->getVarInt32();
            $this->setServer(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 18:
            $length = $d->getVarInt32();
            $this->setVersion(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 24:
            $this->setInstances($d->getVarInt64());
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      if (!isset($this->instances)) return 'instances';
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasServer()) {
        $this->setServer($x->getServer());
      }
      if ($x->hasVersion()) {
        $this->setVersion($x->getVersion());
      }
      if ($x->hasInstances()) {
        $this->setInstances($x->getInstances());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->server) !== isset($x->server)) return false;
      if (isset($this->server) && $this->server !== $x->server) return false;
      if (isset($this->version) !== isset($x->version)) return false;
      if (isset($this->version) && $this->version !== $x->version) return false;
      if (isset($this->instances) !== isset($x->instances)) return false;
      if (isset($this->instances) && !$this->integerEquals($this->instances, $x->instances)) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->server)) {
        $res .= $prefix . "server: " . $this->debugFormatString($this->server) . "\n";
      }
      if (isset($this->version)) {
        $res .= $prefix . "version: " . $this->debugFormatString($this->version) . "\n";
      }
      if (isset($this->instances)) {
        $res .= $prefix . "instances: " . $this->debugFormatInt64($this->instances) . "\n";
      }
      return $res;
    }
  }
}
namespace google\appengine {
  class SetNumInstancesResponse extends \google\net\ProtocolMessage {
    public function clear() {
    }
    public function byteSizePartial() {
      $res = 0;
      return $res;
    }
    public function outputPartial($out) {
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      return $res;
    }
  }
}
namespace google\appengine {
  class StartServerRequest extends \google\net\ProtocolMessage {
    public function getServer() {
      if (!isset($this->server)) {
        return '';
      }
      return $this->server;
    }
    public function setServer($val) {
      $this->server = $val;
      return $this;
    }
    public function clearServer() {
      unset($this->server);
      return $this;
    }
    public function hasServer() {
      return isset($this->server);
    }
    public function getVersion() {
      if (!isset($this->version)) {
        return '';
      }
      return $this->version;
    }
    public function setVersion($val) {
      $this->version = $val;
      return $this;
    }
    public function clearVersion() {
      unset($this->version);
      return $this;
    }
    public function hasVersion() {
      return isset($this->version);
    }
    public function clear() {
      $this->clearServer();
      $this->clearVersion();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->server)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->server));
      }
      if (isset($this->version)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->version));
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->server)) {
        $out->putVarInt32(10);
        $out->putPrefixedString($this->server);
      }
      if (isset($this->version)) {
        $out->putVarInt32(18);
        $out->putPrefixedString($this->version);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 10:
            $length = $d->getVarInt32();
            $this->setServer(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 18:
            $length = $d->getVarInt32();
            $this->setVersion(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      if (!isset($this->server)) return 'server';
      if (!isset($this->version)) return 'version';
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasServer()) {
        $this->setServer($x->getServer());
      }
      if ($x->hasVersion()) {
        $this->setVersion($x->getVersion());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->server) !== isset($x->server)) return false;
      if (isset($this->server) && $this->server !== $x->server) return false;
      if (isset($this->version) !== isset($x->version)) return false;
      if (isset($this->version) && $this->version !== $x->version) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->server)) {
        $res .= $prefix . "server: " . $this->debugFormatString($this->server) . "\n";
      }
      if (isset($this->version)) {
        $res .= $prefix . "version: " . $this->debugFormatString($this->version) . "\n";
      }
      return $res;
    }
  }
}
namespace google\appengine {
  class StartServerResponse extends \google\net\ProtocolMessage {
    public function clear() {
    }
    public function byteSizePartial() {
      $res = 0;
      return $res;
    }
    public function outputPartial($out) {
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      return $res;
    }
  }
}
namespace google\appengine {
  class StopServerRequest extends \google\net\ProtocolMessage {
    public function getServer() {
      if (!isset($this->server)) {
        return '';
      }
      return $this->server;
    }
    public function setServer($val) {
      $this->server = $val;
      return $this;
    }
    public function clearServer() {
      unset($this->server);
      return $this;
    }
    public function hasServer() {
      return isset($this->server);
    }
    public function getVersion() {
      if (!isset($this->version)) {
        return '';
      }
      return $this->version;
    }
    public function setVersion($val) {
      $this->version = $val;
      return $this;
    }
    public function clearVersion() {
      unset($this->version);
      return $this;
    }
    public function hasVersion() {
      return isset($this->version);
    }
    public function clear() {
      $this->clearServer();
      $this->clearVersion();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->server)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->server));
      }
      if (isset($this->version)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->version));
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->server)) {
        $out->putVarInt32(10);
        $out->putPrefixedString($this->server);
      }
      if (isset($this->version)) {
        $out->putVarInt32(18);
        $out->putPrefixedString($this->version);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 10:
            $length = $d->getVarInt32();
            $this->setServer(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 18:
            $length = $d->getVarInt32();
            $this->setVersion(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasServer()) {
        $this->setServer($x->getServer());
      }
      if ($x->hasVersion()) {
        $this->setVersion($x->getVersion());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->server) !== isset($x->server)) return false;
      if (isset($this->server) && $this->server !== $x->server) return false;
      if (isset($this->version) !== isset($x->version)) return false;
      if (isset($this->version) && $this->version !== $x->version) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->server)) {
        $res .= $prefix . "server: " . $this->debugFormatString($this->server) . "\n";
      }
      if (isset($this->version)) {
        $res .= $prefix . "version: " . $this->debugFormatString($this->version) . "\n";
      }
      return $res;
    }
  }
}
namespace google\appengine {
  class StopServerResponse extends \google\net\ProtocolMessage {
    public function clear() {
    }
    public function byteSizePartial() {
      $res = 0;
      return $res;
    }
    public function outputPartial($out) {
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      return $res;
    }
  }
}
namespace google\appengine {
  class GetHostnameRequest extends \google\net\ProtocolMessage {
    public function getServer() {
      if (!isset($this->server)) {
        return '';
      }
      return $this->server;
    }
    public function setServer($val) {
      $this->server = $val;
      return $this;
    }
    public function clearServer() {
      unset($this->server);
      return $this;
    }
    public function hasServer() {
      return isset($this->server);
    }
    public function getVersion() {
      if (!isset($this->version)) {
        return '';
      }
      return $this->version;
    }
    public function setVersion($val) {
      $this->version = $val;
      return $this;
    }
    public function clearVersion() {
      unset($this->version);
      return $this;
    }
    public function hasVersion() {
      return isset($this->version);
    }
    public function getInstance() {
      if (!isset($this->instance)) {
        return '';
      }
      return $this->instance;
    }
    public function setInstance($val) {
      $this->instance = $val;
      return $this;
    }
    public function clearInstance() {
      unset($this->instance);
      return $this;
    }
    public function hasInstance() {
      return isset($this->instance);
    }
    public function clear() {
      $this->clearServer();
      $this->clearVersion();
      $this->clearInstance();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->server)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->server));
      }
      if (isset($this->version)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->version));
      }
      if (isset($this->instance)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->instance));
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->server)) {
        $out->putVarInt32(10);
        $out->putPrefixedString($this->server);
      }
      if (isset($this->version)) {
        $out->putVarInt32(18);
        $out->putPrefixedString($this->version);
      }
      if (isset($this->instance)) {
        $out->putVarInt32(26);
        $out->putPrefixedString($this->instance);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 10:
            $length = $d->getVarInt32();
            $this->setServer(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 18:
            $length = $d->getVarInt32();
            $this->setVersion(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 26:
            $length = $d->getVarInt32();
            $this->setInstance(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasServer()) {
        $this->setServer($x->getServer());
      }
      if ($x->hasVersion()) {
        $this->setVersion($x->getVersion());
      }
      if ($x->hasInstance()) {
        $this->setInstance($x->getInstance());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->server) !== isset($x->server)) return false;
      if (isset($this->server) && $this->server !== $x->server) return false;
      if (isset($this->version) !== isset($x->version)) return false;
      if (isset($this->version) && $this->version !== $x->version) return false;
      if (isset($this->instance) !== isset($x->instance)) return false;
      if (isset($this->instance) && $this->instance !== $x->instance) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->server)) {
        $res .= $prefix . "server: " . $this->debugFormatString($this->server) . "\n";
      }
      if (isset($this->version)) {
        $res .= $prefix . "version: " . $this->debugFormatString($this->version) . "\n";
      }
      if (isset($this->instance)) {
        $res .= $prefix . "instance: " . $this->debugFormatString($this->instance) . "\n";
      }
      return $res;
    }
  }
}
namespace google\appengine {
  class GetHostnameResponse extends \google\net\ProtocolMessage {
    public function getHostname() {
      if (!isset($this->hostname)) {
        return '';
      }
      return $this->hostname;
    }
    public function setHostname($val) {
      $this->hostname = $val;
      return $this;
    }
    public function clearHostname() {
      unset($this->hostname);
      return $this;
    }
    public function hasHostname() {
      return isset($this->hostname);
    }
    public function clear() {
      $this->clearHostname();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->hostname)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->hostname));
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->hostname)) {
        $out->putVarInt32(10);
        $out->putPrefixedString($this->hostname);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 10:
            $length = $d->getVarInt32();
            $this->setHostname(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      if (!isset($this->hostname)) return 'hostname';
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasHostname()) {
        $this->setHostname($x->getHostname());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->hostname) !== isset($x->hostname)) return false;
      if (isset($this->hostname) && $this->hostname !== $x->hostname) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->hostname)) {
        $res .= $prefix . "hostname: " . $this->debugFormatString($this->hostname) . "\n";
      }
      return $res;
    }
  }
}
