/*
 * jQuery 1.2.3 - New Wave Javascript
 *
 * Copyright (c) 2008 John Resig (jquery.com)
 * Dual licensed under the MIT (MIT-LICENSE.txt)
 * and GPL (GPL-LICENSE.txt) licenses.
 *
 * $Date: 2008/02/28 $
 * $Rev: 4663 $
 */
(function(){if(window.jQuery)var _jQuery=window.jQuery;var jQuery=window.jQuery=function(selector,context){return new jQuery.prototype.init(selector,context);};if(window.$)var _$=window.$;window.$=jQuery;var quickExpr=/^[^<]*(<(.|\s)+>)[^>]*$|^#(\w+)$/;var isSimple=/^.[^:#\[\.]*$/;jQuery.fn=jQuery.prototype={init:function(selector,context){selector=selector||document;if(selector.nodeType){this[0]=selector;this.length=1;return this;}else if(typeof selector=="string"){var match=quickExpr.exec(selector);if(match&&(match[1]||!context)){if(match[1])selector=jQuery.clean([match[1]],context);else{var elem=document.getElementById(match[3]);if(elem)if(elem.id!=match[3])return jQuery().find(selector);else{this[0]=elem;this.length=1;return this;}else
selector=[];}}else
return new jQuery(context).find(selector);}else if(jQuery.isFunction(selector))return new jQuery(document)[jQuery.fn.ready?"ready":"load"](selector);return this.setArray(selector.constructor==Array&&selector||(selector.jquery||selector.length&&selector!=window&&!selector.nodeType&&selector[0]!=undefined&&selector[0].nodeType)&&jQuery.makeArray(selector)||[selector]);},jquery:"1.2.3",size:function(){return this.length;},length:0,get:function(num){return num==undefined?jQuery.makeArray(this):this[num];},pushStack:function(elems){var ret=jQuery(elems);ret.prevObject=this;return ret;},setArray:function(elems){this.length=0;Array.prototype.push.apply(this,elems);return this;},each:function(callback,args){return jQuery.each(this,callback,args);},index:function(elem){var ret=-1;this.each(function(i){if(this==elem)ret=i;});return ret;},attr:function(name,value,type){var options=name;if(name.constructor==String)if(value==undefined)return this.length&&jQuery[type||"attr"](this[0],name)||undefined;else{options={};options[name]=value;}return this.each(function(i){for(name in options)jQuery.attr(type?this.style:this,name,jQuery.prop(this,options[name],type,i,name));});},css:function(key,value){if((key=='width'||key=='height')&&parseFloat(value)<0)value=undefined;return this.attr(key,value,"curCSS");},text:function(text){if(typeof text!="object"&&text!=null)return this.empty().append((this[0]&&this[0].ownerDocument||document).createTextNode(text));var ret="";jQuery.each(text||this,function(){jQuery.each(this.childNodes,function(){if(this.nodeType!=8)ret+=this.nodeType!=1?this.nodeValue:jQuery.fn.text([this]);});});return ret;},wrapAll:function(html){if(this[0])jQuery(html,this[0].ownerDocument).clone().insertBefore(this[0]).map(function(){var elem=this;while(elem.firstChild)elem=elem.firstChild;return elem;}).append(this);return this;},wrapInner:function(html){return this.each(function(){jQuery(this).contents().wrapAll(html);});},wrap:function(html){return this.each(function(){jQuery(this).wrapAll(html);});},append:function(){return this.domManip(arguments,true,false,function(elem){if(this.nodeType==1)this.appendChild(elem);});},prepend:function(){return this.domManip(arguments,true,true,function(elem){if(this.nodeType==1)this.insertBefore(elem,this.firstChild);});},before:function(){return this.domManip(arguments,false,false,function(elem){this.parentNode.insertBefore(elem,this);});},after:function(){return this.domManip(arguments,false,true,function(elem){this.parentNode.insertBefore(elem,this.nextSibling);});},end:function(){return this.prevObject||jQuery([]);},find:function(selector){var elems=jQuery.map(this,function(elem){return jQuery.find(selector,elem);});return this.pushStack(/[^+>] [^+>]/.test(selector)||selector.indexOf("..")>-1?jQuery.unique(elems):elems);},clone:function(events){var ret=this.map(function(){if(jQuery.browser.msie&&!jQuery.isXMLDoc(this)){var clone=this.cloneNode(true),container=document.createElement("div");container.appendChild(clone);return jQuery.clean([container.innerHTML])[0];}else
return this.cloneNode(true);});var clone=ret.find("*").andSelf().each(function(){if(this[expando]!=undefined)this[expando]=null;});if(events===true)this.find("*").andSelf().each(function(i){if(this.nodeType==3)return;var events=jQuery.data(this,"events");for(var type in events)for(var handler in events[type])jQuery.event.add(clone[i],type,events[type][handler],events[type][handler].data);});return ret;},filter:function(selector){return this.pushStack(jQuery.isFunction(selector)&&jQuery.grep(this,function(elem,i){return selector.call(elem,i);})||jQuery.multiFilter(selector,this));},not:function(selector){if(selector.constructor==String)if(isSimple.test(selector))return this.pushStack(jQuery.multiFilter(selector,this,true));else
selector=jQuery.multiFilter(selector,this);var isArrayLike=selector.length&&selector[selector.length-1]!==undefined&&!selector.nodeType;return this.filter(function(){return isArrayLike?jQuery.inArray(this,selector)<0:this!=selector;});},add:function(selector){return!selector?this:this.pushStack(jQuery.merge(this.get(),selector.constructor==String?jQuery(selector).get():selector.length!=undefined&&(!selector.nodeName||jQuery.nodeName(selector,"form"))?selector:[selector]));},is:function(selector){return selector?jQuery.multiFilter(selector,this).length>0:false;},hasClass:function(selector){return this.is("."+selector);},val:function(value){if(value==undefined){if(this.length){var elem=this[0];if(jQuery.nodeName(elem,"select")){var index=elem.selectedIndex,values=[],options=elem.options,one=elem.type=="select-one";if(index<0)return null;for(var i=one?index:0,max=one?index+1:options.length;i<max;i++){var option=options[i];if(option.selected){value=jQuery.browser.msie&&!option.attributes.value.specified?option.text:option.value;if(one)return value;values.push(value);}}return values;}else
return(this[0].value||"").replace(/\r/g,"");}return undefined;}return this.each(function(){if(this.nodeType!=1)return;if(value.constructor==Array&&/radio|checkbox/.test(this.type))this.checked=(jQuery.inArray(this.value,value)>=0||jQuery.inArray(this.name,value)>=0);else if(jQuery.nodeName(this,"select")){var values=value.constructor==Array?value:[value];jQuery("option",this).each(function(){this.selected=(jQuery.inArray(this.value,values)>=0||jQuery.inArray(this.text,values)>=0);});if(!values.length)this.selectedIndex=-1;}else
this.value=value;});},html:function(value){return value==undefined?(this.length?this[0].innerHTML:null):this.empty().append(value);},replaceWith:function(value){return this.after(value).remove();},eq:function(i){return this.slice(i,i+1);},slice:function(){return this.pushStack(Array.prototype.slice.apply(this,arguments));},map:function(callback){return this.pushStack(jQuery.map(this,function(elem,i){return callback.call(elem,i,elem);}));},andSelf:function(){return this.add(this.prevObject);},data:function(key,value){var parts=key.split(".");parts[1]=parts[1]?"."+parts[1]:"";if(value==null){var data=this.triggerHandler("getData"+parts[1]+"!",[parts[0]]);if(data==undefined&&this.length)data=jQuery.data(this[0],key);return data==null&&parts[1]?this.data(parts[0]):data;}else
return this.trigger("setData"+parts[1]+"!",[parts[0],value]).each(function(){jQuery.data(this,key,value);});},removeData:function(key){return this.each(function(){jQuery.removeData(this,key);});},domManip:function(args,table,reverse,callback){var clone=this.length>1,elems;return this.each(function(){if(!elems){elems=jQuery.clean(args,this.ownerDocument);if(reverse)elems.reverse();}var obj=this;if(table&&jQuery.nodeName(this,"table")&&jQuery.nodeName(elems[0],"tr"))obj=this.getElementsByTagName("tbody")[0]||this.appendChild(this.ownerDocument.createElement("tbody"));var scripts=jQuery([]);jQuery.each(elems,function(){var elem=clone?jQuery(this).clone(true)[0]:this;if(jQuery.nodeName(elem,"script")){scripts=scripts.add(elem);}else{if(elem.nodeType==1)scripts=scripts.add(jQuery("script",elem).remove());callback.call(obj,elem);}});scripts.each(evalScript);});}};jQuery.prototype.init.prototype=jQuery.prototype;function evalScript(i,elem){if(elem.src)jQuery.ajax({url:elem.src,async:false,dataType:"script"});else
jQuery.globalEval(elem.text||elem.textContent||elem.innerHTML||"");if(elem.parentNode)elem.parentNode.removeChild(elem);}jQuery.extend=jQuery.fn.extend=function(){var target=arguments[0]||{},i=1,length=arguments.length,deep=false,options;if(target.constructor==Boolean){deep=target;target=arguments[1]||{};i=2;}if(typeof target!="object"&&typeof target!="function")target={};if(length==1){target=this;i=0;}for(;i<length;i++)if((options=arguments[i])!=null)for(var name in options){if(target===options[name])continue;if(deep&&options[name]&&typeof options[name]=="object"&&target[name]&&!options[name].nodeType)target[name]=jQuery.extend(target[name],options[name]);else if(options[name]!=undefined)target[name]=options[name];}return target;};var expando="jQuery"+(new Date()).getTime(),uuid=0,windowData={};var exclude=/z-?index|font-?weight|opacity|zoom|line-?height/i;jQuery.extend({noConflict:function(deep){window.$=_$;if(deep)window.jQuery=_jQuery;return jQuery;},isFunction:function(fn){return!!fn&&typeof fn!="string"&&!fn.nodeName&&fn.constructor!=Array&&/function/i.test(fn+"");},isXMLDoc:function(elem){return elem.documentElement&&!elem.body||elem.tagName&&elem.ownerDocument&&!elem.ownerDocument.body;},globalEval:function(data){data=jQuery.trim(data);if(data){var head=document.getElementsByTagName("head")[0]||document.documentElement,script=document.createElement("script");script.type="text/javascript";if(jQuery.browser.msie)script.text=data;else
script.appendChild(document.createTextNode(data));head.appendChild(script);head.removeChild(script);}},nodeName:function(elem,name){return elem.nodeName&&elem.nodeName.toUpperCase()==name.toUpperCase();},cache:{},data:function(elem,name,data){elem=elem==window?windowData:elem;var id=elem[expando];if(!id)id=elem[expando]=++uuid;if(name&&!jQuery.cache[id])jQuery.cache[id]={};if(data!=undefined)jQuery.cache[id][name]=data;return name?jQuery.cache[id][name]:id;},removeData:function(elem,name){elem=elem==window?windowData:elem;var id=elem[expando];if(name){if(jQuery.cache[id]){delete jQuery.cache[id][name];name="";for(name in jQuery.cache[id])break;if(!name)jQuery.removeData(elem);}}else{try{delete elem[expando];}catch(e){if(elem.removeAttribute)elem.removeAttribute(expando);}delete jQuery.cache[id];}},each:function(object,callback,args){if(args){if(object.length==undefined){for(var name in object)if(callback.apply(object[name],args)===false)break;}else
for(var i=0,length=object.length;i<length;i++)if(callback.apply(object[i],args)===false)break;}else{if(object.length==undefined){for(var name in object)if(callback.call(object[name],name,object[name])===false)break;}else
for(var i=0,length=object.length,value=object[0];i<length&&callback.call(value,i,value)!==false;value=object[++i]){}}return object;},prop:function(elem,value,type,i,name){if(jQuery.isFunction(value))value=value.call(elem,i);return value&&value.constructor==Number&&type=="curCSS"&&!exclude.test(name)?value+"px":value;},className:{add:function(elem,classNames){jQuery.each((classNames||"").split(/\s+/),function(i,className){if(elem.nodeType==1&&!jQuery.className.has(elem.className,className))elem.className+=(elem.className?" ":"")+className;});},remove:function(elem,classNames){if(elem.nodeType==1)elem.className=classNames!=undefined?jQuery.grep(elem.className.split(/\s+/),function(className){return!jQuery.className.has(classNames,className);}).join(" "):"";},has:function(elem,className){return jQuery.inArray(className,(elem.className||elem).toString().split(/\s+/))>-1;}},swap:function(elem,options,callback){var old={};for(var name in options){old[name]=elem.style[name];elem.style[name]=options[name];}callback.call(elem);for(var name in options)elem.style[name]=old[name];},css:function(elem,name,force){if(name=="width"||name=="height"){var val,props={position:"absolute",visibility:"hidden",display:"block"},which=name=="width"?["Left","Right"]:["Top","Bottom"];function getWH(){val=name=="width"?elem.offsetWidth:elem.offsetHeight;var padding=0,border=0;jQuery.each(which,function(){padding+=parseFloat(jQuery.curCSS(elem,"padding"+this,true))||0;border+=parseFloat(jQuery.curCSS(elem,"border"+this+"Width",true))||0;});val-=Math.round(padding+border);}if(jQuery(elem).is(":visible"))getWH();else
jQuery.swap(elem,props,getWH);return Math.max(0,val);}return jQuery.curCSS(elem,name,force);},curCSS:function(elem,name,force){var ret;function color(elem){if(!jQuery.browser.safari)return false;var ret=document.defaultView.getComputedStyle(elem,null);return!ret||ret.getPropertyValue("color")=="";}if(name=="opacity"&&jQuery.browser.msie){ret=jQuery.attr(elem.style,"opacity");return ret==""?"1":ret;}if(jQuery.browser.opera&&name=="display"){var save=elem.style.outline;elem.style.outline="0 solid black";elem.style.outline=save;}if(name.match(/float/i))name=styleFloat;if(!force&&elem.style&&elem.style[name])ret=elem.style[name];else if(document.defaultView&&document.defaultView.getComputedStyle){if(name.match(/float/i))name="float";name=name.replace(/([A-Z])/g,"-$1").toLowerCase();var getComputedStyle=document.defaultView.getComputedStyle(elem,null);if(getComputedStyle&&!color(elem))ret=getComputedStyle.getPropertyValue(name);else{var swap=[],stack=[];for(var a=elem;a&&color(a);a=a.parentNode)stack.unshift(a);for(var i=0;i<stack.length;i++)if(color(stack[i])){swap[i]=stack[i].style.display;stack[i].style.display="block";}ret=name=="display"&&swap[stack.length-1]!=null?"none":(getComputedStyle&&getComputedStyle.getPropertyValue(name))||"";for(var i=0;i<swap.length;i++)if(swap[i]!=null)stack[i].style.display=swap[i];}if(name=="opacity"&&ret=="")ret="1";}else if(elem.currentStyle){var camelCase=name.replace(/\-(\w)/g,function(all,letter){return letter.toUpperCase();});ret=elem.currentStyle[name]||elem.currentStyle[camelCase];if(!/^\d+(px)?$/i.test(ret)&&/^\d/.test(ret)){var style=elem.style.left,runtimeStyle=elem.runtimeStyle.left;elem.runtimeStyle.left=elem.currentStyle.left;elem.style.left=ret||0;ret=elem.style.pixelLeft+"px";elem.style.left=style;elem.runtimeStyle.left=runtimeStyle;}}return ret;},clean:function(elems,context){var ret=[];context=context||document;if(typeof context.createElement=='undefined')context=context.ownerDocument||context[0]&&context[0].ownerDocument||document;jQuery.each(elems,function(i,elem){if(!elem)return;if(elem.constructor==Number)elem=elem.toString();if(typeof elem=="string"){elem=elem.replace(/(<(\w+)[^>]*?)\/>/g,function(all,front,tag){return tag.match(/^(abbr|br|col|img|input|link|meta|param|hr|area|embed)$/i)?all:front+"></"+tag+">";});var tags=jQuery.trim(elem).toLowerCase(),div=context.createElement("div");var wrap=!tags.indexOf("<opt")&&[1,"<select multiple='multiple'>","</select>"]||!tags.indexOf("<leg")&&[1,"<fieldset>","</fieldset>"]||tags.match(/^<(thead|tbody|tfoot|colg|cap)/)&&[1,"<table>","</table>"]||!tags.indexOf("<tr")&&[2,"<table><tbody>","</tbody></table>"]||(!tags.indexOf("<td")||!tags.indexOf("<th"))&&[3,"<table><tbody><tr>","</tr></tbody></table>"]||!tags.indexOf("<col")&&[2,"<table><tbody></tbody><colgroup>","</colgroup></table>"]||jQuery.browser.msie&&[1,"div<div>","</div>"]||[0,"",""];div.innerHTML=wrap[1]+elem+wrap[2];while(wrap[0]--)div=div.lastChild;if(jQuery.browser.msie){var tbody=!tags.indexOf("<table")&&tags.indexOf("<tbody")<0?div.firstChild&&div.firstChild.childNodes:wrap[1]=="<table>"&&tags.indexOf("<tbody")<0?div.childNodes:[];for(var j=tbody.length-1;j>=0;--j)if(jQuery.nodeName(tbody[j],"tbody")&&!tbody[j].childNodes.length)tbody[j].parentNode.removeChild(tbody[j]);if(/^\s/.test(elem))div.insertBefore(context.createTextNode(elem.match(/^\s*/)[0]),div.firstChild);}elem=jQuery.makeArray(div.childNodes);}if(elem.length===0&&(!jQuery.nodeName(elem,"form")&&!jQuery.nodeName(elem,"select")))return;if(elem[0]==undefined||jQuery.nodeName(elem,"form")||elem.options)ret.push(elem);else
ret=jQuery.merge(ret,elem);});return ret;},attr:function(elem,name,value){if(!elem||elem.nodeType==3||elem.nodeType==8)return undefined;var fix=jQuery.isXMLDoc(elem)?{}:jQuery.props;if(name=="selected"&&jQuery.browser.safari)elem.parentNode.selectedIndex;if(fix[name]){if(value!=undefined)elem[fix[name]]=value;return elem[fix[name]];}else if(jQuery.browser.msie&&name=="style")return jQuery.attr(elem.style,"cssText",value);else if(value==undefined&&jQuery.browser.msie&&jQuery.nodeName(elem,"form")&&(name=="action"||name=="method"))return elem.getAttributeNode(name).nodeValue;else if(elem.tagName){if(value!=undefined){if(name=="type"&&jQuery.nodeName(elem,"input")&&elem.parentNode)throw"type property can't be changed";elem.setAttribute(name,""+value);}if(jQuery.browser.msie&&/href|src/.test(name)&&!jQuery.isXMLDoc(elem))return elem.getAttribute(name,2);return elem.getAttribute(name);}else{if(name=="opacity"&&jQuery.browser.msie){if(value!=undefined){elem.zoom=1;elem.filter=(elem.filter||"").replace(/alpha\([^)]*\)/,"")+(parseFloat(value).toString()=="NaN"?"":"alpha(opacity="+value*100+")");}return elem.filter&&elem.filter.indexOf("opacity=")>=0?(parseFloat(elem.filter.match(/opacity=([^)]*)/)[1])/100).toString():"";}name=name.replace(/-([a-z])/ig,function(all,letter){return letter.toUpperCase();});if(value!=undefined)elem[name]=value;return elem[name];}},trim:function(text){return(text||"").replace(/^\s+|\s+$/g,"");},makeArray:function(array){var ret=[];if(typeof array!="array")for(var i=0,length=array.length;i<length;i++)ret.push(array[i]);else
ret=array.slice(0);return ret;},inArray:function(elem,array){for(var i=0,length=array.length;i<length;i++)if(array[i]==elem)return i;return-1;},merge:function(first,second){if(jQuery.browser.msie){for(var i=0;second[i];i++)if(second[i].nodeType!=8)first.push(second[i]);}else
for(var i=0;second[i];i++)first.push(second[i]);return first;},unique:function(array){var ret=[],done={};try{for(var i=0,length=array.length;i<length;i++){var id=jQuery.data(array[i]);if(!done[id]){done[id]=true;ret.push(array[i]);}}}catch(e){ret=array;}return ret;},grep:function(elems,callback,inv){var ret=[];for(var i=0,length=elems.length;i<length;i++)if(!inv&&callback(elems[i],i)||inv&&!callback(elems[i],i))ret.push(elems[i]);return ret;},map:function(elems,callback){var ret=[];for(var i=0,length=elems.length;i<length;i++){var value=callback(elems[i],i);if(value!==null&&value!=undefined){if(value.constructor!=Array)value=[value];ret=ret.concat(value);}}return ret;}});var userAgent=navigator.userAgent.toLowerCase();jQuery.browser={version:(userAgent.match(/.+(?:rv|it|ra|ie)[\/: ]([\d.]+)/)||[])[1],safari:/webkit/.test(userAgent),opera:/opera/.test(userAgent),msie:/msie/.test(userAgent)&&!/opera/.test(userAgent),mozilla:/mozilla/.test(userAgent)&&!/(compatible|webkit)/.test(userAgent)};var styleFloat=jQuery.browser.msie?"styleFloat":"cssFloat";jQuery.extend({boxModel:!jQuery.browser.msie||document.compatMode=="CSS1Compat",props:{"for":"htmlFor","class":"className","float":styleFloat,cssFloat:styleFloat,styleFloat:styleFloat,innerHTML:"innerHTML",className:"className",value:"value",disabled:"disabled",checked:"checked",readonly:"readOnly",selected:"selected",maxlength:"maxLength",selectedIndex:"selectedIndex",defaultValue:"defaultValue",tagName:"tagName",nodeName:"nodeName"}});jQuery.each({parent:function(elem){return elem.parentNode;},parents:function(elem){return jQuery.dir(elem,"parentNode");},next:function(elem){return jQuery.nth(elem,2,"nextSibling");},prev:function(elem){return jQuery.nth(elem,2,"previousSibling");},nextAll:function(elem){return jQuery.dir(elem,"nextSibling");},prevAll:function(elem){return jQuery.dir(elem,"previousSibling");},siblings:function(elem){return jQuery.sibling(elem.parentNode.firstChild,elem);},children:function(elem){return jQuery.sibling(elem.firstChild);},contents:function(elem){return jQuery.nodeName(elem,"iframe")?elem.contentDocument||elem.contentWindow.document:jQuery.makeArray(elem.childNodes);}},function(name,fn){jQuery.fn[name]=function(selector){var ret=jQuery.map(this,fn);if(selector&&typeof selector=="string")ret=jQuery.multiFilter(selector,ret);return this.pushStack(jQuery.unique(ret));};});jQuery.each({appendTo:"append",prependTo:"prepend",insertBefore:"before",insertAfter:"after",replaceAll:"replaceWith"},function(name,original){jQuery.fn[name]=function(){var args=arguments;return this.each(function(){for(var i=0,length=args.length;i<length;i++)jQuery(args[i])[original](this);});};});jQuery.each({removeAttr:function(name){jQuery.attr(this,name,"");if(this.nodeType==1)this.removeAttribute(name);},addClass:function(classNames){jQuery.className.add(this,classNames);},removeClass:function(classNames){jQuery.className.remove(this,classNames);},toggleClass:function(classNames){jQuery.className[jQuery.className.has(this,classNames)?"remove":"add"](this,classNames);},remove:function(selector){if(!selector||jQuery.filter(selector,[this]).r.length){jQuery("*",this).add(this).each(function(){jQuery.event.remove(this);jQuery.removeData(this);});if(this.parentNode)this.parentNode.removeChild(this);}},empty:function(){jQuery(">*",this).remove();while(this.firstChild)this.removeChild(this.firstChild);}},function(name,fn){jQuery.fn[name]=function(){return this.each(fn,arguments);};});jQuery.each(["Height","Width"],function(i,name){var type=name.toLowerCase();jQuery.fn[type]=function(size){return this[0]==window?jQuery.browser.opera&&document.body["client"+name]||jQuery.browser.safari&&window["inner"+name]||document.compatMode=="CSS1Compat"&&document.documentElement["client"+name]||document.body["client"+name]:this[0]==document?Math.max(Math.max(document.body["scroll"+name],document.documentElement["scroll"+name]),Math.max(document.body["offset"+name],document.documentElement["offset"+name])):size==undefined?(this.length?jQuery.css(this[0],type):null):this.css(type,size.constructor==String?size:size+"px");};});var chars=jQuery.browser.safari&&parseInt(jQuery.browser.version)<417?"(?:[\\w*_-]|\\\\.)":"(?:[\\w\u0128-\uFFFF*_-]|\\\\.)",quickChild=new RegExp("^>\\s*("+chars+"+)"),quickID=new RegExp("^("+chars+"+)(#)("+chars+"+)"),quickClass=new RegExp("^([#.]?)("+chars+"*)");jQuery.extend({expr:{"":function(a,i,m){return m[2]=="*"||jQuery.nodeName(a,m[2]);},"#":function(a,i,m){return a.getAttribute("id")==m[2];},":":{lt:function(a,i,m){return i<m[3]-0;},gt:function(a,i,m){return i>m[3]-0;},nth:function(a,i,m){return m[3]-0==i;},eq:function(a,i,m){return m[3]-0==i;},first:function(a,i){return i==0;},last:function(a,i,m,r){return i==r.length-1;},even:function(a,i){return i%2==0;},odd:function(a,i){return i%2;},"first-child":function(a){return a.parentNode.getElementsByTagName("*")[0]==a;},"last-child":function(a){return jQuery.nth(a.parentNode.lastChild,1,"previousSibling")==a;},"only-child":function(a){return!jQuery.nth(a.parentNode.lastChild,2,"previousSibling");},parent:function(a){return a.firstChild;},empty:function(a){return!a.firstChild;},contains:function(a,i,m){return(a.textContent||a.innerText||jQuery(a).text()||"").indexOf(m[3])>=0;},visible:function(a){return"hidden"!=a.type&&jQuery.css(a,"display")!="none"&&jQuery.css(a,"visibility")!="hidden";},hidden:function(a){return"hidden"==a.type||jQuery.css(a,"display")=="none"||jQuery.css(a,"visibility")=="hidden";},enabled:function(a){return!a.disabled;},disabled:function(a){return a.disabled;},checked:function(a){return a.checked;},selected:function(a){return a.selected||jQuery.attr(a,"selected");},text:function(a){return"text"==a.type;},radio:function(a){return"radio"==a.type;},checkbox:function(a){return"checkbox"==a.type;},file:function(a){return"file"==a.type;},password:function(a){return"password"==a.type;},submit:function(a){return"submit"==a.type;},image:function(a){return"image"==a.type;},reset:function(a){return"reset"==a.type;},button:function(a){return"button"==a.type||jQuery.nodeName(a,"button");},input:function(a){return/input|select|textarea|button/i.test(a.nodeName);},has:function(a,i,m){return jQuery.find(m[3],a).length;},header:function(a){return/h\d/i.test(a.nodeName);},animated:function(a){return jQuery.grep(jQuery.timers,function(fn){return a==fn.elem;}).length;}}},parse:[/^(\[) *@?([\w-]+) *([!*$^~=]*) *('?"?)(.*?)\4 *\]/,/^(:)([\w-]+)\("?'?(.*?(\(.*?\))?[^(]*?)"?'?\)/,new RegExp("^([:.#]*)("+chars+"+)")],multiFilter:function(expr,elems,not){var old,cur=[];while(expr&&expr!=old){old=expr;var f=jQuery.filter(expr,elems,not);expr=f.t.replace(/^\s*,\s*/,"");cur=not?elems=f.r:jQuery.merge(cur,f.r);}return cur;},find:function(t,context){if(typeof t!="string")return[t];if(context&&context.nodeType!=1&&context.nodeType!=9)return[];context=context||document;var ret=[context],done=[],last,nodeName;while(t&&last!=t){var r=[];last=t;t=jQuery.trim(t);var foundToken=false;var re=quickChild;var m=re.exec(t);if(m){nodeName=m[1].toUpperCase();for(var i=0;ret[i];i++)for(var c=ret[i].firstChild;c;c=c.nextSibling)if(c.nodeType==1&&(nodeName=="*"||c.nodeName.toUpperCase()==nodeName))r.push(c);ret=r;t=t.replace(re,"");if(t.indexOf(" ")==0)continue;foundToken=true;}else{re=/^([>+~])\s*(\w*)/i;if((m=re.exec(t))!=null){r=[];var merge={};nodeName=m[2].toUpperCase();m=m[1];for(var j=0,rl=ret.length;j<rl;j++){var n=m=="~"||m=="+"?ret[j].nextSibling:ret[j].firstChild;for(;n;n=n.nextSibling)if(n.nodeType==1){var id=jQuery.data(n);if(m=="~"&&merge[id])break;if(!nodeName||n.nodeName.toUpperCase()==nodeName){if(m=="~")merge[id]=true;r.push(n);}if(m=="+")break;}}ret=r;t=jQuery.trim(t.replace(re,""));foundToken=true;}}if(t&&!foundToken){if(!t.indexOf(",")){if(context==ret[0])ret.shift();done=jQuery.merge(done,ret);r=ret=[context];t=" "+t.substr(1,t.length);}else{var re2=quickID;var m=re2.exec(t);if(m){m=[0,m[2],m[3],m[1]];}else{re2=quickClass;m=re2.exec(t);}m[2]=m[2].replace(/\\/g,"");var elem=ret[ret.length-1];if(m[1]=="#"&&elem&&elem.getElementById&&!jQuery.isXMLDoc(elem)){var oid=elem.getElementById(m[2]);if((jQuery.browser.msie||jQuery.browser.opera)&&oid&&typeof oid.id=="string"&&oid.id!=m[2])oid=jQuery('[@id="'+m[2]+'"]',elem)[0];ret=r=oid&&(!m[3]||jQuery.nodeName(oid,m[3]))?[oid]:[];}else{for(var i=0;ret[i];i++){var tag=m[1]=="#"&&m[3]?m[3]:m[1]!=""||m[0]==""?"*":m[2];if(tag=="*"&&ret[i].nodeName.toLowerCase()=="object")tag="param";r=jQuery.merge(r,ret[i].getElementsByTagName(tag));}if(m[1]==".")r=jQuery.classFilter(r,m[2]);if(m[1]=="#"){var tmp=[];for(var i=0;r[i];i++)if(r[i].getAttribute("id")==m[2]){tmp=[r[i]];break;}r=tmp;}ret=r;}t=t.replace(re2,"");}}if(t){var val=jQuery.filter(t,r);ret=r=val.r;t=jQuery.trim(val.t);}}if(t)ret=[];if(ret&&context==ret[0])ret.shift();done=jQuery.merge(done,ret);return done;},classFilter:function(r,m,not){m=" "+m+" ";var tmp=[];for(var i=0;r[i];i++){var pass=(" "+r[i].className+" ").indexOf(m)>=0;if(!not&&pass||not&&!pass)tmp.push(r[i]);}return tmp;},filter:function(t,r,not){var last;while(t&&t!=last){last=t;var p=jQuery.parse,m;for(var i=0;p[i];i++){m=p[i].exec(t);if(m){t=t.substring(m[0].length);m[2]=m[2].replace(/\\/g,"");break;}}if(!m)break;if(m[1]==":"&&m[2]=="not")r=isSimple.test(m[3])?jQuery.filter(m[3],r,true).r:jQuery(r).not(m[3]);else if(m[1]==".")r=jQuery.classFilter(r,m[2],not);else if(m[1]=="["){var tmp=[],type=m[3];for(var i=0,rl=r.length;i<rl;i++){var a=r[i],z=a[jQuery.props[m[2]]||m[2]];if(z==null||/href|src|selected/.test(m[2]))z=jQuery.attr(a,m[2])||'';if((type==""&&!!z||type=="="&&z==m[5]||type=="!="&&z!=m[5]||type=="^="&&z&&!z.indexOf(m[5])||type=="$="&&z.substr(z.length-m[5].length)==m[5]||(type=="*="||type=="~=")&&z.indexOf(m[5])>=0)^not)tmp.push(a);}r=tmp;}else if(m[1]==":"&&m[2]=="nth-child"){var merge={},tmp=[],test=/(-?)(\d*)n((?:\+|-)?\d*)/.exec(m[3]=="even"&&"2n"||m[3]=="odd"&&"2n+1"||!/\D/.test(m[3])&&"0n+"+m[3]||m[3]),first=(test[1]+(test[2]||1))-0,last=test[3]-0;for(var i=0,rl=r.length;i<rl;i++){var node=r[i],parentNode=node.parentNode,id=jQuery.data(parentNode);if(!merge[id]){var c=1;for(var n=parentNode.firstChild;n;n=n.nextSibling)if(n.nodeType==1)n.nodeIndex=c++;merge[id]=true;}var add=false;if(first==0){if(node.nodeIndex==last)add=true;}else if((node.nodeIndex-last)%first==0&&(node.nodeIndex-last)/first>=0)add=true;if(add^not)tmp.push(node);}r=tmp;}else{var fn=jQuery.expr[m[1]];if(typeof fn=="object")fn=fn[m[2]];if(typeof fn=="string")fn=eval("false||function(a,i){return "+fn+";}");r=jQuery.grep(r,function(elem,i){return fn(elem,i,m,r);},not);}}return{r:r,t:t};},dir:function(elem,dir){var matched=[];var cur=elem[dir];while(cur&&cur!=document){if(cur.nodeType==1)matched.push(cur);cur=cur[dir];}return matched;},nth:function(cur,result,dir,elem){result=result||1;var num=0;for(;cur;cur=cur[dir])if(cur.nodeType==1&&++num==result)break;return cur;},sibling:function(n,elem){var r=[];for(;n;n=n.nextSibling){if(n.nodeType==1&&(!elem||n!=elem))r.push(n);}return r;}});jQuery.event={add:function(elem,types,handler,data){if(elem.nodeType==3||elem.nodeType==8)return;if(jQuery.browser.msie&&elem.setInterval!=undefined)elem=window;if(!handler.guid)handler.guid=this.guid++;if(data!=undefined){var fn=handler;handler=function(){return fn.apply(this,arguments);};handler.data=data;handler.guid=fn.guid;}var events=jQuery.data(elem,"events")||jQuery.data(elem,"events",{}),handle=jQuery.data(elem,"handle")||jQuery.data(elem,"handle",function(){var val;if(typeof jQuery=="undefined"||jQuery.event.triggered)return val;val=jQuery.event.handle.apply(arguments.callee.elem,arguments);return val;});handle.elem=elem;jQuery.each(types.split(/\s+/),function(index,type){var parts=type.split(".");type=parts[0];handler.type=parts[1];var handlers=events[type];if(!handlers){handlers=events[type]={};if(!jQuery.event.special[type]||jQuery.event.special[type].setup.call(elem)===false){if(elem.addEventListener)elem.addEventListener(type,handle,false);else if(elem.attachEvent)elem.attachEvent("on"+type,handle);}}handlers[handler.guid]=handler;jQuery.event.global[type]=true;});elem=null;},guid:1,global:{},remove:function(elem,types,handler){if(elem.nodeType==3||elem.nodeType==8)return;var events=jQuery.data(elem,"events"),ret,index;if(events){if(types==undefined||(typeof types=="string"&&types.charAt(0)=="."))for(var type in events)this.remove(elem,type+(types||""));else{if(types.type){handler=types.handler;types=types.type;}jQuery.each(types.split(/\s+/),function(index,type){var parts=type.split(".");type=parts[0];if(events[type]){if(handler)delete events[type][handler.guid];else
for(handler in events[type])if(!parts[1]||events[type][handler].type==parts[1])delete events[type][handler];for(ret in events[type])break;if(!ret){if(!jQuery.event.special[type]||jQuery.event.special[type].teardown.call(elem)===false){if(elem.removeEventListener)elem.removeEventListener(type,jQuery.data(elem,"handle"),false);else if(elem.detachEvent)elem.detachEvent("on"+type,jQuery.data(elem,"handle"));}ret=null;delete events[type];}}});}for(ret in events)break;if(!ret){var handle=jQuery.data(elem,"handle");if(handle)handle.elem=null;jQuery.removeData(elem,"events");jQuery.removeData(elem,"handle");}}},trigger:function(type,data,elem,donative,extra){data=jQuery.makeArray(data||[]);if(type.indexOf("!")>=0){type=type.slice(0,-1);var exclusive=true;}if(!elem){if(this.global[type])jQuery("*").add([window,document]).trigger(type,data);}else{if(elem.nodeType==3||elem.nodeType==8)return undefined;var val,ret,fn=jQuery.isFunction(elem[type]||null),event=!data[0]||!data[0].preventDefault;if(event)data.unshift(this.fix({type:type,target:elem}));data[0].type=type;if(exclusive)data[0].exclusive=true;if(jQuery.isFunction(jQuery.data(elem,"handle")))val=jQuery.data(elem,"handle").apply(elem,data);if(!fn&&elem["on"+type]&&elem["on"+type].apply(elem,data)===false)val=false;if(event)data.shift();if(extra&&jQuery.isFunction(extra)){ret=extra.apply(elem,val==null?data:data.concat(val));if(ret!==undefined)val=ret;}if(fn&&donative!==false&&val!==false&&!(jQuery.nodeName(elem,'a')&&type=="click")){this.triggered=true;try{elem[type]();}catch(e){}}this.triggered=false;}return val;},handle:function(event){var val;event=jQuery.event.fix(event||window.event||{});var parts=event.type.split(".");event.type=parts[0];var handlers=jQuery.data(this,"events")&&jQuery.data(this,"events")[event.type],args=Array.prototype.slice.call(arguments,1);args.unshift(event);for(var j in handlers){var handler=handlers[j];args[0].handler=handler;args[0].data=handler.data;if(!parts[1]&&!event.exclusive||handler.type==parts[1]){var ret=handler.apply(this,args);if(val!==false)val=ret;if(ret===false){event.preventDefault();event.stopPropagation();}}}if(jQuery.browser.msie)event.target=event.preventDefault=event.stopPropagation=event.handler=event.data=null;return val;},fix:function(event){var originalEvent=event;event=jQuery.extend({},originalEvent);event.preventDefault=function(){if(originalEvent.preventDefault)originalEvent.preventDefault();originalEvent.returnValue=false;};event.stopPropagation=function(){if(originalEvent.stopPropagation)originalEvent.stopPropagation();originalEvent.cancelBubble=true;};if(!event.target)event.target=event.srcElement||document;if(event.target.nodeType==3)event.target=originalEvent.target.parentNode;if(!event.relatedTarget&&event.fromElement)event.relatedTarget=event.fromElement==event.target?event.toElement:event.fromElement;if(event.pageX==null&&event.clientX!=null){var doc=document.documentElement,body=document.body;event.pageX=event.clientX+(doc&&doc.scrollLeft||body&&body.scrollLeft||0)-(doc.clientLeft||0);event.pageY=event.clientY+(doc&&doc.scrollTop||body&&body.scrollTop||0)-(doc.clientTop||0);}if(!event.which&&((event.charCode||event.charCode===0)?event.charCode:event.keyCode))event.which=event.charCode||event.keyCode;if(!event.metaKey&&event.ctrlKey)event.metaKey=event.ctrlKey;if(!event.which&&event.button)event.which=(event.button&1?1:(event.button&2?3:(event.button&4?2:0)));return event;},special:{ready:{setup:function(){bindReady();return;},teardown:function(){return;}},mouseenter:{setup:function(){if(jQuery.browser.msie)return false;jQuery(this).bind("mouseover",jQuery.event.special.mouseenter.handler);return true;},teardown:function(){if(jQuery.browser.msie)return false;jQuery(this).unbind("mouseover",jQuery.event.special.mouseenter.handler);return true;},handler:function(event){if(withinElement(event,this))return true;arguments[0].type="mouseenter";return jQuery.event.handle.apply(this,arguments);}},mouseleave:{setup:function(){if(jQuery.browser.msie)return false;jQuery(this).bind("mouseout",jQuery.event.special.mouseleave.handler);return true;},teardown:function(){if(jQuery.browser.msie)return false;jQuery(this).unbind("mouseout",jQuery.event.special.mouseleave.handler);return true;},handler:function(event){if(withinElement(event,this))return true;arguments[0].type="mouseleave";return jQuery.event.handle.apply(this,arguments);}}}};jQuery.fn.extend({bind:function(type,data,fn){return type=="unload"?this.one(type,data,fn):this.each(function(){jQuery.event.add(this,type,fn||data,fn&&data);});},one:function(type,data,fn){return this.each(function(){jQuery.event.add(this,type,function(event){jQuery(this).unbind(event);return(fn||data).apply(this,arguments);},fn&&data);});},unbind:function(type,fn){return this.each(function(){jQuery.event.remove(this,type,fn);});},trigger:function(type,data,fn){return this.each(function(){jQuery.event.trigger(type,data,this,true,fn);});},triggerHandler:function(type,data,fn){if(this[0])return jQuery.event.trigger(type,data,this[0],false,fn);return undefined;},toggle:function(){var args=arguments;return this.click(function(event){this.lastToggle=0==this.lastToggle?1:0;event.preventDefault();return args[this.lastToggle].apply(this,arguments)||false;});},hover:function(fnOver,fnOut){return this.bind('mouseenter',fnOver).bind('mouseleave',fnOut);},ready:function(fn){bindReady();if(jQuery.isReady)fn.call(document,jQuery);else
jQuery.readyList.push(function(){return fn.call(this,jQuery);});return this;}});jQuery.extend({isReady:false,readyList:[],ready:function(){if(!jQuery.isReady){jQuery.isReady=true;if(jQuery.readyList){jQuery.each(jQuery.readyList,function(){this.apply(document);});jQuery.readyList=null;}jQuery(document).triggerHandler("ready");}}});var readyBound=false;function bindReady(){if(readyBound)return;readyBound=true;if(document.addEventListener&&!jQuery.browser.opera)document.addEventListener("DOMContentLoaded",jQuery.ready,false);if(jQuery.browser.msie&&window==top)(function(){if(jQuery.isReady)return;try{document.documentElement.doScroll("left");}catch(error){setTimeout(arguments.callee,0);return;}jQuery.ready();})();if(jQuery.browser.opera)document.addEventListener("DOMContentLoaded",function(){if(jQuery.isReady)return;for(var i=0;i<document.styleSheets.length;i++)if(document.styleSheets[i].disabled){setTimeout(arguments.callee,0);return;}jQuery.ready();},false);if(jQuery.browser.safari){var numStyles;(function(){if(jQuery.isReady)return;if(document.readyState!="loaded"&&document.readyState!="complete"){setTimeout(arguments.callee,0);return;}if(numStyles===undefined)numStyles=jQuery("style, link[rel=stylesheet]").length;if(document.styleSheets.length!=numStyles){setTimeout(arguments.callee,0);return;}jQuery.ready();})();}jQuery.event.add(window,"load",jQuery.ready);}jQuery.each(("blur,focus,load,resize,scroll,unload,click,dblclick,"+"mousedown,mouseup,mousemove,mouseover,mouseout,change,select,"+"submit,keydown,keypress,keyup,error").split(","),function(i,name){jQuery.fn[name]=function(fn){return fn?this.bind(name,fn):this.trigger(name);};});var withinElement=function(event,elem){var parent=event.relatedTarget;while(parent&&parent!=elem)try{parent=parent.parentNode;}catch(error){parent=elem;}return parent==elem;};jQuery(window).bind("unload",function(){jQuery("*").add(document).unbind();});jQuery.fn.extend({load:function(url,params,callback){if(jQuery.isFunction(url))return this.bind("load",url);var off=url.indexOf(" ");if(off>=0){var selector=url.slice(off,url.length);url=url.slice(0,off);}callback=callback||function(){};var type="GET";if(params)if(jQuery.isFunction(params)){callback=params;params=null;}else{params=jQuery.param(params);type="POST";}var self=this;jQuery.ajax({url:url,type:type,dataType:"html",data:params,complete:function(res,status){if(status=="success"||status=="notmodified")self.html(selector?jQuery("<div/>").append(res.responseText.replace(/<script(.|\s)*?\/script>/g,"")).find(selector):res.responseText);self.each(callback,[res.responseText,status,res]);}});return this;},serialize:function(){return jQuery.param(this.serializeArray());},serializeArray:function(){return this.map(function(){return jQuery.nodeName(this,"form")?jQuery.makeArray(this.elements):this;}).filter(function(){return this.name&&!this.disabled&&(this.checked||/select|textarea/i.test(this.nodeName)||/text|hidden|password/i.test(this.type));}).map(function(i,elem){var val=jQuery(this).val();return val==null?null:val.constructor==Array?jQuery.map(val,function(val,i){return{name:elem.name,value:val};}):{name:elem.name,value:val};}).get();}});jQuery.each("ajaxStart,ajaxStop,ajaxComplete,ajaxError,ajaxSuccess,ajaxSend".split(","),function(i,o){jQuery.fn[o]=function(f){return this.bind(o,f);};});var jsc=(new Date).getTime();jQuery.extend({get:function(url,data,callback,type){if(jQuery.isFunction(data)){callback=data;data=null;}return jQuery.ajax({type:"GET",url:url,data:data,success:callback,dataType:type});},getScript:function(url,callback){return jQuery.get(url,null,callback,"script");},getJSON:function(url,data,callback){return jQuery.get(url,data,callback,"json");},post:function(url,data,callback,type){if(jQuery.isFunction(data)){callback=data;data={};}return jQuery.ajax({type:"POST",url:url,data:data,success:callback,dataType:type});},ajaxSetup:function(settings){jQuery.extend(jQuery.ajaxSettings,settings);},ajaxSettings:{global:true,type:"GET",timeout:0,contentType:"application/x-www-form-urlencoded",processData:true,async:true,data:null,username:null,password:null,accepts:{xml:"application/xml, text/xml",html:"text/html",script:"text/javascript, application/javascript",json:"application/json, text/javascript",text:"text/plain",_default:"*/*"}},lastModified:{},ajax:function(s){var jsonp,jsre=/=\?(&|$)/g,status,data;s=jQuery.extend(true,s,jQuery.extend(true,{},jQuery.ajaxSettings,s));if(s.data&&s.processData&&typeof s.data!="string")s.data=jQuery.param(s.data);if(s.dataType=="jsonp"){if(s.type.toLowerCase()=="get"){if(!s.url.match(jsre))s.url+=(s.url.match(/\?/)?"&":"?")+(s.jsonp||"callback")+"=?";}else if(!s.data||!s.data.match(jsre))s.data=(s.data?s.data+"&":"")+(s.jsonp||"callback")+"=?";s.dataType="json";}if(s.dataType=="json"&&(s.data&&s.data.match(jsre)||s.url.match(jsre))){jsonp="jsonp"+jsc++;if(s.data)s.data=(s.data+"").replace(jsre,"="+jsonp+"$1");s.url=s.url.replace(jsre,"="+jsonp+"$1");s.dataType="script";window[jsonp]=function(tmp){data=tmp;success();complete();window[jsonp]=undefined;try{delete window[jsonp];}catch(e){}if(head)head.removeChild(script);};}if(s.dataType=="script"&&s.cache==null)s.cache=false;if(s.cache===false&&s.type.toLowerCase()=="get"){var ts=(new Date()).getTime();var ret=s.url.replace(/(\?|&)_=.*?(&|$)/,"$1_="+ts+"$2");s.url=ret+((ret==s.url)?(s.url.match(/\?/)?"&":"?")+"_="+ts:"");}if(s.data&&s.type.toLowerCase()=="get"){s.url+=(s.url.match(/\?/)?"&":"?")+s.data;s.data=null;}if(s.global&&!jQuery.active++)jQuery.event.trigger("ajaxStart");if((!s.url.indexOf("http")||!s.url.indexOf("//"))&&s.dataType=="script"&&s.type.toLowerCase()=="get"){var head=document.getElementsByTagName("head")[0];var script=document.createElement("script");script.src=s.url;if(s.scriptCharset)script.charset=s.scriptCharset;if(!jsonp){var done=false;script.onload=script.onreadystatechange=function(){if(!done&&(!this.readyState||this.readyState=="loaded"||this.readyState=="complete")){done=true;success();complete();head.removeChild(script);}};}head.appendChild(script);return undefined;}var requestDone=false;var xml=window.ActiveXObject?new ActiveXObject("Microsoft.XMLHTTP"):new XMLHttpRequest();xml.open(s.type,s.url,s.async,s.username,s.password);try{if(s.data)xml.setRequestHeader("Content-Type",s.contentType);if(s.ifModified)xml.setRequestHeader("If-Modified-Since",jQuery.lastModified[s.url]||"Thu, 01 Jan 1970 00:00:00 GMT");xml.setRequestHeader("X-Requested-With","XMLHttpRequest");xml.setRequestHeader("Accept",s.dataType&&s.accepts[s.dataType]?s.accepts[s.dataType]+", */*":s.accepts._default);}catch(e){}if(s.beforeSend)s.beforeSend(xml);if(s.global)jQuery.event.trigger("ajaxSend",[xml,s]);var onreadystatechange=function(isTimeout){if(!requestDone&&xml&&(xml.readyState==4||isTimeout=="timeout")){requestDone=true;if(ival){clearInterval(ival);ival=null;}status=isTimeout=="timeout"&&"timeout"||!jQuery.httpSuccess(xml)&&"error"||s.ifModified&&jQuery.httpNotModified(xml,s.url)&&"notmodified"||"success";if(status=="success"){try{data=jQuery.httpData(xml,s.dataType);}catch(e){status="parsererror";}}if(status=="success"){var modRes;try{modRes=xml.getResponseHeader("Last-Modified");}catch(e){}if(s.ifModified&&modRes)jQuery.lastModified[s.url]=modRes;if(!jsonp)success();}else
jQuery.handleError(s,xml,status);complete();if(s.async)xml=null;}};if(s.async){var ival=setInterval(onreadystatechange,13);if(s.timeout>0)setTimeout(function(){if(xml){xml.abort();if(!requestDone)onreadystatechange("timeout");}},s.timeout);}try{xml.send(s.data);}catch(e){jQuery.handleError(s,xml,null,e);}if(!s.async)onreadystatechange();function success(){if(s.success)s.success(data,status);if(s.global)jQuery.event.trigger("ajaxSuccess",[xml,s]);}function complete(){if(s.complete)s.complete(xml,status);if(s.global)jQuery.event.trigger("ajaxComplete",[xml,s]);if(s.global&&!--jQuery.active)jQuery.event.trigger("ajaxStop");}return xml;},handleError:function(s,xml,status,e){if(s.error)s.error(xml,status,e);if(s.global)jQuery.event.trigger("ajaxError",[xml,s,e]);},active:0,httpSuccess:function(r){try{return!r.status&&location.protocol=="file:"||(r.status>=200&&r.status<300)||r.status==304||r.status==1223||jQuery.browser.safari&&r.status==undefined;}catch(e){}return false;},httpNotModified:function(xml,url){try{var xmlRes=xml.getResponseHeader("Last-Modified");return xml.status==304||xmlRes==jQuery.lastModified[url]||jQuery.browser.safari&&xml.status==undefined;}catch(e){}return false;},httpData:function(r,type){var ct=r.getResponseHeader("content-type");var xml=type=="xml"||!type&&ct&&ct.indexOf("xml")>=0;var data=xml?r.responseXML:r.responseText;if(xml&&data.documentElement.tagName=="parsererror")throw"parsererror";if(type=="script")jQuery.globalEval(data);if(type=="json")data=eval("("+data+")");return data;},param:function(a){var s=[];if(a.constructor==Array||a.jquery)jQuery.each(a,function(){s.push(encodeURIComponent(this.name)+"="+encodeURIComponent(this.value));});else
for(var j in a)if(a[j]&&a[j].constructor==Array)jQuery.each(a[j],function(){s.push(encodeURIComponent(j)+"="+encodeURIComponent(this));});else
s.push(encodeURIComponent(j)+"="+encodeURIComponent(a[j]));return s.join("&").replace(/%20/g,"+");}});jQuery.fn.extend({show:function(speed,callback){return speed?this.animate({height:"show",width:"show",opacity:"show"},speed,callback):this.filter(":hidden").each(function(){this.style.display=this.oldblock||"";if(jQuery.css(this,"display")=="none"){var elem=jQuery("<"+this.tagName+" />").appendTo("body");this.style.display=elem.css("display");if(this.style.display=="none")this.style.display="block";elem.remove();}}).end();},hide:function(speed,callback){return speed?this.animate({height:"hide",width:"hide",opacity:"hide"},speed,callback):this.filter(":visible").each(function(){this.oldblock=this.oldblock||jQuery.css(this,"display");this.style.display="none";}).end();},_toggle:jQuery.fn.toggle,toggle:function(fn,fn2){return jQuery.isFunction(fn)&&jQuery.isFunction(fn2)?this._toggle(fn,fn2):fn?this.animate({height:"toggle",width:"toggle",opacity:"toggle"},fn,fn2):this.each(function(){jQuery(this)[jQuery(this).is(":hidden")?"show":"hide"]();});},slideDown:function(speed,callback){return this.animate({height:"show"},speed,callback);},slideUp:function(speed,callback){return this.animate({height:"hide"},speed,callback);},slideToggle:function(speed,callback){return this.animate({height:"toggle"},speed,callback);},fadeIn:function(speed,callback){return this.animate({opacity:"show"},speed,callback);},fadeOut:function(speed,callback){return this.animate({opacity:"hide"},speed,callback);},fadeTo:function(speed,to,callback){return this.animate({opacity:to},speed,callback);},animate:function(prop,speed,easing,callback){var optall=jQuery.speed(speed,easing,callback);return this[optall.queue===false?"each":"queue"](function(){if(this.nodeType!=1)return false;var opt=jQuery.extend({},optall);var hidden=jQuery(this).is(":hidden"),self=this;for(var p in prop){if(prop[p]=="hide"&&hidden||prop[p]=="show"&&!hidden)return jQuery.isFunction(opt.complete)&&opt.complete.apply(this);if(p=="height"||p=="width"){opt.display=jQuery.css(this,"display");opt.overflow=this.style.overflow;}}if(opt.overflow!=null)this.style.overflow="hidden";opt.curAnim=jQuery.extend({},prop);jQuery.each(prop,function(name,val){var e=new jQuery.fx(self,opt,name);if(/toggle|show|hide/.test(val))e[val=="toggle"?hidden?"show":"hide":val](prop);else{var parts=val.toString().match(/^([+-]=)?([\d+-.]+)(.*)$/),start=e.cur(true)||0;if(parts){var end=parseFloat(parts[2]),unit=parts[3]||"px";if(unit!="px"){self.style[name]=(end||1)+unit;start=((end||1)/e.cur(true))*start;self.style[name]=start+unit;}if(parts[1])end=((parts[1]=="-="?-1:1)*end)+start;e.custom(start,end,unit);}else
e.custom(start,val,"");}});return true;});},queue:function(type,fn){if(jQuery.isFunction(type)||(type&&type.constructor==Array)){fn=type;type="fx";}if(!type||(typeof type=="string"&&!fn))return queue(this[0],type);return this.each(function(){if(fn.constructor==Array)queue(this,type,fn);else{queue(this,type).push(fn);if(queue(this,type).length==1)fn.apply(this);}});},stop:function(clearQueue,gotoEnd){var timers=jQuery.timers;if(clearQueue)this.queue([]);this.each(function(){for(var i=timers.length-1;i>=0;i--)if(timers[i].elem==this){if(gotoEnd)timers[i](true);timers.splice(i,1);}});if(!gotoEnd)this.dequeue();return this;}});var queue=function(elem,type,array){if(!elem)return undefined;type=type||"fx";var q=jQuery.data(elem,type+"queue");if(!q||array)q=jQuery.data(elem,type+"queue",array?jQuery.makeArray(array):[]);return q;};jQuery.fn.dequeue=function(type){type=type||"fx";return this.each(function(){var q=queue(this,type);q.shift();if(q.length)q[0].apply(this);});};jQuery.extend({speed:function(speed,easing,fn){var opt=speed&&speed.constructor==Object?speed:{complete:fn||!fn&&easing||jQuery.isFunction(speed)&&speed,duration:speed,easing:fn&&easing||easing&&easing.constructor!=Function&&easing};opt.duration=(opt.duration&&opt.duration.constructor==Number?opt.duration:{slow:600,fast:200}[opt.duration])||400;opt.old=opt.complete;opt.complete=function(){if(opt.queue!==false)jQuery(this).dequeue();if(jQuery.isFunction(opt.old))opt.old.apply(this);};return opt;},easing:{linear:function(p,n,firstNum,diff){return firstNum+diff*p;},swing:function(p,n,firstNum,diff){return((-Math.cos(p*Math.PI)/2)+0.5)*diff+firstNum;}},timers:[],timerId:null,fx:function(elem,options,prop){this.options=options;this.elem=elem;this.prop=prop;if(!options.orig)options.orig={};}});jQuery.fx.prototype={update:function(){if(this.options.step)this.options.step.apply(this.elem,[this.now,this]);(jQuery.fx.step[this.prop]||jQuery.fx.step._default)(this);if(this.prop=="height"||this.prop=="width")this.elem.style.display="block";},cur:function(force){if(this.elem[this.prop]!=null&&this.elem.style[this.prop]==null)return this.elem[this.prop];var r=parseFloat(jQuery.css(this.elem,this.prop,force));return r&&r>-10000?r:parseFloat(jQuery.curCSS(this.elem,this.prop))||0;},custom:function(from,to,unit){this.startTime=(new Date()).getTime();this.start=from;this.end=to;this.unit=unit||this.unit||"px";this.now=this.start;this.pos=this.state=0;this.update();var self=this;function t(gotoEnd){return self.step(gotoEnd);}t.elem=this.elem;jQuery.timers.push(t);if(jQuery.timerId==null){jQuery.timerId=setInterval(function(){var timers=jQuery.timers;for(var i=0;i<timers.length;i++)if(!timers[i]())timers.splice(i--,1);if(!timers.length){clearInterval(jQuery.timerId);jQuery.timerId=null;}},13);}},show:function(){this.options.orig[this.prop]=jQuery.attr(this.elem.style,this.prop);this.options.show=true;this.custom(0,this.cur());if(this.prop=="width"||this.prop=="height")this.elem.style[this.prop]="1px";jQuery(this.elem).show();},hide:function(){this.options.orig[this.prop]=jQuery.attr(this.elem.style,this.prop);this.options.hide=true;this.custom(this.cur(),0);},step:function(gotoEnd){var t=(new Date()).getTime();if(gotoEnd||t>this.options.duration+this.startTime){this.now=this.end;this.pos=this.state=1;this.update();this.options.curAnim[this.prop]=true;var done=true;for(var i in this.options.curAnim)if(this.options.curAnim[i]!==true)done=false;if(done){if(this.options.display!=null){this.elem.style.overflow=this.options.overflow;this.elem.style.display=this.options.display;if(jQuery.css(this.elem,"display")=="none")this.elem.style.display="block";}if(this.options.hide)this.elem.style.display="none";if(this.options.hide||this.options.show)for(var p in this.options.curAnim)jQuery.attr(this.elem.style,p,this.options.orig[p]);}if(done&&jQuery.isFunction(this.options.complete))this.options.complete.apply(this.elem);return false;}else{var n=t-this.startTime;this.state=n/this.options.duration;this.pos=jQuery.easing[this.options.easing||(jQuery.easing.swing?"swing":"linear")](this.state,n,0,1,this.options.duration);this.now=this.start+((this.end-this.start)*this.pos);this.update();}return true;}};jQuery.fx.step={scrollLeft:function(fx){fx.elem.scrollLeft=fx.now;},scrollTop:function(fx){fx.elem.scrollTop=fx.now;},opacity:function(fx){jQuery.attr(fx.elem.style,"opacity",fx.now);},_default:function(fx){fx.elem.style[fx.prop]=fx.now+fx.unit;}};jQuery.fn.offset=function(){var left=0,top=0,elem=this[0],results;if(elem)with(jQuery.browser){var parent=elem.parentNode,offsetChild=elem,offsetParent=elem.offsetParent,doc=elem.ownerDocument,safari2=safari&&parseInt(version)<522&&!/adobeair/i.test(userAgent),fixed=jQuery.css(elem,"position")=="fixed";if(elem.getBoundingClientRect){var box=elem.getBoundingClientRect();add(box.left+Math.max(doc.documentElement.scrollLeft,doc.body.scrollLeft),box.top+Math.max(doc.documentElement.scrollTop,doc.body.scrollTop));add(-doc.documentElement.clientLeft,-doc.documentElement.clientTop);}else{add(elem.offsetLeft,elem.offsetTop);while(offsetParent){add(offsetParent.offsetLeft,offsetParent.offsetTop);if(mozilla&&!/^t(able|d|h)$/i.test(offsetParent.tagName)||safari&&!safari2)border(offsetParent);if(!fixed&&jQuery.css(offsetParent,"position")=="fixed")fixed=true;offsetChild=/^body$/i.test(offsetParent.tagName)?offsetChild:offsetParent;offsetParent=offsetParent.offsetParent;}while(parent&&parent.tagName&&!/^body|html$/i.test(parent.tagName)){if(!/^inline|table.*$/i.test(jQuery.css(parent,"display")))add(-parent.scrollLeft,-parent.scrollTop);if(mozilla&&jQuery.css(parent,"overflow")!="visible")border(parent);parent=parent.parentNode;}if((safari2&&(fixed||jQuery.css(offsetChild,"position")=="absolute"))||(mozilla&&jQuery.css(offsetChild,"position")!="absolute"))add(-doc.body.offsetLeft,-doc.body.offsetTop);if(fixed)add(Math.max(doc.documentElement.scrollLeft,doc.body.scrollLeft),Math.max(doc.documentElement.scrollTop,doc.body.scrollTop));}results={top:top,left:left};}function border(elem){add(jQuery.curCSS(elem,"borderLeftWidth",true),jQuery.curCSS(elem,"borderTopWidth",true));}function add(l,t){left+=parseInt(l)||0;top+=parseInt(t)||0;}return results;};})();
if(window.jstiming)window.jstiming.report=function(k,a){var d="";if(window.jstiming.pt){d+="&srt="+window.jstiming.pt;delete window.jstiming.pt}if(window.external&&window.external.tran)d+="&tran="+window.external.tran;var c=k.t,b=c.start;delete c.start;var h=[];for(var e in c)b&&h.push(e+"."+(c[e]-b));if(a)for(var j in a)d+="&"+j+"="+a[j];(new Image).src=["http://csi.gstatic.com/csi?v=3","&s=codesite&action=",k.name,d,"&rt=",h.join(",")].join("")};(function(){window.CODESITE_CSITimer={};CODESITE_CSITimer.load=window.jstiming.load;window.CODESITE_CSIReportDelay=500;window.CODESITE_reportedToCSI=false;function k(){if(jQuery('body[@class~="gc-documentation"]').length>0)return"product_doc";if(window._homepageGadgetData_)return"codesite_home";if(jQuery('div[@id="gc-home"]').length>0)return"product_home";return"other"}function a(){var c=["codesite","sc"],b=k(),h=CODESITE_getProduct();if(h)if(h=="more")c.push("site_directory");else if(h=="search")c.push("cse");
else if(h=="support")c.push(h);else if(h=="events")c.push(h);else if(b=="product_doc"){c.push(b);c.push(h+"_doc")}else{if(b=="product_home"){c.push(b);c.push(h+"_home")}}else b=="codesite_home"&&c.push(b);c.push("intl_"+CODESITE_langLoc);CODESITE_CSITimer.load.name=c.join(",")}function d(){if(!CODESITE_reportedToCSI){window.setTimeout(function(){for(var c in CODESITE_CSITimer)window.jstiming.report(CODESITE_CSITimer[c])},CODESITE_CSIReportDelay);window.CODESITE_reportedToCSI=true}}jQuery(document).ready(function(){CODESITE_CSITimer.load.tick("dom")});
jQuery(window).load(function(){CODESITE_CSITimer.load.tick("plt");a();d()})})(jQuery);window.CODESITE_msgs={imagebar:{POSTED_ON:"Posted on"},treelist:{EXPAND:"Expand @1",EXPAND_DEFAULT:"Expand branch",COLLAPSE:"Collapse @1",COLLAPSE_DEFAULT:"Collapse branch"},search:{SUGGESTIONS:"Suggestions",MORE:"more",NO_RESULTS_FOUND:"No search results found. Search query: ",SUGGESTIONS_TITLE:"Suggestions",SUGGESTIONS_ITEMS:["Make sure all words are spelled correctly.","Try different keywords.","Try more general keywords."],TRY_WEBSEARCH:"Or try web search",SEARCH_URL:"http://www.google.com/search?q="}};window.CODESITE_langCode={en:"English",de:"Deutsch",es:"Espa\u00f1ol",ja:"\u65e5\u672c\u8a9e",ko:"\ud55c\uad6d\uc5b4","pt-BR":"Portugu\u00eas (Brasil)",ru:"P\u0443\u0441\u0441\u043a\u0438\u0439",vi:"Ti\u1ebfng Vi\u1ec7t","zh-CN":"\u4e2d\u6587 (\u7b80\u4f53)"};
window.CODESITE_prodLang=[{url:"/android/adc.html",langloc:[{innerHTML:window.CODESITE_langCode["zh-CN"],value:"zh-CN"},{innerHTML:window.CODESITE_langCode.en,value:"en"},{innerHTML:window.CODESITE_langCode["pt-BR"],value:"pt-BR"},{innerHTML:window.CODESITE_langCode.ru,value:"ru"},{innerHTML:window.CODESITE_langCode.ja,value:"ja"},{innerHTML:window.CODESITE_langCode.ko,value:"ko"}]},{url:"/android/adc_faq.html",langloc:[{innerHTML:window.CODESITE_langCode["zh-CN"],value:"zh-CN"},{innerHTML:window.CODESITE_langCode.en,
value:"en"},{innerHTML:window.CODESITE_langCode["pt-BR"],value:"pt-BR"},{innerHTML:window.CODESITE_langCode.ru,value:"ru"},{innerHTML:window.CODESITE_langCode.ja,value:"ja"},{innerHTML:window.CODESITE_langCode.ko,value:"ko"}]},{url:"/apis/orkut/",langloc:[{innerHTML:window.CODESITE_langCode["zh-CN"],value:"zh-CN"},{innerHTML:window.CODESITE_langCode.en,value:"en"},{innerHTML:window.CODESITE_langCode["pt-BR"],value:"pt-BR"},{innerHTML:window.CODESITE_langCode.ru,value:"ru"},{innerHTML:window.CODESITE_langCode.es,
value:"es"},{innerHTML:window.CODESITE_langCode.vi,value:"vi"},{innerHTML:window.CODESITE_langCode.ja,value:"ja"}]},{url:"/apis/maps/",langloc:[{innerHTML:window.CODESITE_langCode["zh-CN"],value:"zh-CN"},{innerHTML:window.CODESITE_langCode.en,value:"en"},{innerHTML:window.CODESITE_langCode.de,value:"de"},{innerHTML:window.CODESITE_langCode["pt-BR"],value:"pt-BR"},{innerHTML:window.CODESITE_langCode.ru,value:"ru"},{innerHTML:window.CODESITE_langCode.es,value:"es"},{innerHTML:window.CODESITE_langCode.ja,
value:"ja"}]}];(function(){var k=/\/\/([^\/]*)?(\/intl\/[^\/]*)?(\/.*)?/,a=/\/intl\/(([a-zA-Z]+)(-[a-zA-Z]+)?)(_[a-zA-Z]+)?/,d=a.exec(window.location.href);if(d==null){window.CODESITE_langLoc="en";window.CODESITE_langUrl=""}else{window.CODESITE_langLoc=d[1];window.CODESITE_langUrl=d[0].replace(/_ALL/,"")}jQuery(document).ready(window.CODESITE_langSelectInit=function(c,b){var h=null,e=b||window.location,j=k.exec(e.href);for(var m=0;m<window.CODESITE_prodLang.length;m++)if(j[3].indexOf(window.CODESITE_prodLang[m].url)>=
0){h=window.CODESITE_prodLang[m].langloc;break}h||(h=[{innerHTML:window.CODESITE_langCode["zh-CN"],value:"zh-CN"},{innerHTML:window.CODESITE_langCode.en,value:"en"},{innerHTML:window.CODESITE_langCode["pt-BR"],value:"pt-BR"},{innerHTML:window.CODESITE_langCode.ru,value:"ru"},{innerHTML:window.CODESITE_langCode.es,value:"es"},{innerHTML:window.CODESITE_langCode.ja,value:"ja"}]);for(var y in h)if(h[y].value==CODESITE_langLoc){h[y].selected=true;break}CODESITE_fauxSelect({attachTo:".dropdown",data:h,
opt_icon:"/images/globe2_small.png",opt_onSelect:function(F,s,u){s.html(u.text);CODESITE_localeRedirect(u.value)}})});window.CODESITE_localeRedirect=function(c,b){var h=b||window.location,e=k.exec(h.href);if(e){var j=e[3]?"http://"+e[1]+"/intl/"+c+e[3]:"http://"+e[1]+"/intl/"+c+"/";h.href=j}};window.CODESITE_redirectToI18nContent=function(c){var b=a.exec(c.href),h=b&&b[1]||"en";CODESITE_localeRedirect(h,null);return false}})(jQuery);(function(){window.CODESITE_fauxSelect=function(k,a,d,c,b,h){if(arguments.length==1&&"attachTo"in arguments[0]){var e=arguments[0];k=e.attachTo;a=e.data;d=e.opt_onSelect;c=e.opt_size;b=e.opt_align;h=e.opt_icon}var j=jQuery(k);if(!(j.length==0)){var m=jQuery('<select class="fauxSelect">');b=b?jQuery.trim(b.toString().toLowerCase()):"right";var y=jQuery("<span/>").addClass("fauxSelectIcon");if(h)y=jQuery("<img/>").css({verticalAlign:"middle",border:"none"}).attr("src",h).addClass("fauxSelectIcon");
var F=jQuery("<span>&nbsp;&#9660;</span>").css({verticalAlign:"middle",textDecoration:"none",fontFamily:"arial, sans-serif",fontSize:"11px"}).addClass("fauxSelectArrow"),s="title"+(new Date).getTime(),u=jQuery("<span/>").css({textDecoration:j.css("textDecoration"),verticalAlign:"middle"}).addClass(s).addClass("fauxSelectTitle");u.html(j.text());j.empty();var o=[y,u,F];b=="left"&&o.reverse();jQuery(o).appendTo(j);j.is("a")&&j.bind("click",function(){return false});j.css({textDecoration:"none",cursor:"pointer"});
m.css({position:"absolute",zIndex:"99"});m.attr({size:a.length<=6?a.length:c||6});d&&m.bind("optionSelected",d);if("length"in a)for(var x=0;x<a.length;x++)if("innerHTML"in a[x]){var A=jQuery("<option>").attr(a[x]).appendTo(m);"selected"in a[x]&&m.one("onShow",(function(v){return function(){v[0].selected=true}})(A))}var t=function(){var v=0,C=0;if(window.innerWidth){v=window.innerWidth;C=window.innerHeight}else if(document.documentElement.clientWidth==0){v=document.body.clientWidth;C=document.body.clientHeight}else{v=
document.documentElement.clientWidth;C=document.documentElement.clientHeight}return{width:v,height:C}},B=function(){m.hide();m.trigger("onHide",[m])},z=function(){var v=j.offset();m.css({visibility:"hidden",display:""});var C=v.left,J=v.left+j.get(0).offsetWidth-m.get(0).offsetWidth,N=v.top+j.get(0).offsetHeight,P=t();if(b=="right"&&J<0)b="left";else if(b=="left"&&C+m.get(0).offsetWidth>P.width)b="right";m.css({left:b=="right"?J+"px":C+"px",top:N+"px"});m.css("visibility","").show();m.trigger("onShow",
[m])},E=function(v,C){C||(C="mouseover");v||(v=400);return function(){var J=-1;J=setTimeout(function(){B();J=-1},v);m.one(C,function(){J!=-1&&clearTimeout(J)})}};j.bind("click",function(){m.is(":visible")?B():z()});m.bind("onShow",function(v,C){C.find("option").unbind("click");C.find("option:selected").one("click",B);C.get(0).focus()});m.bind("mouseout",E.call(null));m.one("mouseover",function(){m.one("blur",E.call(null,0))});m.bind("change",function(){B();if(d){var v=m.get(0).options[m.get(0).selectedIndex];
m.trigger("optionSelected",[u,v])}});return m.css("display","none").appendTo(document.body)}}})(jQuery);(function(){try{document.execCommand("BackgroundImageCache",false,true)}catch(k){}function a(b){return window.encodeURIComponent?encodeURIComponent(b):escape(b)}function d(b){return window.decodeURIComponent?decodeURIComponent(b):unescape(b)}RegExp.escape=(function(){var b=["/",".","*","+","?","|","(",")","[","]","{","}","\\"],h=new RegExp("(\\"+b.join("|\\")+")","g");return function(e){return e.replace(h,"\\$1")}})();window.CODESITE_minWidth=(function(){var b=[],h=function(){if(!!CODESITE_minWidth)for(var e=
0,j=b[0]||null;e<b.length;++e,j=b[e])try{if(j.parent_.offsetWidth<=j.minWidth_){j.style.width=j.minWidth_+"px";j.style.overflow="hidden"}else{j.style.width="";j.style.overflow=""}}catch(m){}};if(jQuery.browser.msie){jQuery(window).resize(h);jQuery(h)}return function(e,j){if(!!jQuery.browser.msie){var m=jQuery(e)[0];m.minWidth_=j-0;m.parent_=m.parentNode;b.push(m)}}})();window.CODESITE_createImageBar=function(b,h){var e=new google.feeds.Feed(b);e.setResultFormat(google.feeds.Feed.XML_FORMAT);e.setNumEntries(2);
e.load(function(j){if(!j.error){var m=jQuery(h),y=jQuery("item",j.xmlDocument),F=0;if(y.length>=2)F=2;var s=['<div class="post techtalk">','<div class="screenshot">','<a href="@link">','<img alt="@origTitle" src="@thumb" height="80" width="90">',"</a>","</div>",'<div class="info">','<div class="name">','<a href="@link" title="@origTitle">@title</a>',"</div>",'<div class="author videodateformat">',CODESITE_msgs.imagebar.POSTED_ON," @date</div>","</div>","</div>"].join(""),u=jQuery(['<div class="g-section g-tpl-50-50 gc-techtalk">',
'<div class="g-unit g-first">&nbsp;</div>','<div class="g-unit">&nbsp;</div>',"</div>"].join(""));for(var o=0;o<F;o++){var x=jQuery("title:first",y[o]).text(),A=x,t=jQuery("link:first",y[o]).text(),B=t.substring("http://www.youtube.com/watch?v=".length),z;if((z=y.eq(o).find("atom\\:updated, updated")).length){var E=z.eq(0).text().replace(/(\d{4})-(\d{2})-(\d{2})T.*/,"$2 $3 $1").split(" ");z=new Date;z.setFullYear(E[2],E[0]-1,E[1])}else if((z=y.eq(o).find("dc\\:date, date")).length)z=new Date(z.eq(0).text());
var v=google.feeds.getElementsByTagNameNS(y[o],"http://search.yahoo.com/mrss/","thumbnail")[0],C=v.getAttribute("url");v.getAttribute("width");v.getAttribute("height");z=z.getMonth()+1+"/"+z.getDate()+"/"+z.getFullYear();var J=jQuery(s.replace(/@link/g,t).replace(/@videoid/g,B).replace(/@thumb/g,C).replace(/@origTitle/g,x).replace(/@title/g,A).replace(/@date/g,z));jQuery(".g-unit:eq("+o+")",u).prepend(J)}m.append(u)}})};window.CODESITE_loadFeedAPI=function(){google.load("feeds","1",{callback:CODESITE_initFeedAPI})};
jQuery(function(){jQuery("#searchForm").show();jQuery("#searchForm2").hide()});window.CODESITE_initFeedAPI=function(){if(CODESITE_codeVideoDiv.length){CODESITE_createImageBar(_homepageGadgetData_.homepageVideoFeedUrl,"#gc-codevideo");CODESITE_minWidth("#codesiteContent",1000)}if(CODESITE_macRecentChangesDiv.length){var b=new BlogPreview(document.getElementById("recentchanges"));b.show("http://googlemacplayground.blogspot.com/atom.xml","changes")}};function c(){var b=/\/intl\/(.*?)\//.exec(document.location);
b=b?["&lang=",b[1],"#"].join(""):"#";function h(C){var J="",N;if(typeof C=="string"){if(C!="")J="&"+a(C)}else for(N in C)J+=["&",N,"=",a(C[N])].join("");return J}if(CODESITE_codeBlogDiv.length){var e=[],j=window._apiGadgetData_||window._homepageGadgetData_,m=j.blogOptions,y=400,F="100%",s="__MSG_blogs__",u="";if(m){F=m.width||F;y=m.height||y;s=m.up_gadgetTitle||s;u=m.xtraFeeds||u}if(j.blogFeedUrl&&j.blogFeedUrl.length){if(!j.blogFeedName||j.blogFeedName.length==0)j.blogFeedName="__MSG_blogs__";e.push(a([j.blogFeedName,
":",j.blogFeedUrl].join("")))}j.googleCodeBlogIntlFeedUrl&&j.googleCodeBlogIntlFeedUrl.length&&e.push(a(["__MSG_blogs.local__:",j.googleCodeBlogIntlFeedUrl].join("")));j.googleCodeBlogFeedUrl&&j.googleCodeBlogFeedUrl.length&&e.push(a(["__MSG_blogs.googleCode__:",j.googleCodeBlogFeedUrl].join("")));j.relatedDeveloperBlogsFeedUrl&&j.relatedDeveloperBlogsFeedUrl.length&&e.push(a(["__MSG_blogs.related__:",j.relatedDeveloperBlogsFeedUrl].join("")));if(u.length){var o=d(u).split("|");for(var x=0;x<o.length;x++)e.push(a(o[x]))}if(e.length)jQuery('<iframe frameborder="0">').attr({src:["http://www.gmodules.com/ig/ifr?",
"url=http://code.google.com/gadgets/FeedGadget/gadget.xml",b,"up_showaddbutton=true&","up_random=true&","up_defer=true&","up_gadgetTitle=",a(s),"&","up_feeds=",e.join("|"),h(m||"")].join(""),frameborder:"0",width:F,height:y}).css({border:"none"}).appendTo(CODESITE_codeBlogDiv)}if(CODESITE_featuredDiv.length){var A=[],t=window._apiGadgetData_||window._homepageGadgetData_,B=t.groupOptions,z=400,E="100%",v="__MSG_groups.community__",u="";if(B){E=B.width||E;z=B.height||z;v=B.up_gadgetTitle||v;u=B.xtraFeeds||
u}t.featuredProjectsFeedUrl&&t.featuredProjectsFeedUrl.length&&A.push(a(["featured:__MSG_featured.projects__:",t.featuredProjectsFeedUrl].join("")));if(t.groupFeedUrl&&t.groupFeedUrl.length){if(!t.groupFeedName||t.groupFeedName.length==0)t.groupFeedName="__MSG_groups.community__";A.push(a([t.groupFeedName,":",t.groupFeedUrl].join("")))}t.featureFeedUrl&&t.featureFeedUrl.length&&A.push(a(["featured:__MSG_featured.projects__:",t.featureFeedUrl].join("")));t.articleFeedUrl&&t.articleFeedUrl.length&&
A.push(a(["__MSG_articles__:",t.articleFeedUrl].join("")));t.userGroupsFeedUrl&&t.userGroupsFeedUrl.length&&A.push(a(["__MSG_groups.user__:",t.userGroupsFeedUrl].join("")));if(u.length){var o=d(u).split("|");for(var x=0;x<o.length;x++)A.push(a(o[x]))}if(A.length)jQuery('<iframe frameborder="0">').attr({src:["http://www.gmodules.com/ig/ifr?","url=http://code.google.com/gadgets/FeedGadget/gadget.xml",b,"up_showaddbutton=true&","up_defer=true&","up_gadgetTitle=",a(v),"&","up_feeds=",A.join("|"),h(B||
"")].join(""),frameborder:"0",width:E,height:z}).css({border:"none"}).appendTo(CODESITE_featuredDiv)}}jQuery(function(){try{prettyPrint()}catch(b){}});jQuery(function(){var b=jQuery("#gc-pagecontent"),h=jQuery("#gc-toc");if(b.length){var e=jQuery('<div id="gc-collapsible-arrow">'),j=jQuery('<div id="gc-collapsible">'),m=function(y){var F=b.offset();e.css({left:F.left+"px",top:(y.pageY||y.clientY)+"px"})};b.css("position","relative").append(j);jQuery(document.body).append(e);jQuery.browser.msie&&jQuery.browser.version<
7&&b.css("left","-5px");b.is(".skip-collapsible")||j.mouseover(function(y){j.addClass("hover");if(h.is(":hidden")){j.css("left","-3px");e.addClass("collapsed")}else e.removeClass("collapsed");e.show();m(y)}).mousemove(function(y){m(y)}).mouseout(function(){j.removeClass("hover");j.css("left","");e.hide()}).click(function(){e.hide();j.removeClass("hover").css("left","");h.toggle();if(h.is(":visible")){b.css("margin-left","");jQuery.browser.msie&&jQuery.browser.version<7&&b.css("left","-5px")}else{b.css("margin-left",
"0px");jQuery.browser.msie&&jQuery.browser.version<7&&b.css("left","")}});j.height(b.height())}});jQuery(window.CODESITE_createVideoAndGadgets=function(){CODESITE_codeBlogDiv=jQuery("#gc-blog-gadget");CODESITE_featuredDiv=jQuery("#gc-community-gadget");CODESITE_codeVideoDiv=jQuery("#gc-codevideo");CODESITE_macRecentChangesDiv=jQuery("#recentchanges");if(CODESITE_codeVideoDiv.length||CODESITE_macRecentChangesDiv.length)if(window.google)CODESITE_loadFeedAPI();else{var b=document.createElement("script");
b.src="http://www.google.com/jsapi?key=internal-codesite&callback=CODESITE_loadFeedAPI";b.type="text/javascript";document.getElementsByTagName("head")[0].appendChild(b)}if(CODESITE_codeBlogDiv.length||CODESITE_featuredDiv.length)c()});window.CODESITE_getIntlUrl=function(b){var h=["/intl/","/p/","/u/","/hosting/","/support/","/soc/","/codejam/","/apis/youtube/dashboard/"];if(b.indexOf("/")==0){for(var e in h)if(b.indexOf(h[e])>=0)return b;return CODESITE_langUrl+b}else return b};window.CODESITE_derivePath=
function(b){var h=window.ORIGINAL_PAGE_PATH;if(!h)return b;var e=window.location.href;e=e.substring(0,e.lastIndexOf("/"));var j=h.substring(0,h.lastIndexOf("/"));e=e.substring(0,e.length-j.length);return e+b};window.CODESITE_docEarlyProcessing=function(){CODESITE_buildTreelistWidget()};window.CODESITE_getProduct=function(b){var b=b||window.location.href,h=/https?:\/\/[^\/]*(\/intl\/[^\/]*)?(\/apis)?(\/([a-z0-9]*))?\//,e=h.exec(b);if(!e)return"";var j=e[4];return j?j:""};jQuery(window).load(function(){window.setTimeout(function(){jQuery.getScript("http://www.google-analytics.com/ga.js",
function(){var b=window._gat._getTracker("UA-18071-1");b._setAllowAnchor(true);b._initData();b._trackPageview()})},0)})})(jQuery);(function(){var k={products:{sectionTitle:"Products",labels:["All","Ads","AJAX","Browser","Geo","Product APIs","Search","Social"],labelsMapExternalToInternal:{All:"products",Ads:"ads",AJAX:"ajax",Browser:"browser",Geo:"geo","Product APIs":"apis",Search:"search",Social:"social"},labelsMapInternalToExternal:{products:"All",ads:"Ads",ajax:"AJAX",browser:"Browser",geo:"Geo",apis:"Product APIs",search:"Search",social:"Social"},resourceKeys:["home","doc","group","blog","faq","samplecode","articles","terms",
"appgallery"],resourceKeysMap:{home:"Home",doc:"Documentation",group:"Group",blog:"Blog",faq:"FAQ",samplecode:"Sample Code",articles:"Articles & Tutorials",terms:"Terms",appgallery:"App Gallery"}},programs:{sectionTitle:"Resources",labels:["Open Source","Education","Events"],labelsMapExternalToInternal:{"Open Source":"opensource",Education:"education",Events:"events"},labelsMapInternalToExternal:{opensource:"Open Source",education:"Education",events:"Events"}},messages:{NEW:"New!",LONG_DESC_PANEL_TITLE:"Details",
FOR_MORE:"For more information"}};window.CODESITE_siteDirectoryMetaData=k;var a={dictionariesList:["products","programs","searchSuggest","searchResultTabs"],products:{dictionaryType:"products",includeInSiteDirectory:true,includeInSearchSuggest:true,siteDirectoryMetaData:k.products,keys:["android","blogger","chromium","feedburner","gadgets","gears","gmail","accounts","adsense","adsenseforaudio","adwords","ajax","ajaxfeeds","ajaxlanguage","ajaxsearch","analytics","appengine","apps","base","books","calendar",
"chart","checkout","csearch","codesearch","contacts","coupons","customsearch","gdata","gdgadgets","desktop","documents","earth","finance","friendconnect","health","mapplets","maps","flashmaps","gme","notebook","gra","safebrowsing","enterprise","sitemaps","sketchup","spreadsheets","staticmaps","talk","themes","toolbar","transit","visualization","webtoolkit","webmastertools","igoogle","kml","opensocial","orkut","picasa","picasaweb","socialgraph","subscribedlinks","v8","youtube"],entries:{android:{title:"Android",
groupsTitle:"Android Groups",url:"/android/",productId:"android",labels:["products"],keywords:{mobile:10},shortDesc:"Build mobile apps for Android, a software stack for mobile devices.",longDesc:'Android is a software stack for mobile devices including an operating system, middleware and key applications. It is being developed by the <a href="http://www.openhandsetalliance.com/">Open Handset Alliance</a>, a group of more than 30 technology and mobile companies. Android was built from the ground-up to enable developers to create compelling mobile applications that take full advantage of all a handset has to offer.  Developers can create applications for the platform using the Android SDK.',
resources:{home:"/android/",doc:"/android/documentation.html",group:"http://groups.google.com/group/android-developers",blog:"http://android-developers.blogspot.com/",faq:"/android/kb/index.html",terms:"/android/terms.html"}},gdata:{title:"Google Data APIs",groupsTitle:"Google Data APIs Groups",url:"/apis/gdata/",productId:"gdata",labels:["products","apis"],keywords:{apis:1,feed:1,entries:6,gentries:10,"data apis":10,java:1},shortDesc:"A simple, standard protocol for reading and writing data on the web.",
longDesc:"The Google Data APIs provide a simple, standard protocol for reading and writing data on the web. Google Data API is a protocol based on the Atom 1.0 and RSS 2.0 syndication formats, plus the Atom Publishing Protocol. Several Google services provide a Google Data API, including Google Base, Blogger, Google Calendar, Google Spreadsheets and Picasa Web Albums.",resources:{home:"/apis/gdata/",doc:"/apis/gdata/overview.html",group:"http://groups.google.com/group/google-help-dataapi",blog:"http://googledataapis.blogspot.com/",
samplecode:"/apis/gdata/clientlibs.html",terms:"http://www.google.com/terms_of_service.html"}},blogger:{title:"Blogger Data API",groupsTitle:"Blogger Data API Groups",url:"/apis/blogger/",productId:"blogger",labels:["products","apis","social"],keywords:{apis:1,feed:1,entries:2,gentries:1,"data apis":4},shortDesc:"Enable your apps to view and update Blogger content.",longDesc:"The Blogger Data API allows client applications to view and update Blogger content in the form of Google Data API feeds. Your client application can use the Google Data API to create new blog posts, edit or delete existing posts, and query for posts that match particular criteria.",
resources:{home:"/apis/blogger/",doc:"/apis/blogger/developers_guide_protocol.html",group:"http://groups.google.com/group/bloggerDev",blog:"http://googledataapis.blogspot.com/",samplecode:"/apis/blogger/code.html",articles:"/apis/blogger/articles/",terms:"http://www.blogger.com/terms.g"}},chromium:{title:"Chromium",groupsTitle:"Chromium Groups",url:"/chromium/",productId:"chromium",labels:["products","browser"],keywords:{browser:1,chrome:1,chromium:1,v8:1},shortDesc:"Contribute to the open source project behind Google Chrome.",
longDesc:'Chromium is the open source browser project behind <a href="http://www.google.com/chrome">Google Chrome</a>. Built from components that include the Apple WebKit renderer and the new V8 JavaScript engine, Chromium provides all the elements of a functional web browser. The UI of Chromium is unobtrusive, providing more space for content. Chromium\'s multi-process architecture improves stability and security by isolating web pages in separate processes that run in a sandbox.',resources:{home:"/chromium/",
doc:"http://dev.chromium.org",group:"http://groups.google.com/group/chromium-discuss",blog:"http://blog.chromium.org",faq:"http://dev.chromium.org/developers/faq",terms:"/chromium/terms.html"}},feedburner:{title:"Feedburner APIs",groupsTitle:"FeedBurner Groups",url:"/apis/feedburner/",productId:"feedburner",labels:["products","apis"],keywords:{feed:10},shortDesc:"Interact with FeedBurner's feed management and awareness-generating capabilities.",longDesc:"FeedBurner offers web services for interacting with their feed management and awareness-generating capabilities. Using the features this library provides, anyone with a FeedBurner account may perform some of the most common actions available on the FeedBurner service programmatically.",
resources:{home:"/apis/feedburner/",doc:"/apis/feedburner/developers_guide.html",group:"http://forums.feedburner.com",blog:"http://blogs.feedburner.com",terms:"http://www.feedburner.com/fb/a/tos"}},gmail:{title:"Gmail Atom Feeds",url:"/apis/gdata/faq.html#GmailAtomFeed",productId:"gmail",labels:["products"],keywords:{feed:1},shortDesc:"Offers a simple feed mechanism for reading your Gmail inbox or labels.",longDesc:"This feed mechanism lets you read your Gmail inbox or labels via any aggregator that supports the Atom XML feed format.",
resources:{home:"/apis/gdata/faq.html#GmailAtomFeed",group:"http://groups.google.com/group/Gmail-Help-Discussion",terms:"http://mail.google.com/mail/help/terms_of_use.html"}},accounts:{title:"Google Account Authentication",groupsTitle:"Google Account Authentication Groups",url:"/apis/accounts/",productId:"accounts",labels:["products"],keywords:{apis:1,feed:1,entries:1,gentries:1},shortDesc:"Get access into desktop or mobile applications.",longDesc:"Writing mashups or other applications that exchange data with your user's Google services? Use the Authentication service to simplify the  process of getting permission from your users. Libraries are available for desktop applications and web applications. The Authentication service now supports the OAuth open standard.",
resources:{home:"/apis/accounts/index.html",group:"http://groups.google.com/group/Google-Accounts-API",terms:"http://www.google.com/terms_of_service.html"}},adsense:{title:"Google AdSense API",groupsTitle:"Google AdSense API Groups",url:"/apis/adsense/",productId:"adsense",labels:["products","ads"],keywords:{ads:1,apis:1},shortDesc:"Generate revenue for you and your users by placing ads on your website.",longDesc:"The AdSense API enables you to integrate AdSense signup, ad unit management, and reporting into your web or blog hosting platform. You and your users can generate revenue from your users' web content on your site by showing relevant ads and referring products.",
resources:{home:"/apis/adsense/",doc:"/apis/adsense/developer/index.html",group:"http://groups.google.com/group/adsense-api",blog:"http://adsense.blogspot.com/",faq:"/apis/adsense/faq/index.html",samplecode:"/apis/adsense/developer/adsense_api_samples.html",articles:"/apis/adsense/articles/index.html",terms:"/apis/adsense/terms.html"}},adsenseforaudio:{title:"Google AdSense for Audio API",groupsTitle:"Google AdSense for Audio API Groups",url:"/apis/adsenseforaudio/",productId:"adsenseforaudio",labels:["products",
"ads"],keywords:{ads:1,apis:1},shortDesc:"Incorporate AdSense for Audio into your broadcast system.",longDesc:"The AdSense for Audio API enables you to integrate AdSense for Audio into a broadcast system, such as a radio automation system. By integrating AdSense for Audio into a broadcast system you give radio stations access to the AdSense for Audio network, which makes their unsold commercial inventory available to thousands of new advertisers through the Google Audio Ads program.",resources:{home:"/apis/adsenseforaudio/",
doc:"/apis/adsenseforaudio/docs/developer_guide.html",group:"http://groups.google.com/group/audioadsense-api-support",faq:"/apis/adsenseforaudio/docs/faq.html",terms:"/apis/adsenseforaudio/docs/terms_of_service.html"}},adwords:{title:"Google AdWords API",groupsTitle:"Google AdWords API Groups",url:"/apis/adwords/",productId:"adwords",labels:["products","ads"],keywords:{ads:2,apis:1},shortDesc:"Automate and streamline your campaign management activities.",longDesc:"The AdWords API enables advertisers and third parties alike to integrate directly with the AdWords advertising platform. Armed with direct access, you can design a suite of applications that automate reporting, data integration, campaign and bid management.",
resources:{home:"/apis/adwords/",doc:"/apis/adwords/docs/developer/",group:"http://groups.google.com/group/adwords-api",blog:"http://adwordsapi.blogspot.com/",faq:"http://www.google.com/support/adwordsapi/",samplecode:"/apis/adwords/docs/samples.html",terms:"/apis/adwords/docs/terms.html"}},ajax:{title:"Google AJAX APIs",groupsTitle:"Google AJAX APIs Groups",url:"/apis/ajax/",productId:"ajax",labels:["products","ajax"],keywords:{ajax:10,apis:10},shortDesc:"Implement rich, dynamic web sites entirely in JavaScript and HTML.",
longDesc:"Google's AJAX APIs let you implement rich, dynamic web sites entirely in JavaScript and HTML. You can add a map to your site, a dynamic search box, or download feeds with just a few lines of JavaScript.",resources:{home:"/apis/ajax/",doc:"/apis/ajax/documentation/",group:"http://groups.google.com/group/Google-AJAX-Search-API",blog:"http://googleajaxsearchapi.blogspot.com/",faq:"/support/bin/topic.py?topic=10021",terms:"/tos.html"}},ajaxfeeds:{title:"Google AJAX Feed API",groupsTitle:"Google AJAX Feed API Groups",
url:"/apis/ajaxfeeds/",productId:"ajaxfeeds",labels:["products","ajax"],keywords:{ajax:8,apis:5,feed:6},shortDesc:"Easily mash up public feeds using JavaScript.",longDesc:"The AJAX Feed API makes it easy to access and use data feeds in your JavaScript applications. You used to need a server to proxy feeds before you could read and manipulate them in mashups; now you can load RSS and Atom feeds from different sources with a few lines of JavaScript code.",resources:{home:"/apis/ajaxfeeds/",doc:"/apis/ajaxfeeds/documentation/",
group:"http://groups.google.com/group/Google-AJAX-Search-API",blog:"http://googleajaxsearchapi.blogspot.com/",faq:"/support/bin/topic.py?topic=10021",samplecode:"/apis/ajaxfeeds/examples.html",terms:"/apis/ajaxfeeds/terms.html"}},ajaxlanguage:{title:"Google AJAX Language API",groupsTitle:"Google AJAX Language API Groups",url:"/apis/ajaxlanguage/",productId:"ajaxlanguage",labels:["products","ajax"],keywords:{ajax:8,apis:5,language:10},shortDesc:"Easily translate and detect multiple languages using JavaScript.",
longDesc:"The AJAX Language API make it easy to translate and detect multiple languages in your JavaScript applications.",resources:{home:"/apis/ajaxlanguage/",doc:"/apis/ajaxlanguage/documentation/",group:"http://groups.google.com/group/Google-AJAX-Search-API",blog:"http://googleajaxsearchapi.blogspot.com/",faq:"/support/bin/topic.py?topic=10021",samplecode:"/apis/ajaxlanguage/documentation#Examples",terms:"/apis/ajaxlanguage/terms.html"}},ajaxsearch:{title:"Google AJAX Search API",groupsTitle:"Google AJAX Search API Groups",
url:"/apis/ajaxsearch/",productId:"ajaxsearch",labels:["products","ajax","search","apis"],keywords:{ajax:9,apis:10,search:6,translate:5},shortDesc:"Put a Google Search box and results on your own site.",longDesc:"The Google AJAX Search API lets you use JavaScript to embed a simple, dynamic Google search box and display search results in your own web pages, or use search results programmatically in innovative ways. If you don't feel like coding, you can even use our code wizards to add custom AJAX search controls to your web page in just a few steps.",
resources:{home:"/apis/ajaxsearch/",doc:"/apis/ajaxsearch/documentation/",group:"http://groups.google.com/group/Google-AJAX-Search-API",blog:"http://googleajaxsearchapi.blogspot.com/",faq:"/support/bin/topic.py?topic=10021",samplecode:"/apis/ajaxsearch/samples.html",articles:"/support/bin/topic.py?topic=11530",terms:"/apis/ajaxsearch/terms.html"}},analytics:{title:"Google Analytics",groupsTitle:"Google Analytics Groups",url:"/apis/analytics/",productId:"analytics",labels:["products"],keywords:{tools:1},
shortDesc:"Track total page views, unique visitors, and AdWords conversions on your site.",longDesc:"Google Analytics allows you gather, view and analyze data about your website traffic, such as content popularity, aggregated visitor behavior, and much more. By embedding our basic JavaScript snippet into your website, you enable your site to send key information to Google Analytics for each pageview. Our powerful servers process your site's data and generate over 80 reports that you can use, interpret, and act upon. The simple administrative interface allows you to set up goals and filters so you can control what data goes into your reports based on your business needs. The best part: this sophisticated, full-featured web analytics package is free.",
resources:{home:"/apis/analytics/",doc:"/apis/analytics/docs/",group:"/apis/analytics/groups.html",blog:"http://analytics.blogspot.com/",terms:"http://www.google.com/analytics/tos.html"}},appengine:{title:"Google App Engine",groupsTitle:"Google App Engine Groups",url:"/appengine/",productId:"appengine",labels:["products"],keywords:{apis:5,tools:1},shortDesc:"Run your web applications on Google's infrastructure.",longDesc:"Google App Engine lets you run your web applications on Google's infrastructure.  App Engine applications are easy to build, easy to maintain, and easy to scale as your traffic and data storage needs grow.  With App Engine, there are no servers to maintain: You just upload your application, and it's ready to serve your users.",
resources:{home:"/appengine/",doc:"/appengine/docs/",group:"/appengine/groups.html",faq:"/appengine/kb/",articles:"/appengine/articles/",terms:"/appengine/terms.html",appgallery:"http://appgallery.appspot.com/"}},apps:{title:"Google Apps APIs",groupsTitle:"Google Apps APIs Groups",url:"/apis/apps/",productId:"apps",labels:["products","apis"],keywords:{apis:1},shortDesc:"Provides domain administration for Premier and Education Edition customers.",longDesc:"Google Apps also universally supports individual service extensibility with Gadgets, Calendar, Spreadsheets, and Talk.",
resources:{home:"/apis/apps/",doc:"/apis/apps/gdata_provisioning_api_v2.0_reference.html",group:"http://groups.google.com/group/google-apps-apis",faq:"/support/bin/topic.py?topic=11279",samplecode:"/apis/apps/libraries_and_samples.html",articles:"/support/bin/topic.py?topic=12142",terms:"http://www.google.com/terms_of_service.html"}},base:{title:"Google Base Data API",groupsTitle:"Google Base Data API Groups",url:"/apis/base/",productId:"base",labels:["products"],keywords:{apis:1,feed:1,entries:2,
gentries:1,"data apis":2},shortDesc:"Manage Google Base content programmatically.",longDesc:"With the Google Base Data API, you can query Google Base data to create applications and mashups, as well as input and manage Google Base items programmatically. Your application can upload new data, update or delete existing items, and execute specialized queries to find matches for complex attribute criteria. For more information, please see the section on Google Data APIs.",resources:{home:"/apis/base/",
doc:"/apis/base/starting-out.html",group:"http://groups.google.com/group/Google-Base-data-API",blog:"http://googlebase.blogspot.com",faq:"/apis/base/faq.html",samplecode:"/apis/base/sample-apps.html",articles:"/support/bin/topic.py?topic=11983",terms:"http://www.google.com/terms_of_service.html"}},books:{title:"Google Book Search APIs",groupsTitle:"Google Book Search APIs Groups",url:"/apis/books/",productId:"books",labels:["products","ajax","apis","search"],keywords:{ajax:9,apis:10,search:5,feeds:1,
books:1},shortDesc:"Integrate Google Book Search content into your website or application.",longDesc:'Google <a href="http://books.google.com">Book Search</a> is our effort to make book content more discoverable on the Web. Using our APIs, you too can easily and reliably integrate with this respository from your own website or application.',resources:{home:"/apis/books/",doc:"/apis/books/docs/getting-started.html",group:"http://groups.google.com/group/booksearch-apis",blog:"http://booksearch.blogspot.com",
terms:"/apis/books/terms.html"}},calendar:{title:"Google Calendar APIs and Tools",groupsTitle:"Google Calendar APIs and Tools Groups",url:"/apis/calendar/",productId:"calendar",labels:["products","apis","social"],keywords:{apis:1,feed:5,entries:2,gadgets:3,gentries:1,"data apis":3,tools:1},shortDesc:"Create and manage events, calendars, and gadgets for Google Calendar.",longDesc:"The Google Calendar Data API and other tools enable you to do many things: create a web front end for your group's calendar, generate a public calendar based on your organization's event database, create Calendar Gadgets, and much more.",
resources:{home:"/apis/calendar/",doc:"/apis/calendar/developers_guide_protocol.html",group:"http://groups.google.com/group/google-calendar-help-dataapi",blog:"http://googledataapis.blogspot.com/",faq:"/apis/calendar/faq.html",samplecode:"/apis/calendar/code.html",articles:"/apis/calendar/articles/",terms:"/apis/calendar/terms.html"}},chart:{title:"Google Chart API",groupsTitle:"Google Chart API Groups",url:"/apis/chart/",productId:"chart",labels:["products"],keywords:{apis:1,charts:1},shortDesc:"Dynamically embed charts in your webpage.",
longDesc:"The Google Chart API is a simple tool that lets you create many types of charts. Send an HTTP request that includes data and formatting parameters and the Chart API returns a PNG image of the chart. Embed in a webpage with an image tag and you're done!",resources:{home:"/apis/chart/",group:"http://groups.google.com/group/google-chart-api",faq:"/apis/chart/faq.html",terms:"/apis/chart/terms.html"}},checkout:{title:"Google Checkout API",groupsTitle:"Google Checkout API Groups",url:"/apis/checkout/",
productId:"checkout",labels:["products"],keywords:{apis:5},shortDesc:"Start selling on your website.",longDesc:"Google Checkout provides a streamlined e-commerce checkout process that can be integrated with Google AdWords and Analytics to attract more leads and drive better conversion rates. The Checkout API allows you to integrate your site with Google Checkout, either by spending 5 minutes and dropping in simple \"Buy Now\" buttons, or by stepping through a complete integration of your order management system with Checkout. It's a message-based REST XML API involving synchronous and asynchronous interactions between Google and the merchant's server.",
resources:{home:"/apis/checkout/",doc:"/apis/checkout/developer/Google_Checkout_Basic_HTML_Overview.html",group:"http://groups.google.com/group/google-checkout-developers-forum",blog:"http://googlecheckoutapi.blogspot.com/",faq:"/support/bin/topic.py?topic=10026",samplecode:"/apis/checkout/samplecode.html",articles:"http://checkout.google.com/support/sell/bin/topic.py?topic=11964",terms:"http://checkout.google.com/termsOfService"}},csearch:{title:"Google Code Search",url:"http://www.google.com/codesearch",
productId:"csearch",labels:["products","search"],keywords:{search:1},shortDesc:"Search public source code.",longDesc:"Google Code Search helps you find function definitions and sample code by giving you one place to search publicly accessible source code hosted on the Internet. With Google Code Search, you can: <ul><li>Use regular expressions to search more precisely</li><li>Restrict your search by language, license or filename</li> <li>View the source file with links back to the entire package and the webpage where it came from</li></ul>",
resources:{home:"http://www.google.com/codesearch",group:"http://groups.google.com/group/Google-Code-Search",faq:"http://www.google.com/help/faq_codesearch.html",terms:"/tos.html"}},codesearch:{title:"Google Code Search Data API",groupsTitle:"Google Code Search Data API Groups",url:"/apis/codesearch/",productId:"codesearch",labels:["products","search"],keywords:{apis:1,feed:1,entries:1,gentries:1,search:1},shortDesc:"Enable your apps to view data from Code Search.",longDesc:"The Google Code Search Data API allows client applications to view data from Code Search in the form of Google Data API feeds. Your client application can use the Google Code Search Data API to query for public source code, function definitions, and sample code.",
resources:{home:"/apis/codesearch/",doc:"/apis/codesearch/gdata.html",group:"http://groups.google.com/group/Google-Code-Search",blog:"http://googledataapis.blogspot.com/",faq:"/support/bin/topic.py?topic=10441",samplecode:"/apis/gdata/clientlibs.html",terms:"/tos.html"}},customsearch:{title:"Google Custom Search API",groupsTitle:"Google Custom Search API Groups",url:"/apis/customsearch/",productId:"customsearch",labels:["products","ads","apis","search"],keywords:{apis:1,ads:1,custom:1,search:1,cse:1},
shortDesc:"Create a custom search engine for your website or a collection of websites",longDesc:"Google Custom Search enables you to create a search engine for your website, your blog, or a collection of websites within minutes. You can harness the power of Google to create a search engine tailored to your needs and interests and present the results in your website. You can fine-tune the ranking, customize the look and feel of the search results, and invite your friends or trusted users to help you build your custom search engine. You can even make money from your search engine by using your Google AdSense account.",
resources:{home:"/apis/customsearch/",doc:"/apis/customsearch/docs/start.html",group:"http://groups.google.com/group/google-custom-search",blog:"http://googlecustomsearch.blogspot.com/",terms:"http://www.google.com/coop/docs/cse/tos.html"}},contacts:{title:"Google Contacts Data API",groupsTitle:"Google Contacts Data API Groups",url:"/apis/contacts/",productId:"contacts",labels:["products","social"],keywords:{apis:1,feed:1,entries:2,gentries:1,contacts:1,"data apis":4},shortDesc:"Allow your apps to view and update user contacts.",
longDesc:"The Google Contacts Data API allows client applications to view and update Contacts content in the form of Google Data API feeds. Your client application can request a list of a user's contacts, edit or delete content in an existing contact, and query the content in an existing contact. Here are some of the things you can do with the Contacts Data API:<li>Synchronize Google contacts with contacts on a mobile device</li><li>Maintain relationships between people in social applications</li><li>Give users the ability to communicate directly with their friends from external applications using phone, email, and IM</li></ul>",
resources:{home:"/apis/contacts/",doc:"/apis/contacts/developers_guide_protocol.html",group:"http://groups.google.com/group/google-contacts-api",blog:"http://googledataapis.blogspot.com",terms:"/apis/contacts/api-terms.html"}},coupons:{title:"Google Coupon Feeds",url:"/apis/coupons/",productId:"coupons",labels:["products"],keywords:{feed:1},shortDesc:"Provide coupon listings that are included in Google search results.",longDesc:"Google coupon feeds enable businesses to provide coupon listings that will be included in Google search results. Coupon feeds enable merchants to easily distribute coupons for free via the web. Consumers can also search for, print and redeem coupons for free.",
resources:{home:"/apis/coupons/",doc:"/apis/coupons/",terms:"http://www.google.com/terms_of_service.html"}},gdgadgets:{title:"Google Desktop Gadget API",groupsTitle:"Google Desktop Gadget API Groups",url:"/apis/desktop/",productId:"gdgadgets",labels:["products"],keywords:{gadgets:3,search:1},shortDesc:"Write powerful, visually appealing gadgets for millions of Google Desktop users around the world.",longDesc:"Desktop gadgets are powerful mini-applications that can live within the Google Desktop sidebar, or right on the user's desktop, or even inside iGoogle home pages. You create Desktop gadgets using XML and JavaScript, optionally adding native code for access to Windows APIs. The Desktop Gadget API enables advanced functionality such as transparency, animation, custom fonts, and personalization.",
resources:{home:"/apis/desktop/",doc:"/apis/desktop/docs/gadgetapi.html",group:"http://groups.google.com/group/Google-Desktop-Developer",blog:"http://googledesktopapis.blogspot.com/",faq:"http://code.google.com/support/bin/topic.py?topic=10033",samplecode:"/apis/desktop/docs/examples.html",Articles:"http://code.google.com/support/bin/topic.py?topic=11366",terms:"http://desktop.google.com/dev/apiterms.html"}},desktop:{title:"Google Desktop Search APIs",searchTabTitle:"Google Desktop APIs",groupsTitle:"Google Desktop APIs Groups",
url:"/apis/desktop/",productId:"desktop",labels:["products","search"],keywords:{gadgets:1,search:3},shortDesc:"Put desktop search support into your apps, or extend Google Desktop to search more file types.",longDesc:"Use the power of Google Desktop in your applications and gadgets, or create indexing plug-ins that let users search any file type &mdash; documents, spreadsheets, music files, email, calendar, or your software application's special file type. The Search APIs work with JavaScript, VBScript, C, C++, C#, and VB.Net code.",
resources:{home:"/apis/desktop/",doc:"/apis/desktop/docs/searchapi.html",group:"http://groups.google.com/group/Google-Desktop-Developer",blog:"http://googledesktopapis.blogspot.com/",samplecode:"/apis/desktop/docs/examples.html",terms:"http://desktop.google.com/dev/apiterms.html"}},documents:{title:"Google Documents List Data API",groupsTitle:"Google Documents List Data API Groups",url:"/apis/documents/",productId:"documents",labels:["products","apis"],keywords:{apis:1,feed:1,entries:2,gentries:1,
"data apis":3},shortDesc:"Enable your apps to view and update your list of Google Documents.",longDesc:'The Google Documents List Data API allows client applications to view and search through documents stored in <a href="http://docs.google.com/">Google Documents</a> using Google Data API feeds. Your client application can request a list of a user\'s word processing documents and/or spreadsheets and upload existing documents to Google Documents.',resources:{home:"/apis/documents/",doc:"/apis/documents/developers_guide_protocol.html",
group:"http://groups.google.com/group/Google-Docs-Data-APIs",blog:"http://googledataapis.blogspot.com/",faq:"/apis/documents/faq.html",samplecode:"/apis/documents/code.html",articles:"/apis/documents/articles/",terms:"http://www.google.com/google-d-s/terms.html"}},earth:{title:"Google Earth API",groupsTitle:"Google Earth API Groups",url:"/apis/earth/",productId:"earth",labels:["products","apis","geo","ajax"],keywords:{apis:4,developer:1,"developer day":1,geo:6,maps:6,kml:6},shortDesc:"Embed Google Earth into your web page.",
longDesc:"The Google Earth Plug-in and its JavaScript API let you embed Google Earth, a true 3D digital globe, into your web pages. Using the API you can draw markers and lines, drape images over the terrain, add 3D models, or load KML files, allowing you to build sophisticated 3D map applications. If you have an existing Maps API site, you can 3D-enable your page with as little as one line of code.",resources:{home:"/apis/earth/",doc:"/apis/earth/documentation/",group:"http://groups.google.com/group/kml-support/topics",
blog:"http://googlegeodevelopers.blogspot.com/"}},finance:{title:"Google Finance Data API",url:"/apis/finance/",productId:"finance",labels:["products","apis"],keywords:{apis:4,feeds:1,"data apis":1},shortDesc:"View and update Finance content in the form of Google Data API feeds.",longDesc:"The Google Finance Portfolio Data API allows client applications to view and update Finance content in the form of Google Data API feeds.<br> <br>Your client application can use the Finance Data API to create new portfolio and transaction entries, request a list of entries, and edit or delete existing entries.",
resources:{home:"/apis/finance/",doc:"/apis/finance/developers_guide_java.html"}},flashmaps:{title:"Google Maps API For Flash",url:"/apis/maps/documentation/flash/",productId:"flashmaps",labels:["products","geo"],keywords:{ajax:7,apis:4,actionscript:1,geo:6,maps:6},shortDesc:"Integrate Google Maps in Flash applications.",longDesc:"The Google Maps API for Flash allows you to add maps to Flash applications.  Based on ActionScript 3.0, this API enables Flex developers to easily customize maps through a variety of services.",
resources:{home:"/apis/maps/documentation/flash/index.html",doc:"/apis/maps/documentation/flash/intro.html",group:"http://groups.google.com/group/google-maps-api-for-flash",blog:"http://googlegeodevelopers.blogspot.com/",faq:"/apis/maps/faq.html",terms:"/apis/maps/terms.html"}},friendconnect:{title:"Google Friend Connect",url:"http://www.google.com/friendconnect",productId:"friendconnect",labels:["products","social"],keywords:{apis:5,gadgets:5,social:10},shortDesc:"Grow website traffic with easy-to-add social features.",
longDesc:"Google Friend Connect enables webmasters to quickly and easily enhance their site with community features; what's more, these features leverage visitors' <i>existing</i> social ties. By simply copying and pasting a few lines of JavaScript, you can implement the social functionality you want, and visitors can connect with their Facebook, orkut and other friends directly on your website.",resources:{}},gadgets:{title:"Gadgets API",groupsTitle:"Gadgets API Groups",url:"/apis/gadgets/",productId:"gadgets",
labels:["products","apis","social"],keywords:{finance:1,apis:8,gadgets:6},shortDesc:"Build mini-apps that run on multiple sites including iGoogle, Google Desktop, or any webpage.",longDesc:"Gadgets are simple HTML and JavaScript mini-applications served in iFrames that can be embedded in webpages and other apps. Built-in JavaScript libraries make it easy to create gadgets that include tabs, Flash content, persistent storage, dynamic resizing, and more. Many gadgets are viewed millions of times per week and generate significant traffic for their authors.",
resources:{home:"/apis/gadgets/",doc:"/apis/gadgets/docs/dev_guide.html",group:"http://groups.google.com/group/Google-Gadgets-API",blog:"http://googlegadgetsapi.blogspot.com",faq:"/support/bin/topic.py?topic=10027",terms:"/apis/gadgets/docs/terms.html"}},gears:{title:"Gears",groupsTitle:"Gears Groups",url:"/apis/gears/",productId:"gears",labels:["products","ajax","browser"],keywords:{ajax:5,apis:9,tools:1},shortDesc:"Enable web applications to work offline, from your desktop PC or your mobile device.",
longDesc:"Gears is an open source browser extension that lets you create web applications that run offline. It lets you store and serve application resources locally, store data locally in a fully-searchable relational database, and run asynchronous JavaScript to improve application responsiveness.",resources:{home:"/apis/gears/",doc:"/apis/gears/design.html",group:"http://groups.google.com/group/google-gears/",blog:"http://gearsblog.blogspot.com/",faq:"/support/bin/topic.py?topic=11628",samplecode:"/apis/gears/sample.html",
articles:"/apis/gears/tutorial.html",terms:"http://gears.google.com/tos.html"}},health:{title:"Google Health API",groupsTitle:"Google Health Developers Groups",url:"/apis/health/",productId:"health",labels:["products","apis"],keywords:{"data apis":3,feed:1,health:1,java:1},shortDesc:"Manage your personal health information with Google.",longDesc:"The Google Health Data API allows client applications to view and send Health content in the form of Google Data API feeds. Your client application can use the Health Data API to create new medical records, request a list of medical records and query for medical records that match particular criteria. <br> <br>Here are some of the things you can do with the Health Data API:<br> <br> <ul> <li>Upload patient medical records</li> <li>Get patient medical data and provide personalized functionality based on that data </li>",
resources:{home:"/apis/health/",doc:"/apis/health/developers_guide_protocol.html",group:"http://groups.google.com/group/googlehealthdevelopers/",faq:"/apis/health/faq.html",terms:"http://www.google.com/health/html/terms.html"}},igoogle:{title:"iGoogle Developer Home",groupsTitle:"iGoogle Developers Groups",url:"/apis/igoogle/",productId:"igoogle",labels:["products","apis","social"],keywords:{ads:3,apis:1,gadgets:1,social:1},shortDesc:"Build and test your gadget in the new sandbox for iGoogle.",longDesc:"Gadgets on iGoogle now support canvas view and OpenSocial, a common set of APIs, HTML, and JavaScript designed to let you easily build social applications. Build and test your gadget in the new sandbox for iGoogle.",
resources:{home:"/apis/igoogle/",doc:"/apis/igoogle/docs/igoogledevguide.html",group:"http://groups.google.com/group/Google-Gadgets-API/",blog:"http://googlegadgetsapi.blogspot.com/",faq:"/apis/igoogle/faq.html",terms:"/apis/gadgets/docs/terms.html"}},kml:{title:"KML",groupsTitle:"KML Groups",url:"/apis/kml/",productId:"kml",labels:["products","geo"],keywords:{apis:1,geo:4,maps:1},shortDesc:"Create and share content with Google Earth, Maps, and Maps for mobile.",longDesc:"KML is a file format used to display geographic data in an Earth browser, such as Google Earth, Google Maps and Google Maps for mobile. KML uses a tag-based structure with nested elements and attributes and is XML-based. Google Earth and Google Maps have millions of users, so there's already a wide audience awaiting your content.",
resources:{home:"/apis/kml/",doc:"/apis/kml/documentation/",group:"http://groups.google.com/group/kml-support",blog:"http://googlegeodevelopers.blogspot.com/",faq:"/support/bin/topic.py?topic=10426",samplecode:"/apis/kml/documentation/kml_tut.html",articles:"/support/bin/topic.py?topic=11367",terms:"http://www.google.com/terms_of_service.html"}},mapplets:{title:"Google Mapplets",url:"/apis/maps/documentation/mapplets/",productId:"mapplets",labels:["products","geo"],keywords:{apis:1,gadgets:1,geo:5,
maps:1},shortDesc:"Build mini-applications to embed within the Google Maps site.",longDesc:"Google Mapplets are mini-applications that you can embed within the Google Maps site. Examples include real estate search, current weather conditions, and distance measurement. Mapplets are Gadgets that can manipulate the map using JavaScript calls that are derived from the Google Maps API.",resources:{home:"/apis/maps/documentation/mapplets/",doc:"/apis/maps/documentation/mapplets/guide.html",group:"http://groups.google.com/group/Google-Maps-API",
blog:"http://googlegeodevelopers.blogspot.com/",faq:"/apis/maps.faq.html",articles:"/apis/maps/articles/",terms:"/apis/maps/terms.html"}},maps:{title:"Google Maps API",groupsTitle:"Google Maps API Groups",url:"/apis/maps/",productId:"maps",labels:["products","ajax","apis","geo"],keywords:{ajax:7,apis:4,geo:6,maps:6},shortDesc:"Integrate Google's interactive maps with data on your site.",longDesc:"The Google Maps API allows you to create innovative online mapping applications and helps integrate maps and geo-coding into your websites. With it, you can easily present your geo-referenced content in any web browser.",
resources:{home:"/apis/maps/",doc:"/apis/maps/documentation/index.html",group:"http://groups.google.com/group/Google-Maps-API",blog:"http://googlegeodevelopers.blogspot.com/",faq:"/apis/maps/faq.html",samplecode:"/apis/maps/documentation/examples/index.html",articles:"/apis/maps/articles",terms:"/apis/maps/terms.html"}},gme:{title:"Google Mashup Editor",groupsTitle:"Google Mashup Editor Groups",url:"/gme/",productId:"gme",labels:["products"],keywords:{ajax:2,entries:1,gentries:1,tools:5},shortDesc:"Quickly write code for simple web applications and mashups.",
longDesc:"Google Mashup Editor is an AJAX development framework and a set of tools that enable developers to quickly and easily create simple web applications and mashups with Google services like Google Maps and Google Base. Creating applications with Google Mashup Editor is simple, using our declarative XML tags, JavaScript, CSS, and HTML.",resources:{home:"/gme/",doc:"/gme/gettingstarted.html",group:"http://groups.google.com/group/google-mashup-editor",blog:"http://googlemashupeditor.blogspot.com/",
faq:"/support/bin/topic.py?topic=11558",samplecode:"http://gallery.googlemashups.com/",articles:"/support/bin/topic.py?topic=12044",terms:"http://www.google.com/terms_of_service.html"}},notebook:{title:"Google Notebook Data API",groupsTitle:"Google Notebook Data API Groups",url:"/apis/notebook/",productId:"notebook",labels:["products"],keywords:{apis:1,feed:1,entries:1,gentries:1,"data apis":3},shortDesc:"Enables your apps to view stored data as Google Data API feeds.",longDesc:"The Google Notebook Data API allows client applications to view stored data in the form of Google Data API feeds.  Your client application can request a list of a user's public notebooks, or query the content of an existing public notebook.",
resources:{home:"/apis/notebook/",doc:"/apis/notebook/gdata.html",group:"http://groups.google.com/group/Google-Labs-Notebook",blog:"http://googledataapis.blogspot.com/",samplecode:"/apis/gdata/clientlibs.html",terms:"http://www.google.com/terms_of_service.html"}},gra:{title:"Google Radio Automation API",url:"/apis/gra/",productId:"gra",labels:["products"],keywords:{java:1,apis:1,radio:10,automation:3},shortDesc:"Write applications for the radio industry to run inside Google Radio Automation.",longDesc:"Google Radio Automation is used by radio stations to ingest, manage, and broadcast audio content. Using this API, you can write applications to add functionality to Google Radio Automation or tightly integrate your product with Google Radio Automation.",
resources:{home:"/apis/gra/",doc:"/apis/gra/docs/developer_guide.html",faq:"/apis/gra/docs/faq.html",terms:"/apis/gra/docs/terms_graapi.html"}},opensocial:{title:"OpenSocial",groupsTitle:"OpenSocial Groups",url:"/apis/opensocial/",productId:"opensocial",labels:["products","ajax","social"],keywords:{social:10,"open source":2,apis:8},shortDesc:"Build social applications that work across many websites.",longDesc:"OpenSocial defines a common API for social applications across multiple websites. With standard JavaScript and HTML, developers can create apps that access a social network's friends and update feeds. <br><br>A common API means you have less to learn to build for multiple websites. OpenSocial is currently being developed by a broad set of members of the web community. The ultimate goal is for any social website to be able to implement the API and host 3rd party social applications.",
resources:{home:"/apis/opensocial/",doc:"/apis/opensocial/docs/index.html",group:"http://groups.google.com/group/opensocial-api/",blog:"http://opensocialapis.blogspot.com/",faq:"/apis/opensocial/faq.html",articles:"/apis/opensocial/articles/",terms:"/apis/opensocial/terms.html"}},orkut:{title:"Orkut Developer Home",searchTabTitle:"Orkut",groupsTitle:"Orkut Groups",url:"/apis/orkut/",productId:"orkut",labels:["products","apis","social"],keywords:{social:8},shortDesc:"Create social applications for the millions of global Orkut users.",
longDesc:'As a developer, you can create social applications for Orkut users. Orkut supports <a href="/apis/opensocial/">OpenSocial</a>, a common set of APIs, HTML, and JavaScript designed to let developers easily build social applications.',resources:{home:"/apis/orkut/"}},safebrowsing:{title:"Google Safe Browsing APIs",groupsTitle:"Google Safe Browsing APIs Groups",url:"/apis/safebrowsing/",productId:"safebrowsing",labels:["products"],keywords:{apis:1,feed:1,entries:1,gentries:1},shortDesc:"Download lists of suspected phishing and malware URLs.",
longDesc:"The Safe Browsing API is an experimental API that allows client applications to check URLs against Google's constantly-updated blacklists of suspected phishing and malware pages. Your client application can use the API to download an encrypted table for local, client-side lookups of URLs that you would like to check.",resources:{home:"/apis/safebrowsing/",doc:"/apis/safebrowsing/developers_guide.html",group:"http://groups.google.com/group/google-safe-browsing-api",blog:"http://googleonlinesecurity.blogspot.com/",
terms:"/apis/safebrowsing/terms.html"}},enterprise:{title:"Google Search Appliance APIs",groupsTitle:"Google Search Appliance APIs Groups",url:"/enterprise/",productId:"enterprise",labels:["products","search"],keywords:{apis:1,search:1},shortDesc:"Enables complete control over enterprise search results.",longDesc:'The <a href="/apis/searchappliance/documentation/xml_reference.html">Search Protocol</a> is a simple HTTP-based protocol for serving search results. Search administrators have complete control over requesting and presenting search results to end users. The <a href="/apis/searchappliance/documentation/feedsguide.html">Feeds Protocol</a> enables a customer or a third-party developer to write a custom application to feed a data source into the Google Search Appliance for processing, indexing, and serving. The <a href="/apis/searchappliance/documentation/authn_authz_spi.html">Authorization Protocol</a> enables a customer\'s web service to authorize users to access specific documents for searching in real-time, leveraging their existing security and access control environment.',
resources:{home:"/apis/searchappliance/",doc:"/apis/searchappliance/documentation/",group:"http://groups.google.com/group/Google-Enterprise-Developer",blog:"http://googleenterprise.blogspot.com/",terms:"http://www.google.com/terms_of_service.html"}},sitemaps:{title:"Google Sitemaps",url:"https://www.google.com/webmasters/tools/docs/en/about.html",productId:"sitemaps",labels:["products","search"],keywords:{search:1,tools:1},shortDesc:"Enables Google to quickly crawl your website.",longDesc:'Enables Google crawlers to quickly find what pages are present and which have recently changed. You create a file conforming to the Sitemap Protocol on your webserver; this file informs and direct Google crawlers, improving the time to inclusion in the index.  We have an open-source <a href="http://goog-sitemapgen.sourceforge.net/">project</a> that helps in the creation of these sitemaps, and many <a href="/sm_thirdparty.html">third party Sitemap tools</a> are available.',
resources:{home:"https://www.google.com/webmasters/tools/docs/en/about.html",doc:"https://www.google.com/webmasters/tools/docs/en/protocol.html",group:"http://groups.google.com/group/Google_Webmaster_Help",blog:"http://googlewebmastercentral.blogspot.com/",terms:"http://www.google.com/accounts/TOS"}},sketchup:{title:"Google SketchUp Ruby API",groupsTitle:"Google SketchUp Ruby API Groups",url:"/apis/sketchup/",productId:"sketchup",labels:["products","geo"],keywords:{apis:1,geo:3},shortDesc:"Extend Google SketchUp with Ruby.",
longDesc:'Google SketchUp Ruby API allows you to manipulate SketchUp models and extend the behavior of Google SketchUp.  You can write macros for repeated tasks.  You can also write customs tools for Google SketchUp and other plugins. <a href="http://groups.google.com/group/sketchupruby/topics">Show off a little</a>.',resources:{home:"/apis/sketchup/",doc:"/apis/sketchup/docs/gsrubyapi_examples.html",group:"http://groups.google.com/group/sketchupruby/topics",blog:"http://sketchupapi.blogspot.com/",
terms:"/apis/sketchup/docs/tos.html"}},socialgraph:{title:"Social Graph API",groupsTitle:"Social Graph API Groups",url:"/apis/socialgraph/",productId:"socialgraph",labels:["products","social"],keywords:{social:9},shortDesc:"Enable users to quickly add their public social connections to your site.",longDesc:'The Social Graph API makes information about the public connections between people on the Web easily available and useful for developers.  Developers can query this public information to offer their users dramatically streamlined "add friends" functionality and other useful features.',
resources:{home:"/apis/socialgraph/",doc:"/apis/socialgraph/docs/",group:"http://groups.google.com/group/social-graph-api",faq:"apis/socialgraph/faq.html",terms:"/apis/socialgraph/terms.html"}},spreadsheets:{title:"Google Spreadsheets Data API",groupsTitle:"Google Spreadsheets Data API Groups",url:"/apis/spreadsheets/",productId:"spreadsheets",labels:["products","apis"],keywords:{apis:1,feed:1,entries:2,gentries:1,"data apis":4},shortDesc:"Enable your apps to view and update Google Spreadsheets content.",
longDesc:"The Google Spreadsheets Data API allows client applications to view and update Spreadsheets content in the form of Google Data API feeds. Your client application can request a list of a user's spreadsheets, edit or delete content in an existing Spreadsheets worksheet, and query the content in an existing Spreadsheets worksheet.",resources:{home:"/apis/spreadsheets/",doc:"/apis/spreadsheets/developers_guide_protocol.html",group:"http://groups.google.com/group/Google-Docs-Data-APIs",blog:"http://googledataapis.blogspot.com/",
faq:"/apis/spreadsheets/faq.html",samplecode:"/apis/spreadsheets/code.html",articles:"/apis/spreadsheets/articles/",terms:"/apis/maps/terms.html"}},staticmaps:{title:"Google Static Maps API",url:"/apis/maps/documentation/staticmaps/",productId:"staticmaps",labels:["products","geo"],keywords:{apis:1,geo:6,maps:2},shortDesc:"Embed a Google Maps image on your webpage without requiring JavaScript or any dynamic page loading.",longDesc:"The Google Static Maps API lets you embed a Google Maps image on your webpage without requiring JavaScript or any dynamic page loading. The Google Static Map service creates your map based on URL parameters sent through a standard HTTP request and returns the map as an image you can display on your web page!",
resources:{home:"/apis/maps/documentation/staticmaps/",doc:"/apis/maps/documentation/staticmaps/",group:"http://groups.google.com/group/Google-Maps-API",blog:"http://googlegeodevelopers.blogspot.com/",terms:"/apis/maps/terms.html"}},subscribedlinks:{title:"Subscribed Links",groupsTitle:"Subscribed Links Groups",url:"http://www.google.com/coop/docs/guide_subscribed_links.html",productId:"subscribedlinks",labels:["products","search"],keywords:{apis:1,developer:1,"custom results":1,gadgets:1,onebox:1,
search:1,"special results":1,"subscribed links":1},shortDesc:"Define search keywords that trigger custom search results.",longDesc:"Google Subscribed Links enables you to create custom search results and define search keywords for triggering the results. Web users who have signed into their Google account and subscribed to your subscribed links can use keywords that you defined to see your custom search results appear in the Google results page. Your subscribed links can answer questions, display links to your services, provide news and status information, and calculate quantities, among other things.",
resources:{home:"http://www.google.com/coop/docs/guide_subscribed_links.html",doc:"http://www.google.com/coop/docs/guide_subscribed_links.html",group:"http://groups.google.com/group/google-subscribed-link",terms:"http://www.google.com/coop/docs/subscribedlinks/tos.html"}},talk:{title:"Google Talk for Developers",groupsTitle:"Google Talk XMPP Groups",url:"/apis/talk/",productId:"talk",labels:["products","apis","social"],keywords:{apis:1},shortDesc:"Connect your client or network to the Google Talk network, add chatback, or customize the Google Talk gadget.",
longDesc:'The Google Talk network uses <a href="http://www.xmpp.org/specs/">XMPP</a> for its communications protocol, making it easy for client developers to connect and other networks to federate. There are some non-standard XMPP extensions, which are covered in the <a href="/apis/talk/jep_extensions/extensions.html">Google Talk XMPP Extensions</a> section. Google also offers Libjingle, a set of C++ components to interoperate with Google Talk\'s peer-to-peer and voice calling capabilities. For details, see the <a href="/apis/talk/libjingle/index.html">Libjingle Developer Guide</a>. There are multiple interfaces in a great variety of languages including Python, PHP, Java, and C#. <br><br>Web developers may be interested in <a href="http://www.google.com/talk/service/badge/New">chatback</a> and in the <a href="/apis/talk/talk_gadget.html">Google Talk Gadget</a>, a browser-based instant messaging client for the Google Talk network.',
resources:{home:"/apis/talk/",doc:"/apis/talk/talk_developers_home.html",group:"http://groups.google.com/group/google-talk-open",faq:"/apis/talk/developer_faq.html",samplecode:"/apis/talk/libjingle/index.html",terms:"http://www.google.com/terms_of_service.html"}},themes:{title:"Google Themes API",url:"/apis/themes/",productId:"themes",labels:["products"],keywords:{apis:1},shortDesc:"Design a dynamic theme for the iGoogle homepage.",longDesc:"The Google Themes API allows you to further personalize the iGoogle homepage by specifying your own background images and colors in an XML file.  Themes can change throughout the day, making it easy to create a visual story, a landscape that changes as the sun rises and sets, or a dynamic piece of art.",
resources:{home:"/apis/themes/",doc:"/apis/themes/docs/dev_guide.html",terms:"/apis/themes/docs/terms.html"}},toolbar:{title:"Google Toolbar API",url:"http://www.google.com/tools/toolbar/buttons/apis",productId:"toolbar",labels:["products","apis"],keywords:{apis:1,tools:1},shortDesc:"Lets you create custom buttons for the Google Toolbar.",longDesc:"The Google Toolbar API lets you create custom buttons for the Google Toolbar (version 4 and above) using XML.  Buttons can navigate to and search a site, display an RSS feed in a menu, and change their icon dynamically.",
resources:{home:"http://www.google.com/tools/toolbar/buttons/apis",doc:"http://www.google.com/tools/toolbar/buttons/apis/howto_guide.html",group:"http://groups.google.com/group/Google-Custom-Buttons",faq:"/support/bin/topic.py?topic=10037",samplecode:"http://toolbar.google.com/buttons",terms:"http://www.google.com/terms_of_service.html"}},transit:{title:"Google Transit Feed Specification",groupsTitle:"Google Transit Feed Groups",url:"/transit/spec/transit_feed_specification.html",productId:"transit",
labels:["products","geo"],keywords:{feed:1,geo:1,maps:1},shortDesc:"Provide public transit route and schedule information for Google Maps and more.",longDesc:"The Google Transit Feed Specification is a common format that transit agencies and other interested parties can use to make public transportation information available through Google Transit Trip Planner, Google Earth, Google Maps, and other tools.",resources:{home:"/transit/spec/transit_feed_specification.html",doc:"/transit/spec/transit_feed_specification.html",
group:"http://groups.google.com/group/googletransit/",samplecode:"http://spreadsheets.google.com/pub?key=puMHBiWYEbXT0UxQGLDpuBA&gid=11",terms:"http://www.google.com/terms_of_service.html"}},visualization:{title:"Google Visualization API",groupsTitle:"Google Visualization API Groups",url:"/apis/visualization/",productId:"visualization",labels:["products","ajax"],keywords:{ajax:1,apis:3,gentries:1,gadgets:3},shortDesc:"Create visualizations and reporting applications that access structured data in a common format.",
longDesc:"The Google Visualization API allows you to create visualization and reporting applications over structured data and helps integrate these into your websites or Gadgets. With this API, you can easily create visualizations that provide insights from relevant content and embed those in any web browser.<br><br>This API is also used to create Spreadsheet Gadgets which: <ul><li>Add new features to Google Spreadsheets.</li><li>Use a Google Spreadsheet as a data source for iGoogle or other gadget-enabled sites.</li></ul>",
resources:{home:"/apis/visualization/",doc:"/apis/visualization/documentation/",group:"http://groups.google.com/group/google-visualization-api",faq:"/apis/visualization/faq.html",terms:"/apis/visualization/terms.html"}},webtoolkit:{title:"Google Web Toolkit",groupsTitle:"Google Web Toolkit Groups",url:"/webtoolkit/",productId:"webtoolkit",labels:["products","ajax","browser"],keywords:{ajax:6,java:1,tools:6,gwt:10},shortDesc:"Build AJAX apps in the Java language.",longDesc:"The Google Web Toolkit (GWT) is an open source Java software development framework that helps you produce user-friendly AJAX applications. With GWT, you can use your favorite Java development tools to build AJAX applications without having to tackle the steep learning curve of JavaScript/CSS browser quirks.",
resources:{home:"/webtoolkit/",doc:"/webtoolkit/documentation/",group:"http://groups.google.com/group/Google-Web-Toolkit",blog:"http://googlewebtoolkit.blogspot.com/",faq:"/support/bin/topic.py?topic=10034",samplecode:"/webtoolkit/download.html",articles:"/support/bin/topic.py?topic=11368",terms:"/tos.html"}},picasa:{title:"Picasa APIs",groupsTitle:"Picasa APIs Groups",url:"/apis/picasa/",productId:"picasa",labels:["products","apis","social"],keywords:{apis:3,gentries:1},shortDesc:"Create custom buttons and upload files to 3rd party service.",
longDesc:"The Picasa APIs enable you to create buttons users can install in the  Picasa client user interface (see image below). Once installed, the button  exports selected images from Picasa to another desktop application or  web-based service.",resources:{home:"/apis/picasa/",doc:"/apis/picasa/docs/button_api.html",group:"http://groups.google.com/group/google-picasa-apis",faq:"/apis/picasa/faq.html",terms:"/apis/picasa/terms.html"}},picasaweb:{title:"Picasa Web Albums Data API",groupsTitle:"Picasa Web Albums Data API Groups",
url:"/apis/picasaweb/",productId:"picasaweb",labels:["products","apis","social"],keywords:{feed:1,entries:1,gentries:1,"data apis":3},shortDesc:"Include Picasa Web Albums in your application or website.",longDesc:"The Picasa Web Albums Data API allows websites and client applications to view and update Picasa Web Albums content. Using Google Data API feeds, you can retrieve and update photo albums, add new comments and photos, and even tag photos automatically. It's the easy way to get photos and albums into your own website or application.",
resources:{home:"/apis/picasaweb/",doc:"/apis/picasaweb/gdata.html",group:"http://groups.google.com/group/Google-Picasa-Data-API",blog:"http://googledataapis.blogspot.com/",faq:"/apis/picasaweb/faq.html",samplecode:"/apis/picasaweb/code.html",articles:"/apis/picasaweb/articles/",terms:"/apis/picasaweb/terms.html"}},v8:{title:"V8",url:"/apis/v8/",productId:"v8",labels:["products","browser"],keywords:{apis:1,browser:1,chrome:1,chromium:1,tools:1},shortDesc:"Google's high performance, open source, JavaScript engine.",
longDesc:"Embed V8 in your own C++ application to make your application's objects and methods available to JavaScript, and to make JavaScript objects and functions available to your application.",resources:{home:"/apis/v8/",doc:"/apis/v8/intro.html",terms:"/apis/v8/terms.html"}},webmastertools:{title:"Google Webmaster Tools Data API",groupsTitle:"Webmaster Tools Data API Groups",url:"/apis/webmastertools/",productId:"webmastertools",labels:["products","search"],keywords:{"data apis":1,search:1,tools:1},
shortDesc:"View and update site information and Sitemaps in the form of feeds.",longDesc:'Google Webmaster Tools Data API allows client applications to view and update site information and <a href="http://www.google.com/support/webmasters/bin/answer.py?answer=40318">Sitemaps</a> in the form of Google Webmaster Tools Data API feeds. Your client application can use the Google Webmaster Tools Data API to view sites in your account, add and remove sites, verify site ownership, and submit and delete Sitemaps.',
resources:{home:"/apis/webmastertools/",doc:"/apis/webmastertools/docs/developers_guide.html",group:"http://groups.google.com/group/Google_Webmaster_Help",blog:"http://googlewebmastercentral.blogspot.com/",terms:"/apis/webmastertools/docs/terms.html"}},youtube:{title:"YouTube APIs",groupsTitle:"YouTube Data API Groups",url:"/apis/youtube/",productId:"youtube",labels:["products","apis","social"],keywords:{feed:4,entries:2,gentries:6},shortDesc:"Integrate YouTube videos into your website or application.",
longDesc:"YouTube offers open access to key parts of the YouTube video repository and user community, via an open API interface and RSS feeds. Using our APIs, you can easily integrate online videos from YouTube's rapidly growing repository of videos into your application.",resources:{home:"/apis/youtube/",doc:"/apis/youtube/developers_guide_protocol.html",group:"http://groups.google.com/group/youtube-api",blog:"http://apiblog.youtube.com/",faq:"/apis/youtube/faq.html",samplecode:"/apis/youtube/code.html",
articles:"/apis/youtube/articles/",terms:"/apis/youtube/terms.html"}}}},programs:{dictionaryType:"programs",includeInSiteDirectory:true,includeInSearchSuggest:true,siteDirectoryMetaData:k.programs,keys:["projectHosting","opensource","soc","ghop","mac","edu","doctype","events","campfire"],entries:{opensource:{title:"OpenSource",url:"/opensource/",productId:"opensource",labels:["opensource"],keywords:{"open source":10},shortDesc:"Google's contribution back to the Open Source community.",longDesc:'Google is a proud user and supporter of open source software and development methodologies. As a company, Google contributes back to the Open Source community in a variety of ways.<br><br>Key Links: <ul><li><a href="/projects.html">Source Code</a> - From our <a href="/p/google-perftools/">performance tools</a> to application layer projects like <a href="http://gears.google.com/">Gears</a>, Google releases internally developed code as open source.</li><li><a href="/hosting/">Project Hosting on Google Code</a> - Project Hosting on Google Code is a free service to the open source community.</li><li><a href="/soc/">Google Summer of Code</a> - Now in its third year, Google Summer of Code is our program to introduce students to open source development and real-world programming challenges.</li></ul>'},
soc:{title:"Google Summer of Code",url:"/soc/",productId:"soc",labels:["opensource"],keywords:{"open source":5},shortDesc:"Introduce students to open source development",longDesc:'<p><i>Google Summer of Code</i> is a program that offers student developers stipends to write code for various open source projects. Google will be working with several open source, free software, and technology-related groupsto identify and fund several projects over a three month period. Historically, the program has brought together over 1,500 students with over 130 open source projects to create millions of lines of code.   </p>  <p>We\'ll be regularly posting news and updates about the program to the   <a href="http://google-opensource.blogspot.com/search/label/gsoc">Google Open Source Blog</a>.   If you\'re interested in participating in the program in the future, you can still   check out our <a href="/opensource/gsoc/2008/faqs.html">FAQs</a>.   Many of our mentoring organizations have also added program write ups to their websites.  </p>  <p>The program, which kicked off in <a href="/soc/2005/">2005</a>, is now in its fourth year. If you\'re feeling nostalgic or are interested in learning more about the projects we have worked with in the past, check out the   <a href="/soc/2006/">2006</a> and   <a href="/soc/2007/">2007</a> program pages.  </p>'},
ghop:{title:"Highly Open Participation Contest",url:"/opensource/ghop/2007-8/",productId:"ghop",labels:["opensource"],keywords:{"open source":2},shortDesc:"Get young people involved in open source development",longDesc:'Following on from the success of the <a href="http://code.google.com/soc/">Google Summer of Code</a> program, Google is pleased to announce this new effort to get young people involved in open source development.  We\'ve teamed up with the open source projects listed here to give student contestants the opportunity to learn more about and contribute to all aspects of open source software development, from writing code and documentation to preparing training materials and conducting user experience research.'},
projectHosting:{title:"Project Hosting",url:"/hosting/",productId:"projectHosting",labels:["opensource"],keywords:{"open source":6},shortDesc:"Host your open source project on Google Code.",longDesc:'Project Hosting on Google Code is a free service to the open source community. Featuring a Subversion back-end, wiki support, file downloads, issue tracking and a clean, Google-style interface, our project hosting service is the world\'s second largest open source hosting site after <a href="http://sourceforge.net/index.php">SourceForge.net</a>.'},
mac:{title:"Google Mac Developer Playground",url:"/mac/",productId:"mac",labels:["opensource"],keywords:{"open source":2,osx:6,apple:6,iphone:6},shortDesc:"Download open-source Mac software.",longDesc:"The Google Mac Developer Playground is a collection of open-source projects Mac developers at Google work on during their 20% time or on their own time."},edu:{title:"Google Code University",groupsTitle:"Google Code University Groups",url:"/edu/",productId:"edu",labels:["education"],keywords:{educators:1},
shortDesc:"Materials Created Especially for CS educators.",longDesc:'This website provides tutorials and sample course content so CS        students and educators can learn more about current computing        technologies and paradigms.         In particular, this content is Creative Commons licensed which makes it        easy for CS educators to use in their own classes.        <br><br>  Key Links:  <ul>    <li><a href="/edu/index.html">Home</a></li>    <li><a href="http://groups.google.com/group/Google-Code-for-Educators">Groups</a></li>    <li><a href="/edu/curriculumsearch/index.html">CS Curriculum Search</a></li>  </ul>  <p>  Course materials:  <ul>    <li><a href="/edu/ajax/index.html">Ajax Programming</a></li>    <li><a href="/edu/parallel/index.html">Distributed Systems</a></li>    <li><a href="/edu/security/index.html">Web Security</a></li>    <li><a href="/edu/languages/index.html">Languages</a></li>    <li><a href="/edu/tools101/index.html">Tools 101</a></li>  </ul>'},
doctype:{title:"Google DocType",groupsTitle:"Google DocType Groups",url:"/doctype/",productId:"doctype",labels:["education"],keywords:{educators:1},shortDesc:"An encyclopedia of the open web.",longDesc:"Google Doctype is an 100% open encyclopedia -- by web developers, for web developers. It includes sample code, test cases, and articles on web security, JavaScript, and CSS."},events:{title:"Developer Events",url:"/events/",productId:"events",labels:["events"],keywords:{developer:1,gdd:1,"developer day":1},
shortDesc:"Learn about upcoming developer events.",longDesc:"Learn more about developer events like Google I/O, a two-day developer gathering in San Francisco, and Google Developer Days, a series of events around the globe.  The Google Developer Events Calendar can be used to find upcoming developer events, including hackathons, meetups, and presentations on all things code.<br><br>You can add the Google Developer Events Calendar to your Google Calendar or you can add it to your feed reader.</div></p>"},
campfire:{title:"Google Campfire One",url:"/campfire/",productId:"campfire",labels:["events"],keywords:{developer:1},shortDesc:"Conversations with the developer community.",longDesc:'Every once in a while we\'ll invite members of the developer community on campus to talk shop, share some news, and eat S\'mores. We\'re calling this "Google Campfire One."   <br><br>  Key Links:  <ul>    <li><a href="/campfire/">Home</a></li>  </ul>'}}},searchSuggest:{dictionaryType:"searchSuggest",includeInSiteDirectory:false,
includeInSearchSuggest:true,keys:["googleio","support","developerday","codeblog","featuredprojects","enterprisecomm","opensourceprojects","protocolbuffers"],entries:{googleio:{title:"Google I/O",url:"/events/io/",keywords:{apis:1,gentries:1,"google io":1,io:1}},support:{title:"Knowledge Base",url:"/support/",keywords:{faq:1}},developerday:{title:"Developer Day 2008",url:"/events/developerday/",keywords:{developer:1}},codeblog:{title:"Google Code Blog",url:"http://google-code-updates.blogspot.com/",
keywords:{developer:1}},featuredprojects:{title:"Featured Projects",url:"http://google-code-featured.blogspot.com/",keywords:{developer:1}},enterprisecomm:{title:"Google Enterprise Developer Community ",url:"/enterprise/",keywords:{developer:1}},opensourceprojects:{title:"Open Source Projects",url:"/hosting/projects.html",keywords:{"open source":1}},protocolbuffers:{title:"Protocol Buffers",groupsTitle:"Protocol Buffers Groups",url:"/apis/protocolbuffers/",productId:"protocolbuffers",keywords:{serialization:10,
"open source":4,apis:8,"structured data":10,data:1}}}},searchResultTabs:{dictionaryType:"searchResultTabs",includeInSiteDirectory:false,includeInSearchSuggest:false,keys:["google_code","discussion","project_hosting","developer_videos"],entries:{google_code:{title:"Google Code Website"},discussion:{title:"Google Code Groups",groupsTitle:"Google Code Groups"},project_hosting:{title:"Project Hosting"},developer_videos:{title:"Developer Videos"}}}};window.CODESITE_productDictionary_default=a;window.CODESITE_productDictionary=
a})();var CSE={QUERY_REGEX_HASH:/([^\#]*)\#(p=([^&]*)&)?q=(.*)$/,QUERY_REGEX_QUES:/([^\?]*)\?(p=([^&]*)&)?q=(.*)$/,CSE_URL:"http://code.google.com/cse/googlecode-context.xml",searchControl:{},recentQuery:"",showingSearchResults:false,iframeUrlInSync:true,init:function(){CSE.searchControl=new GSearchControl;CSE.searchControl.setResultSetSize(GSearch.LARGE_RESULTSET);CSE.searchControl.setLinkTarget(GSearch.LINK_TARGET_TOP);var k=CSE.getProductParam();if(CODESITE_getSearchTabTitle(k)!=null){CSE.addSearcher(k,
false);CODESITE_getSearchTabTitle(k,true)!=null&&CSE.addSearcher(k,true)}CSE.addSearcher("google_code",false);CSE.addSearcher("discussion",true);CSE.addSearcher("project_hosting",false);var a=new GvideoSearch;a.setQueryAddition("ytchannel:GoogleDevelopers");a.setResultSetSize(GSearch.SMALL_RESULTSET);a.setUserDefinedLabel(CODESITE_getSearchTabTitle("developer_videos"));CSE.searchControl.addSearcher(a);var d=document.getElementById("searchControl"),c=new GdrawOptions;c.setDrawMode(GSearchControl.DRAW_MODE_TABBED);
CSE.searchControl.draw(d,c);CSE.checkHash(CSE.QUERY_REGEX_HASH,window.location.href)},addSearcher:function(k,a){var d=new GwebSearch;a?d.setSiteRestriction({crefUrl:CSE.CSE_URL},k+"_groups"):d.setSiteRestriction({crefUrl:CSE.CSE_URL},k);d.setUserDefinedLabel(CODESITE_getSearchTabTitle(k,a));CSE.searchControl.addSearcher(d)},checkHash:function(k,a){var d=k.exec(a);if(d){var c=decodeURI(d[4]);if(c!=""&&c!=CSE.recentQuery){jQuery("#gsearchInput").attr("value",c);CSE.executeQuery(c)}}else{if(CSE.showingSearchResults){jQuery("#searchControl").hide();
jQuery("#codesiteContent").show();CSE.recentQuery="";CSE.showingSearchResults=false;window.history.back(-1)}return false}return true},getProductParam:function(){var k=CSE.QUERY_REGEX_HASH.exec(window.location.href),a="";if(k&&k[4]){a=decodeURI(k[3]);if(CODESITE_getSearchTabTitle(a)==null)a=""}return a},executeQuery:function(k){if(!(k==""))if(!!CSE.iframeUrlInSync){var a=CSE.getProductParam();CSE.handleAnalytics(k,a);var d=a!=""?"p="+encodeURI(a)+"&q="+encodeURI(k):"q="+encodeURI(k);jQuery.browser.msie&&
CSE.handleIeHistory(d);CSE.recentQuery=k;CODESITE_setURL("#"+d);jQuery("#searchControl").show();jQuery("#codesiteContent").hide();CSE.showingSearchResults=true;var c=CSE.makeNoResultsHtml(k);CSE.searchControl.setNoResultsString(c);CSE.searchControl.execute(k)}},handleIeHistory:function(k){CSE.iframeUrlInSync=false;window.backiFrame.location.search=k;var a=window.setInterval(d,window.CODESITE_backButton.IFRAME_POLLING_INTERVAL);function d(){if(window.backiFrame.location.search.substring(1)==k){CSE.iframeUrlInSync=
true;window.clearInterval(a)}}},makeNoResultsHtml:function(k){var a=[CODESITE_msgs.search.NO_RESULTS_FOUND,"<b>",CSE.escapeHtml(k),"</b><br><br>",CODESITE_msgs.search.SUGGESTIONS_TITLE,":<br><br><ul>"].join("");for(var d=0,c=CODESITE_msgs.search.SUGGESTIONS_ITEMS.length;d<c;d++)a=[a,"<li>",CODESITE_msgs.search.SUGGESTIONS_ITEMS[d],"</li>"].join("");return[a,'</ul><br><a href="',CODESITE_msgs.search.SEARCH_URL,encodeURI(k),'">',CODESITE_msgs.search.TRY_WEBSEARCH,"</a>."].join("")},handleAnalytics:function(k,
a){var d=jQuery("#searchControl").css("display")=="block"?jQuery('div[@class*="gsc-tabhActive"]').text():"",c="/search/?q="+k+"&product="+a+"&tab="+d;if(window.pageTracker)try{pageTracker._initData();pageTracker._trackPageview(c)}catch(b){}},escapeHtml:function(k){return k.replace(/&/g,"&amp;").replace(/</g,"&lt;").replace(/>/g,"&gt;").replace(/\'/g,"&#039;").replace(/\"/g,"&quot;")},pollHash:function(){if(jQuery.browser.msie)CSE.iframeUrlInSync&&CSE.checkHash(CSE.QUERY_REGEX_QUES,window.backiFrame.location.href)&&
CSE.checkHash(CSE.QUERY_REGEX_HASH,window.location.href);else CSE.checkHash(CSE.QUERY_REGEX_HASH,window.location.href)}};window.CODESITE_CSE=CSE;window.CODESITE_setURL=function(k){location.href=k};
window.executeGSearch=function(k){if(!(k==""))if(!!CODESITE_CSE.iframeUrlInSync){var a=CODESITE_getProduct();if(a=="search")CODESITE_CSE.executeQuery(k);else{if(CODESITE_getSearchTabTitle(a)==null)a="";var d=a!=""?"p="+encodeURI(a)+"&q="+encodeURI(k):"q="+encodeURI(k);CODESITE_setURL(CODESITE_langUrl+"/search/#"+d)}}};
window.CODESITE_getSearchTabTitle=function(k,a){if(!k)return null;var d=CODESITE_productDictionary.dictionariesList;for(var c in d){var b=CODESITE_productDictionary[d[c]].entries[k];if(b)if(a){if(b.groupsTitle)return b.groupsTitle}else return b.searchTabTitle||b.title}var d=CODESITE_productDictionary.dictionariesList;for(var c in d){var b=CODESITE_productDictionary_default[d[c]].entries[k];if(b)if(a){if(b.groupsTitle)return b.groupsTitle}else return b.searchTabTitle||b.title}return null};(function(){function k(a,d){this.results_=[];this.buttonEl_=jQuery("#"+d);this.inputFieldEl_=jQuery("#"+a);var c=this;jQuery(this.buttonEl_).focus(function(){c.hideResultsWindow_()});this.searchResultsEl_=jQuery('<div id="cs-searchresults">');this.searchResultsEl_.click(function(e){(event||e).cancelBubble=true});this.searchResultsEl_.appendTo(document.body);jQuery('<div id="cs-recommended">').html(CODESITE_msgs.search.SUGGESTIONS).appendTo(this.searchResultsEl_);for(var b=0,h=1;b<this.MAX_RESULTS_;b++,
h++)jQuery('<div id="searchResult'+h+'">').appendTo(this.searchResultsEl_);jQuery(document.body).click(function(e){return c.handleBodyClick_.call(c,e)});jQuery(document).keydown(function(e){return c.handleBodyKeyDown_.call(c,e)}).keypress(function(e){return c.handleBodyKeyPress_.call(c,e)}).keyup(function(e){return c.handleBodyKeyUp_.call(c,e)});jQuery(window).resize(function(e){c.handleBodyResize_.call(c,e)});window.onpageshow=function(e){e.persisted&&c.hideResultsWindow_()};this.inputFieldEl_.keyup(function(e){return c.handleInputKeyUp_.call(c,
e)}).focus(function(e){return c.handleInputFocus_.call(c,e)}).blur(function(e){return c.handleInputBlur_.call(c,e)}).click(function(e){return c.handleInputClick_.call(c,e)}).attr("autocomplete","off");this.initialized_=!!(this.inputFieldEl_.length&&this.searchResultsEl_.length&&this.buttonEl_.length)}k.prototype={results_:null,initialized_:false,searchActive_:true,resultsWindowHidden_:true,inputFieldEl_:0,searchResultsEl_:0,inputFieldHasFocus_:0,activeResult_:0,arrowKeyProcessed_:false,typedQuery_:"",
backgroundHover:"#3366CC",backgroundOff:"#ffffff",foregroundOff:"#000000",MAX_RESULTS_:7,FIRST_RESULT_:1,getQueryFromInputField_:function(){return jQuery.trim(this.inputFieldEl_.val().toLowerCase())},querySearch_:function(){if(!!this.searchActive_)if(this.typedQuery_.length==0)this.hideResultsWindow_();else{this.results_.splice(0,this.results_.length);var a=CODESITE_productDictionary.dictionariesList;for(var d in a){var c=CODESITE_productDictionary[a[d]];if(!!c.includeInSearchSuggest)for(var b in c.entries){var h=
c.entries[b],e=0,j=new RegExp("(?:\\s|^)"+RegExp.escape(this.typedQuery_)),m=h.title.toLowerCase().match(j);if(m!=null)e=2;for(var y in h.keywords){var F=y.match(j);if(F!=null)e+=h.keywords[y];var s=this.typedQuery_.split(" ");if(s.length>1)for(var b=0;b<s.length;b++){var u=new RegExp("(?:\\s|^)"+s[b]),o=y.match(u);if(o!=null)e+=h.keywords[y]}}e>0&&this.results_.push({match:e,title:h.title,url:CODESITE_getIntlUrl(h.url)})}}this.results_.sort(this.sortMatches_);this.results_.length=Math.min(this.results_.length,
6);this.prepareResultsWindow_()}},sortMatches_:function(a,d){var c=d.match,b=a.match;return c<b?-1:c>b?1:0},createSearchResultDiv:function(a){var d=a+1,c=this,b=jQuery("#searchResult"+d);b.attr("class","cs-searchresult").css({display:"block",textAlign:"left",zoom:"1"}).html(['<a tabindex="-1" id="searchResultLink',d,'" ','href="',this.results_[a].url,'">',this.results_[a].title,"</a>"].join("")).unbind().mouseover(function(){c.deactivateAllResults_();c.activateSearchResult_(d)}).mouseout(function(){c.deactivateSearchResult_(d)}).click(function(){window.location.href=
c.results_[a].url})},prepareResultsWindow_:function(){this.activeResult_=0;if(this.results_.length==0)this.hideResultsWindow_();else{for(var a=0;a<this.results_.length;a++)this.createSearchResultDiv(a);this.deactivateAllResults_();var d=this.results_.length+1,c=jQuery("#searchResult"+d),b=this;c.attr("class","").css({textAlign:"right",display:"block",zoom:"1"}).html('<a style="color: #0000ff; text-decoration: underline;" id="searchResultLink'+d+'"> '+CODESITE_msgs.search.MORE+" &raquo;</a>").unbind().mouseup(function(){b.hideResultsWindow_();
executeGSearch(b.inputFieldEl_.val())}).mouseover(function(){b.deactivateAllResults_();b.activateSearchResult_(d)}).mouseout(function(){b.deactivateSearchResult_(d)});for(var a=d+1;a<=this.MAX_RESULTS_;a++)jQuery("#searchResult"+a).hide();this.resultsWindowHidden_&&this.showResultsWindow_()}},updateDimensions_:function(){if(!!this.searchActive_){var a=this.inputFieldEl_.offset();a.left+=3;this.searchResultsEl_.css({left:a.left+"px",top:a.top+this.inputFieldEl_[0].offsetHeight+2+"px",width:this.inputFieldEl_.css("width")})}},
showResultsWindow_:function(){if(!!this.searchActive_){this.searchResultsEl_.css("visibility","hidden");this.updateDimensions_();this.searchResultsEl_.css("display","block");this.searchResultsEl_.css("visibility","visible");this.resultsWindowHidden_=false}},hideResultsWindow_:function(){if(!this.resultsWindowHidden_){this.searchResultsEl_.hide();this.resultsWindowHidden_=true;this.activeResult_=0}},activateSearchResult_:function(a){this.inputFieldEl_[0].blur();var d=jQuery("#searchResult"+a),c=jQuery("#searchResultLink"+
a);d.length&&d.css("backgroundColor",this.backgroundHover);c.length&&c.css("color","white")},deactivateSearchResult_:function(a){var d=jQuery("#searchResult"+a),c=jQuery("#searchResultLink"+a);d&&d.css("background",this.backgroundOff);if(c&&a==this.results_.length+1)c.css("color","#0000ff");else c&&c.css("color",this.foregroundOff)},deactivateAllResults_:function(){for(var a=0,d=this.results_.length+1;a<d;a++)this.deactivateSearchResult_(a+1)},activateNextSearchResult_:function(){if(this.results_.length>
0)if(this.activeResult_<=this.results_.length){this.deactivateSearchResult_(this.activeResult_);this.activeResult_++;this.activateSearchResult_(this.activeResult_)}},activatePrevSearchResult_:function(){if(this.results_.length>0)if(this.activeResult_==this.FIRST_RESULT_){this.deactivateSearchResult_(this.activeResult_);this.activeResult_=0;this.inputFieldEl_[0].focus()}else if(this.activeResult_>this.FIRST_RESULT_){this.deactivateSearchResult_(this.activeResult_);this.activeResult_--;this.activateSearchResult_(this.activeResult_)}},
handleInputKeyUp_:function(a){if(!!this.initialized_)if(!!this.searchActive_){a=a||window.event;var d=a.which?a.which:a.keyCode;if(d==13){this.hideResultsWindow_();executeGSearch(this.inputFieldEl_.val())}else{var c=this.getQueryFromInputField_();if(c!=this.typedQuery_){this.typedQuery_=c;this.querySearch_()}return true}}},handleBodyKeyDown_:function(a){var d=true,c=false;if(this.initialized_){a=a||window.event;var b=a.which?a.which:a.keyCode,h=a.target?a.target:a.srcElement,e=jQuery("#searchResultLink"+
this.activeResult_),j=[this.inputFieldEl_[0],document.documentElement,document.body];for(var m=0;m<j.length;m++)if(h==j[m])c=true;if(!c)return true;switch(b){case 13:if(this.activeResult_>=0){if(this.activeResult_==this.results_.length+1){this.hideResultsWindow_();executeGSearch(this.inputFieldEl_.val())}else if(e.length)location.href=e.attr("href");d=false}break;case 27:if(this.searchActive_)if(this.resultsWindowHidden_){this.inputFieldEl_.val("");d=false}else{this.hideResultsWindow_();d=false}else{this.searchActive_=
true;this.inputFieldEl_[0].focus();d=true}break;case 40:case 63233:if(this.resultsWindowHidden_&&this.inputFieldHasFocus_&&b!=39){this.searchActive_=true;this.querySearch_();d=false}else if(!this.resultsWindowHidden_&&(this.activeResult_>0||b!=39)){this.deactivateAllResults_();this.activateNextSearchResult_();d=false;this.arrowKeyProcessed_=true}break;case 38:case 63235:if(!this.resultsWindowHidden_){this.deactivateAllResults_();this.activatePrevSearchResult_();d=false;this.arrowKeyProcessed_=true}break;
case 37:case 39:if(!this.inputFieldHasFocus_&&!this.resultsWindowHidden_){this.arrowKeyProcessed_=false;this.inputFieldEl_[0].focus()}}}return d},handleBodyKeyPress_:function(a){if(this.initialized_){a=a||window.event;var d=a.which?a.which:a.keyCode;if(this.arrowKeyProcessed_&&d>=37&&d<=40)return false;return true}},handleBodyKeyUp_:function(a){var d=true;a=a||window.event;this.arrowKeyProcessed_=false;return d},handleBodyResize_:function(){this.updateDimensions_();return true},handleInputBlur_:function(){this.inputFieldHasFocus_=
0},handleInputFocus_:function(){this.inputFieldHasFocus_=0.5;this.initialized_&&this.deactivateAllResults_()},handleInputClick_:function(a){a=a||window.event;this.searchActive_=a.cancelBubble=true;if(this.inputFieldHasFocus_==1)this.resultsWindowHidden_&&this.querySearch_();else this.inputFieldHasFocus_=1},handleBodyClick_:function(a){a=a||window.event;var d=a.target?a.target:a.srcElement;d&&d.parentNode&&this.hideResultsWindow_()}};window.CODESITE_asYouTypeSearch=k;jQuery(function(){try{new k("gsearchInput",
"gsearchButton")}catch(a){}})})(jQuery);(function(){var k={POLLING_INTERVAL:450,IFRAME_POLLING_INTERVAL:50,init:function(){var a=window.location.href.match(/\/search/);if(jQuery.browser.msie)k.poll(a);else if(jQuery.browser.mozilla)k.poll(a);else jQuery.browser.safari&&navigator.userAgent.indexOf("Version/")!=-1&&k.poll(a)},poll:function(a){a&&window.setInterval(function(){a&&window.CODESITE_CSE.pollHash()},k.POLLING_INTERVAL)}};window.CODESITE_backButton=k})(jQuery);jQuery(document).ready(function(){window.CODESITE_backButton.init()});(function(){var k={};(function(){var i=["abstract bool break case catch char class const const_cast continue default delete deprecated dllexport dllimport do double dynamic_cast else enum explicit extern false float for friend goto if inline int long mutable naked namespace new noinline noreturn nothrow novtable operator private property protected public register reinterpret_cast return selectany short signed sizeof static static_cast struct switch template this thread throw true try typedef typeid typename union unsigned using declaration, directive uuid virtual void volatile while typeof",
"as base by byte checked decimal delegate descending event finally fixed foreach from group implicit in interface internal into is lock null object out override orderby params readonly ref sbyte sealed stackalloc string select uint ulong unchecked unsafe ushort var","package synchronized boolean implements import throws instanceof transient extends final strictfp native super","debugger export function with NaN Infinity","require sub unless until use elsif BEGIN END","and assert def del elif except exec global lambda not or pass print raise yield False True None",
"then end begin rescue ensure module when undef next redo retry alias defined","done fi"];for(var f=0;f<i.length;f++){var g=i[f].split(" ");for(var l=0;l<g.length;l++)if(g[l])k[g[l]]=true}}).call(this);function a(i){return i>="a"&&i<="z"||i>="A"&&i<="Z"}function d(i,f,g,l){i.unshift(g,l||0);try{f.splice.apply(f,i)}finally{i.splice(0,2)}}var c=(function(){var i=["!","!=","!==","#","%","%=","&","&&","&&=","&=","(","*","*=","+=",",","-=","->","/","/=",":","::",";","<","<<","<<=","<=","=","==","===",
">",">=",">>",">>=",">>>",">>>=","?","@","[","^","^=","^^","^^=","{","|","|=","||","||=","~","break","case","continue","delete","do","else","finally","instanceof","return","throw","try","typeof"],f="(?:(?:(?:^|[^0-9.])\\.{1,3})|(?:(?:^|[^\\+])\\+)|(?:(?:^|[^\\-])-)";for(var g=0;g<i.length;++g){var l=i[g];f+=a(l.charAt(0))?"|\\b"+l:"|"+l.replace(/([^=<>:&])/g,"\\$1")}f+="|^)\\s*$";return new RegExp(f)})(),b=/&/g,h=/</g,e=/>/g,j=/\"/g;function m(i){return i.replace(b,"&amp;").replace(h,"&lt;").replace(e,
"&gt;")}var y=/&lt;/g,F=/&gt;/g,s=/&apos;/g,u=/&quot;/g,o=/&amp;/g;function x(i){var f=i.indexOf("&");if(f<0)return i;for(--f;(f=i.indexOf("&#",f+1))>=0;){var g=i.indexOf(";",f);if(g>=0){var l=i.substring(f+3,g),q=10;if(l&&l.charAt(0)=="x"){l=l.substring(1);q=16}var n=parseInt(l,q);isNaN(n)||(i=i.substring(0,f)+String.fromCharCode(n)+i.substring(g+1))}}return i.replace(y,"<").replace(F,">").replace(s,"'").replace(u,'"').replace(o,"&")}function A(i){return"XMP"==i.tagName}var t=null;function B(i){if(null===
t){var f=document.createElement("PRE");f.appendChild(document.createTextNode('<!DOCTYPE foo PUBLIC "foo bar">\n<foo />'));t=!/</.test(f.innerHTML)}if(t){var g=i.innerHTML;if(A(i))g=m(g);return g}var l=[];for(var q=i.firstChild;q;q=q.nextSibling)z(q,l);return l.join("")}function z(i,f){switch(i.nodeType){case 1:var g=i.tagName.toLowerCase();f.push("<",g);for(var l=0;l<i.attributes.length;++l){var q=i.attributes[l];if(!!q.specified){f.push(" ");z(q,f)}}f.push(">");for(var n=i.firstChild;n;n=n.nextSibling)z(n,
f);if(i.firstChild||!/^(?:br|link|img)$/.test(g))f.push("</",g,">");break;case 2:f.push(i.name.toLowerCase(),'="',i.value.replace(b,"&amp;").replace(h,"&lt;").replace(e,"&gt;").replace(j,"&quot;"),'"');break;case 3:case 4:f.push(m(i.nodeValue));break}}function E(i){var f=0;return function(g){var l=null,q=0;for(var n=0,w=g.length;n<w;++n){var p=g.charAt(n);switch(p){case "\t":l||(l=[]);l.push(g.substring(q,n));var r=i-f%i;f+=r;for(;r>=0;r-="                ".length)l.push("                ".substring(0,
r));q=n+1;break;case "\n":f=0;break;default:++f}}if(!l)return g;l.push(g.substring(q));return l.join("")}}var v=/(?:[^<]+|<!--[\s\S]*?--\>|<!\[CDATA\[([\s\S]*?)\]\]>|<\/?[a-zA-Z][^>]*>|<)/g,C=/^<!--/,J=/^<\[CDATA\[/,N=/^<br\b/i;function P(i){var f=i.match(v),g=[],l=0,q=[];if(f)for(var n=0,w=f.length;n<w;++n){var p=f[n];if(p.length>1&&p.charAt(0)==="<"){if(!C.test(p))if(J.test(p)){g.push(p.substring(9,p.length-3));l+=p.length-12}else if(N.test(p)){g.push("\n");l+=1}else q.push(l,p)}else{var r=x(p);
g.push(r);l+=r.length}}return{source:g.join(""),tags:q}}function O(i,f){var g={};(function(){var q=i.concat(f);for(var n=q.length;--n>=0;){var w=q[n],p=w[3];if(p)for(var r=p.length;--r>=0;)g[p.charAt(r)]=w}})();var l=f.length;return function(q,n){n=n||0;var w=[n,"pln"],p="",r=0,K=q;while(K.length){var D,H=null,I=g[K.charAt(0)];if(I){var G=K.match(I[1]);H=G[0];D=I[0]}else{for(var L=0;L<l;++L){I=f[L];var M=I[2];if(!(M&&!M.test(p))){var G=K.match(I[1]);if(G){H=G[0];D=I[0];break}}}if(!H){D="pln";H=K.substring(0,
1)}}w.push(n+r,D);r+=H.length;K=K.substring(H.length);if(D!=="com"&&/\S/.test(H))p=H}return w}}var R=O([["str",/^\'(?:[^\\\']|\\[\s\S])*(?:\'|$)/,null,"'"],["str",/^\"(?:[^\\\"]|\\[\s\S])*(?:\"|$)/,null,'"'],["str",/^\`(?:[^\\\`]|\\[\s\S])*(?:\`|$)/,null,"`"]],[["pln",/^(?:[^\'\"\`\/\#]+)/,null," \r\n"],["com",/^#[^\r\n]*/,null,"#"],["com",/^\/\/[^\r\n]*/,null],["str",/^\/(?:[^\\\*\/]|\\[\s\S])+(?:\/|$)/,c],["com",/^\/\*[\s\S]*?(?:\*\/|$)/,null]]),S=O([],[["pln",/^\s+/,null," \r\n"],["pln",/^[a-z_$@][a-z_$@0-9]*/i,
null],["lit",/^0x[a-f0-9]+[a-z]/i,null],["lit",/^(?:\d(?:_\d+)*\d*(?:\.\d*)?|\.\d+)(?:e[+-]?\d+)?[a-z]*/i,null,"123456789"],["pun",/^[^\s\w\.$@]+/,null]]);function T(i,f){for(var g=0;g<f.length;g+=2){var l=f[g+1];if(l==="pln"){var q=f[g],n=g+2<f.length?f[g+2]:i.length,w=i.substring(q,n),p=S(w,q);for(var r=0,K=p.length;r<K;r+=2){var D=p[r+1];if(D==="pln"){var H=p[r],I=r+2<K?p[r+2]:w.length,G=i.substring(H,I);if(G==".")p[r+1]="pun";else if(G in k)p[r+1]="kwd";else if(/^@?[A-Z][A-Z$]*[a-z][A-Za-z$]*$/.test(G))p[r+
1]=G.charAt(0)=="@"?"lit":"typ"}}d(p,f,g,2);g+=p.length-2}}return f}var U=O([],[["pln",/^[^<]+/,null],["dec",/^<!\w[^>]*(?:>|$)/,null],["com",/^<!--[\s\S]*?(?:--\>|$)/,null],["src",/^<\?[\s\S]*?(?:\?>|$)/,null],["src",/^<%[\s\S]*?(?:%>|$)/,null],["src",/^<(script|style|xmp)\b[^>]*>[\s\S]*?<\/\1\b[^>]*>/i,null],["tag",/^<\/?\w[^<>]*>/,null]]);function V(i){var f=U(i);for(var g=0;g<f.length;g+=2)if(f[g+1]==="src"){var l=f[g],q=g+2<f.length?f[g+2]:i.length,n=i.substring(l,q),w=n.match(/^(<[^>]*>)([\s\S]*)(<\/[^>]*>)$/);
if(w)f.splice(g,2,l,"tag",l+w[1].length,"src",l+w[1].length+(w[2]||"").length,"tag")}return f}var W=O([["atv",/^\'[^\']*(?:\'|$)/,null,"'"],["atv",/^\"[^\"]*(?:\"|$)/,null,'"'],["pun",/^[<>\/=]+/,null,"<>/="]],[["tag",/^[\w-]+/,/^</],["atv",/^[\w-]+/,/^=/],["atn",/^[\w-]+/,null],["pln",/^\s+/,null," \r\n"]]);function X(i,f){for(var g=0;g<f.length;g+=2){var l=f[g+1];if(l==="tag"){var q=f[g],n=g+2<f.length?f[g+2]:i.length,w=i.substring(q,n),p=W(w,q);d(p,f,g,2);g+=p.length-2}}return f}function Y(i,f){for(var g=
0;g<f.length;g+=2){var l=f[g+1];if(l=="src"){var q=f[g],n=g+2<f.length?f[g+2]:i.length,w=Q(i.substring(q,n));for(var p=0,r=w.length;p<r;p+=2)w[p]+=q;d(w,f,g,2);g+=w.length-2}}return f}function Z(i,f){var g=false;for(var l=0;l<f.length;l+=2){var q=f[l+1];if(q==="atn"){var n=f[l],w=l+2<f.length?f[l+2]:i.length;g=/^on|^style$/i.test(i.substring(n,w))}else if(q=="atv"){if(g){var n=f[l],w=l+2<f.length?f[l+2]:i.length,p=i.substring(n,w),r=p.length,K=r>=2&&/^[\"\']/.test(p)&&p.charAt(0)===p.charAt(r-1),
D,H,I;if(K){H=n+1;I=w-1;D=p}else{H=n+1;I=w-1;D=p.substring(1,p.length-1)}var G=Q(D);for(var L=0,M=G.length;L<M;L+=2)G[L]+=H;if(K){G.push(I,"atv");d(G,f,l+2,0)}else d(G,f,l,2)}g=false}}return f}function Q(i){var f=R(i);return f=T(i,f)}function aa(i){var f=V(i);f=X(i,f);f=Y(i,f);return f=Z(i,f)}function ba(i,f,g){var l=[],q=0,n=null,w=null,p=0,r=0,K=E(8);function D(I){if(I>q){if(n&&n!==w){l.push("</span>");n=null}if(!n&&w){n=w;l.push('<span class="',n,'">')}var G=m(K(i.substring(q,I))).replace(/(\r\n?|\n| ) /g,
"$1&nbsp;").replace(/\r\n?|\n/g,"<br>");l.push(G);q=I}}while(true){var H;if(H=p<f.length?r<g.length?f[p]<=g[r]:true:false){D(f[p]);if(n){l.push("</span>");n=null}l.push(f[p+1]);p+=2}else if(r<g.length){D(g[r]);w=g[r+1];r+=2}else break}D(i.length);n&&l.push("</span>");return l.join("")}function ca(i){try{var f=P(i),g=f.source,l=f.tags,q=/^\s*</.test(g)&&/>\s*$/.test(g),n=q?aa(g):Q(g);return ba(g,l,n)}catch(w){if("console"in window){console.log(w);console.trace()}return i}}function da(i){var f=[document.getElementsByTagName("pre"),
document.getElementsByTagName("code"),document.getElementsByTagName("xmp")],g=[];for(var l=0;l<f.length;++l)for(var q=0;q<f[l].length;++q)g.push(f[l][q]);var n=0;function w(){var p=(new Date).getTime()+250;for(;n<g.length&&(new Date).getTime()<p;n++){var r=g[n];if(r.className&&r.className.indexOf("prettyprint")>=0){var K=false;for(var D=r.parentNode;D!=null;D=D.parentNode)if((D.tagName=="pre"||D.tagName=="code"||D.tagName=="xmp")&&D.className&&D.className.indexOf("prettyprint")>=0){K=true;break}if(!K){var H=
B(r);H=H.replace(/(?:\r\n?|\n)$/,"");var I=ca(H);if(A(r)){var G=document.createElement("PRE");for(var L=0;L<r.attributes.length;++L){var M=r.attributes[L];M.specified&&G.setAttribute(M.name,M.value)}G.innerHTML=I;r.parentNode.replaceChild(G,r)}else r.innerHTML=I}}}if(n<g.length)setTimeout(w,250);else i&&i()}w()}this.prettyPrint=da})();(function(){var k=/\/\/([^\/]*)?(\/[^\#\?]*)?([^\#]*)?(.*)$/,a=["a + ul","a + ol","h1 + ul","h1 + ol","h2 + ul","h2 + ol","span.tlw-title + ul","span.tlw-title + ol"].join();function d(h){var e=5381;for(var j=0;j<h.length;j++)e=(e<<5)+e+h.charCodeAt(j);return e}var c=window._tocPath_?[null,null,_tocPath_,null,""]:k.exec(location.href),b=c?["ck_",d(c[2]+c[4])].join(""):"ck_checksumError";window.CODESITE_filterSingleQuotes=function(h){var e=/(\')/g;return String.prototype.replace.call(h,e,"\\$1")};
window.CODESITE_createTreeLists=function(h){h=h!=jQuery&&h||".treelist";function e(s,u,o,x){var A=o||CODESITE_msgs.treelist.EXPAND_DEFAULT,t=x||CODESITE_msgs.treelist.COLLAPSE_DEFAULT,B=jQuery(u),z=B.parents("div:first").next(),E=s?t:A,v=s?"tlw-minus":"tlw-plus";B.attr("alt",E).parent().attr("title",E);B.removeClass("tlw-minus tlw-plus").addClass(v);s?z.show():z.hide()}var j=(function(){var s=function(){var u=[],o=null;for(var x in this)if(!(x=="toString")){x=CODESITE_filterSingleQuotes(x);o=CODESITE_filterSingleQuotes(this[x]);
u.push(['"',x,'":"',o,'"'].join(""))}return["{",u.join(),"}"].join("")};return function(){var u=null,o=null;if(u=(new RegExp([b,"=([^;]*)?"].join(""))).exec(document.cookie))o=eval("["+u[1]+"][0]");o=o||{};o.toString=s;return o}})();function m(s,u){var o=j();if(u)o[s]=true;else delete o[s];document.cookie=[b,"=",o.toString()].join("")}var y=['<div class="tlw-title">','<a href="javascript:void(0)" class="tlw-control" title="">','<img src="',CODESITE_derivePath("/images/cleardot.gif"),'" alt="" class="tlw-control">',
"</a>","</div>"].join("");jQuery(h).each(function(){var s=jQuery(this);if(!s.is(".tlw-processed")){s._count=0;var u=arguments.callee,o=(u._list=u._list||[]).length;u._list.push(s);s.addClass("tlw-processed tlw-instance-"+o);s.find("a + span.new").each(function(){var x=jQuery(this),A=x.prev(),t=jQuery("<span>");t.css("textDecoration",A.css("textDecoration"));t.append(A.html());A.css("textDecoration","none").empty();A.append(t).append(this)});s.find(a).each(function(){var x=jQuery(this),A=[o,"sub",
s._count].join("-"),t=x.prev(),B=jQuery(y),z=jQuery("img.tlw-control:first",B),E=CODESITE_msgs.treelist.EXPAND.replace(/@1/g,t.text()),v=CODESITE_msgs.treelist.COLLAPSE.replace(/@1/g,t.text());if(!t.is(".tlw-ignore")){var C={$open:function(){if(x.is(":hidden")){e(true,z,E,v);CODESITE_createTreeLists._init&&m(A,true)}},$close:function(){if(x.is(":visible")){e(false,z,E,v);CODESITE_createTreeLists._init&&m(A,false)}},$toggle:function(){var J=x.is(":hidden");e(J,z,E,v);CODESITE_createTreeLists._init&&
m(A,J)}};jQuery.extend(this,C);jQuery.extend(z.parent()[0],C);x.attr("id",A);x.before(B);B.append(t);B.addClass("tlw-branch");B.parent().css({paddingTop:"0",paddingBottom:"0"});this.$close();z.parent().click(function(){this.$toggle()});s._count++}})}});var F=j();jQuery.each(F,function(s){if(!(s=="toString"))try{jQuery("#"+s)[0].$open()}catch(u){}});window.ontreelistcomplete&&typeof ontreelistcomplete=="function"&&window.ontreelistcomplete(h)};window.CODESITE_convertTableOfContents=function(){jQuery("#gc-toc ul:first, #gc-toc ol:first").addClass("treelist tlw-nested-only").siblings("ul, ol").addClass("treelist tlw-nested-only");
for(var h=0,e=jQuery(".treelist.tlw-nested-only").children();h<e.length;h++)jQuery(e[h]).children(":first").next(a).prev().addClass("tlw-ignore")};window.CODESITE_tocHighlighter=function(){var h=/\/intl\/.*?\//,e=/\/index\.html$/,j=jQuery("#gc-toc a[@href]"),m=window.location.href,y=null,F=null,s=null,u=k.exec(m);if(u)m=u[2];m=m.replace(h,"/").replace(e,"/");for(var o=0;o<j.length;o++){if(F=k.exec(j[o].href)){s=jQuery(j[o]);y=(F[2]+F[4]).replace(h,"/").replace(e,"/");if(m==y){s.parent().addClass("selected");
s.is(".tlw-hidden")&&s.parent().addClass("tlw-hidden");var x=s.siblings("a.tlw-control");for(var A=0;A<x.length;A++)x[A].$open();var t=s.parents("ul").siblings(".tlw-branch").find("a.tlw-control");for(var B=0;B<t.length;B++)t[B].$open()}}}var z=jQuery(".tlw-branch .tlw-expanded"),E=jQuery(".tlw-branch .tlw-collapsed"),v;for(var o=0;o<z.length;o++){(v=z[o].previousSibling)&&v.$open&&v.$open()}for(var o=0;o<E.length;o++){(v=E[o].previousSibling)&&v.$close&&v.$close()}window.ontreelisthighlight&&typeof ontreelisthighlight==
"function"&&window.ontreelisthighlight()};window.CODESITE_buildTreelistWidgetCalled=false;window.CODESITE_buildTreelistWidget=function(){if(!CODESITE_buildTreelistWidgetCalled){CODESITE_convertTableOfContents();CODESITE_createTreeLists();CODESITE_tocHighlighter();window.CODESITE_buildTreelistWidgetCalled=true}};jQuery(document).ready(function(){CODESITE_buildTreelistWidget()});jQuery(window).load(function(){CODESITE_createTreeLists._init=true})})(jQuery);(function(){function k(a){this.parentElem=a.parent;this.controlsElem=a.controls;this.contentElem=a.content;if(!(!this.parentElem||!this.controlsElem||!this.contentElem)){k.active[this.index=k.active.length]=this;var d=this;this.toggleElem=jQuery('<img src="images/cleardot.gif">').addClass("collapsible-control").mouseover(function(){var c=jQuery(this);c.addClass("collapsible-hover")}).mouseout(function(){var c=jQuery(this);c.removeClass("collapsible-hover")});this.controlsElem.mousedown(function(){var c=
jQuery(d.toggleElem),b=jQuery(d.contentElem);if(b.is(":visible")){c.addClass("collapsible-plus").removeClass("collapsible-minus");b.hide()}else{c.addClass("collapsible-minus").removeClass("collapsible-plus");b.show()}});if(this.parentElem.is(".closed"))a.opened=false;if(this.parentElem.is(".opened"))a.opened=true;if(a.opened===true)this.toggleElem.addClass("collapsible-minus");else{this.toggleElem.addClass("collapsible-plus");this.contentElem.hide()}this.controlsElem.prepend(this.toggleElem);this.parentElem.addClass("collapsible-done")}}
k.prototype={index:-1,parentElem:null,controlsElem:null,contentElem:null,toggleElem:null};jQuery.extend(k,{active:[],convert:function(){var a=jQuery(".collapsible");for(var d=0;d<a.length;d++)if(!(a[d].className.indexOf("collapsible-done")!=-1)){var c=jQuery(".collapsible-controls",a[d]),b=jQuery(".collapsible-content",a[d]);!c.length||!b.length||new k({parent:jQuery(a[d]),controls:c,content:b})}}});window.CODESITE_collapsible=k;jQuery(function(){CODESITE_collapsible.convert()})})();
