# teag_event.tcl
#!/bin/sh
# the next line restarts using tclsh \
exec tclsh "$0" "$@"

package require Gnocl

# arrow buttons
if (0) {
set box [gnocl::box]
set but1 [gnocl::arrowButton -arrow up -shadow in -tooltip "Go Up" -onClicked {puts "%w up arrowButton"}]
set but2 [gnocl::arrowButton -arrow down -shadow in -tooltip "Go Down" -onClicked {puts "%w down arrowButton"}]
set but3 [gnocl::arrowButton -arrow left -shadow in -tooltip "Go Left" -onClicked {puts "%w left arrowButton"}]
set but4 [gnocl::arrowButton -arrow right -shadow in -tooltip "Go Right" -data right -onClicked {puts "%w right arrowButton"}]
$box add [list $but1 $but2 $but3 $but4]
gnocl::window -title "arrowButton" -child $box
}

# link buttons
if (0) {
set box [gnocl::box]
set but1 [gnocl::linkButton -uri www.bbc.co.uk -onClicked {eval exec firefox %u &}]]
set but2 [gnocl::linkButton -uri www.bbc.co.uk -text HOMEPAGE -onClicked {eval exec firefox %u &}]]
$box add [list $but1 $but2 ]
gnocl::window -title "linkButton" -child $box
}

#toggle buttons
if (0) {

proc update {val bar} {
	upvar $val snap
	$bar push "SNAP: $snap(x) $snap(y) $snap(z)"
}

array set snap {x 0 y 0 z 0}
set box [gnocl::box -orientation vertical]
set lab [gnocl::label -text Snap]
set stat [gnocl::statusBar]
update snap $stat
set but1 [gnocl::toggleButton -text "X" -variable snap(x) -prelightBackgroundColor cyan -activeBackgroundColor red -onToggled { update snap $stat}]
set but2 [gnocl::toggleButton -text "Y" -variable snap(y) -prelightBackgroundColor cyan -activeBackgroundColor red -onToggled { update snap $stat}]
set but3 [gnocl::toggleButton -text "Z" -variable snap(z) -prelightBackgroundColor cyan -activeBackgroundColor red -onToggled { update snap $stat}]

$box add [list $lab $but1 $but2 $but3 $stat]

gnocl::window -title "toggleButton" -child $box

}

#button -some new options
if (0) {
set box [gnocl::box]
set but [gnocl::button \
	-onEnter {puts "You Entered %w"}  \
	-onLeave {puts "You Left %w"}  \
	-tooltip "Button" ]

$box add $but
gnocl::window -title "button" -child $box
}

#scaleButton
if (0) {
set box [gnocl::box]
# set scl [gnocl::scaleButton -icons "%#Zoom100" -onValueChanged {puts "HELLO"}]
set scl [gnocl::scaleButton \
	-value 50 \
	-normalBackgroundColor blue \
	-tooltip "ScaleButton" -onValueChanged {puts "HELLO %w %v"}]
puts $scl

$scl configure -icons "GTK_STOCK_DIALOG_QUESTION"
#$scl configure -icons "GTK_STOCK_ZOOM_IN, GTK_STOCK_ZOOM_OUT, GTK_STOCK_ZOOM_100"
$box add $scl
gnocl::window -title "scaleButton" -child $box

}

#volumeButton
if (0) {
set box [gnocl::box]
# set vol [gnocl::volumeButton -icons "%#Zoom100" -onValueChanged {puts "HELLO"}]
set vol [gnocl::volumeButton ]

puts $vol

$scl configure -icons "GTK_STOCK_DIALOG_QUESTION"
#vol configure -icons "GTK_STOCK_ZOOM_IN, GTK_STOCK_ZOOM_OUT, GTK_STOCK_ZOOM_100"
$box add $vol
gnocl::window -title "volumeButton" -child $box
}

#textTags
if (1) {
set text [gnocl::text]
$text tag create bold -fontWeight bold -foreground blue -onEvent {puts "%w %t"}
$text insert end "This is "
$text insert end "Gnocl" -tags bold
$text insert end "!"
gnocl::window -title "TextTags" -child $text

}

gnocl::mainLoop
