# teag_event.tcl
#!/bin/sh
# the next line restarts using tclsh \
exec tclsh "$0" "$@"

package require Gnocl



set txt1 [gnocl::text -baseColor #ffffdd ]
set txt2 [gnocl::text -baseColor #ddffdd ]

set box1 [gnocl::box  -orientation vertical -borderWidth 2 -shadow in -fill {1 1}]

$box1 configure -children [list $txt1 $txt2] -fill {1 1} -expand 1

set win [gnocl::window -title "Test-Text-1a" -width 400 -height 150 -child $box1 -onDestroy { exit } -visible 0 -windowCenter 1]
$win configure -visible 1 



# simple popup menu
set menu [gnocl::menu -title "menu" -tearoff 0]
$menu add [gnocl::menuItem -text "%#Save" -onClicked {puts "save"}]
$menu add [gnocl::menuSeparator]
$menu add [gnocl::menuItem -text "%#Quit" -onClicked exit]


if {1} {
$txt1 tag create link1 \
   -fontWeight bold \
   -foreground blue \
   -onEvent {
         puts "LINK: Event Type %t %s %x %y %b"
         puts "X %X Y %Y"
         set a %t
         set b %b
         if { $a == "buttonPress" && $b == "3" } {
           $menu popup
           break;
         }
      } 
}
$txt1 configure -baseFont "Andika 15"


$txt1 insert end "This is some text!\n" 
$txt1 insert end "Click On Me!\n" -tags link1
$txt1 insert end "This is more text!\n"
$txt1 insert end "Click On Me Too!\n" -tags link1


gnocl::mainLoop
