 #---------------
 # histogram.tcl
 #
 # place histogram into canvas
 #---------------


#!/bin/sh
# the next line restarts using tclsh \
exec tclsh "$0" "$@"

package require Gnocl
package require GnoclCanvas

namespace eval graph {}

proc graph::mapy {c y} {
	if {$y == "0"} { return $y }
	set h [$c cget -height]
	return [expr $h - $y]
}

proc graph::grid {c w h} {
	set x1 0
	set x2 $w
	set y1 [graph::mapy $c 0]
	set y2 [graph::mapy $c $h]
	$c create rectangle -coords [list $x1 $y1 $x2 $y2] -fill white -tags grid
}

proc graph::point {c x y r} {
	$c create ellipse -coords [list $x $y $r]
}


set main [gnocl::window -heightRequest 300 -widthRequest 500]

set cv [gnocl::canvas]

$main configure -child $cv


graph::grid $cv 400 200

graph::point $cv 100 200 2


