#!/bin/sh
# the next line restarts using tclsh \
exec tclsh "$0" "$@"

package require Gnocl

package require GnoclSourceView

set sourceView [gnocl::sourceView \
	-showLineNumbers 1 \
	-highlightCurrentLine 1 \
	-insertSpace 0 \
	-showLineMarks 1 \
	-rightMargin 25 \
	-showRightMargin 1 \
	-tabWidth 4 \
	-baseColor #FF0000 \
	-baseFont "Mono 10" \
	-onButtonPress 		{puts "buttonPress! %b"} \
	-onButtonRelease 	{puts "buttonRelease %b"} \
	-onKeyPress 		{puts "keyPress %k"} \
	-onKeyRelease		{puts "keyRelease %k"} \
	-onUndo				{puts "Undo %w"} \
	-onRedo				{puts "Redo %w"} ]

	 # -showMargin 1 \
	 #-onMotion 			"puts onMotion"]

gnocl::window -title "SourceView" -child $sourceView

# widget command parsing now implemented, individual feature implementation now the next task...
$sourceView insert {0 0} "0\n1\n2\n3\n"
$sourceView insert {0 0} "---\n"
$sourceView insert {1 0} "aaa\n"
$sourceView insert {2 0} "bbb\n"
$sourceView insert {3 0} "ārya prājñā pāramītā!\n"
