/**
 * NAME
 * 	vte.c
 * \author William J Giddings
 * \brief
 * 	 This file implements a Tcl interface to the Gnome VTE.
 * FUNCTION
 * NOTES
 * BUGS
 * \date 12.03.09
 * SEE ALSO
 */

#include "gnoclVTE.h"

/**
 * Widget options
 */
static GnoclOption vteOptions[] =
{

	{"-transparent", GNOCL_BOOL, "background-transparent"},

	/**
	 *  GtkObject Properties
	 */
	{ "-data", GNOCL_OBJ, "", gnoclOptData },
	{ "-hasFocus", GNOCL_BOOL, "has-focus" },
	{ "-heightGroup", GNOCL_OBJ, "h", gnoclOptSizeGroup },
	{ "-name", GNOCL_STRING, "name" },
	{ "-backgroundColor", GNOCL_OBJ, "normal", gnoclOptGdkColorBg },

	/* GtkButton specific signals */
	{ "-onEnter", GNOCL_OBJ, "E", gnoclOptOnEnterLeave },
	{ "-onLeave", GNOCL_OBJ, "L", gnoclOptOnEnterLeave },
	{ "-onClicked", GNOCL_OBJ, "clicked", gnoclOptCommand },
	{ "-onButtonPress", GNOCL_OBJ, "P", gnoclOptOnButton },
	{ "-onButtonRelease", GNOCL_OBJ, "R", gnoclOptOnButton },

	/* GtkWidget signals */
	{ "-onPopupMenu", GNOCL_OBJ, "popup-menu", gnoclOptCommand },
	{ "-onRealize", GNOCL_OBJ, "realize", gnoclOptCommand },
	{ "-onShowHelp", GNOCL_OBJ, "", gnoclOptOnShowHelp },

	{ "-prelightBackgroundColor", GNOCL_OBJ, "prelight", gnoclOptGdkColorBg },
	{ "-relief", GNOCL_OBJ, "relief", gnoclOptRelief },
	{ "-sensitive", GNOCL_BOOL, "sensitive" },
	{ "-sizeGroup", GNOCL_OBJ, "s", gnoclOptSizeGroup },
	{ "-tooltip", GNOCL_OBJ, "", gnoclOptTooltip },
	{ "-visible", GNOCL_BOOL, "visible" },
	{ "-widthGroup", GNOCL_OBJ, "w", gnoclOptSizeGroup },

	{ "-backgroundImage", GNOCL_OBJ, "", gnoclOptBackgroundImage },

	/* inherited GtkWidget properties */
	{ "-heightRequest", GNOCL_INT, "height-request" },
	{ "-widthRequest", GNOCL_INT, "width-request" },


	{ NULL },
};

/**
 * vteFunc
 * \author WJG
 * \date 12.03.09
 */
static int vteFunc (
	ClientData data,
	Tcl_Interp *interp,
	int objc,
	Tcl_Obj * const objv[] )
{
	return TCL_OK;
}

/**
 * \author WJG
 * \date 12-03-2008
 * \brief Configure the vte widget based upon parameters passed to the calling function.
 * \bug none
 */
static int configure (
	Tcl_Interp *interp,
	GtkWidget *term,
	GnoclOption options[] )
{
	g_print ( "vte/configure\n" );
	return TCL_OK;
}


/**
 * \author WJG
 * \date 12-03-2008
 * \brief Configure the vte widget based upon parameters passed to the calling function.
 * \bug none
 */
int gnoclVTECmd (
	ClientData data,
	Tcl_Interp *interp,
	int objc,
	Tcl_Obj * const objv[] )
{

	g_print ( "gnoclVTECmd\n" );

	int               ret;
	GtkWidget *term;

	if ( gnoclParseOptions ( interp, objc, objv, vteOptions ) != TCL_OK )
	{
		gnoclClearOptions ( vteOptions );
		return TCL_ERROR;
	}


	GtkWidget *terminal = vte_terminal_new ();

	GtkWidget *scrollbar = gtk_vscrollbar_new ( vte_terminal_get_adjustment
						   ( VTE_TERMINAL ( terminal ) ) );
	GtkWidget *hbox = gtk_hbox_new ( FALSE, 0 );

	vte_terminal_fork_command ( VTE_TERMINAL ( terminal ), "/bin/bash",
								NULL, NULL, g_get_home_dir (), FALSE, FALSE, FALSE );
	vte_terminal_set_font_from_string ( VTE_TERMINAL ( terminal ), "Monospace 9" );
	vte_terminal_set_scroll_on_output ( VTE_TERMINAL ( terminal ), FALSE );
	vte_terminal_set_scroll_on_keystroke ( VTE_TERMINAL ( terminal ), TRUE );
	vte_terminal_set_mouse_autohide ( VTE_TERMINAL ( terminal ), TRUE );

	gtk_box_pack_start ( GTK_BOX ( hbox ), terminal, TRUE, TRUE, 0 );

	gtk_box_pack_start ( GTK_BOX ( hbox ), scrollbar, FALSE, FALSE, 0 );

	/* set options */


	gtk_widget_show ( GTK_WIDGET ( terminal ) );

	ret = gnoclSetOptions ( interp, vteOptions, G_OBJECT ( terminal ), -1 );

	if ( ret == TCL_OK )
	{
		ret = configure ( interp, terminal, vteOptions );
	}

	gnoclClearOptions ( vteOptions );

	if ( ret != TCL_OK )
	{
		gtk_widget_destroy ( GTK_WIDGET ( terminal ) );
		return TCL_ERROR;
	}


	char *command = "mc\n";

	/* -background */
	GdkColor color;
	gchar text[] = "red";
	gdk_color_parse ( &text, &color );
	vte_terminal_set_color_background ( VTE_TERMINAL ( terminal ), &color );

	/* -foreground */
	vte_terminal_set_color_foreground ( VTE_TERMINAL ( terminal ), &color );

	/* -tint */
	vte_terminal_set_background_tint_color ( VTE_TERMINAL ( terminal ), &color );

	/* -bold */
	vte_terminal_set_color_bold ( VTE_TERMINAL ( terminal ), &color );

	/* -saturation */
	vte_terminal_set_background_saturation ( VTE_TERMINAL ( terminal ), 0.5 );

	/* -transparent */
	vte_terminal_set_background_transparent ( VTE_TERMINAL ( terminal ), 1 );

	/* -backgroundImage */
	vte_terminal_set_background_image_file ( VTE_TERMINAL ( terminal ), "./EU_flag.jpg" );

	/* -scrollBackground */
	vte_terminal_set_scroll_background ( VTE_TERMINAL ( terminal ), 1 );

	/* -cursor
	 * typedef enum {
	    VTE_CURSOR_SHAPE_BLOCK,
	    VTE_CURSOR_SHAPE_IBEAM,
	    VTE_CURSOR_SHAPE_UNDERLINE
		} VteTerminalCursorShape;
	 * */
	/* not available */
	/*
	 vte_terminal_set_cursor_shape (VTE_TERMINAL (terminal),1);
	*/

	/* -cursorBlink default = 0*/
	vte_terminal_set_cursor_blinks ( VTE_TERMINAL ( terminal ), 1 );

	/* -mouseHide default = 1*/
	vte_terminal_set_mouse_autohide ( VTE_TERMINAL ( terminal ), 0 );

	/* -font */
	// vte_terminal_set_font_from_string (VTE_TERMINAL (terminal), text);

	/* -hearBell default = 0 */
	vte_terminal_set_audible_bell ( VTE_TERMINAL ( terminal ), 1 );

	/* -seeBell default = 0 */
	vte_terminal_set_visible_bell ( VTE_TERMINAL ( terminal ), 1 );

	/* -allowBold */
	vte_terminal_set_allow_bold ( VTE_TERMINAL ( terminal ), 1 );

	/* id feed ??string?? */
	vte_terminal_feed_child ( VTE_TERMINAL ( terminal ), command, strlen ( command ) );

	return gnoclRegisterWidget ( interp, GTK_WIDGET ( hbox ) , vteFunc );

	//return TCL_OK;

}

