# introduction_example.tcl

#!/bin/sh
# the next line restarts using tclsh \
exec tclsh "$0" "$@"

# Load the Gnocl package to be able to use the Gnocl commands.
package require Gnocl

#  Create a menu to which different menu entries are added in the
#  following lines.
set menu [gnocl::menu]

# A standard New entry is created and added to the menu. The percent
# sign as first character of the test string gives, together with the
# next character, the string a special meaning (see Percent String).
# In this case "%#" means that "New" is used as stock item, which means
# that not only a standard text is used, but also if available the
# standard icon and a standard accelerator are added.
# The string that follows the onClicked option is executed whenever
# the menu is clicked or its accelerator pressed.
$menu add [gnocl::menuItem \
    -text "%#New" \
    -tooltip "Make new" \
    -onClicked {puts "That's new"}]

$menu add [gnocl::menuSeparator]

$menu add [gnocl::menuItem \
    -text "%#Quit" \
    -onClicked exit \
    -tooltip "Quit program"]

set file [gnocl::menuItem \
    -text "%__File" \
    -submenu $menu]

set menu [gnocl::menu]
$menu add [gnocl::menuItem \
    -text "%__About" \
    -tooltip "Show about dialog" \
    -onClicked {puts "Mini example (c) 2001 P.G. Baum"}]

set help [gnocl::menuItem \
    -text "%__Help" \
    -submenu $menu]

# A toolBar is created similar to the menu above.
# With the -type option a syle with text and icons is used.
set toolBar [gnocl::toolBar -style both]

# A toolBar items is added to the toolBar. The syntax is similar to menu
# entries. Again a percent string is used to select a standard text and icon.
$toolBar add item \
    -text "%#Quit" \
    -tooltip "Tooltip Quit" \
    -onClicked exit

$toolBar add space
$toolBar add item \
    -text "%#New" \
    -tooltip "Tooltip new" \
    -onClicked {puts "That's new"}

set box [gnocl::box \
    -orientation vertical \
    -borderWidth 0 \
    -spacing 0]

set win [gnocl::window \
    -widthRequest 200 \
    -heightRequest 200 \
    -child $box \
    -title "Test Application"]

# To be visible each widget must be a direct or indirect ancestor of a
# top level widget. The standard top level widget is window.
$box add [gnocl::menuBar \
    -children [list $file $help]]
$box add $toolBar

# As main widget of the application a simple label is used. This one
# demonstrates another Percent String: the Markup String. It contains
# not only the text, but also the formatting of the text. This is very
# convenient and has huge advantages for internationalization of applications.
$box add [gnocl::label -text \
      {%<<span foreground="blue" size="large">Hello</span> \
      <span foreground="red" size="large">World</span>}] \
      -expand 1
$box add [gnocl::statusBar]

# Since Gnocl is event based the GTK main loop has to be called. This
# function never returns. From now on the GUI reacts on user input or
# other events like timers and the associated callback functions are called.
gnocl::mainLoop
