#****f* function/gnoclMegaWidgets
# NAME
# gnoclMegaWidgets.tcl
# DESCRIPTION
# Provides simple megawidgets for use in Gnocl application.
# AUTHOR
# William J Giddings
# CREATION DATE
# 06-FEB-09
# PURPOSE
# Save the scripter a whole pile of time building code to produce
# embed and configure child widgets.
# USAGE
# At present, keep within directory where required and source into
# script. A Tcl package could be created, however, the ultimate aim
# is to move simple megawidgets into the Gnocl core package.
# COMMANDS
# gnocl::OKCancel
# gnocl::labelEntry
# gnocl::labelCombo
# OPTIONS
# EXAMPLE
# FUNCTION
# NOTES
# BUGS
# SEE ALSO
# USES
# USED BY
# MODIFICATION HISTORY
# TODO
# Add new widgets with time...
# SOURCE
#

package require Gnocl


# simple listBox based upon the text widget
# the list contained by the object needs to be traced

proc gnocl::listBox {args} {
	set lb [gnocl::text \
		-editable 0 \
		-onButtonPress {} \
		-onButtonRelease {} \
		]
	$lb tag create a -background white
	$lb tag create b -background grey

	# allocate which elements get which settings
	foreach {a b} $args {
		switch -- $a {
			-listVariable {
				# these are for the OK buton
				puts "Putting a trace on $b"
				 upvar $b listVariable
				set i 0
				set tag a
				foreach item $listVariable {
					$lb insert "$i 0" "$item\n" -tags $tag
					if {$tag == "a"} {set tag "b" } else {set tag  "a"}
				}
				# remove the last line inserted, this will be a <CR>
			}
			-text2  {
				# these are for the OK buton
				$lb configure -text $b
			}
			-command2 {
				# these are for the Cancel button
				$lb configure -onClicked $b
			}
			default {
				$lc configure $a $b
			}
		}

	}

	# overload the box to add commands
	rename $lb _$lb

	# this section doesn't do much yet...
    proc $lb {cmd args} {
		set self [lindex [::info level 0] 0]
            switch -- $cmd {
                super   {puts "super! $args" }
				cget { puts cget}
                default {uplevel 1 _$self $cmd $args}
				}
    }

	return $lb

}


# megawidget to contain Ok/Cancel buttons
proc gnocl::OkCancel { args } {
	# create the elements of the megawidget
	set box [gnocl::box]
	set but1 [gnocl::button]
	set but2 [gnocl::button]

	# give the subttons some defaults names
	$but1 configure -text OK
	$but2 configure -text Cancel

	# allocate which elements get which settings
	foreach {a b} $args {
		switch -- $a {
			-text1 {
				# these are for the OK buton
				$but1 configure -text $b
			}
			-command1 {
				# these are for the OK buton
				$but1 configure -onClicked $b
			}
			-text2  {
				# these are for the OK buton
				$but2 configure -text $b
			}
			-command2 {
				# these are for the Cancel button
				$but2 configure -onClicked $b
			}
			default {
				$but1 configure -text OK
				$but2 configure -text Cancel
			}
		}
	}

	$box add $but1 -fill {1 0} -expand 1
	$box add $but2 -fill {1 0} -expand 1

	# overload the box to add commands
	rename $box _$box

	# this section doesn't do much yet...
    proc $box {cmd args} {
		set self [lindex [::info level 0] 0]
            switch -- $cmd {
                super   {puts "super! $args" }
				cget { puts cget}
                default {uplevel 1 _$self $cmd $args}
				}
    }

	return $box
}


# megawidget to contain Ok/Cancel buttons
proc gnocl::OkCancelReset { args } {
	# create the elements of the megawidget

	set box [gnocl::box]
	set but1 [gnocl::button]
	set but2 [gnocl::button]
	set but3 [gnocl::button]

	# give the subttons some defaults names
	$but1 configure -text OK
	$but2 configure -text Cancel
	$but3 configure -text Reset

	# allocate which elements get which settings
	foreach {a b} $args {
		switch -- $a {
			-text1 {
				# these are for the OK buton
				$but1 configure -text $b
			}
			-command1 {
				# these are for the OK buton
				$but1 configure -onClicked $b
			}
			-text2  {
				# these are for the OK buton
				$but2 configure -text $b
			}
			-command2 {
				# these are for the Cancel button
				$but2 configure -onClicked $b
			}
			-text3  {
				# these are for the OK buton
				$but3 configure -text $b
			}
			-command3 {
				# these are for the Cancel button
				$but3 configure -onClicked $b
			}
			default {
				$but1 configure -text OK
				$but2 configure -text Cancel
				$but3 configure -text Reset
			}
		}
	}

	$box add $but1 -fill {1 0} -expand 1
	$box add $but2 -fill {1 0} -expand 1
	$box add $but3 -fill {1 0} -expand 1

	# overload the box to add commands
	rename $box _$box

	# this section doesn't do much yet...
    proc $box {cmd args} {
		set self [lindex [::info level 0] 0]
            switch -- $cmd {
                super   {puts "super! $args" }
				cget { puts cget}
                default {uplevel 1 _$self $cmd $args}
				}
    }

	return $box
}

# gnocl::labelEntry
#
# megawiget that provides labeled entry box
#
proc gnocl::labelEntry { args } {

	# construct the elements of the megawidget
	set box [gnocl::box -orientation horizontal]
	set lab [gnocl::label ]
	set ent [gnocl::entry ]

	# keep a copy of element names
	$box configure -data "$lab $ent"

	# allocate which element gets which settings
    foreach {a b} $args {
		switch -- $a {
			# these are for the box
			-buttonType -
			-borderWidth -
			-shadow {
				$box configure $a $b
			}
			-align -
			-justify -
			-widthChars -
			-text -
			-tooltip {
				# these are for the label
				$lab configure $a $b
			}
			-labelWidthChars {
				# these are for the entry
			    $lab configure -widthChars $b
			}

			-entryWidthChars {
				# these are for the entry
			    $ent configure -widthChars $b
			}
			default {
				$ent configure $a $b
			}
		}
	}

	$box add $lab -fill {0 0} -expand 0
	$box add $ent -fill {0 0} -expand 0

	# overload the box to add commands
	rename $box _$box

	# the names of the element widgets need to be hard-coded into the procs.
    eval "proc $box {cmd args} {
		puts \"overloaded widget\"
		set self [lindex [::info level 0] 0]
            switch -- \$cmd {
				# handle widget commands
                super   {puts \"super! \$args\" }
				cget {
					switch -- \$args {
						-text {
							return [$lab cget -text]
							}
						default {
							return
							}
						}
					}
                default {
					# these all go to the base widget, ie the box
					uplevel 1 _\$self \$cmd \$args
					}
				}
		}"

	return $box
}

# gnocl::labelEntry
#
# megawiget that provides labeled entry box
#
proc gnocl::labelComboEntry { args } {

	# construct the elements of the megawidget
	set box [gnocl::box -orientation horizontal]
	set lab [gnocl::label ]
	set cent [gnocl::comboEntry ]

	# keep a copy of element names
	$box configure -data "$lab $cent"

	# allocate which element gets which settings
    foreach {a b} $args {
		switch -- $a {
			# these are for the box
			-buttonType -
			-borderWidth -
			-shadow {
				$box configure $a $b
			}
			-align -
			-justify -
			-widthChars -
			-text -
			-tooltip {
				# these are for the label
				$lab configure $a $b
			}
			-labelWidthChars {
				# these are for the entry
			    $lab configure -widthChars $b
			}

			-entryWidthChars {
				# these are for the comboEntry
			    #$cent configure -widthChars $b
			}
			default {
				$cent configure $a $b
			}
		}
	}

	$box add $lab -fill {0 0} -expand 0
	$box add $cent -fill {0 0} -expand 0

	# overload the box to add commands
	rename $box _$box

	# the names of the element widgets need to be hard-coded into the procs.
    eval "proc $box {cmd args} {
		puts \"overloaded widget\"
		set self [lindex [::info level 0] 0]
            switch -- \$cmd {
				# handle widget commands
                super   {puts \"super! \$args\" }
				cget {
					switch -- \$args {
						-text {
							return [$lab cget -text]
							}
						default {
							return
							}
						}
					}
                default {
					# these all go to the base widget, ie the box
					uplevel 1 _\$self \$cmd \$args
					}
				}
		}"

	return $box
}


# gnocl::labelEntry
#
# megawiget that provides labeled entry box
#
proc gnocl::labelSpinButton { args } {

	# construct the elements of the megawidget
	set box [gnocl::box -orientation horizontal]
	set lab [gnocl::label ]
	set sbut [gnocl::spinButton ]

	# keep a copy of element names
	$box configure -data "$lab $sbut"

	# allocate which element gets which settings
    foreach {a b} $args {
		switch -- $a {
			# these are for the box
			-buttonType -
			-borderWidth -
			-shadow {
				$box configure $a $b
			}
			-align -
			-justify -
			-widthChars -
			-text -
			-tooltip {
				# these are for the label
				$lab configure $a $b
			}
			-labelWidthChars {
				# these are for the entry
			    $lab configure -widthChars $b
			}

			-entryWidthChars {
				# these are for the comboEntry
			    #$cent configure -widthChars $b
			}
			default {
				$sbut configure $a $b
			}
		}
	}

	$box add $lab -fill {0 0} -expand 0
	$box add $sbut -fill {0 0} -expand 0

	# overload the box to add commands
	rename $box _$box

	# the names of the element widgets need to be hard-coded into the procs.
    eval "proc $box {cmd args} {
		puts \"overloaded widget\"
		set self [lindex [::info level 0] 0]
            switch -- \$cmd {
				# handle widget commands
                super   {puts \"super! \$args\" }
				cget {
					switch -- \$args {
						-text {
							return [$lab cget -text]
							}
						default {
							return
							}
						}
					}
                default {
					# these all go to the base widget, ie the box
					uplevel 1 _\$self \$cmd \$args
					}
				}
		}"

	return $box
}
