#---------------
# UndoRedoDemo.tcl
#---------------
# Created by WIlliam J Giddings
# March, 2008
#---------------
# Description:
# Demonstrates simple textBuffer undo/redo functionality.
#---------------
# Notes:
# cd /Desktop/GnoclEdit_2/undoer/wjgstuff
#
# This version has a single buffer to show edit history
#
#---------------

# basic Tcl/Gnocl Script
#! /bin/sh/
#\
exec tclsh "$0" "$@"

package require Gnocl

source gnoclTextUndoRedo.tcl
source gnoclBind.tcl

set text [gnocl::text]
set box1 [gnocl::box -orientation vertical]
set box2 [gnocl::box -orientation horizontal ]
set undo [gnocl::button -text "%#Undo" -onClicked { on_undo $text } ]
set redo [gnocl::button -text "%#Redo" -onClicked { on_redo $text } ]

$box2 add [list $undo $redo]
$box1 add $box2
$box1 add $text -fill {1 1} -expand 1

gnocl::window -title "Text" -child $box1

set userAction 1

#----------------
# UNDO/REDO STUFF
#----------------

# respond to text insert signals
$text configure -onInsertText {
	if { $userAction } {
		# add the event details to the undo stack
		push ${text}.UNDO "insert-text \{%r %c\} \{%t\} \{%l\}"
		# clear the redo stack
		catch { unset ${text}.REDO }
	}
}

# respond to text insert signals
$text configure -onDeleteRange {

	if { $userAction } {
		push ${text}.UNDO "delete-range \{%r %c\} \{%l %o\} \{%t\}"
	}
}

# respond to text action signals
$text configure -onBeginUserAction {
	set userAction 1
}

$text configure -onEndUserAction {
	set userAction 0
}

# there are no default Undo/Redo bindings, so set your own
# (GtkSourceView widget defaults to Ctrl-z & Ctrl-Z
gnocl::bind $text <Ctrl-Key-z> "on_undo $text"
gnocl::bind $text <Ctrl-Key-y> "on_redo $text"

$text insert end "Ctrl-z undo\nCtrl-y redo"

#-----------------

gnocl::mainLoop
