/**
 * BNCSutil
 * Battle.Net Utility Library
 *
 * Copyright (C) 2004-2006 Eric Naeseth
 *
 * Common Interface
 * November 20, 2004
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * A copy of the GNU Lesser General Public License is included in the BNCSutil
 * distribution in the file COPYING.  If you did not receive this copy,
 * write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA  02111-1307  USA
 */

#ifndef BNCSUTIL_BNCSUTIL_H_INCLUDED
#define BNCSUTIL_BNCSUTIL_H_INCLUDED

#include <bncsutil/mutil.h> /* Myriad Utility Header */
#include <bncsutil/checkrevision.h> /* CheckRevision / EXE info */
#include <bncsutil/bsha1.h> /* Broken SHA-1 */
#include <bncsutil/oldauth.h> /* Old Logon System */
#include <bncsutil/decodekey.h> /* CD-Key Decoding C wrappers */
#ifdef __cplusplus
#include <bncsutil/cdkeydecoder.h> /* CD-Key Decoding Class */
#endif /* __cplusplus */
#include <bncsutil/nls.h> /* New Logon System */
#include <bncsutil/libinfo.h> /* BNCSutil Library Information */

#endif /* BNCSUTIL_BNCSUTIL_H_INCLUDED */
