/*
 * Decompiled with CFR 0.152.
 */
package br.com.gfp.ols.telas;

import br.com.gfp.controllers.GFPController;
import br.com.gfp.controllers.SupportRequestController;
import br.com.gfp.internationalization.ErrosDeDadosMessages;
import br.com.gfp.internationalization.TableHeaderMessages;
import br.com.gfp.internationalization.TelaBancoMessages;
import br.com.gfp.ols.componentes.CategoriaComboBoxModel;
import br.com.gfp.ols.componentes.GrupoComboBoxModel;
import br.com.gfp.ols.componentes.OLSTableCellRenderer;
import br.com.gfp.ols.componentes.OnLineSupportMessages;
import br.com.gfp.ols.componentes.WebComboBoxModel;
import br.com.gfp.ols.dados.SupportRequest;
import br.com.gfp.telas.componentes.GFPHeaderRenderer;
import br.com.gfp.util.SimpleLog;
import br.com.igor.beans.GeneralEventHandler;
import br.com.igor.beans.MessageView;
import br.com.igor.beans.RequiredField;
import br.com.igor.beans.ZLabel;
import br.com.igor.beans.ZTextArea;
import br.com.igor.beans.ZTextField;
import br.com.igor.beans.aplicativos.PainelTelaBasica;
import br.com.igor.beans.table.DBTable;
import br.com.igor.beans.table.SortableTabelHeaderRenderer;
import br.com.igor.db.PersistentObject;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;

public class TelaSupportRequest
extends JInternalFrame {
    private PainelTelaBasica painelTelaBasica = new PainelTelaBasica();
    private ZLabel jlTituloDoRequest;
    private ZTextField jtfTituloDoRequest;
    private ZLabel jlCategoria;
    private JComboBox jcbCategoria;
    private ZLabel jlGrupo;
    private JComboBox jcbGrupo;
    private DBTable jtRequest;
    private ZLabel jlComentario;
    private ZTextArea taComentario;
    private SupportRequest request = null;
    private SupportRequestController controller = new SupportRequestController();

    public TelaSupportRequest() {
        this.request = new SupportRequest();
        this.setVisible(true);
        this.setIconifiable(true);
        this.setMaximizable(true);
        this.setResizable(true);
        this.setClosable(true);
        this.setContentPane((Container)this.painelTelaBasica);
        this.setTitle(OnLineSupportMessages.getMessages().getString("SupportRequest"));
        this.painelTelaBasica = new PainelTelaBasica();
        this.jtRequest = new DBTable((PersistentObject)new SupportRequest(), (SortableTabelHeaderRenderer)new GFPHeaderRenderer());
        this.jtRequest.hideColumn("Id");
        this.jtRequest.hideColumn("Tipo");
        this.jtRequest.hideColumn("MyRequest");
        this.jtRequest.hideColumn("LocalPost");
        this.jtRequest.getColumn((Object)"AtribuidoPara").setCellRenderer((TableCellRenderer)((Object)new OLSTableCellRenderer(-1, -1)));
        this.jtRequest.getColumn((Object)"CommentsCount").setCellRenderer((TableCellRenderer)((Object)new OLSTableCellRenderer(-1, -1)));
        this.jtRequest.getColumn((Object)"Id").setCellRenderer((TableCellRenderer)((Object)new OLSTableCellRenderer(-1, -1)));
        this.jtRequest.getColumn((Object)"Prioridade").setCellRenderer((TableCellRenderer)((Object)new OLSTableCellRenderer(-1, -1)));
        this.jtRequest.getColumn((Object)"Status").setCellRenderer((TableCellRenderer)((Object)new OLSTableCellRenderer(-1, -1)));
        this.jtRequest.getColumn((Object)"Texto").setCellRenderer((TableCellRenderer)((Object)new OLSTableCellRenderer(-1, -1)));
        this.jtRequest.getColumn((Object)"Titulo").setCellRenderer((TableCellRenderer)((Object)new OLSTableCellRenderer(-1, -1)));
        this.jtRequest.getColumn((Object)"Categoria").setCellRenderer((TableCellRenderer)((Object)new OLSTableCellRenderer(-1, -1)));
        this.jtRequest.getColumn((Object)"Grupo").setCellRenderer((TableCellRenderer)((Object)new OLSTableCellRenderer(-1, -1)));
        this.jtRequest.getSelectionModel().addListSelectionListener((ListSelectionListener)GeneralEventHandler.makeProxy((Object)this, (String)"loadFromTable", ListSelectionListener.class, (String)"valueChanged"));
        this.painelTelaBasica.setJtDados((JTable)this.jtRequest);
        this.painelTelaBasica.setPrintButtonVisible(false);
        this.painelTelaBasica.getTextAreaDescricao().setEditable(false);
        this.jlTituloDoRequest = new ZLabel((MessageView)GFPController.getGFPController().getContexto().get((Object)GFPController.RODAPE_MESSAGER));
        this.jtfTituloDoRequest = new ZTextField();
        this.jlGrupo = new ZLabel((MessageView)GFPController.getGFPController().getContexto().get((Object)GFPController.RODAPE_MESSAGER));
        this.jcbGrupo = new JComboBox(new GrupoComboBoxModel());
        this.jlCategoria = new ZLabel((MessageView)GFPController.getGFPController().getContexto().get((Object)GFPController.RODAPE_MESSAGER));
        this.jcbCategoria = new JComboBox(new CategoriaComboBoxModel());
        this.jlComentario = new ZLabel((MessageView)GFPController.getGFPController().getContexto().get((Object)GFPController.RODAPE_MESSAGER));
        this.taComentario = new ZTextArea();
        this.jlTituloDoRequest.setText(TableHeaderMessages.getMessages().getString("Titulo"));
        this.jlTituloDoRequest.setDisplayedMnemonic(TableHeaderMessages.getMessages().getString("TituloMnemonic").charAt(0));
        this.jlTituloDoRequest.setRequiredField((RequiredField)this.jtfTituloDoRequest);
        this.jlTituloDoRequest.setValidationNotNull(true);
        this.jlTituloDoRequest.setToolTipText(TableHeaderMessages.getMessages().getString("TituloToolTip"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.painelTelaBasica.addComponent((JComponent)this.jlTituloDoRequest, gridBagConstraints, 0);
        this.jtfTituloDoRequest.setMinimumSize(new Dimension(100, 24));
        this.jtfTituloDoRequest.setPreferredSize(new Dimension(180, 26));
        this.jtfTituloDoRequest.setToolTipText(TableHeaderMessages.getMessages().getString("TituloToolTip"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.painelTelaBasica.addComponent((JComponent)this.jtfTituloDoRequest, gridBagConstraints, 0);
        this.jlCategoria.setText(TableHeaderMessages.getMessages().getString("Categoria"));
        this.jlCategoria.setDisplayedMnemonic(TableHeaderMessages.getMessages().getString("CategoriaMnemonic").charAt(0));
        this.jlCategoria.setRequiredField((RequiredField)this.jtfTituloDoRequest);
        this.jlCategoria.setValidationNotNull(true);
        this.jlCategoria.setToolTipText(TableHeaderMessages.getMessages().getString("CategoriaToolTip"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.painelTelaBasica.addComponent((JComponent)this.jlCategoria, gridBagConstraints, 0);
        this.jcbCategoria.setMinimumSize(new Dimension(100, 24));
        this.jcbCategoria.setPreferredSize(new Dimension(180, 26));
        this.jcbCategoria.setToolTipText(TableHeaderMessages.getMessages().getString("CategoriaToolTip"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.painelTelaBasica.addComponent((JComponent)this.jcbCategoria, gridBagConstraints, 0);
        this.jlGrupo.setText(TableHeaderMessages.getMessages().getString("Grupo"));
        this.jlGrupo.setDisplayedMnemonic(TableHeaderMessages.getMessages().getString("GrupoMnemonic").charAt(0));
        this.jlGrupo.setRequiredField((RequiredField)this.jtfTituloDoRequest);
        this.jlGrupo.setValidationNotNull(true);
        this.jlGrupo.setToolTipText(TableHeaderMessages.getMessages().getString("GrupoToolTip"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.painelTelaBasica.addComponent((JComponent)this.jlGrupo, gridBagConstraints, 0);
        this.jcbGrupo.setMinimumSize(new Dimension(100, 24));
        this.jcbGrupo.setPreferredSize(new Dimension(180, 26));
        this.jcbGrupo.setToolTipText(TableHeaderMessages.getMessages().getString("GrupoToolTip"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.painelTelaBasica.addComponent((JComponent)this.jcbGrupo, gridBagConstraints, 0);
        this.jlComentario.setText(OnLineSupportMessages.getMessages().getString("NovoComentario"));
        this.jlComentario.setDisplayedMnemonic(OnLineSupportMessages.getMessages().getString("NovoComentarioMnemonic").charAt(0));
        this.jlComentario.setRequiredField((RequiredField)this.taComentario);
        this.jlComentario.setToolTipText(OnLineSupportMessages.getMessages().getString("NovoComentarioToolTip"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.painelTelaBasica.addComponent((JComponent)this.jlComentario, gridBagConstraints, 0);
        JScrollPane jScrollPane = new JScrollPane((Component)this.taComentario);
        jScrollPane.setPreferredSize(new Dimension(150, 60));
        jScrollPane.setMinimumSize(new Dimension(150, 60));
        jScrollPane.setMinimumSize(new Dimension(250, 60));
        this.taComentario.setToolTipText(OnLineSupportMessages.getMessages().getString("NovoComentarioToolTip"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.painelTelaBasica.addComponent((JComponent)jScrollPane, gridBagConstraints, 0);
        this.painelTelaBasica.getPainelBotoes().addActionListener("salvar", (ActionListener)GeneralEventHandler.makeProxy((Object)this, (String)"salvar", ActionListener.class, (String)"actionPerformed"));
        this.painelTelaBasica.getPainelBotoes().addActionListener("atualizar", (ActionListener)GeneralEventHandler.makeProxy((Object)this, (String)"atualizar", ActionListener.class, (String)"actionPerformed"));
        this.painelTelaBasica.getPainelBotoes().addActionListener("novo", (ActionListener)GeneralEventHandler.makeProxy((Object)this, (String)"novo", ActionListener.class, (String)"actionPerformed"));
        this.painelTelaBasica.getPainelBotoes().addActionListener("excluir", (ActionListener)GeneralEventHandler.makeProxy((Object)this, (String)"excluir", ActionListener.class, (String)"actionPerformed"));
        this.painelTelaBasica.getPainelBotoes().addActionListener("pesquisar", (ActionListener)GeneralEventHandler.makeProxy((Object)this, (String)"pesquisar", ActionListener.class, (String)"actionPerformed"));
        this.painelTelaBasica.getPainelBotoes().addActionListener("limpar", (ActionListener)GeneralEventHandler.makeProxy((Object)this, (String)"limpar", ActionListener.class, (String)"actionPerformed"));
        this.painelTelaBasica.getPainelBotoes().addActionListener("filtrar", (ActionListener)GeneralEventHandler.makeProxy((Object)this, (String)"filtrar", ActionListener.class, (String)"actionPerformed"));
        this.getContentPane().add((Component)this.painelTelaBasica, "Center");
    }

    public void salvar(ActionEvent actionEvent) {
        if (this.request == null) {
            JOptionPane.showMessageDialog(this, TelaBancoMessages.getMessages().getString("semDadosParaSalvar"));
            return;
        }
        this.loadRequest();
        if (this.controller.isAdicionandoNovo()) {
            final SupportRequest supportRequest = new SupportRequest();
            supportRequest.setDados(this.request.getAsMap());
            supportRequest.setNovoTexto(this.request.getNovoTexto());
            new Thread("AdicionandoSupportRequest"){

                public void run() {
                    try {
                        TelaSupportRequest.this.controller.adicionarNovo(supportRequest);
                    }
                    catch (SQLException sQLException) {
                        JOptionPane.showMessageDialog(TelaSupportRequest.this, sQLException.getMessage(), ErrosDeDadosMessages.getMessages().getString("MessageTitle"), 2);
                        TelaSupportRequest.this.painelTelaBasica.getPainelBotoes().setOcorreuErro(true);
                        return;
                    }
                }
            }.start();
        } else {
            final SupportRequest supportRequest = new SupportRequest();
            supportRequest.setDados(this.request.getAsMap());
            supportRequest.setNovoTexto("\nPost by " + System.getProperty("user.name") + "\n" + this.request.getNovoTexto());
            new Thread("AtualizandoSupportRequest"){

                public void run() {
                    try {
                        TelaSupportRequest.this.controller.atualizar(supportRequest);
                    }
                    catch (SQLException sQLException) {
                        JOptionPane.showMessageDialog(TelaSupportRequest.this, sQLException.getMessage(), ErrosDeDadosMessages.getMessages().getString("MessageTitle"), 2);
                        TelaSupportRequest.this.painelTelaBasica.getPainelBotoes().setOcorreuErro(true);
                        return;
                    }
                }
            }.start();
        }
        this.request = null;
        this.refreshTabelaRequests();
    }

    public void pesquisar(ActionEvent actionEvent) {
        if (this.request == null) {
            this.request = new SupportRequest(this.jtfTituloDoRequest.getText());
        }
        this.loadRequest();
        try {
            this.request = (SupportRequest)this.controller.getBy((PersistentObject)this.request);
        }
        catch (SQLException sQLException) {
            ((SimpleLog)GFPController.getGFPController().getContexto().get((Object)GFPController.LOG)).log("Erro ao pesquisar mapeamentoVisaVale: " + (Object)((Object)this.request));
            ((SimpleLog)GFPController.getGFPController().getContexto().get((Object)GFPController.LOG)).log(sQLException.getLocalizedMessage());
            ((SimpleLog)GFPController.getGFPController().getContexto().get((Object)GFPController.LOG)).log((Throwable)sQLException);
            this.request = null;
        }
        this.editarRequest();
    }

    public void excluir(ActionEvent actionEvent) {
        if (this.request == null) {
            JOptionPane.showMessageDialog(this, TelaBancoMessages.getMessages().getString("semDadosParaExcluir"));
            return;
        }
        this.loadRequest();
        try {
            this.controller.deletar((PersistentObject)this.request);
        }
        catch (SQLException sQLException) {
            ((SimpleLog)GFPController.getGFPController().getContexto().get((Object)GFPController.LOG)).log("Erro ao deletar mapeamentoVisaVale: " + (Object)((Object)this.request));
            ((SimpleLog)GFPController.getGFPController().getContexto().get((Object)GFPController.LOG)).log(sQLException.getLocalizedMessage());
            ((SimpleLog)GFPController.getGFPController().getContexto().get((Object)GFPController.LOG)).log((Throwable)sQLException);
        }
        this.request = null;
        this.refreshTabelaRequests();
    }

    public void novo(ActionEvent actionEvent) {
        this.request = new SupportRequest(this.jtfTituloDoRequest.getText());
        this.controller.setAdicionandoNovo(true);
    }

    public void atualizar(ActionEvent actionEvent) {
        this.refreshTabelaRequests();
    }

    public void limpar(ActionEvent actionEvent) {
        this.painelTelaBasica.showRequiredFields();
        this.request = null;
        this.painelTelaBasica.getTextAreaDescricao().setText("");
        this.jtfTituloDoRequest.setText("");
        this.jcbGrupo.setSelectedItem(null);
        this.jcbCategoria.setSelectedItem(null);
        this.taComentario.setText("");
        this.painelTelaBasica.getPainelBotoes().dadosCarregados(false);
        this.controller.setAdicionandoNovo(false);
        this.jtfTituloDoRequest.setEnabled(true);
        this.jcbCategoria.setEnabled(true);
        this.jcbGrupo.setEnabled(true);
    }

    public void filtrar(ActionEvent actionEvent) {
        this.request = new SupportRequest();
        this.loadRequest();
        this.jtRequest.setDataType((PersistentObject)this.request);
        try {
            this.jtRequest.filter();
        }
        catch (Exception exception) {
            ((SimpleLog)GFPController.getGFPController().getContexto().get((Object)GFPController.LOG)).log("Erro na filtragem da tabela de mapeamentoVisaVales!");
            ((SimpleLog)GFPController.getGFPController().getContexto().get((Object)GFPController.LOG)).log(exception.getLocalizedMessage());
            ((SimpleLog)GFPController.getGFPController().getContexto().get((Object)GFPController.LOG)).log((Throwable)exception);
        }
    }

    private void loadRequest() {
        this.request.setTitulo(this.jtfTituloDoRequest.getText());
        this.request.setCategoria(((WebComboBoxModel)((Object)this.jcbCategoria.getModel())).getSelectedId());
        this.request.setGrupo(((WebComboBoxModel)((Object)this.jcbGrupo.getModel())).getSelectedId());
        this.request.setNovoTexto(this.taComentario.getText());
    }

    private void editarRequest() {
        this.painelTelaBasica.hideRequiredFields();
        if (this.request == null) {
            return;
        }
        this.jtfTituloDoRequest.setText(this.request.getTitulo());
        this.jtfTituloDoRequest.setEnabled(false);
        this.jcbCategoria.setSelectedItem(this.request.getCategoria());
        this.jcbCategoria.setEnabled(false);
        this.jcbGrupo.setSelectedItem(this.request.getGrupo());
        this.jcbGrupo.setEnabled(false);
        this.painelTelaBasica.getTextAreaDescricao().setText(this.request.getTexto());
        this.painelTelaBasica.getPainelBotoes().dadosCarregados(true);
    }

    private void refreshTabelaRequests() {
        try {
            this.jtRequest.loadDados();
        }
        catch (Exception exception) {
            ((SimpleLog)GFPController.getGFPController().getContexto().get((Object)GFPController.LOG)).log("Erro na atualizacao da tabela de mapeamentoVisaVales!");
            ((SimpleLog)GFPController.getGFPController().getContexto().get((Object)GFPController.LOG)).log(exception.getLocalizedMessage());
            ((SimpleLog)GFPController.getGFPController().getContexto().get((Object)GFPController.LOG)).log((Throwable)exception);
        }
    }

    public void loadFromTable(ListSelectionEvent listSelectionEvent) {
        if (this.isVisible()) {
            try {
                this.request = (SupportRequest)this.jtRequest.getPersistentObject(this.jtRequest.getSelectedRow());
            }
            catch (SQLException sQLException) {
                ((SimpleLog)GFPController.getGFPController().getContexto().get((Object)GFPController.LOG)).log("Erro ao carregar Mapeamentos VisaVale!");
                ((SimpleLog)GFPController.getGFPController().getContexto().get((Object)GFPController.LOG)).log(sQLException.getLocalizedMessage());
                ((SimpleLog)GFPController.getGFPController().getContexto().get((Object)GFPController.LOG)).log((Throwable)sQLException);
            }
            this.editarRequest();
        }
    }
}

