/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.xml;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.eclipse.xsd.XSDSchema;
import org.geotools.feature.NameImpl;
import org.geotools.feature.type.SchemaImpl;
import org.geotools.util.logging.Logging;
import org.geotools.xml.SchemaLocationResolver;
import org.geotools.xml.SchemaLocator;
import org.geotools.xml.Schemas;
import org.geotools.xs.XS;
import org.opengis.feature.type.Name;
import org.opengis.feature.type.Schema;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class XSD {
    protected static Logger LOGGER = Logging.getLogger((String)"org.geotools.xml");
    protected XSDSchema schema;
    protected Schema typeSchema;
    protected Schema typeMappingProfile;
    private Set dependencies;

    protected XSD() {
    }

    protected Schema buildTypeSchema() {
        return new SchemaImpl(this.getNamespaceURI());
    }

    protected Schema buildTypeMappingProfile(Schema typeSchema) {
        return typeSchema.profile(Collections.EMPTY_SET);
    }

    protected Name name(QName qName) {
        return new NameImpl(qName.getNamespaceURI(), qName.getLocalPart());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Schema getTypeSchema() {
        if (this.typeSchema == null) {
            XSD xSD = this;
            synchronized (xSD) {
                this.typeSchema = this.buildTypeSchema();
            }
        }
        return this.typeSchema;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Schema getTypeMappingProfile() {
        if (this.typeMappingProfile == null) {
            XSD xSD = this;
            synchronized (xSD) {
                this.typeMappingProfile = this.buildTypeMappingProfile(this.getTypeSchema());
            }
        }
        return this.typeMappingProfile;
    }

    public abstract String getNamespaceURI();

    public abstract String getSchemaLocation();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Set<XSD> getDependencies() {
        if (this.dependencies == null) {
            XSD xSD = this;
            synchronized (xSD) {
                if (this.dependencies == null) {
                    this.dependencies = new LinkedHashSet();
                    this.dependencies.add(XS.getInstance());
                    this.addDependencies(this.dependencies);
                }
            }
        }
        return this.dependencies;
    }

    public List<XSD> getAllDependencies() {
        return this.allDependencies();
    }

    protected List allDependencies() {
        LinkedList<XSD> unpacked = new LinkedList<XSD>();
        Stack<XSD> stack = new Stack<XSD>();
        stack.addAll(this.getDependencies());
        while (!stack.isEmpty()) {
            XSD xsd = (XSD)stack.pop();
            if (this.equals(xsd) || unpacked.contains(xsd)) continue;
            unpacked.addFirst(xsd);
            stack.addAll(xsd.getDependencies());
        }
        return unpacked;
    }

    protected void addDependencies(Set dependencies) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final XSDSchema getSchema() throws IOException {
        if (this.schema == null) {
            XSD xSD = this;
            synchronized (xSD) {
                if (this.schema == null) {
                    LOGGER.fine("building schema for schema: " + this.getNamespaceURI());
                    this.schema = this.buildSchema();
                }
            }
        }
        return this.schema;
    }

    protected XSDSchema buildSchema() throws IOException {
        ArrayList<SchemaLocator> locators = new ArrayList<SchemaLocator>();
        ArrayList<SchemaLocationResolver> resolvers = new ArrayList<SchemaLocationResolver>();
        for (XSD dependency : this.allDependencies()) {
            SchemaLocationResolver resolver;
            SchemaLocator locator = dependency.createSchemaLocator();
            if (locator != null) {
                locators.add(locator);
            }
            if ((resolver = dependency.createSchemaLocationResolver()) == null) continue;
            resolvers.add(resolver);
        }
        SchemaLocationResolver resolver = this.createSchemaLocationResolver();
        if (resolver != null) {
            resolvers.add(resolver);
        }
        return Schemas.parse(this.getSchemaLocation(), locators, resolvers);
    }

    public SchemaLocator createSchemaLocator() {
        return new SchemaLocator(this);
    }

    public SchemaLocationResolver createSchemaLocationResolver() {
        return new SchemaLocationResolver(this);
    }

    public QName qName(String local) {
        return new QName(this.getNamespaceURI(), local);
    }

    public final boolean equals(Object obj) {
        if (obj instanceof XSD) {
            XSD other = (XSD)obj;
            return this.getNamespaceURI().equals(other.getNamespaceURI());
        }
        return false;
    }

    public final int hashCode() {
        return this.getNamespaceURI().hashCode();
    }

    public String toString() {
        return this.getNamespaceURI();
    }
}

