/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.storage.metastore.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geowebcache.storage.StorageException;
import org.geowebcache.storage.metastore.jdbc.JDBCMBWrapper;
import org.geowebcache.storage.metastore.jdbc.JDBCUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class JDBCMBIdCache {
    private static Log log = LogFactory.getLog(JDBCMBIdCache.class);
    public static int MAX_FORMATS = 50;
    public static int MAX_LAYERS = 100;
    public static int MAX_PARAMETERS = 100;
    public static int MAX_GRIDSETS = 50;
    private final Map<String, Long> formatsCache = new HashMap<String, Long>();
    private final Map<String, Long> layersCache = new HashMap<String, Long>();
    private final Map<String, Long> serializedParametersCache;
    private final Map<Map<String, String>, Long> parametersCache = new HashMap<Map<String, String>, Long>();
    private final Map<String, Long> gridSetsCache;
    private final JDBCMBWrapper wrpr;

    protected JDBCMBIdCache(JDBCMBWrapper wrpr) {
        this.serializedParametersCache = new HashMap<String, Long>();
        this.gridSetsCache = new HashMap<String, Long>();
        this.wrpr = wrpr;
    }

    private Long getOrInsert(String key, Map<String, Long> map, int maxSize, String table) throws StorageException {
        if (key.length() > 254) {
            throw new StorageException("Value is too big for table " + table + ":" + key);
        }
        Long res = null;
        try {
            res = this.doSelect(table, key);
            if (res == null) {
                res = this.doInsert(table, key);
            }
        }
        catch (SQLException se) {
            log.error((Object)("Error on Select or Insert: " + se.getMessage()));
        }
        if (res != null) {
            if (map.size() > maxSize) {
                map.clear();
            }
            map.put(key, res);
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Long doInsert(String table, String key) throws SQLException {
        Long res;
        block5: {
            res = null;
            Connection connection = this.wrpr.getConnection();
            PreparedStatement prep = null;
            ResultSet rs = null;
            try {
                String query = "INSERT INTO " + table + " (value) VALUES (?)";
                prep = connection.prepareStatement(query, 1);
                prep.setString(1, key);
                prep.executeUpdate();
                rs = prep.getGeneratedKeys();
                rs.first();
                res = rs.getLong(1);
                JDBCUtils.close(rs);
            }
            catch (SQLException se) {
                log.error((Object)se.getMessage());
                break block5;
            }
            finally {
                JDBCUtils.close(rs);
                JDBCUtils.close(prep);
                JDBCUtils.close(connection);
            }
            JDBCUtils.close(prep);
            JDBCUtils.close(connection);
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Long doSelect(String table, String key) throws SQLException {
        Connection connection;
        ResultSet rs;
        PreparedStatement prep;
        block7: {
            Long l;
            block6: {
                prep = null;
                rs = null;
                connection = this.wrpr.getConnection();
                try {
                    String query = "SELECT ID FROM " + table + " WHERE VALUE LIKE ? LIMIT 1";
                    prep = connection.prepareStatement(query);
                    prep.setString(1, key);
                    rs = prep.executeQuery();
                    if (rs.first()) {
                        l = rs.getLong(1);
                        JDBCUtils.close(rs);
                        break block6;
                    }
                    JDBCUtils.close(rs);
                    break block7;
                }
                catch (SQLException se) {
                    log.error((Object)se.getMessage());
                    return null;
                }
            }
            JDBCUtils.close(prep);
            JDBCUtils.close(connection);
            return l;
        }
        JDBCUtils.close(prep);
        JDBCUtils.close(connection);
        return null;
        finally {
            JDBCUtils.close(rs);
            JDBCUtils.close(prep);
            JDBCUtils.close(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Long getFormatId(String format) throws StorageException {
        Map<String, Long> map = this.formatsCache;
        synchronized (map) {
            Long ret = this.formatsCache.get(format);
            if (ret == null) {
                ret = this.getOrInsert(format, this.formatsCache, MAX_FORMATS, "FORMATS");
            }
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Long getLayerId(String layer) throws StorageException {
        Map<String, Long> map = this.layersCache;
        synchronized (map) {
            Long ret = this.layersCache.get(layer);
            if (ret == null) {
                ret = this.getOrInsert(layer, this.layersCache, MAX_LAYERS, "LAYERS");
            }
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long getParametersId(Map<String, String> parameteres) throws StorageException {
        if (parameteres == null || parameteres.size() == 0) {
            return -1L;
        }
        Map<Map<String, String>, Long> map = this.parametersCache;
        synchronized (map) {
            Long ret = this.parametersCache.get(parameteres);
            if (ret == null) {
                String serializedParameters = this.marshall(parameteres);
                ret = this.getOrInsert(serializedParameters, this.serializedParametersCache, MAX_PARAMETERS, "PARAMETERS");
                this.parametersCache.put(new HashMap<String, String>(parameteres), ret);
            }
            return ret;
        }
    }

    private String marshall(Map<String, String> parameters) {
        StringBuilder sb = new StringBuilder();
        TreeMap<String, String> sorted = new TreeMap<String, String>(parameters);
        for (Map.Entry e : sorted.entrySet()) {
            sb.append('&').append((String)e.getKey()).append('=').append((String)e.getValue());
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Long getGridSetsId(String gridSetId) throws StorageException {
        Map<String, Long> map = this.gridSetsCache;
        synchronized (map) {
            Long ret = this.gridSetsCache.get(gridSetId);
            if (ret == null) {
                ret = this.getOrInsert(gridSetId, this.gridSetsCache, MAX_GRIDSETS, "GRIDSETS");
            }
            return ret;
        }
    }
}

