/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.storage;

import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geowebcache.io.Resource;
import org.geowebcache.storage.BlobStore;
import org.geowebcache.storage.BlobStoreListener;
import org.geowebcache.storage.DiscontinuousTileRange;
import org.geowebcache.storage.MetaStore;
import org.geowebcache.storage.StorageException;
import org.geowebcache.storage.TileObject;
import org.geowebcache.storage.TileRange;

public class StorageBroker {
    private static Log log = LogFactory.getLog(StorageBroker.class);
    private BlobStore blobStore;
    private MetaStore metaStore;
    private boolean metaStoreEnabled = true;
    private boolean verifyFileSize = false;
    private boolean isReady = false;

    public StorageBroker(MetaStore metaStore, BlobStore blobStore) {
        this.metaStore = metaStore;
        this.blobStore = blobStore;
        this.metaStoreEnabled = metaStore != null ? metaStore.enabled() : false;
    }

    public void addBlobStoreListener(BlobStoreListener listener) {
        this.blobStore.addListener(listener);
    }

    public boolean removeBlobStoreListener(BlobStoreListener listener) {
        return this.blobStore.removeListener(listener);
    }

    public void setVerifyFileSize(boolean verifyFileSize) {
        this.verifyFileSize = verifyFileSize;
    }

    public boolean delete(String layerName) throws StorageException {
        boolean ret = true;
        if (this.metaStoreEnabled) {
            ret = this.metaStore.delete(layerName);
        }
        ret = ret && this.blobStore.delete(layerName);
        return ret;
    }

    public boolean delete(TileRange trObj) throws StorageException {
        boolean deleted;
        if (this.metaStoreEnabled) {
            deleted = this.metaStore.delete(this.blobStore, trObj);
        } else {
            if (trObj instanceof DiscontinuousTileRange) {
                throw new StorageException("DiscontinuousTileRange currently requries a metastore.");
            }
            deleted = this.blobStore.delete(trObj);
        }
        return deleted;
    }

    public boolean expire(TileRange trObj) throws StorageException {
        boolean expired = false;
        if (this.metaStoreEnabled) {
            expired = this.metaStore.expire(trObj);
        }
        return expired;
    }

    public boolean get(TileObject tileObj) throws StorageException {
        if (!this.metaStoreEnabled) {
            boolean found = this.getBlobOnly(tileObj);
            return found;
        }
        if (!this.metaStore.get(tileObj)) {
            return false;
        }
        if (tileObj.getId() == -1L) {
            throw new StorageException("metaStore.get() returned true, but did not set an id on the object");
        }
        if (tileObj.blob_size > 0) {
            Resource blob = this.blobStore.get(tileObj);
            if (blob == null) {
                throw new StorageException("Blob for " + Arrays.toString(tileObj.xyz) + " was expected to have size " + tileObj.blob_size + " but was null.");
            }
            if (this.verifyFileSize && blob.getSize() != (long)tileObj.blob_size) {
                throw new StorageException("Blob was expected to have size " + tileObj.blob_size + " but was " + blob.getSize());
            }
            tileObj.blob = blob;
            return true;
        }
        return false;
    }

    private boolean getBlobOnly(TileObject tileObj) throws StorageException {
        if (tileObj.getParameters() == null || tileObj.getParameters().size() == 0) {
            Resource blob = this.blobStore.get(tileObj);
            if (blob == null) {
                return false;
            }
            tileObj.blob = blob;
            return true;
        }
        log.error((Object)"Cannot fetch tile with parameters if metastore is disabled!");
        return false;
    }

    public boolean put(TileObject tileObj) throws StorageException {
        if (!this.metaStoreEnabled) {
            boolean stored = this.putBlobOnly(tileObj);
            return stored;
        }
        try {
            this.metaStore.put(tileObj);
            this.blobStore.put(tileObj);
            this.metaStore.unlock(tileObj);
            return true;
        }
        catch (StorageException se) {
            log.error((Object)se.getMessage());
            return false;
        }
    }

    private boolean putBlobOnly(TileObject tileObj) {
        if (tileObj.getParameters() == null || tileObj.getParameters().size() == 0) {
            try {
                this.blobStore.put(tileObj);
            }
            catch (StorageException se) {
                log.error((Object)("Unable to save tile: " + se.getMessage()));
                return false;
            }
            return true;
        }
        log.debug((Object)"Cannot save tile with parameters if metastore is disabled!");
        return false;
    }

    public void destroy() {
        log.info((Object)"Destroying StorageBroker");
    }
}

