/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.storage;

import java.util.Map;
import org.geowebcache.mime.MimeType;
import org.geowebcache.storage.RasterMask;
import org.geowebcache.storage.TileRange;
import org.geowebcache.util.ServletUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiscontinuousTileRange
extends TileRange {
    private final RasterMask rasterMask;

    public DiscontinuousTileRange(String layerName, String gridSetId, int zoomStart, int zoomStop, RasterMask rasterMask, MimeType mimeType, String parameters) {
        this(layerName, gridSetId, zoomStart, zoomStop, rasterMask, mimeType, ServletUtils.queryStringToMap(parameters));
    }

    public DiscontinuousTileRange(String layerName, String gridSetId, int zoomStart, int zoomStop, RasterMask rasterMask, MimeType mimeType, Map<String, String> parameters) {
        super(layerName, gridSetId, zoomStart, zoomStop, rasterMask.getGridCoverages(), mimeType, parameters);
        this.rasterMask = rasterMask;
    }

    @Override
    public boolean contains(long x, long y, int z) {
        if (super.contains(x, y, z)) {
            return this.rasterMask.lookup(x, y, z);
        }
        return false;
    }

    @Override
    public boolean contains(long[] idx) {
        return this.contains(idx[0], idx[1], (int)idx[2]);
    }
}

