/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.seed;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.conveyor.ConveyorTile;
import org.geowebcache.filter.request.RequestFilter;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.layer.wms.WMSLayer;
import org.geowebcache.seed.GWCTask;
import org.geowebcache.storage.StorageBroker;
import org.geowebcache.storage.TileRange;
import org.geowebcache.storage.TileRangeIterator;

class SeedTask
extends GWCTask {
    private static Log log = LogFactory.getLog(SeedTask.class);
    private final TileRangeIterator trIter;
    private final TileLayer tl;
    private boolean reseed;
    private boolean doFilterUpdate;
    private StorageBroker storageBroker;
    private int tileFailureRetryCount;
    private long tileFailureRetryWaitTime;
    private long totalFailuresBeforeAborting;
    private AtomicLong sharedFailureCounter;

    public SeedTask(StorageBroker sb, TileRangeIterator trIter, TileLayer tl, boolean reseed, boolean doFilterUpdate) {
        this.storageBroker = sb;
        this.trIter = trIter;
        this.tl = tl;
        this.reseed = reseed;
        this.doFilterUpdate = doFilterUpdate;
        this.tileFailureRetryCount = 0;
        this.tileFailureRetryWaitTime = 100L;
        this.totalFailuresBeforeAborting = 10000L;
        this.sharedFailureCounter = new AtomicLong();
        this.parsedType = reseed ? GWCTask.TYPE.RESEED : GWCTask.TYPE.SEED;
        this.layerName = tl.getName();
        this.state = GWCTask.STATE.READY;
    }

    protected void doActionInternal() throws GeoWebCacheException, InterruptedException {
        this.state = GWCTask.STATE.RUNNING;
        Thread.currentThread().setPriority(3);
        this.checkInterrupted();
        long START_TIME = System.currentTimeMillis();
        String layerName = this.tl.getName();
        log.info((Object)(Thread.currentThread().getName() + " begins seeding layer : " + layerName));
        TileRange tr = this.trIter.getTileRange();
        this.checkInterrupted();
        this.tilesTotal = this.tileCount(tr.rangeBounds, tr.zoomStart, tr.zoomStop);
        int metaTilingFactorX = this.tl.getMetaTilingFactors()[0];
        int metaTilingFactorY = this.tl.getMetaTilingFactors()[1];
        boolean tryCache = !this.reseed;
        this.checkInterrupted();
        long[] gridLoc = this.trIter.nextMetaGridLocation(new long[3]);
        long seedCalls = 0L;
        while (gridLoc != null && !this.terminate) {
            this.checkInterrupted();
            Map<String, String> fullParameters = tr.parameters;
            ConveyorTile tile = new ConveyorTile(this.storageBroker, layerName, tr.gridSetId, gridLoc, tr.mimeType, fullParameters, null, null);
            for (int fetchAttempt = 0; fetchAttempt <= this.tileFailureRetryCount; ++fetchAttempt) {
                try {
                    this.checkInterrupted();
                    this.tl.seedTile(tile, tryCache);
                    break;
                }
                catch (Exception e) {
                    if (this.tileFailureRetryCount == 0) {
                        if (e instanceof GeoWebCacheException) {
                            throw (GeoWebCacheException)e;
                        }
                        throw new GeoWebCacheException(e);
                    }
                    long sharedFailureCount = this.sharedFailureCounter.incrementAndGet();
                    if (sharedFailureCount >= this.totalFailuresBeforeAborting) {
                        log.info((Object)("Aborting seed thread " + Thread.currentThread().getName() + ". Error count reached configured maximum of " + this.totalFailuresBeforeAborting));
                        this.state = GWCTask.STATE.DEAD;
                        return;
                    }
                    String logMsg = "Seed failed at " + tile.toString() + " after " + (fetchAttempt + 1) + " of " + (this.tileFailureRetryCount + 1) + " attempts.";
                    if (fetchAttempt < this.tileFailureRetryCount) {
                        log.debug((Object)logMsg);
                        if (this.tileFailureRetryWaitTime <= 0L) continue;
                        log.trace((Object)("Waiting " + this.tileFailureRetryWaitTime + " before trying again"));
                        Thread.sleep(this.tileFailureRetryCount);
                        continue;
                    }
                    log.info((Object)(logMsg + " Skipping and continuing with next tile. Original error: " + e.getMessage()));
                    continue;
                }
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)(Thread.currentThread().getName() + " seeded " + Arrays.toString(gridLoc)));
            }
            long tilesCompletedByThisThread = seedCalls * (long)metaTilingFactorX * (long)metaTilingFactorY;
            this.updateStatusInfo(this.tl, tilesCompletedByThisThread, START_TIME);
            this.checkInterrupted();
            ++seedCalls;
            gridLoc = this.trIter.nextMetaGridLocation(gridLoc);
        }
        if (this.terminate) {
            log.info((Object)("Job on " + Thread.currentThread().getName() + " was terminated after " + this.tilesDone + " tiles"));
        } else {
            log.info((Object)(Thread.currentThread().getName() + " completed (re)seeding layer " + layerName + " after " + this.tilesDone + " tiles and " + this.timeSpent + " seconds."));
        }
        this.checkInterrupted();
        if (this.threadOffset == 0 && this.doFilterUpdate) {
            this.runFilterUpdates(tr.gridSetId);
        }
        this.state = GWCTask.STATE.DONE;
    }

    private long tileCount(long[][] coveredGridLevels, int startZoom, int stopZoom) {
        long count = 0L;
        for (int i = startZoom; i <= stopZoom; ++i) {
            long[] gridBounds = coveredGridLevels[i];
            long thisLevel = (1L + gridBounds[2] - gridBounds[0]) * (1L + gridBounds[3] - gridBounds[1]);
            if (thisLevel > 0x1FFFFFFFFFFFFFFFL && i != stopZoom) {
                return -1L;
            }
            count += thisLevel;
        }
        return count;
    }

    private void updateStatusInfo(TileLayer layer, long tilesCount, long start_time) {
        this.tilesDone = tilesCount;
        this.timeSpent = (int)(System.currentTimeMillis() - start_time) / 1000;
        int threadCount = this.sharedThreadCount.get();
        long timeTotal = Math.round((double)this.timeSpent * ((double)this.tilesTotal / (double)threadCount / (double)tilesCount));
        this.timeRemaining = (int)(timeTotal - this.timeSpent);
    }

    private void runFilterUpdates(String gridSetId) {
        List<RequestFilter> reqFilters = this.tl.getRequestFilters();
        if (reqFilters != null && !reqFilters.isEmpty()) {
            for (RequestFilter reqFilter : reqFilters) {
                if (reqFilter.update(this.tl, gridSetId)) {
                    log.info((Object)("Updated request filter " + reqFilter.getName()));
                    continue;
                }
                log.debug((Object)("Request filter " + reqFilter.getName() + " returned false on update."));
            }
        }
    }

    public void setFailurePolicy(int tileFailureRetryCount, long tileFailureRetryWaitTime, long totalFailuresBeforeAborting, AtomicLong sharedFailureCounter) {
        this.tileFailureRetryCount = tileFailureRetryCount;
        this.tileFailureRetryWaitTime = tileFailureRetryWaitTime;
        this.totalFailuresBeforeAborting = totalFailuresBeforeAborting;
        this.sharedFailureCounter = sharedFailureCounter;
    }

    protected void dispose() {
        if (this.tl instanceof WMSLayer) {
            ((WMSLayer)this.tl).cleanUpThreadLocals();
        }
    }
}

