/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.layer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.conveyor.ConveyorTile;
import org.geowebcache.filter.parameters.ParameterFilter;
import org.geowebcache.filter.request.RequestFilter;
import org.geowebcache.filter.request.RequestFilterException;
import org.geowebcache.grid.BoundingBox;
import org.geowebcache.grid.GridMismatchException;
import org.geowebcache.grid.GridSetBroker;
import org.geowebcache.grid.GridSubset;
import org.geowebcache.grid.GridSubsetFactory;
import org.geowebcache.grid.OutsideCoverageException;
import org.geowebcache.grid.SRS;
import org.geowebcache.grid.XMLGridSubset;
import org.geowebcache.grid.XMLOldGrid;
import org.geowebcache.io.ByteArrayResource;
import org.geowebcache.io.Resource;
import org.geowebcache.layer.ExpirationRule;
import org.geowebcache.layer.LayerListenerList;
import org.geowebcache.layer.MetaTile;
import org.geowebcache.layer.TileLayerListener;
import org.geowebcache.layer.meta.LayerMetaInformation;
import org.geowebcache.layer.updatesource.UpdateSourceDefinition;
import org.geowebcache.mime.FormatModifier;
import org.geowebcache.mime.MimeException;
import org.geowebcache.mime.MimeType;
import org.geowebcache.storage.StorageException;
import org.geowebcache.storage.TileObject;
import org.geowebcache.util.ServletUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TileLayer {
    private static Log log = LogFactory.getLog(TileLayer.class);
    protected static final ThreadLocal<ByteArrayResource> WMS_BUFFER = new ThreadLocal();
    protected static final ThreadLocal<ByteArrayResource> WMS_BUFFER2 = new ThreadLocal();
    private static final int[] DEFAULT_METATILING_FACTORS = new int[]{1, 1};
    protected String name;
    protected LayerMetaInformation metaInformation;
    protected List<String> mimeFormats;
    protected List<FormatModifier> formatModifiers;
    protected List<XMLGridSubset> gridSubsets;
    protected List<ParameterFilter> parameterFilters;
    protected Hashtable<SRS, XMLOldGrid> grids;
    protected List<RequestFilter> requestFilters;
    protected List<UpdateSourceDefinition> updateSources;
    protected Boolean useETags;
    protected ArrayList<ExpirationRule> expireCacheList;
    protected String expireClients;
    protected ArrayList<ExpirationRule> expireClientsList;
    protected String expireCache;
    protected Boolean cacheBypassAllowed;
    protected Boolean queryable;
    protected int[] metaWidthHeight;
    protected transient boolean saveExpirationHeaders;
    protected transient List<MimeType> formats;
    protected transient Hashtable<String, GridSubset> subSets;
    private transient LayerListenerList listeners;
    protected Integer backendTimeout;
    protected String wmsStyles = null;
    private transient Map<String, String> defaultParams;

    public void addLayerListener(TileLayerListener listener) {
        if (this.listeners == null) {
            this.listeners = new LayerListenerList();
        }
        this.listeners.addListener(listener);
    }

    public boolean removeLayerListener(TileLayerListener listener) {
        return this.listeners == null ? false : this.listeners.removeListener(listener);
    }

    protected final void sendTileRequestedEvent(ConveyorTile tile) {
        if (this.listeners != null) {
            this.listeners.sendTileRequested(this, tile);
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public abstract boolean isEnabled();

    public abstract void setEnabled(boolean var1);

    public LayerMetaInformation getMetaInformation() {
        return this.metaInformation;
    }

    public void setMetaInformation(LayerMetaInformation metaInfo) {
        this.metaInformation = metaInfo;
    }

    public void addGridSet(String gridSetId, GridSubset gridSubset) {
        this.subSets.put(gridSetId, gridSubset);
    }

    public Hashtable<String, GridSubset> getGridSubsets() {
        return this.subSets;
    }

    public void addFormat(String format) throws MimeException {
        MimeType mime = MimeType.createFromFormat(format);
        this.formats.add(mime);
    }

    public final boolean initialize(GridSetBroker gridSetBroker) {
        if (this.expireCacheList == null) {
            this.expireCacheList = new ArrayList(1);
            if (this.expireCache == null) {
                this.expireCacheList.add(new ExpirationRule(0, -2));
            } else {
                int expireCacheInt = Integer.parseInt(this.expireCache);
                if (expireCacheInt == -4) {
                    this.saveExpirationHeaders = true;
                }
                this.expireCacheList.add(new ExpirationRule(0, expireCacheInt));
            }
        }
        if (this.expireClientsList == null) {
            this.expireClientsList = new ArrayList(1);
            if (this.expireClients == null) {
                this.expireClientsList.add(new ExpirationRule(0, 7200));
            } else {
                int expireClientsInt = Integer.parseInt(this.expireClients);
                if (expireClientsInt == -4) {
                    this.saveExpirationHeaders = true;
                } else if (expireClientsInt == -2) {
                    expireClientsInt = 31536000;
                }
                this.expireClientsList.add(new ExpirationRule(0, expireClientsInt));
            }
        }
        try {
            this.formats = new ArrayList<MimeType>();
            if (this.mimeFormats != null) {
                for (String fmt : this.mimeFormats) {
                    this.formats.add(MimeType.createFromFormat(fmt));
                }
            }
            if (this.formats.size() == 0) {
                this.formats.add(0, MimeType.createFromFormat("image/png"));
                this.formats.add(1, MimeType.createFromFormat("image/jpeg"));
            }
        }
        catch (GeoWebCacheException gwce) {
            log.error((Object)gwce.getMessage());
            gwce.printStackTrace();
        }
        if (this.subSets == null) {
            this.subSets = new Hashtable();
        }
        if (this.gridSubsets != null) {
            for (XMLGridSubset xmlGridSubset : this.gridSubsets) {
                GridSubset gridSubset = xmlGridSubset.getGridSubSet(gridSetBroker);
                if (gridSubset == null) {
                    log.error((Object)(xmlGridSubset.getGridSetName() + " is not known by the GridSetBroker, skipping for layer " + this.name));
                    continue;
                }
                this.subSets.put(gridSubset.getName(), gridSubset);
            }
            this.gridSubsets = null;
        }
        if (this.grids != null && !this.grids.isEmpty()) {
            Iterator<XMLOldGrid> iter = this.grids.values().iterator();
            while (iter.hasNext()) {
                GridSubset converted = iter.next().convertToGridSubset(gridSetBroker);
                this.subSets.put(converted.getSRS().toString(), converted);
            }
            this.grids = null;
        }
        if (this.subSets.size() == 0) {
            this.subSets.put(gridSetBroker.WORLD_EPSG4326.getName(), GridSubsetFactory.createGridSubSet(gridSetBroker.WORLD_EPSG4326));
            this.subSets.put(gridSetBroker.WORLD_EPSG3857.getName(), GridSubsetFactory.createGridSubSet(gridSetBroker.WORLD_EPSG3857));
        }
        return this.initializeInternal(gridSetBroker);
    }

    protected abstract boolean initializeInternal(GridSetBroker var1);

    public GridSubset getGridSubsetForSRS(SRS srs) {
        for (GridSubset gridSubset : this.subSets.values()) {
            if (!gridSubset.getSRS().equals(srs)) continue;
            return gridSubset;
        }
        return null;
    }

    public List<UpdateSourceDefinition> getUpdateSources() {
        List<Object> sources = this.updateSources == null ? Collections.emptyList() : this.updateSources;
        return sources;
    }

    public boolean supportsFormat(String strFormat) throws GeoWebCacheException {
        if (strFormat == null) {
            return true;
        }
        for (MimeType mime : this.formats) {
            if (!strFormat.equalsIgnoreCase(mime.getFormat())) continue;
            return true;
        }
        throw new GeoWebCacheException("Format " + strFormat + " is not supported by " + this.getName());
    }

    public boolean useETags() {
        return this.useETags != null && this.useETags != false;
    }

    public abstract ConveyorTile getTile(ConveyorTile var1) throws GeoWebCacheException, IOException, OutsideCoverageException;

    public Resource getFeatureInfo(ConveyorTile convTile, BoundingBox bbox, int height, int width, int x, int y) throws GeoWebCacheException {
        throw new GeoWebCacheException("GetFeatureInfo is not supported by this layer (" + this.getName() + ")");
    }

    public abstract ConveyorTile getNoncachedTile(ConveyorTile var1) throws GeoWebCacheException;

    public abstract void seedTile(ConveyorTile var1, boolean var2) throws GeoWebCacheException, IOException;

    public abstract ConveyorTile doNonMetatilingRequest(ConveyorTile var1) throws GeoWebCacheException;

    public double[] getResolutions(String gridSetId) throws GeoWebCacheException {
        return this.subSets.get(gridSetId).getResolutions();
    }

    public FormatModifier getFormatModifier(MimeType responseFormat) {
        if (this.formatModifiers == null || this.formatModifiers.size() == 0) {
            return null;
        }
        for (FormatModifier mod : this.formatModifiers) {
            if (mod.getResponseFormat() != responseFormat) continue;
            return mod;
        }
        return null;
    }

    public List<FormatModifier> getFormatModifiers() {
        return this.formatModifiers;
    }

    public void setFormatModifiers(List<FormatModifier> formatModifiers) {
        this.formatModifiers = formatModifiers;
    }

    public String getStyles() {
        return this.wmsStyles;
    }

    public int[] getMetaTilingFactors() {
        return this.metaWidthHeight == null ? DEFAULT_METATILING_FACTORS : this.metaWidthHeight;
    }

    public Boolean isCacheBypassAllowed() {
        return this.cacheBypassAllowed;
    }

    public void setCacheBypassAllowed(boolean allowed) {
        this.cacheBypassAllowed = allowed;
    }

    public boolean isQueryable() {
        return this.queryable != null && this.queryable != false;
    }

    public Integer getBackendTimeout() {
        return this.backendTimeout;
    }

    public void setBackendTimeout(int seconds) {
        this.backendTimeout = seconds;
    }

    public List<MimeType> getMimeTypes() {
        return this.formats;
    }

    public MimeType getDefaultMimeType() {
        return this.formats.get(0);
    }

    public long[] indexFromBounds(String gridSetId, BoundingBox tileBounds) throws GridMismatchException {
        return this.subSets.get(gridSetId).closestIndex(tileBounds);
    }

    public BoundingBox boundsFromIndex(String gridSetId, long[] gridLoc) {
        return this.subSets.get(gridSetId).boundsFromIndex(gridLoc);
    }

    public abstract void acquireLayerLock();

    public abstract void releaseLayerLock();

    public void setExpirationHeader(HttpServletResponse response, int zoomLevel) {
        int expireValue = this.getExpireClients(zoomLevel);
        if (expireValue == 0) {
            return;
        }
        if (expireValue > 0) {
            response.setHeader("Cache-Control", "max-age=" + expireValue + ", must-revalidate");
            response.setHeader("Expires", ServletUtils.makeExpiresHeader(expireValue));
        } else if (expireValue == -2) {
            long oneYear = 31536000L;
            response.setHeader("Cache-Control", "max-age=" + oneYear);
            response.setHeader("Expires", ServletUtils.makeExpiresHeader((int)oneYear));
        } else if (expireValue == -1) {
            response.setHeader("Cache-Control", "no-cache");
        } else if (expireValue == -4) {
            int seconds = 3600;
            response.setHeader("geowebcache-error", "No real CacheControl information available");
            response.setHeader("Cache-Control", "max-age=" + seconds);
            response.setHeader("Expires", ServletUtils.makeExpiresHeader(seconds));
        }
    }

    public int getExpireClients(int zoomLevel) {
        return this.getExpiration(this.expireClientsList, zoomLevel);
    }

    public int getExpireCache(int zoomLevel) {
        return this.getExpiration(this.expireCacheList, zoomLevel);
    }

    private int getExpiration(ArrayList<ExpirationRule> list, int zoomLevel) {
        int retVal;
        int length = list.size();
        if (length == 1) {
            retVal = list.get(0).getExpiration();
        } else {
            int i;
            for (i = 1; i < length && list.get(i).getMinZoom() <= zoomLevel; ++i) {
            }
            retVal = list.get(i - 1).getExpiration();
        }
        if (retVal == -4) {
            return 7200;
        }
        return retVal;
    }

    public void mergeWith(TileLayer otherLayer) throws GeoWebCacheException {
        Iterator<Object> iter;
        log.warn((Object)("Merging grids, formats and filters of " + this.name));
        if (otherLayer.mimeFormats != null) {
            for (String string : otherLayer.mimeFormats) {
                if (this.supportsFormat(string)) continue;
                this.addFormat(string);
            }
        }
        if (otherLayer.formatModifiers != null) {
            if (this.formatModifiers == null) {
                this.formatModifiers = otherLayer.formatModifiers;
            } else {
                for (FormatModifier formatModifier : otherLayer.formatModifiers) {
                    this.formatModifiers.add(formatModifier);
                }
            }
        }
        if (otherLayer.subSets != null && otherLayer.subSets.size() > 0) {
            for (Map.Entry entry : otherLayer.subSets.entrySet()) {
                this.subSets.put((String)entry.getKey(), (GridSubset)entry.getValue());
            }
        }
        if (otherLayer.requestFilters != null) {
            if (this.requestFilters == null) {
                this.requestFilters = new ArrayList<RequestFilter>();
            }
            iter = otherLayer.requestFilters.iterator();
            while (iter.hasNext()) {
                this.requestFilters.add((RequestFilter)iter.next());
            }
        }
        if (otherLayer.parameterFilters != null) {
            if (this.parameterFilters != null) {
                iter = otherLayer.parameterFilters.iterator();
                while (iter.hasNext()) {
                    this.parameterFilters.add((ParameterFilter)iter.next());
                }
            } else {
                this.parameterFilters = otherLayer.parameterFilters;
            }
        }
    }

    public void applyRequestFilters(ConveyorTile convTile) throws RequestFilterException {
        if (this.requestFilters == null) {
            return;
        }
        for (RequestFilter filter : this.requestFilters) {
            filter.apply(convTile);
        }
    }

    public List<ParameterFilter> getParameterFilters() {
        return this.parameterFilters;
    }

    public synchronized Map<String, String> getDefaultParameterFilters() {
        if (this.defaultParams == null) {
            if (this.parameterFilters == null || this.parameterFilters.size() == 0) {
                this.defaultParams = Collections.emptyMap();
            } else {
                HashMap<String, String> defaults = new HashMap<String, String>();
                for (ParameterFilter parameterFilter : this.parameterFilters) {
                    String key = parameterFilter.getKey().toUpperCase();
                    String defaultValue = TileLayer.decodeDimensionValue(parameterFilter.getDefaultValue());
                    defaults.put(key, defaultValue);
                }
                this.defaultParams = Collections.unmodifiableMap(defaults);
            }
        }
        return this.defaultParams;
    }

    public Map<String, String> getModifiableParameters(Map<String, ?> map, String encoding) throws GeoWebCacheException {
        if (this.parameterFilters == null) {
            return Collections.emptyMap();
        }
        HashMap<String, String> fullParameters = new HashMap<String, String>();
        String[] keys = new String[this.parameterFilters.size()];
        for (int i = 0; i < this.parameterFilters.size(); ++i) {
            ParameterFilter parameterFilter = this.parameterFilters.get(i);
            keys[i] = parameterFilter.getKey();
        }
        Map<String, String> requestValues = ServletUtils.selectedStringsFromMap(map, encoding, keys);
        Map<String, String> defaultValues = this.getDefaultParameterFilters();
        for (ParameterFilter parameterFilter : this.parameterFilters) {
            String key = parameterFilter.getKey().toUpperCase();
            String value = requestValues.get(key);
            value = TileLayer.decodeDimensionValue(value);
            String defaultValue = defaultValues.get(key);
            if (value == null || value.length() == 0 || defaultValue != null && defaultValue.equals(value)) {
                fullParameters.put(key, defaultValue);
                continue;
            }
            String appliedValue = parameterFilter.apply(value);
            fullParameters.put(key, appliedValue);
        }
        if (((Object)defaultValues).equals(fullParameters)) {
            return Collections.emptyMap();
        }
        return fullParameters;
    }

    protected static String decodeDimensionValue(String value) {
        if (value != null && value.startsWith("_")) {
            if (value.equals("_null")) {
                return null;
            }
            if (value.equals("_empty")) {
                return "";
            }
            return value;
        }
        return value;
    }

    public static String encodeDimensionValue(String value) {
        if (value == null) {
            return "_null";
        }
        if (value.length() == 0) {
            return "_empty";
        }
        return value;
    }

    public List<RequestFilter> getRequestFilters() {
        return this.requestFilters;
    }

    public GridSubset getGridSubset(String gridSetId) {
        return this.subSets.get(gridSetId);
    }

    protected ByteArrayResource getImageBuffer(ThreadLocal<ByteArrayResource> tl) {
        ByteArrayResource buffer = tl.get();
        if (buffer == null) {
            buffer = new ByteArrayResource(16384);
            tl.set(buffer);
        }
        buffer.truncate();
        return buffer;
    }

    protected void saveTiles(MetaTile metaTile, ConveyorTile tileProto) throws GeoWebCacheException {
        long[][] gridPositions = metaTile.getTilesGridPositions();
        long[] gridLoc = tileProto.getTileIndex();
        GridSubset gridSubset = this.getGridSubset(tileProto.getGridSetId());
        int zoomLevel = (int)gridLoc[2];
        boolean store = this.getExpireCache(zoomLevel) != -1;
        for (int i = 0; i < gridPositions.length; ++i) {
            boolean encode;
            ByteArrayResource resource;
            long[] gridPos = gridPositions[i];
            if (Arrays.equals(gridLoc, gridPos)) {
                resource = this.getImageBuffer(WMS_BUFFER2);
                tileProto.setBlob(resource);
                encode = true;
            } else {
                resource = this.getImageBuffer(WMS_BUFFER);
                encode = store;
            }
            if (!encode || !gridSubset.covers(gridPos)) continue;
            try {
                boolean completed = metaTile.writeTileToStream(i, resource);
                if (!completed) {
                    log.error((Object)"metaTile.writeTileToStream returned false, no tiles saved");
                }
                if (!store) continue;
                long[] idx = new long[]{gridPos[0], gridPos[1], gridPos[2]};
                TileObject tile = TileObject.createCompleteTileObject(this.getName(), idx, tileProto.getGridSetId(), tileProto.getMimeType().getFormat(), tileProto.getParameters(), resource);
                try {
                    tileProto.getStorageBroker().put(tile);
                    continue;
                }
                catch (StorageException e) {
                    throw new GeoWebCacheException(e);
                }
            }
            catch (IOException ioe) {
                log.error((Object)("Unable to write image tile to ByteArrayOutputStream: " + ioe.getMessage()));
                ioe.printStackTrace();
            }
        }
    }
}

