/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.grid;

import java.util.Hashtable;
import org.geowebcache.GeoWebCacheException;

public class SRS
implements Comparable {
    private final int number;
    private static final SRS EPSG4326 = new SRS(4326);
    private static final SRS EPSG3857 = new SRS(3857);
    private static final SRS EPSG900913 = new SRS(900913);
    private static Hashtable<Integer, SRS> list = new Hashtable();

    private SRS(int epsgNumber) {
        this.number = epsgNumber;
    }

    public static SRS getSRS(int epsgNumber) {
        SRS ret = list.get(epsgNumber);
        if (ret == null) {
            if (epsgNumber == 4326) {
                list.put(4326, EPSG4326);
            } else if (epsgNumber == 900913 || epsgNumber == 3857) {
                list.put(3857, EPSG3857);
            }
            ret = new SRS(epsgNumber);
            list.put(epsgNumber, ret);
        }
        return ret;
    }

    public static SRS getSRS(String epsgStr) throws GeoWebCacheException {
        String crsAuthPrefix = "EPSG:";
        if (epsgStr.substring(0, 5).equalsIgnoreCase("EPSG:")) {
            int epsgNumber = Integer.parseInt(epsgStr.substring(5, epsgStr.length()));
            return SRS.getSRS(epsgNumber);
        }
        throw new GeoWebCacheException("Can't parse " + epsgStr + " as SRS string.");
    }

    public boolean equals(Object obj) {
        if (obj instanceof SRS) {
            SRS other = (SRS)obj;
            if (other.number == this.number || this.number == 3857 && other.number == 900913 || this.number == 900913 && other.number == 3857) {
                return true;
            }
        }
        return false;
    }

    public int getNumber() {
        return this.number;
    }

    public int hashCode() {
        return this.number;
    }

    public String toString() {
        return "EPSG:" + Integer.toString(this.number);
    }

    public String filePath() {
        return "EPSG_" + Integer.toString(this.number);
    }

    public static SRS getEPSG4326() {
        return EPSG4326;
    }

    public static SRS getEPSG3857() {
        return EPSG3857;
    }

    public static SRS getEPSG900913() {
        return EPSG900913;
    }

    public int compareTo(Object o) {
        SRS other = (SRS)o;
        if (other.number == this.number) {
            return 0;
        }
        if (other.number > this.number) {
            return -1;
        }
        return 1;
    }
}

