/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.grid;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geowebcache.grid.BoundingBox;
import org.geowebcache.grid.GridCoverage;
import org.geowebcache.grid.GridSet;
import org.geowebcache.grid.GridSubset;

public class GridSubsetFactory {
    private static Log log = LogFactory.getLog(GridSubsetFactory.class);

    public static GridSubset createGridSubSet(GridSet gridSet) {
        GridSubset ret = new GridSubset(gridSet);
        ret.firstLevel = 0;
        ret.gridCoverageLevels = new GridCoverage[gridSet.gridLevels.length];
        for (int i = 0; i < ret.gridCoverageLevels.length; ++i) {
            GridCoverage gridCov;
            long[] tmp = new long[]{0L, 0L, gridSet.gridLevels[i].extent[0] - 1L, gridSet.gridLevels[i].extent[1] - 1L, i};
            ret.gridCoverageLevels[i] = gridCov = new GridCoverage(tmp);
        }
        ret.fullGridSetCoverage = true;
        return ret;
    }

    public static GridSubset createGridSubSet(GridSet gridSet, BoundingBox extent, Integer zoomStart, Integer zoomStop) {
        if (gridSet == null) {
            log.error((Object)"Passed GridSet was null!");
        }
        GridSubset ret = new GridSubset(gridSet);
        ret.firstLevel = zoomStart != null ? zoomStart : 0;
        ret.gridCoverageLevels = zoomStop != null ? new GridCoverage[zoomStop - ret.firstLevel + 1] : new GridCoverage[gridSet.gridLevels.length - ret.firstLevel];
        ret.originalExtent = extent;
        BoundingBox gridSetBounds = gridSet.getBounds();
        if (extent == null || extent.contains(gridSetBounds)) {
            ret.fullGridSetCoverage = true;
        }
        for (int i = 0; i < ret.gridCoverageLevels.length; ++i) {
            GridCoverage gridCov;
            if (extent != null) {
                gridCov = new GridCoverage(gridSet.closestRectangle(i + ret.firstLevel, extent));
            } else {
                long[] gridExtent = gridSet.gridLevels[i + ret.firstLevel].extent;
                long[] fullCoverage = new long[]{0L, 0L, gridExtent[0] - 1L, gridExtent[1] - 1L, i + ret.firstLevel};
                gridCov = new GridCoverage(fullCoverage);
            }
            ret.gridCoverageLevels[i] = gridCov;
        }
        return ret;
    }
}

