/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.config;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.xml.DomReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.config.Configuration;
import org.geowebcache.config.ConfigurationException;
import org.geowebcache.config.GeoWebCacheConfiguration;
import org.geowebcache.config.XMLConfigurationProvider;
import org.geowebcache.config.meta.ServiceInformation;
import org.geowebcache.filter.parameters.FloatParameterFilter;
import org.geowebcache.filter.parameters.ParameterFilter;
import org.geowebcache.filter.parameters.RegexParameterFilter;
import org.geowebcache.filter.parameters.StringParameterFilter;
import org.geowebcache.filter.request.CircularExtentFilter;
import org.geowebcache.filter.request.FileRasterFilter;
import org.geowebcache.filter.request.WMSRasterFilter;
import org.geowebcache.grid.GridSet;
import org.geowebcache.grid.GridSetBroker;
import org.geowebcache.grid.SRS;
import org.geowebcache.grid.XMLGridSet;
import org.geowebcache.grid.XMLGridSubset;
import org.geowebcache.grid.XMLOldGrid;
import org.geowebcache.layer.ExpirationRule;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.layer.meta.ContactInformation;
import org.geowebcache.layer.meta.LayerMetaInformation;
import org.geowebcache.layer.updatesource.GeoRSSFeedDefinition;
import org.geowebcache.layer.wms.WMSHttpHelper;
import org.geowebcache.layer.wms.WMSLayer;
import org.geowebcache.mime.FormatModifier;
import org.geowebcache.seed.SeedRequest;
import org.geowebcache.storage.DefaultStorageFinder;
import org.geowebcache.storage.StorageBroker;
import org.geowebcache.storage.StorageException;
import org.geowebcache.util.ApplicationContextProvider;
import org.springframework.web.context.WebApplicationContext;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLConfiguration
implements Configuration {
    private static Log log = LogFactory.getLog(XMLConfiguration.class);
    private static final String CONFIGURATION_FILE_NAME = "geowebcache.xml";
    private static final String[] CONFIGURATION_REL_PATHS = new String[]{"/WEB-INF/classes", "/../resources"};
    private WebApplicationContext context;
    private GridSetBroker gridSetBroker;
    private DefaultStorageFinder defStoreFind;
    private String absPath = null;
    private String relPath = null;
    private boolean mockConfiguration = false;
    private File configH = null;
    StorageBroker storageBroker = null;
    private GeoWebCacheConfiguration gwcConfig = null;

    public XMLConfiguration(ApplicationContextProvider appCtx, GridSetBroker gridSetBroker, DefaultStorageFinder defaultStorage, String filePath) {
        this.context = appCtx.getApplicationContext();
        this.gridSetBroker = gridSetBroker;
        this.defStoreFind = defaultStorage;
        if (filePath.startsWith("/") || filePath.contains(":\\")) {
            this.absPath = filePath;
        } else {
            this.relPath = filePath;
        }
        log.info((Object)("Will look for geowebcache.xml in " + filePath));
        try {
            File xmlFile = this.findConfFile();
            if (xmlFile == null) {
                return;
            }
            this.loadConfiguration(xmlFile);
            this.initialize();
        }
        catch (GeoWebCacheException e) {
            e.printStackTrace();
        }
    }

    public XMLConfiguration(ApplicationContextProvider appCtx, GridSetBroker gridSetBroker, DefaultStorageFinder defaultStorage) {
        this.context = appCtx.getApplicationContext();
        this.gridSetBroker = gridSetBroker;
        this.defStoreFind = defaultStorage;
        try {
            File xmlFile = this.findConfFile();
            if (xmlFile == null) {
                return;
            }
            this.loadConfiguration(xmlFile);
            this.initialize();
        }
        catch (GeoWebCacheException e) {
            e.printStackTrace();
        }
    }

    public XMLConfiguration(InputStream is) throws Exception {
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        docBuilderFactory.setNamespaceAware(true);
        DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
        XStream xs = this.getConfiguredXStream(new XStream());
        this.gwcConfig = (GeoWebCacheConfiguration)xs.unmarshal((HierarchicalStreamReader)new DomReader((Element)this.checkAndTransform(docBuilder.parse(is))));
        this.mockConfiguration = true;
        this.initialize();
    }

    private void initialize() {
        if (this.gwcConfig.gridSets != null) {
            for (XMLGridSet xmlGridSet : this.gwcConfig.gridSets) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Reading " + xmlGridSet.getName()));
                }
                GridSet gridSet = xmlGridSet.makeGridSet();
                log.info((Object)("Read GridSet " + gridSet.getName()));
                this.gridSetBroker.put(gridSet);
            }
        }
        if (this.gwcConfig.layers != null) {
            for (TileLayer layer : this.gwcConfig.layers) {
                this.setDefaultValues(layer);
            }
        }
    }

    private File findConfFile() throws GeoWebCacheException {
        if (this.configH == null) {
            this.determineConfigDirH();
        }
        File xmlFile = null;
        if (this.configH == null) {
            log.debug((Object)"Unable to determine configuration directory. If you are running GWC in GeoServer this is probably not an issue.");
            return null;
        }
        xmlFile = new File(this.configH.getAbsolutePath() + File.separator + CONFIGURATION_FILE_NAME);
        if (xmlFile != null) {
            log.info((Object)("Found configuration file in " + this.configH.getAbsolutePath()));
        } else {
            log.info((Object)("Found no configuration file in " + this.configH.getAbsolutePath() + " If you are running GWC in GeoServer this is probably not an issue."));
        }
        return xmlFile;
    }

    @Override
    public synchronized List<TileLayer> getTileLayers(boolean reload) throws GeoWebCacheException {
        if (reload && !this.mockConfiguration) {
            File xmlFile = this.findConfFile();
            this.loadConfiguration(xmlFile);
            this.initialize();
        }
        if (this.gwcConfig != null) {
            return this.gwcConfig.layers;
        }
        return null;
    }

    @Override
    public boolean isRuntimeStatsEnabled() {
        if (this.gwcConfig == null || this.gwcConfig.runtimeStats == null) {
            return true;
        }
        return this.gwcConfig.runtimeStats;
    }

    @Override
    public synchronized ServiceInformation getServiceInformation() throws GeoWebCacheException {
        if (!this.mockConfiguration && this.gwcConfig == null) {
            File xmlFile = this.findConfFile();
            this.loadConfiguration(xmlFile);
        }
        return this.gwcConfig.serviceInformation;
    }

    private void setDefaultValues(TileLayer layer) {
        if (layer.isCacheBypassAllowed() == null) {
            if (this.gwcConfig.cacheBypassAllowed != null) {
                layer.setCacheBypassAllowed(this.gwcConfig.cacheBypassAllowed);
            } else {
                layer.setCacheBypassAllowed(false);
            }
        }
        if (layer.getBackendTimeout() == null) {
            if (this.gwcConfig.backendTimeout != null) {
                layer.setBackendTimeout(this.gwcConfig.backendTimeout);
            } else {
                layer.setBackendTimeout(120);
            }
        }
        if (layer.getFormatModifiers() == null && this.gwcConfig.formatModifiers != null) {
            layer.setFormatModifiers(this.gwcConfig.formatModifiers);
        }
        if (layer instanceof WMSLayer) {
            WMSHttpHelper sourceHelper;
            WMSLayer wl = (WMSLayer)layer;
            URL proxyUrl = null;
            try {
                if (this.gwcConfig.proxyUrl != null) {
                    proxyUrl = new URL(this.gwcConfig.proxyUrl);
                    log.debug((Object)("Using proxy " + proxyUrl.getHost() + ":" + proxyUrl.getPort()));
                } else if (wl.getProxyUrl() != null) {
                    proxyUrl = new URL(wl.getProxyUrl());
                    log.debug((Object)("Using proxy " + proxyUrl.getHost() + ":" + proxyUrl.getPort()));
                }
            }
            catch (MalformedURLException e) {
                log.error((Object)("could not parse proxy URL " + wl.getProxyUrl() + " ! continuing WITHOUT proxy!"), (Throwable)e);
            }
            if (wl.getHttpUsername() != null) {
                sourceHelper = new WMSHttpHelper(wl.getHttpUsername(), wl.getHttpPassword(), proxyUrl);
                log.debug((Object)("Using per-layer HTTP credentials for " + wl.getName() + ", " + "username " + wl.getHttpUsername()));
            } else if (this.gwcConfig.httpUsername != null) {
                sourceHelper = new WMSHttpHelper(this.gwcConfig.httpUsername, this.gwcConfig.httpPassword, proxyUrl);
                log.debug((Object)("Using global HTTP credentials for " + wl.getName()));
            } else {
                sourceHelper = new WMSHttpHelper(null, null, proxyUrl);
                log.debug((Object)("Not using HTTP credentials for " + wl.getName()));
            }
            wl.setSourceHelper(sourceHelper);
        }
    }

    private void loadConfiguration(File xmlFile) throws GeoWebCacheException {
        Node rootNode = this.loadDocument(xmlFile);
        XStream xs = this.getConfiguredXStream(new XStream());
        this.gwcConfig = (GeoWebCacheConfiguration)xs.unmarshal((HierarchicalStreamReader)new DomReader((Element)rootNode));
        this.gwcConfig.init();
    }

    private void writeConfiguration() throws GeoWebCacheException {
        File xmlFile = this.findConfFile();
        this.persistToFile(xmlFile);
    }

    public XStream getConfiguredXStream(XStream xs) {
        xs.setMode(1001);
        xs.alias("gwcConfiguration", GeoWebCacheConfiguration.class);
        xs.useAttributeFor(GeoWebCacheConfiguration.class, "xmlns_xsi");
        xs.aliasField("xmlns:xsi", GeoWebCacheConfiguration.class, "xmlns_xsi");
        xs.useAttributeFor(GeoWebCacheConfiguration.class, "xsi_noNamespaceSchemaLocation");
        xs.aliasField("xsi:noNamespaceSchemaLocation", GeoWebCacheConfiguration.class, "xsi_noNamespaceSchemaLocation");
        xs.useAttributeFor(GeoWebCacheConfiguration.class, "xmlns");
        xs.alias("keyword", String.class);
        xs.alias("layers", List.class);
        xs.alias("wmsLayer", WMSLayer.class);
        xs.alias("grids", new ArrayList().getClass());
        xs.alias("grid", XMLOldGrid.class);
        xs.alias("gridSet", XMLGridSet.class);
        xs.alias("gridSubset", XMLGridSubset.class);
        xs.alias("mimeFormats", new ArrayList().getClass());
        xs.alias("formatModifiers", new ArrayList().getClass());
        xs.alias("srs", SRS.class);
        xs.alias("parameterFilters", new ArrayList().getClass());
        xs.alias("parameterFilter", ParameterFilter.class);
        xs.alias("seedRequest", SeedRequest.class);
        xs.alias("floatParameterFilter", FloatParameterFilter.class);
        xs.alias("regexParameterFilter", RegexParameterFilter.class);
        xs.alias("stringParameterFilter", StringParameterFilter.class);
        xs.alias("formatModifier", FormatModifier.class);
        xs.alias("circularExtentFilter", CircularExtentFilter.class);
        xs.alias("wmsRasterFilter", WMSRasterFilter.class);
        xs.alias("fileRasterFilter", FileRasterFilter.class);
        xs.alias("expirationRule", ExpirationRule.class);
        xs.useAttributeFor(ExpirationRule.class, "minZoom");
        xs.useAttributeFor(ExpirationRule.class, "expiration");
        xs.alias("geoRssFeed", GeoRSSFeedDefinition.class);
        xs.alias("metaInformation", LayerMetaInformation.class);
        xs.alias("contactInformation", ContactInformation.class);
        if (this.context != null) {
            Collection configExtensions = this.context.getBeansOfType(XMLConfigurationProvider.class).values();
            for (XMLConfigurationProvider extension : configExtensions) {
                xs = extension.getConfiguredXStream(xs);
            }
        }
        return xs;
    }

    protected void persistToFile(File xmlFile) throws GeoWebCacheException {
        XStream xs = this.getConfiguredXStream(new XStream());
        OutputStreamWriter writer = null;
        try {
            writer = new OutputStreamWriter((OutputStream)new FileOutputStream(xmlFile), "UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            uee.printStackTrace();
            throw new GeoWebCacheException(uee.getMessage());
        }
        catch (FileNotFoundException fnfe) {
            throw new GeoWebCacheException(fnfe.getMessage());
        }
        try {
            writer.write("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n");
            xs.toXML((Object)this.gwcConfig, (Writer)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new GeoWebCacheException("Error writing to " + xmlFile.getAbsolutePath() + ": " + e.getMessage());
        }
        log.info((Object)("Wrote configuration to " + xmlFile.getAbsolutePath()));
    }

    public boolean modifyLayer(TileLayer tl) throws GeoWebCacheException {
        boolean response = this.gwcConfig.replaceLayer(tl);
        if (response) {
            this.writeConfiguration();
        }
        return response;
    }

    public boolean addLayer(TileLayer tl) throws GeoWebCacheException {
        boolean response = this.gwcConfig.addLayer(tl);
        if (response) {
            this.writeConfiguration();
        }
        return response;
    }

    public boolean deleteLayer(TileLayer layer) throws GeoWebCacheException {
        boolean response = this.gwcConfig.removeLayer(layer);
        if (response) {
            this.writeConfiguration();
        }
        return response;
    }

    private Node loadDocument(File xmlFile) throws ConfigurationException {
        Node topNode = null;
        try {
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            docBuilderFactory.setNamespaceAware(true);
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            topNode = this.checkAndTransform(docBuilder.parse(xmlFile));
        }
        catch (ParserConfigurationException pce) {
            log.error((Object)pce.getMessage());
            pce.printStackTrace();
        }
        catch (IOException ei) {
            throw new ConfigurationException("Error parsing file " + xmlFile.getAbsolutePath());
        }
        catch (SAXException saxe) {
            log.error((Object)saxe.getMessage());
        }
        if (topNode == null) {
            throw new ConfigurationException("Error parsing file " + xmlFile.getAbsolutePath() + ", top node came out as null");
        }
        return topNode;
    }

    private Node checkAndTransform(Document doc) throws ConfigurationException {
        Node rootNode = doc.getDocumentElement();
        if (!rootNode.getNodeName().equals("gwcConfiguration")) {
            log.info((Object)"The configuration file is of the pre 1.0 type, trying to convert.");
            rootNode = this.applyTransform(rootNode, "geowebcache_pre10.xsl").getFirstChild();
        }
        if (rootNode.getNamespaceURI().equals("http://geowebcache.org/schema/1.0.0")) {
            log.info((Object)"Updating configuration from 1.0.0 to 1.0.1");
            rootNode = this.applyTransform(rootNode, "geowebcache_100.xsl").getFirstChild();
        }
        if (rootNode.getNamespaceURI().equals("http://geowebcache.org/schema/1.0.1")) {
            log.info((Object)"Updating configuration from 1.0.1 to 1.0.2");
            rootNode = this.applyTransform(rootNode, "geowebcache_101.xsl").getFirstChild();
        }
        if (rootNode.getNamespaceURI().equals("http://geowebcache.org/schema/1.0.2")) {
            log.info((Object)"Updating configuration from 1.0.2 to 1.1.0");
            rootNode = this.applyTransform(rootNode, "geowebcache_102.xsl").getFirstChild();
        }
        if (rootNode.getNamespaceURI().equals("http://geowebcache.org/schema/1.1.0")) {
            log.info((Object)"Updating configuration from 1.1.0 to 1.1.3");
            rootNode = this.applyTransform(rootNode, "geowebcache_110.xsl").getFirstChild();
        }
        if (rootNode.getNamespaceURI().equals("http://geowebcache.org/schema/1.1.3")) {
            log.info((Object)"Updating configuration from 1.1.3 to 1.1.4");
            rootNode = this.applyTransform(rootNode, "geowebcache_113.xsl").getFirstChild();
        }
        if (rootNode.getNamespaceURI().equals("http://geowebcache.org/schema/1.1.4")) {
            log.info((Object)"Updating configuration from 1.1.4 to 1.1.5");
            rootNode = this.applyTransform(rootNode, "geowebcache_114.xsl").getFirstChild();
        }
        if (rootNode.getNamespaceURI().equals("http://geowebcache.org/schema/1.1.5")) {
            log.info((Object)"Updating configuration from 1.1.5 to 1.2.0");
            rootNode = this.applyTransform(rootNode, "geowebcache_115.xsl").getFirstChild();
        }
        if (rootNode.getNamespaceURI().equals("http://geowebcache.org/schema/1.2.0")) {
            log.info((Object)"Updating configuration from 1.2.0 to 1.2.1");
            rootNode = this.applyTransform(rootNode, "geowebcache_120.xsl").getFirstChild();
        }
        if (rootNode.getNamespaceURI().equals("http://geowebcache.org/schema/1.2.1")) {
            log.info((Object)"Updating configuration from 1.2.1 to 1.2.2");
            rootNode = this.applyTransform(rootNode, "geowebcache_121.xsl").getFirstChild();
        }
        if (rootNode.getNamespaceURI().equals("http://geowebcache.org/schema/1.2.2")) {
            log.info((Object)"Updating configuration from 1.2.2 to 1.2.4");
            rootNode = this.applyTransform(rootNode, "geowebcache_122.xsl").getFirstChild();
        }
        if (!rootNode.getNodeName().equals("gwcConfiguration")) {
            log.error((Object)"Unable to parse file, expected gwcConfiguration at root after transform.");
            throw new ConfigurationException("Unable to parse after transform.");
        }
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        InputStream is = XMLConfiguration.class.getResourceAsStream("geowebcache.xsd");
        try {
            Schema schema = factory.newSchema(new StreamSource(is));
            Validator validator = schema.newValidator();
            DOMSource domSrc = new DOMSource(rootNode);
            validator.validate(domSrc);
            log.info((Object)"Configuration file validated fine.");
        }
        catch (SAXException e) {
            log.info((Object)e.getMessage());
            log.info((Object)"Will try to use configuration anyway.");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return rootNode;
    }

    private Node applyTransform(Node oldRootNode, String xslFilename) {
        DOMResult result = new DOMResult();
        InputStream is = XMLConfiguration.class.getResourceAsStream(xslFilename);
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer(new StreamSource(is));
            transformer.transform(new DOMSource(oldRootNode), result);
        }
        catch (TransformerConfigurationException e) {
            e.printStackTrace();
        }
        catch (TransformerFactoryConfigurationError e) {
            e.printStackTrace();
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
        return result.getNode();
    }

    private void determineConfigDirH() {
        String baseDir = this.context.getServletContext().getRealPath("");
        if (this.absPath != null) {
            this.configH = new File(this.absPath);
        } else if (this.relPath != null) {
            this.configH = new File(baseDir + this.relPath);
            log.debug((Object)("Configuration directory set to: " + this.configH.getAbsolutePath()));
        } else if (this.relPath == null) {
            File tmpPath;
            String defaultPath = null;
            try {
                defaultPath = this.defStoreFind.getDefaultPath();
            }
            catch (StorageException se) {
                // empty catch block
            }
            if (defaultPath != null && (tmpPath = new File(defaultPath + File.separator + CONFIGURATION_FILE_NAME)).exists()) {
                this.configH = new File(tmpPath.getParent());
            }
            if (this.configH == null) {
                for (int i = 0; i < CONFIGURATION_REL_PATHS.length; ++i) {
                    File tmpPath2;
                    this.relPath = CONFIGURATION_REL_PATHS[i];
                    if (File.separator.equals("\\")) {
                        this.relPath = this.relPath.replace("/", "\\");
                    }
                    if (!(tmpPath2 = new File(baseDir + this.relPath + File.separator + CONFIGURATION_FILE_NAME)).exists() || !tmpPath2.canRead()) continue;
                    log.info((Object)("No configuration directory was specified, using " + tmpPath2.getAbsolutePath()));
                    this.configH = new File(baseDir + this.relPath);
                }
            }
        }
        if (this.configH == null) {
            log.info((Object)"Failed to find geowebcache.xml. This is not a problem unless you are trying to use a custom XML configuration file.");
        } else {
            log.debug((Object)("Configuration directory set to: " + this.configH.getAbsolutePath()));
            if (!this.configH.exists() || !this.configH.canRead()) {
                log.error((Object)"Configuration file cannot be read or does not exist!");
            }
        }
    }

    @Override
    public String getIdentifier() throws GeoWebCacheException {
        if (this.mockConfiguration) {
            return "Mock configuration";
        }
        if (this.configH == null) {
            this.findConfFile();
        }
        if (this.configH != null) {
            return this.configH.getAbsolutePath();
        }
        return null;
    }

    public void setRelativePath(String relPath) {
        log.error((Object)"Specifying the relative path as a property is deprecated. Please pass it as the 4th argument to the constructor.");
    }

    public void setAbsolutePath(String absPath) {
        log.error((Object)"Specifying the absolute path as a property is deprecated. Please pass it as the 4th argument to the constructor.");
    }

    public void debugPrint(Node node) {
        if (node == null) {
            System.out.println("1: No node");
            return;
        }
        System.out.println("1: " + node.getNodeName() + " " + node.getNamespaceURI());
        node = node.getFirstChild();
        if (node != null) {
            System.out.println("2: " + node.getNodeName() + " " + node.getNamespaceURI());
            node = node.getFirstChild();
        }
        if (node != null) {
            System.out.println("3: " + node.getNodeName() + " " + node.getNamespaceURI());
        }
    }
}

