/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.web.data;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import org.apache.wicket.WicketRuntimeException;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.wms.web.data.AbstractStylePage;
import org.geoserver.wms.web.data.StylePage;

public class StyleNewPage
extends AbstractStylePage {
    public StyleNewPage() {
        this.initUI(null);
    }

    protected void onStyleFormSubmit() {
        Catalog catalog = this.getCatalog();
        StyleInfo s = (StyleInfo)this.styleForm.getModelObject();
        if (s.getFilename() == null) {
            s.setFilename(s.getName() + ".sld");
        }
        try {
            this.getCatalog().add(s);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Error occurred saving the style", e);
            this.error(e);
            return;
        }
        try {
            catalog.getResourcePool().writeStyle(s, (InputStream)new ByteArrayInputStream(this.rawSLD.getBytes()));
        }
        catch (IOException e) {
            throw new WicketRuntimeException((Throwable)e);
        }
        this.setResponsePage(StylePage.class);
    }
}

