/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.georss;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.geowebcache.georss.GeoRSSReader;
import org.geowebcache.georss.StaxGeoRSSReader;
import org.geowebcache.util.HttpClientBuilder;

class GeoRSSReaderFactory {
    GeoRSSReaderFactory() {
    }

    public GeoRSSReader createReader(URL url, String username, String password) throws IOException {
        HttpClientBuilder builder = new HttpClientBuilder();
        builder.setHttpCredentials(username, password, url);
        builder.setBackendTimeout(120000);
        HttpClient httpClient = builder.buildClient();
        GetMethod getMethod = new GetMethod(url.toString());
        if (builder.isDoAuthentication()) {
            getMethod.setDoAuthentication(true);
            httpClient.getParams().setAuthenticationPreemptive(true);
        }
        httpClient.executeMethod((HttpMethod)getMethod);
        String contentEncoding = getMethod.getResponseCharSet();
        if (contentEncoding == null) {
            contentEncoding = "UTF-8";
        }
        InputStream in = getMethod.getResponseBodyAsStream();
        BufferedReader reader = new BufferedReader(new InputStreamReader(in, contentEncoding));
        return this.createReader(reader);
    }

    public GeoRSSReader createReader(Reader feed) throws IOException {
        StaxGeoRSSReader reader;
        try {
            reader = new StaxGeoRSSReader(feed);
        }
        catch (XMLStreamException e) {
            throw new IllegalStateException(e);
        }
        catch (FactoryConfigurationError e) {
            throw new IllegalStateException(e);
        }
        return reader;
    }
}

