/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageio.plugins.arcgrid.raster;

import it.geosolutions.imageio.plugins.arcgrid.AsciiGridsImageReader;
import it.geosolutions.imageio.plugins.arcgrid.AsciiGridsImageWriter;
import it.geosolutions.imageio.plugins.arcgrid.raster.EsriAsciiGridRaster;
import it.geosolutions.imageio.plugins.arcgrid.raster.GrassAsciiGridRaster;
import it.geosolutions.imageio.utilities.StringToDouble;
import java.awt.Rectangle;
import java.awt.image.WritableRaster;
import java.io.EOFException;
import java.io.IOException;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.logging.Logger;
import javax.imageio.ImageReadParam;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;
import javax.media.jai.JAI;
import javax.media.jai.RasterFactory;
import javax.media.jai.TileFactory;
import javax.media.jai.iterator.RectIter;

public abstract class AsciiGridRaster {
    protected static final Logger LOGGER = Logger.getLogger(AsciiGridRaster.class.toString());
    public static final String newline = System.getProperty("line.separator");
    protected final int[] tileTreeMutex = new int[1];
    protected volatile boolean abortRequired = false;
    private static final int MAX_BYTES_TO_READ = 70;
    private static final int MAX_VALUE_LENGTH = 40;
    protected double maxValue = Double.MIN_VALUE;
    protected double minValue = Double.MAX_VALUE;
    protected double xllCellCoordinate = Double.NaN;
    protected double yllCellCoordinate = Double.NaN;
    protected int sourceXSubsampling = 1;
    protected int sourceYSubsampling = 1;
    protected boolean isCorner;
    protected double cellSizeX = Double.NaN;
    protected double cellSizeY = Double.NaN;
    protected int nCols = -1;
    protected int nRows = -1;
    protected boolean compress;
    protected long dataStartAt = -1L;
    protected TreeMap<Long, Long> tileMarker = new TreeMap();
    protected int tileWidth = -1;
    protected int tileHeight = -1;
    protected ImageInputStream imageIS = null;
    protected ImageOutputStream imageOS = null;
    protected double noData = Double.NaN;
    protected AsciiGridsImageReader reader;
    protected AsciiGridsImageWriter writer;

    protected AsciiGridRaster(ImageInputStream iis) {
        this.imageIS = iis;
        this.abortRequired = false;
    }

    protected AsciiGridRaster(ImageInputStream iis, AsciiGridsImageReader reader) {
        this(iis);
        this.reader = reader;
    }

    protected AsciiGridRaster(ImageOutputStream ios) {
        this.imageOS = ios;
        this.abortRequired = false;
    }

    protected AsciiGridRaster(ImageOutputStream ios, AsciiGridsImageWriter writer) {
        this(ios);
        this.writer = writer;
    }

    public abstract void parseHeader() throws IOException;

    public abstract void writeHeader(String var1, String var2, String var3, String var4, String var5, String var6, String var7, String var8) throws IOException;

    public abstract String getNoDataMarker();

    public final double getMaxValue() {
        return this.maxValue;
    }

    public final double getMinValue() {
        return this.minValue;
    }

    public final double getNoData() {
        return this.noData;
    }

    public final int getNRows() {
        return this.nRows;
    }

    public abstract AsciiGridRasterType getRasterType();

    public final int getNCols() {
        return this.nCols;
    }

    public int getSourceXSubsampling() {
        return this.sourceXSubsampling;
    }

    public int getSourceYSubsampling() {
        return this.sourceYSubsampling;
    }

    public final double getCellSizeX() {
        return this.cellSizeX;
    }

    public final double getCellSizeY() {
        return this.cellSizeY;
    }

    public final double getXllCellCoordinate() {
        return this.xllCellCoordinate;
    }

    public final double getYllCellCoordinate() {
        return this.yllCellCoordinate;
    }

    public final int getTileHeight() {
        return this.tileHeight;
    }

    public final int getTileWidth() {
        return this.tileWidth;
    }

    public final void setTilesSize(int tileWidth, int tileHeight) {
        this.tileHeight = tileHeight;
        this.tileWidth = tileWidth;
    }

    public final boolean isCorner() {
        return this.isCorner;
    }

    final long getDataStartAt() {
        return this.dataStartAt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public WritableRaster readRaster(ImageReadParam param) throws IOException {
        boolean hasListeners = this.reader.isHasListeners();
        int perc = 0;
        int iPerc = 1;
        int dstWidth = -1;
        int dstHeight = -1;
        int srcRegionWidth = -1;
        int srcRegionHeight = -1;
        int srcRegionXOffset = -1;
        int srcRegionYOffset = -1;
        int xSubsamplingFactor = -1;
        int ySubsamplingFactor = -1;
        boolean doSubsampling = false;
        Rectangle srcRegion = param.getSourceRegion();
        if (srcRegion != null) {
            srcRegionWidth = (int)srcRegion.getWidth();
            srcRegionHeight = (int)srcRegion.getHeight();
            srcRegionXOffset = (int)srcRegion.getX();
            srcRegionYOffset = (int)srcRegion.getY();
            if (srcRegionXOffset < 0) {
                srcRegionXOffset = 0;
            }
            if (srcRegionYOffset < 0) {
                srcRegionYOffset = 0;
            }
            if (srcRegionXOffset + srcRegionWidth > this.nCols) {
                srcRegionWidth = this.nCols - srcRegionXOffset;
            }
            dstWidth = srcRegionWidth;
            if (srcRegionYOffset + srcRegionHeight > this.nRows) {
                srcRegionHeight = this.nRows - srcRegionYOffset;
            }
            dstHeight = srcRegionHeight;
        } else {
            dstWidth = this.nCols;
            dstHeight = this.nRows;
            srcRegionYOffset = 0;
            srcRegionXOffset = 0;
            srcRegionWidth = this.nCols;
            srcRegionHeight = this.nRows;
        }
        xSubsamplingFactor = param.getSourceXSubsampling();
        ySubsamplingFactor = param.getSourceYSubsampling();
        if (xSubsamplingFactor > this.nCols) throw new IOException("The subSamplingFactor cannot be greater than image size!");
        if (ySubsamplingFactor > this.nRows) {
            throw new IOException("The subSamplingFactor cannot be greater than image size!");
        }
        if (xSubsamplingFactor > 1 || ySubsamplingFactor > 1) {
            doSubsampling = true;
        }
        int samplesToLoad = srcRegionHeight * this.nCols;
        dstWidth = (dstWidth - 1) / xSubsamplingFactor + 1;
        dstHeight = (dstHeight - 1) / ySubsamplingFactor + 1;
        long samplesToThrowAwayBeforeFirstValidSample = this.nCols * srcRegionYOffset;
        TileFactory factory = (TileFactory)JAI.getDefaultInstance().getRenderingHint(JAI.KEY_TILE_FACTORY);
        WritableRaster raster = factory != null ? factory.createTile(RasterFactory.createBandedSampleModel((int)5, (int)dstWidth, (int)dstHeight, (int)1), null) : RasterFactory.createBandedRaster((int)5, (int)dstWidth, (int)dstHeight, (int)1, null);
        int ch = -1;
        int prevCh = -1;
        long samplesCounted = 0L;
        long streamPosition = 0L;
        this.imageIS.seek(this.dataStartAt);
        if (samplesToThrowAwayBeforeFirstValidSample > 0L) {
            int[] nArray = this.tileTreeMutex;
            // MONITORENTER : this.tileTreeMutex
            Long markedPos = this.tileMarker.get(samplesToThrowAwayBeforeFirstValidSample);
            if (markedPos != null) {
                this.imageIS.seek(markedPos);
                samplesCounted = samplesToThrowAwayBeforeFirstValidSample;
            } else {
                SortedMap<Long, Long> sm = this.tileMarker.headMap(samplesToThrowAwayBeforeFirstValidSample);
                if (!sm.entrySet().isEmpty()) {
                    long key = sm.lastKey();
                    markedPos = this.tileMarker.get(key);
                    if (markedPos != null) {
                        this.imageIS.seek(markedPos);
                        samplesCounted = (int)key;
                    }
                } else {
                    this.imageIS.seek(this.dataStartAt);
                    samplesCounted = 0L;
                }
            }
            // MONITOREXIT : nArray
        }
        streamPosition = this.imageIS.getStreamPosition();
        if (hasListeners && this.abortRequired) {
            return raster;
        }
        if (samplesCounted < samplesToThrowAwayBeforeFirstValidSample) {
            int tileH = this.getTileHeight();
            int tileW = this.getTileWidth();
            while (samplesCounted < samplesToThrowAwayBeforeFirstValidSample) {
                ch = this.imageIS.read();
                if (ch == -1) {
                    throw new EOFException("EOF found while looking for valid input");
                }
                ++streamPosition;
                if (ch != 32 && ch != 10 && ch != 13 && ch != 9 && (prevCh == 32 || prevCh == 10 || prevCh == 13 || prevCh == 9) && ++samplesCounted % (long)(tileH * tileW) == 0L) {
                    Long key = samplesCounted;
                    Long val = streamPosition;
                    int[] nArray = this.tileTreeMutex;
                    // MONITORENTER : this.tileTreeMutex
                    if (!this.tileMarker.containsKey(key)) {
                        this.tileMarker.put(key, val);
                    }
                    // MONITOREXIT : nArray
                }
                prevCh = ch;
                if (!hasListeners || (perc = (int)((float)samplesCounted * 1.0f / (float)samplesToThrowAwayBeforeFirstValidSample * 100.0f)) % (10 * iPerc) != 0 || perc <= 0) continue;
                if (this.abortRequired) {
                    return raster;
                }
                ++iPerc;
            }
        }
        samplesCounted = 0L;
        prevCh = -1;
        ch = -1;
        double value = 0.0;
        long rasterX = 0L;
        long rasterY = 0L;
        long tempCol = 0L;
        long tempRow = 0L;
        double noDataValue = this.getNoData();
        StringToDouble doubleConverter = StringToDouble.acquire();
        while (true) {
            int[] nArray;
            if (samplesCounted >= (long)samplesToLoad) {
                nArray = this.tileTreeMutex;
                // MONITORENTER : this.tileTreeMutex
                this.tileMarker.put((long)samplesToLoad + samplesToThrowAwayBeforeFirstValidSample, new Long(this.imageIS.getStreamPosition()));
                // MONITOREXIT : nArray
                StringToDouble.release((StringToDouble)doubleConverter);
                return raster;
            }
            value = this.getValue(this.imageIS, 70, 40, doubleConverter);
            tempCol = samplesCounted % (long)this.nCols;
            tempRow = samplesCounted / (long)this.nCols;
            if (tempCol >= (long)srcRegionXOffset && tempCol < (long)(srcRegionXOffset + srcRegionWidth) && (!doSubsampling || doSubsampling && tempRow % (long)ySubsamplingFactor == 0L && tempCol % (long)xSubsamplingFactor == 0L)) {
                if (Double.isInfinite(value) && samplesCounted != (long)samplesToLoad) {
                    StringToDouble.release((StringToDouble)doubleConverter);
                    throw new IOException("Error on reading data due to an END of File or invalid data find");
                }
                if (value != noDataValue && !Double.isNaN(value) && !Double.isInfinite(value)) {
                    nArray = this.tileTreeMutex;
                    // MONITORENTER : this.tileTreeMutex
                    this.minValue = Math.min(this.minValue, value);
                    this.maxValue = Math.max(this.maxValue, value);
                    // MONITOREXIT : nArray
                }
                rasterY = tempRow / (long)ySubsamplingFactor;
                rasterX = (tempCol - (long)srcRegionXOffset) / (long)xSubsamplingFactor;
                raster.setSample((int)rasterX, (int)rasterY, 0, value);
            }
            if (hasListeners && (perc = (int)((float)(++samplesCounted) * 1.0f / (float)samplesToLoad * 100.0f)) % (10 * iPerc) == 0 && perc > 0) {
                if (this.abortRequired) {
                    return raster;
                }
                this.reader.processImageProgress(perc);
                ++iPerc;
            }
            value = 0.0;
        }
    }

    public void writeRaster(RectIter iterator, Double noDataDouble, String noDataMarker) throws IOException {
        boolean hasListeners = this.writer.isHasListeners();
        int pixelsToWrite = hasListeners ? this.writer.getNColumns() * this.writer.getNRows() : 0;
        int pixelsWritten = 0;
        int perc = 0;
        int iPerc = 1;
        if (hasListeners && this.abortRequired) {
            return;
        }
        while (!iterator.finishedLines()) {
            while (!iterator.finishedPixels()) {
                double sample = iterator.getSampleDouble();
                String sampleString = Double.toString(sample);
                if (hasListeners && (perc = (int)((float)(++pixelsWritten) * 1.0f / (float)pixelsToWrite * 1000.0f)) % (25 * iPerc) == 0 && perc > 0) {
                    if (this.abortRequired) {
                        return;
                    }
                    this.writer.processImageProgress((float)perc / 10.0f);
                    ++iPerc;
                }
                if (noDataDouble.compareTo(new Double(sample)) != 0 && !Double.isNaN(sample) && !Double.isInfinite(sample)) {
                    this.imageOS.writeBytes(sampleString);
                } else {
                    this.imageOS.writeBytes(noDataMarker);
                }
                iterator.nextPixel();
                if (iterator.finishedPixels()) continue;
                this.imageOS.write(32);
            }
            this.imageOS.writeBytes(newline);
            iterator.nextLine();
            iterator.startPixels();
        }
    }

    public void abort() {
        this.abortRequired = true;
    }

    public boolean isAborting() {
        return this.abortRequired;
    }

    public void clearAbort() {
        this.abortRequired = false;
    }

    double getValue(ImageInputStream inStream, int maxBytesToRead, int maxValueLength, StringToDouble doubleConverter) throws IOException {
        double retVal = Double.NaN;
        boolean started = false;
        int bytesRead = 0;
        int validBytesRead = 0;
        while (true) {
            byte b;
            if ((b = (byte)(inStream.read() & 0xFF)) == -1) {
                return Double.NEGATIVE_INFINITY;
            }
            if (++bytesRead > maxBytesToRead) break;
            if (b == 32 || b == 10 || b == 13 || b == 9) {
                if (!started) continue;
                break;
            }
            if ((b < 48 || b > 57) && b != 43 && b != 45 && b != 69 && b != 101 && b != 46 && b != 42 && b != 44) {
                return Double.NEGATIVE_INFINITY;
            }
            ++validBytesRead;
            if (!doubleConverter.pushChar((int)b)) {
                return Double.NEGATIVE_INFINITY;
            }
            started = true;
            if (validBytesRead > maxValueLength) break;
        }
        retVal = doubleConverter.compute();
        return retVal;
    }

    String getKey(ImageInputStream inStream, int maxBytesToRead, int maxKeyLength, byte specialChar) throws IOException {
        byte b;
        StringBuffer buffer = new StringBuffer(10);
        boolean started = false;
        int bytesRead = 0;
        int validBytesRead = 0;
        while ((b = (byte)(inStream.read() & 0xFF)) != -1 && ++bytesRead < maxBytesToRead) {
            if (b == 32 || b == 10 || b == 13 || b == 9) {
                if (started) break;
                continue;
            }
            if (specialChar > 127 ? !(b == 95 || b >= 97 && b <= 122 || b >= 64 && b <= 90) : !(b == 95 || b == specialChar || b >= 97 && b <= 122 || b >= 64 && b <= 90)) break;
            buffer.append(new String(new byte[]{b}, "ascii"));
            started = true;
            if (++validBytesRead < maxKeyLength) continue;
            break;
        }
        return buffer.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AsciiGridRasterType {
        UNDEFINED{

            public AsciiGridRaster createAsciiGridRaster(ImageInputStream inStream) {
                throw new UnsupportedOperationException("Operation not supported by the UNDEFINED raster type");
            }

            public AsciiGridRaster createAsciiGridRaster(ImageOutputStream oStream, AsciiGridsImageWriter writer) {
                throw new UnsupportedOperationException("Operation not supported by the UNDEFINED raster type");
            }

            public AsciiGridRaster createAsciiGridRaster(ImageOutputStream oStream) {
                throw new UnsupportedOperationException("Operation not supported by the UNDEFINED raster type");
            }

            public AsciiGridRaster createAsciiGridRaster(ImageInputStream inStream, AsciiGridsImageReader reader) {
                throw new UnsupportedOperationException("Operation not supported by the UNDEFINED raster type");
            }
        }
        ,
        ESRI{

            public EsriAsciiGridRaster createAsciiGridRaster(ImageInputStream inStream) {
                return new EsriAsciiGridRaster(inStream);
            }

            public EsriAsciiGridRaster createAsciiGridRaster(ImageOutputStream oStream, AsciiGridsImageWriter writer) {
                return new EsriAsciiGridRaster(oStream, writer);
            }

            public EsriAsciiGridRaster createAsciiGridRaster(ImageOutputStream oStream) {
                return new EsriAsciiGridRaster(oStream);
            }

            public EsriAsciiGridRaster createAsciiGridRaster(ImageInputStream inStream, AsciiGridsImageReader reader) {
                return new EsriAsciiGridRaster(inStream, reader);
            }
        }
        ,
        GRASS{

            public GrassAsciiGridRaster createAsciiGridRaster(ImageInputStream inStream) {
                return new GrassAsciiGridRaster(inStream);
            }

            public GrassAsciiGridRaster createAsciiGridRaster(ImageOutputStream oStream, AsciiGridsImageWriter writer) {
                return new GrassAsciiGridRaster(oStream, writer);
            }

            public GrassAsciiGridRaster createAsciiGridRaster(ImageOutputStream oStream) {
                return new GrassAsciiGridRaster(oStream);
            }

            public GrassAsciiGridRaster createAsciiGridRaster(ImageInputStream inStream, AsciiGridsImageReader reader) {
                return new GrassAsciiGridRaster(inStream, reader);
            }
        };


        public abstract AsciiGridRaster createAsciiGridRaster(ImageInputStream var1);

        public abstract AsciiGridRaster createAsciiGridRaster(ImageOutputStream var1, AsciiGridsImageWriter var2);

        public abstract AsciiGridRaster createAsciiGridRaster(ImageOutputStream var1);

        public abstract AsciiGridRaster createAsciiGridRaster(ImageInputStream var1, AsciiGridsImageReader var2);

        public static AsciiGridRasterType getDefaultRasterType() {
            return UNDEFINED;
        }
    }
}

