/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep.utilint;

import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.rep.impl.RepImpl;
import com.sleepycat.je.rep.impl.TextProtocol;
import com.sleepycat.je.rep.impl.node.NameIdPair;
import com.sleepycat.je.rep.utilint.RepUtils;
import com.sleepycat.je.rep.utilint.ReplicationFormatter;
import com.sleepycat.je.utilint.LoggerUtils;
import com.sleepycat.je.utilint.StoppableThread;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceDispatcher
extends StoppableThread {
    private final InetSocketAddress socketAddress;
    private final Selector selector;
    private final ServerSocketChannel serverChannel;
    private boolean processAcceptRequests = true;
    private int errorCount = 0;
    private final Map<String, Service> serviceMap = new ConcurrentHashMap<String, Service>();
    private final ExecutorService pool = Executors.newCachedThreadPool();
    private final Logger logger;
    private final Formatter formatter;
    private static final String REQUEST_PREFIX = "Service:";
    private static final byte[] REQUEST_PREFIX_BYTES;
    private final RepImpl repImpl;
    private static final int INITIAL_BUFFER_SIZE;

    public ServiceDispatcher(InetSocketAddress socketAddress, RepImpl repImpl) throws IOException {
        super(repImpl, "ServiceDispatcher-" + socketAddress.getHostName() + ":" + socketAddress.getPort());
        this.repImpl = repImpl;
        this.socketAddress = socketAddress;
        this.serverChannel = ServerSocketChannel.open();
        this.serverChannel.configureBlocking(false);
        this.selector = Selector.open();
        this.serverChannel.register(this.selector, 16);
        ServerSocket acceptSocket = this.serverChannel.socket();
        acceptSocket.setSoTimeout(0);
        acceptSocket.bind(socketAddress);
        this.logger = repImpl == null ? LoggerUtils.getLoggerFormatterNeeded(this.getClass()) : LoggerUtils.getLogger(this.getClass());
        NameIdPair nameIdPair = repImpl == null ? NameIdPair.NULL : repImpl.getNameIdPair();
        this.formatter = new ReplicationFormatter(nameIdPair);
    }

    public ServiceDispatcher(InetSocketAddress socketAddress) throws IOException {
        this(socketAddress, null);
    }

    public void preShutdown() {
        this.processAcceptRequests = false;
    }

    public void shutdown() {
        if (this.shutdownDone()) {
            return;
        }
        LoggerUtils.logMsg(this.logger, this.repImpl, this.formatter, Level.INFO, "ServiceDispatcher shutdown starting. HostPort=" + this.socketAddress.getHostName() + ":" + this.socketAddress.getPort() + " Registered services: " + this.serviceMap.keySet());
        this.shutdownThread(this.logger);
        for (String serviceName : this.serviceMap.keySet()) {
            this.cancel(serviceName);
        }
        this.pool.shutdownNow();
        try {
            this.serverChannel.socket().close();
            this.selector.close();
        }
        catch (IOException e) {
            LoggerUtils.logMsg(this.logger, this.repImpl, this.formatter, Level.WARNING, "Ignoring I/O error during close: " + e.getMessage());
        }
        LoggerUtils.logMsg(this.logger, this.repImpl, this.formatter, Level.INFO, "ServiceDispatcher shutdown completed. HostPort=" + this.socketAddress.getHostName() + ":" + this.socketAddress.getPort());
    }

    @Override
    protected int initiateSoftShutdown() {
        this.selector.wakeup();
        return 0;
    }

    @Override
    protected Logger getLogger() {
        return this.logger;
    }

    private static byte[] serviceRequestMessage(String serviceName) {
        byte[] serviceNameBytes;
        try {
            serviceNameBytes = serviceName.getBytes("US-ASCII");
        }
        catch (UnsupportedEncodingException e) {
            throw EnvironmentFailureException.unexpectedException(e);
        }
        int length = REQUEST_PREFIX_BYTES.length + 1 + serviceNameBytes.length;
        ByteBuffer buffer = ByteBuffer.allocate(length);
        buffer.put(REQUEST_PREFIX_BYTES).put((byte)serviceNameBytes.length).put(serviceNameBytes);
        return buffer.array();
    }

    public static OutputStream getServiceOutputStream(Socket socket, String serviceName) throws IOException, ServiceConnectFailedException {
        assert (socket.isConnected());
        byte[] message = ServiceDispatcher.serviceRequestMessage(serviceName);
        OutputStream out = socket.getOutputStream();
        out.write(message);
        out.flush();
        InputStream in = socket.getInputStream();
        int result = in.read();
        if (result < 0) {
            throw new IOException("No service response byte: " + result);
        }
        Response response = Response.get(result);
        if (response == null) {
            throw new IOException("Unexpected read response byte: " + result);
        }
        if (response != Response.OK) {
            throw new ServiceConnectFailedException(serviceName, response);
        }
        return out;
    }

    public static void doServiceHandshake(SocketChannel channel, String serviceName) throws IOException, ServiceConnectFailedException {
        ByteBuffer message = ByteBuffer.wrap(ServiceDispatcher.serviceRequestMessage(serviceName));
        while (message.remaining() > 0) {
            channel.write(message);
        }
        ByteBuffer buffer = ByteBuffer.allocate(1);
        while (buffer.remaining() > 0) {
            if (channel.read(buffer) >= 0) continue;
            throw new IOException("EOF in response to service request:" + serviceName);
        }
        int result = channel.read(buffer);
        if (result < 0) {
            throw new IOException("No service response byte: " + result);
        }
        buffer.flip();
        Response response = Response.get(buffer.get());
        if (response == null) {
            throw new IOException("Unexpected read response byte: " + result);
        }
        if (response != Response.OK) {
            throw new ServiceConnectFailedException(serviceName, response);
        }
    }

    public SocketChannel takeChannel(String serviceName, boolean blocking, int soTimeout) throws InterruptedException {
        while (true) {
            Service service;
            if ((service = this.serviceMap.get(serviceName)) == null) {
                throw EnvironmentFailureException.unexpectedState("Service: " + serviceName + " was not registered");
            }
            if (!(service instanceof QueuingService)) {
                throw EnvironmentFailureException.unexpectedState("Service: " + serviceName + " is not a queuing service");
            }
            Socket socket = null;
            SocketChannel channel = null;
            try {
                channel = ((QueuingService)service).take();
                assert (channel != null);
                if (channel == RepUtils.CHANNEL_EOF_MARKER) {
                    return null;
                }
                channel.configureBlocking(blocking);
                socket = channel.socket();
                socket.setSoTimeout(soTimeout);
                return channel;
            }
            catch (IOException e) {
                LoggerUtils.logMsg(this.logger, this.repImpl, this.formatter, Level.WARNING, "Unable to configure channel for service: " + serviceName + "\n" + e.getMessage());
                try {
                    if (channel == null) continue;
                    channel.close();
                    continue;
                }
                catch (IOException e1) {
                    LoggerUtils.logMsg(this.logger, this.repImpl, this.formatter, Level.FINEST, "Cleanup failed for service: " + serviceName + "\n" + e.getMessage());
                    continue;
                }
            }
            break;
        }
    }

    public InetSocketAddress getSocketAddress() {
        return this.socketAddress;
    }

    public void register(String serviceName, BlockingQueue<SocketChannel> serviceQueue) {
        if (serviceName == null) {
            throw EnvironmentFailureException.unexpectedState("The serviceName argument must not be null");
        }
        if (this.serviceMap.containsKey(serviceName)) {
            throw EnvironmentFailureException.unexpectedState("Service: " + serviceName + " is already registered");
        }
        if (serviceQueue == null) {
            throw EnvironmentFailureException.unexpectedState("The serviceQueue argument must not be null");
        }
        this.serviceMap.put(serviceName, new QueuingService(serviceName, serviceQueue));
    }

    public void register(Service service) {
        if (service == null) {
            throw EnvironmentFailureException.unexpectedState("The service argument must not be null");
        }
        if (this.serviceMap.containsKey(service.name)) {
            throw EnvironmentFailureException.unexpectedState("Service: " + service.name + " is already registered");
        }
        LoggerUtils.logMsg(this.logger, this.repImpl, this.formatter, Level.FINE, "Service: " + service.name + " registered.");
        this.serviceMap.put(service.name, service);
    }

    public boolean isRegistered(String serviceName) {
        if (serviceName == null) {
            throw EnvironmentFailureException.unexpectedState("The serviceName argument must not be null");
        }
        return this.serviceMap.containsKey(serviceName);
    }

    public void cancel(String serviceName) {
        if (serviceName == null) {
            throw EnvironmentFailureException.unexpectedState("The serviceName argument must not be null.");
        }
        Service service = this.serviceMap.remove(serviceName);
        if (service == null) {
            throw EnvironmentFailureException.unexpectedState("Service: " + serviceName + " was not registered.");
        }
        service.cancel();
        LoggerUtils.logMsg(this.logger, this.repImpl, this.formatter, Level.FINE, "Service: " + serviceName + " shut down.");
    }

    private void processAccept() {
        SocketChannel socketChannel = null;
        try {
            socketChannel = this.serverChannel.accept();
            if (!this.processAcceptRequests) {
                this.closeChannel(socketChannel);
                return;
            }
            socketChannel.configureBlocking(false);
            socketChannel.register(this.selector, 1, ByteBuffer.allocate(INITIAL_BUFFER_SIZE));
        }
        catch (IOException e) {
            LoggerUtils.logMsg(this.logger, this.repImpl, this.formatter, Level.WARNING, "Server accept exception: " + e.getMessage());
            this.closeChannel(socketChannel);
        }
    }

    private String processRead(SelectionKey readKey) {
        SocketChannel socketChannel = null;
        try {
            ByteBuffer readBuffer = (ByteBuffer)readKey.attachment();
            socketChannel = (SocketChannel)readKey.channel();
            int readBytes = socketChannel.read(readBuffer);
            if (readBytes < 0) {
                ++this.errorCount;
                LoggerUtils.logMsg(this.logger, this.repImpl, this.formatter, Level.WARNING, "Premature EOF on channel: " + socketChannel + " read() returned: " + readBytes);
                socketChannel.close();
                return null;
            }
            if (readBuffer.remaining() == 0) {
                readBuffer.flip();
                if (readBuffer.capacity() == INITIAL_BUFFER_SIZE) {
                    String prefix = new String(readBuffer.array(), 0, REQUEST_PREFIX.length(), "US-ASCII");
                    if (!prefix.equals(REQUEST_PREFIX)) {
                        ++this.errorCount;
                        LoggerUtils.logMsg(this.logger, this.repImpl, this.formatter, Level.WARNING, "Malformed service request: " + prefix);
                        socketChannel.write(Response.FORMAT_ERROR.byteBuffer());
                        socketChannel.close();
                        return null;
                    }
                    byte nameLength = readBuffer.get(INITIAL_BUFFER_SIZE - 1);
                    if (nameLength <= 0) {
                        ++this.errorCount;
                        LoggerUtils.logMsg(this.logger, this.repImpl, this.formatter, Level.WARNING, "Bad service service name length: " + nameLength);
                        socketChannel.write(Response.FORMAT_ERROR.byteBuffer());
                        socketChannel.close();
                        return null;
                    }
                    ByteBuffer buffer = ByteBuffer.allocate(INITIAL_BUFFER_SIZE + nameLength);
                    buffer.put(readBuffer);
                    readKey.attach(buffer);
                    return this.processRead(readKey);
                }
                String request = new String(readBuffer.array(), "US-ASCII");
                readKey.cancel();
                return request.substring(REQUEST_PREFIX.length() + 1);
            }
            return null;
        }
        catch (IOException e) {
            LoggerUtils.logMsg(this.logger, this.repImpl, this.formatter, Level.WARNING, "Exception during read: " + e.getMessage());
            this.closeChannel(socketChannel);
            return null;
        }
    }

    private void closeChannel(Channel channel) {
        if (channel != null) {
            try {
                channel.close();
            }
            catch (IOException e1) {
                LoggerUtils.logMsg(this.logger, this.repImpl, this.formatter, Level.WARNING, "Exception during cleanup: " + e1.getMessage());
            }
        }
    }

    @Override
    public void run() {
        LoggerUtils.logMsg(this.logger, this.repImpl, this.formatter, Level.INFO, "Started ServiceDispatcher. HostPort=" + this.socketAddress.getHostName() + ":" + this.socketAddress.getPort());
        try {
            while (true) {
                int result = this.selector.select();
                if (this.isShutdown()) {
                    return;
                }
                try {
                    if (result == 0) {
                        continue;
                    }
                }
                catch (IOException e) {
                    LoggerUtils.logMsg(this.logger, this.repImpl, this.formatter, Level.SEVERE, "Server socket exception " + e.getMessage());
                    throw EnvironmentFailureException.unexpectedException(e);
                }
                Set<SelectionKey> skeys = this.selector.selectedKeys();
                for (SelectionKey key : skeys) {
                    switch (key.readyOps()) {
                        case 16: {
                            this.processAccept();
                            break;
                        }
                        case 1: {
                            String serviceName = this.processRead(key);
                            if (serviceName == null) break;
                            key.cancel();
                            this.processService((SocketChannel)key.channel(), serviceName);
                            break;
                        }
                        default: {
                            throw EnvironmentFailureException.unexpectedState("Unexpected ops bit set: " + key.readyOps());
                        }
                    }
                }
                skeys.clear();
            }
        }
        finally {
            this.closeChannel(this.serverChannel);
            this.cleanup();
        }
    }

    private void processService(SocketChannel channel, String serviceName) {
        Service service = this.serviceMap.get(serviceName);
        try {
            if (service == null) {
                ++this.errorCount;
                channel.write(Response.UNKNOWN_SERVICE.byteBuffer());
                this.closeChannel(channel);
                LoggerUtils.logMsg(this.logger, this.repImpl, this.formatter, Level.INFO, "Request for unknown Service: " + serviceName + " Registered services: " + this.serviceMap.keySet());
                return;
            }
            Response response = service.isBusy() ? Response.BUSY : Response.OK;
            LoggerUtils.logMsg(this.logger, this.repImpl, this.formatter, Level.FINE, "Service response: " + (Object)((Object)response) + " for service: " + service.name);
            if (channel.write(response.byteBuffer()) == 0) {
                throw EnvironmentFailureException.unexpectedState("Failed to write byte. Send buffer size: " + channel.socket().getSendBufferSize());
            }
            if (response == Response.OK) {
                service.requestDispatch(channel);
            }
        }
        catch (IOException e) {
            this.closeChannel(channel);
            LoggerUtils.logMsg(this.logger, this.repImpl, this.formatter, Level.WARNING, "IO error writing to channel for service: " + serviceName + e.getMessage());
        }
    }

    static {
        try {
            REQUEST_PREFIX_BYTES = REQUEST_PREFIX.getBytes("US-ASCII");
        }
        catch (UnsupportedEncodingException e) {
            throw EnvironmentFailureException.unexpectedException(e);
        }
        INITIAL_BUFFER_SIZE = REQUEST_PREFIX_BYTES.length + 1;
    }

    public static abstract class ExecutingRunnable
    implements Runnable {
        protected final SocketChannel channel;
        protected final TextProtocol protocol;
        protected final boolean expectResponse;

        public ExecutingRunnable(SocketChannel channel, TextProtocol protocol, boolean expectResponse) {
            this.channel = channel;
            this.protocol = protocol;
            this.expectResponse = expectResponse;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                this.channel.configureBlocking(true);
                TextProtocol.RequestMessage request = this.protocol.getRequestMessage(this.channel);
                if (request == null) {
                    return;
                }
                TextProtocol.ResponseMessage response = this.getResponse(request);
                if (this.expectResponse) {
                    PrintWriter out = new PrintWriter(this.channel.socket().getOutputStream(), true);
                    out.println(response.wireFormat());
                } else assert (response == null);
            }
            catch (IOException e) {
                this.logMessage("IO error on socket: " + e.getMessage());
                return;
            }
            finally {
                if (this.channel.isOpen()) {
                    try {
                        this.channel.close();
                    }
                    catch (IOException e) {
                        this.logMessage("IO error on socket: " + e.getMessage());
                        return;
                    }
                }
            }
        }

        protected abstract TextProtocol.ResponseMessage getResponse(TextProtocol.RequestMessage var1) throws IOException;

        protected abstract void logMessage(String var1);
    }

    public static class ServiceConnectFailedException
    extends Exception {
        final Response response;
        final String serviceName;

        ServiceConnectFailedException(String serviceName, Response response) {
            assert (response != Response.OK);
            this.response = response;
            this.serviceName = serviceName;
        }

        public Response getResponse() {
            return this.response;
        }

        public String getMessage() {
            switch (this.response) {
                case FORMAT_ERROR: {
                    return "Bad message format, for service:" + this.serviceName;
                }
                case UNKNOWN_SERVICE: {
                    return "Unknown service request:" + this.serviceName;
                }
                case BUSY: {
                    return "Service was busy";
                }
            }
            throw EnvironmentFailureException.unexpectedState("Unexpected response:" + (Object)((Object)this.response) + " for service:" + this.serviceName);
        }
    }

    public static abstract class ExecutingService
    extends Service {
        private final ServiceDispatcher dispatcher;

        public ExecutingService(String serviceName, ServiceDispatcher dispatcher) {
            super(serviceName);
            this.dispatcher = dispatcher;
        }

        public abstract Runnable getRunnable(SocketChannel var1);

        void requestDispatch(SocketChannel channel) {
            this.dispatcher.pool.execute(this.getRunnable(channel));
        }

        void cancel() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class LazyQueuingService
    extends QueuingService {
        private final Thread serviceThread;

        public LazyQueuingService(String serviceName, BlockingQueue<SocketChannel> queue, Thread serviceThread) {
            super(serviceName, queue);
            this.serviceThread = serviceThread;
        }

        @Override
        void requestDispatch(SocketChannel channel) {
            switch (this.serviceThread.getState()) {
                case NEW: {
                    this.serviceThread.start();
                    LoggerUtils.logMsg(ServiceDispatcher.this.logger, ServiceDispatcher.this.repImpl, ServiceDispatcher.this.formatter, Level.FINE, "Thread started for service: " + this.name);
                    break;
                }
                case RUNNABLE: 
                case TIMED_WAITING: 
                case WAITING: 
                case BLOCKED: {
                    LoggerUtils.logMsg(ServiceDispatcher.this.logger, ServiceDispatcher.this.repImpl, ServiceDispatcher.this.formatter, Level.FINE, "Thread started for service: " + this.name);
                    break;
                }
                default: {
                    EnvironmentFailureException e = EnvironmentFailureException.unexpectedState("Thread for service:" + this.name + "is in state:" + (Object)((Object)this.serviceThread.getState()));
                    LoggerUtils.logMsg(ServiceDispatcher.this.logger, ServiceDispatcher.this.repImpl, ServiceDispatcher.this.formatter, Level.WARNING, ((Throwable)e).getMessage());
                    throw e;
                }
            }
            super.requestDispatch(channel);
        }

        @Override
        void cancel() {
            if (this.serviceThread.isAlive()) {
                this.serviceThread.interrupt();
                try {
                    this.serviceThread.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            super.cancel();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class QueuingService
    extends Service {
        private final BlockingQueue<SocketChannel> queue;

        QueuingService(String serviceName, BlockingQueue<SocketChannel> queue) {
            super(serviceName);
            this.queue = queue;
        }

        SocketChannel take() throws InterruptedException {
            return this.queue.take();
        }

        @Override
        void requestDispatch(SocketChannel channel) {
            if (!this.queue.add(channel)) {
                throw EnvironmentFailureException.unexpectedState("request queue overflow");
            }
        }

        @Override
        void cancel() {
            for (SocketChannel channel : this.queue) {
                try {
                    channel.close();
                }
                catch (IOException iOException) {}
            }
            this.queue.add(RepUtils.CHANNEL_EOF_MARKER);
        }
    }

    private static abstract class Service {
        final String name;

        public Service(String name) {
            if (name == null) {
                throw EnvironmentFailureException.unexpectedState("Service name was null");
            }
            this.name = name;
        }

        abstract void requestDispatch(SocketChannel var1);

        public boolean isBusy() {
            return false;
        }

        abstract void cancel();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Response {
        OK,
        BUSY,
        FORMAT_ERROR,
        UNKNOWN_SERVICE;


        ByteBuffer byteBuffer() {
            ByteBuffer buffer = ByteBuffer.allocate(1);
            buffer.put((byte)this.ordinal());
            buffer.flip();
            return buffer;
        }

        static Response get(int ordinal) {
            if (ordinal < Response.values().length) {
                return Response.values()[ordinal];
            }
            return null;
        }
    }
}

