/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.dbi;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.DbInternal;
import com.sleepycat.je.EnvironmentConfig;
import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.EnvironmentLockedException;
import com.sleepycat.je.EnvironmentMutableConfig;
import com.sleepycat.je.EnvironmentNotFoundException;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.dbi.RepConfigProxy;
import com.sleepycat.je.latch.LatchSupport;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DbEnvPool {
    private static DbEnvPool pool = new DbEnvPool();
    private final Map<String, EnvironmentImpl> envs = new HashMap<String, EnvironmentImpl>();
    private final Set<EnvironmentImpl> sharedCacheEnvs = new HashSet<EnvironmentImpl>();

    private DbEnvPool() {
    }

    public static DbEnvPool getInstance() {
        return pool;
    }

    public synchronized int getNSharedCacheEnvironments() {
        return this.sharedCacheEnvs.size();
    }

    private EnvironmentImpl getAnySharedCacheEnv() {
        Iterator<EnvironmentImpl> iter = this.sharedCacheEnvs.iterator();
        return iter.hasNext() ? iter.next() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EnvironmentImpl getEnvironment(File envHome, EnvironmentConfig config, boolean checkImmutableParams, boolean openIfNeeded, RepConfigProxy repConfigProxy) throws EnvironmentNotFoundException, EnvironmentLockedException {
        EnvironmentImpl envImpl;
        block17: {
            String environmentKey = null;
            envImpl = null;
            DbEnvPool dbEnvPool = this;
            synchronized (dbEnvPool) {
                environmentKey = this.getEnvironmentMapKey(envHome);
                envImpl = this.envs.get(environmentKey);
                if (envImpl != null) {
                    if (!envImpl.isReplicated() && repConfigProxy != null) {
                        throw new UnsupportedOperationException("This environment was previously opened as a standalone environment. It cannot be re-opened for replication.");
                    }
                    if (envImpl.isReplicated() && repConfigProxy == null && !config.getReadOnly()) {
                        throw new UnsupportedOperationException("This environment was previously opened for replication. It cannot be re-opened in read/write mode for standalone operation.");
                    }
                    envImpl.checkIfInvalid();
                    if (checkImmutableParams) {
                        envImpl.checkImmutablePropsForEquality(DbInternal.getProps(config));
                    }
                    envImpl.incReferenceCount();
                } else if (openIfNeeded) {
                    EnvironmentImpl sharedCacheEnv = config.getSharedCache() ? this.getAnySharedCacheEnv() : null;
                    EnvironmentImpl environmentImpl = envImpl = repConfigProxy == null ? new EnvironmentImpl(envHome, config, sharedCacheEnv) : this.loadRepImpl(envHome, config, sharedCacheEnv, repConfigProxy);
                    assert (config.getSharedCache() == envImpl.getSharedCache());
                    envImpl.incReferenceCount();
                    this.envs.put(environmentKey, envImpl);
                }
            }
            if (envImpl != null) {
                boolean success = false;
                try {
                    envImpl.finishInit(config);
                    DbEnvPool dbEnvPool2 = this;
                    synchronized (dbEnvPool2) {
                        this.addToSharedCacheEnvs(envImpl);
                    }
                    success = true;
                    Object var13_13 = null;
                    if (success) break block17;
                    this.envs.remove(environmentKey);
                }
                catch (Throwable throwable) {
                    Object var13_14 = null;
                    if (!success) {
                        this.envs.remove(environmentKey);
                    }
                    throw throwable;
                }
                {
                }
            }
        }
        return envImpl;
    }

    private EnvironmentImpl loadRepImpl(File envHome, EnvironmentConfig config, EnvironmentImpl sharedCacheEnv, RepConfigProxy repConfigProxy) throws DatabaseException {
        String repClassName = "com.sleepycat.je.rep.impl.RepImpl";
        String envImplName = "com.sleepycat.je.dbi.EnvironmentImpl";
        String repProxy = "com.sleepycat.je.dbi.RepConfigProxy";
        try {
            Class<?> repClass = Class.forName("com.sleepycat.je.rep.impl.RepImpl");
            return (EnvironmentImpl)repClass.getConstructor(envHome.getClass(), config.getClass(), Class.forName("com.sleepycat.je.dbi.EnvironmentImpl"), Class.forName("com.sleepycat.je.dbi.RepConfigProxy")).newInstance(envHome, config, sharedCacheEnv, repConfigProxy);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw EnvironmentFailureException.unexpectedException(e);
        }
        catch (Exception e) {
            throw EnvironmentFailureException.unexpectedException(e);
        }
    }

    private void addToSharedCacheEnvs(EnvironmentImpl envImpl) throws DatabaseException {
        if (envImpl.getSharedCache() && !this.sharedCacheEnvs.contains(envImpl)) {
            this.sharedCacheEnvs.add(envImpl);
            assert (envImpl.getEvictor().checkEnv(envImpl));
            this.resetSharedCache(-1L, envImpl);
        }
    }

    synchronized void setMutableConfig(EnvironmentImpl envImpl, EnvironmentMutableConfig mutableConfig) throws DatabaseException {
        envImpl.doSetMutableConfig(mutableConfig);
        if (envImpl.getSharedCache()) {
            this.resetSharedCache(envImpl.getMemoryBudget().getMaxMemory(), envImpl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void closeEnvironment(EnvironmentImpl envImpl, boolean doCheckpoint, boolean isAbnormalClose) {
        if (envImpl.decReferenceCount()) {
            try {
                envImpl.doClose(doCheckpoint, isAbnormalClose);
                Object var5_4 = null;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                this.removeEnvironment(envImpl);
                throw throwable;
            }
            this.removeEnvironment(envImpl);
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void closeEnvironmentAfterInvalid(EnvironmentImpl envImpl) throws DatabaseException {
        try {
            envImpl.doCloseAfterInvalid();
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.removeEnvironment(envImpl);
            throw throwable;
        }
        this.removeEnvironment(envImpl);
    }

    private void removeEnvironment(EnvironmentImpl envImpl) throws DatabaseException {
        boolean found;
        String environmentKey = this.getEnvironmentMapKey(envImpl.getEnvironmentHome());
        boolean bl = found = this.envs.remove(environmentKey) != null;
        if (this.sharedCacheEnvs.remove(envImpl)) {
            assert (found && envImpl.getSharedCache());
            assert (!envImpl.getEvictor().checkEnv(envImpl));
            if (this.sharedCacheEnvs.isEmpty()) {
                envImpl.getEvictor().shutdown();
            } else {
                envImpl.getMemoryBudget().subtractCacheUsage();
                this.resetSharedCache(-1L, null);
            }
        } else assert (!found || !envImpl.getSharedCache());
        if (this.envs.isEmpty()) {
            LatchSupport.clearNotes();
        }
    }

    public synchronized void clear() {
        this.envs.clear();
    }

    public synchronized Collection<EnvironmentImpl> getEnvImpls() {
        return this.envs.values();
    }

    String getEnvironmentMapKey(File file) throws DatabaseException {
        try {
            return file.getCanonicalPath();
        }
        catch (IOException e) {
            throw EnvironmentFailureException.unexpectedException(e);
        }
    }

    private void resetSharedCache(long newMaxMemory, EnvironmentImpl skipEnv) throws DatabaseException {
        for (EnvironmentImpl envImpl : this.sharedCacheEnvs) {
            if (envImpl == skipEnv) continue;
            envImpl.getMemoryBudget().reset(newMaxMemory, false, envImpl.getConfigManager());
        }
    }
}

