/*
 * Decompiled with CFR 0.152.
 */
package jaitools.numeric;

public class CompareOp {
    public static final double DTOL = 1.0E-8;
    public static final float FTOL = 1.0E-4f;

    public static boolean isZero(double x) {
        return Math.abs(x) < 1.0E-8;
    }

    public static boolean isZero(float x) {
        return Math.abs(x) < 1.0E-4f;
    }

    public static boolean isZero(double x, double tol) {
        return Math.abs(x) < tol;
    }

    public static boolean isZero(float x, float tol) {
        return Math.abs(x) < tol;
    }

    public static int acompare(double x1, double x2) {
        if (CompareOp.isZero(x1 - x2)) {
            return 0;
        }
        return Double.compare(x1, x2);
    }

    public static int acompare(float x1, float x2) {
        if (CompareOp.isZero(x1 - x2)) {
            return 0;
        }
        return Float.compare(x1, x2);
    }

    public static int acompare(double x1, double x2, double tol) {
        if (CompareOp.isZero(x1 - x2, tol)) {
            return 0;
        }
        return Double.compare(x1, x2);
    }

    public static int acompare(float x1, float x2, float tol) {
        if (CompareOp.isZero(x1 - x2, tol)) {
            return 0;
        }
        return Float.compare(x1, x2);
    }

    public static int pcompare(double x1, double x2, double propTol) {
        if (CompareOp.aequal(x1, x2)) {
            return 0;
        }
        int comp = CompareOp.acompare(Math.abs(x1), Math.abs(x2));
        double absTol = Math.abs(propTol) * (comp > 0 ? x1 : x2);
        return CompareOp.acompare(x1, x2, absTol);
    }

    public static int pcompare(float x1, float x2, float propTol) {
        if (CompareOp.aequal(x1, x2)) {
            return 0;
        }
        int comp = CompareOp.acompare(Math.abs(x1), Math.abs(x2));
        double absTol = Math.abs(propTol) * (comp > 0 ? x1 : x2);
        return CompareOp.acompare((double)x1, (double)x2, absTol);
    }

    public static boolean aequal(double x1, double x2) {
        return CompareOp.isZero(x1 - x2);
    }

    public static boolean aequal(float x1, float x2) {
        return CompareOp.isZero(x1 - x2);
    }

    public static boolean aequal(double x1, double x2, double tol) {
        return CompareOp.isZero(x1 - x2, tol);
    }

    public static boolean aequal(float x1, float x2, float tol) {
        return CompareOp.isZero(x1 - x2, tol);
    }

    public static boolean pequal(double x1, double x2, double propTol) {
        if (CompareOp.aequal(x1, x2)) {
            return true;
        }
        int comp = CompareOp.acompare(Math.abs(x1), Math.abs(x2));
        double absTol = Math.abs(propTol) * (comp > 0 ? x1 : x2);
        return CompareOp.aequal(x1, x2, absTol);
    }

    public static boolean pequal(float x1, float x2, float propTol) {
        if (CompareOp.aequal(x1, x2)) {
            return true;
        }
        int comp = CompareOp.acompare(Math.abs(x1), Math.abs(x2));
        double absTol = Math.abs(propTol) * (comp > 0 ? x1 : x2);
        return CompareOp.aequal((double)x1, (double)x2, absTol);
    }
}

