/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.security.service;

import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.Page;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.geoserver.security.impl.ServiceAccessRule;
import org.geoserver.web.GeoServerSecuredPage;
import org.geoserver.web.security.SelectionServiceRemovalLink;
import org.geoserver.web.security.service.EditServiceAccessRulePage;
import org.geoserver.web.security.service.NewServiceAccessRulePage;
import org.geoserver.web.security.service.ServiceAccessRuleProvider;
import org.geoserver.web.wicket.GeoServerDataProvider;
import org.geoserver.web.wicket.GeoServerDialog;
import org.geoserver.web.wicket.GeoServerTablePanel;
import org.geoserver.web.wicket.SimpleAjaxLink;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceAccessRulePage
extends GeoServerSecuredPage {
    private GeoServerTablePanel<ServiceAccessRule> rules;
    private SelectionServiceRemovalLink removal;
    GeoServerDialog dialog;

    public ServiceAccessRulePage() {
        ServiceAccessRuleProvider provider = new ServiceAccessRuleProvider();
        Component[] componentArray = new Component[1];
        this.rules = new GeoServerTablePanel<ServiceAccessRule>("table", (GeoServerDataProvider)provider, true){

            protected Component getComponentForProperty(String id, IModel itemModel, GeoServerDataProvider.Property<ServiceAccessRule> property) {
                if (property == ServiceAccessRuleProvider.RULEKEY) {
                    return ServiceAccessRulePage.this.editRuleLink(id, itemModel, property);
                }
                if (property == ServiceAccessRuleProvider.ROLES) {
                    return new Label(id, property.getModel(itemModel));
                }
                throw new RuntimeException("Uknown property " + property);
            }

            protected void onSelectionUpdate(AjaxRequestTarget target) {
                ServiceAccessRulePage.this.removal.setEnabled(ServiceAccessRulePage.this.rules.getSelection().size() > 0);
                target.addComponent((Component)ServiceAccessRulePage.this.removal);
            }
        };
        componentArray[0] = this.rules;
        this.add(componentArray);
        this.rules.setOutputMarkupId(true);
        Component[] componentArray2 = new Component[1];
        this.dialog = new GeoServerDialog("dialog");
        componentArray2[0] = this.dialog;
        this.add(componentArray2);
        this.setHeaderPanel(this.headerPanel());
    }

    protected Component headerPanel() {
        Fragment header = new Fragment("headerPanel", "header", (MarkupContainer)this);
        header.add(new Component[]{new BookmarkablePageLink("addNew", NewServiceAccessRulePage.class)});
        Component[] componentArray = new Component[1];
        this.removal = new SelectionServiceRemovalLink("removeSelected", this.rules, this.dialog);
        componentArray[0] = this.removal;
        header.add(componentArray);
        this.removal.setOutputMarkupId(true);
        this.removal.setEnabled(false);
        return header;
    }

    AjaxLink addRuleLink() {
        return new AjaxLink("addRule", (IModel)new Model()){

            public void onClick(AjaxRequestTarget target) {
                this.setResponsePage((Page)new NewServiceAccessRulePage());
            }
        };
    }

    Component editRuleLink(String id, IModel itemModel, GeoServerDataProvider.Property<ServiceAccessRule> property) {
        return new SimpleAjaxLink(id, itemModel, property.getModel(itemModel)){

            protected void onClick(AjaxRequestTarget target) {
                this.setResponsePage((Page)new EditServiceAccessRulePage((ServiceAccessRule)this.getDefaultModelObject()));
            }
        };
    }
}

