/*
 * Decompiled with CFR 0.152.
 */
package net.sf.json;

import net.sf.json.JSON;
import net.sf.json.JSONArray;
import net.sf.json.JSONException;
import net.sf.json.JSONNull;
import net.sf.json.JSONObject;
import net.sf.json.JSONString;
import net.sf.json.JsonConfig;
import net.sf.json.util.JSONTokener;
import net.sf.json.util.JSONUtils;

public class JSONSerializer {
    public static Object toJava(JSON json) {
        return JSONSerializer.toJava(json, new JsonConfig());
    }

    public static Object toJava(JSON json, JsonConfig jsonConfig) {
        if (JSONUtils.isNull(json)) {
            return null;
        }
        Object object = null;
        object = json instanceof JSONArray ? (jsonConfig.getArrayMode() == 2 ? JSONArray.toArray((JSONArray)json, jsonConfig) : JSONArray.toList((JSONArray)json, jsonConfig)) : JSONObject.toBean((JSONObject)json, jsonConfig);
        return object;
    }

    public static JSON toJSON(Object object) {
        return JSONSerializer.toJSON(object, new JsonConfig());
    }

    public static JSON toJSON(Object object, JsonConfig jsonConfig) {
        JSON json = null;
        if (object == null) {
            json = JSONNull.getInstance();
        } else if (object instanceof JSONString) {
            json = JSONSerializer.toJSON((JSONString)object, jsonConfig);
        } else if (object instanceof String) {
            json = JSONSerializer.toJSON((String)object, jsonConfig);
        } else if (JSONUtils.isArray(object)) {
            json = JSONArray.fromObject(object, jsonConfig);
        } else {
            try {
                json = JSONObject.fromObject(object, jsonConfig);
            }
            catch (JSONException e) {
                if (object instanceof JSONTokener) {
                    ((JSONTokener)object).reset();
                }
                json = JSONArray.fromObject(object, jsonConfig);
            }
        }
        return json;
    }

    private static JSON toJSON(JSONString string, JsonConfig jsonConfig) {
        return JSONSerializer.toJSON(string.toJSONString(), jsonConfig);
    }

    private static JSON toJSON(String string, JsonConfig jsonConfig) {
        JSON json = null;
        if (string.startsWith("[")) {
            json = JSONArray.fromObject(string, jsonConfig);
        } else if (string.startsWith("{")) {
            json = JSONObject.fromObject(string, jsonConfig);
        } else if ("null".equalsIgnoreCase(string)) {
            json = JSONNull.getInstance();
        } else {
            throw new JSONException("Invalid JSON String");
        }
        return json;
    }
}

