/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.wicket.browser;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.extensions.ajax.markup.html.IndicatingAjaxFallbackLink;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;

public abstract class FileBreadcrumbs
extends Panel {
    IModel rootFile;

    public FileBreadcrumbs(String id, IModel rootFile, IModel currentFile) {
        super(id, currentFile);
        this.rootFile = rootFile;
        this.add(new Component[]{new ListView("path", new BreadcrumbModel(rootFile, currentFile)){

            protected void populateItem(ListItem item) {
                File file = (File)item.getModelObject();
                boolean last = item.getIndex() == this.getList().size() - 1;
                Label name = new Label("pathItem", file.getName() + "/");
                IndicatingAjaxFallbackLink link = new IndicatingAjaxFallbackLink("pathItemLink", item.getModel()){

                    public void onClick(AjaxRequestTarget target) {
                        FileBreadcrumbs.this.pathItemClicked((File)this.getModelObject(), target);
                    }
                };
                link.add(new Component[]{name});
                item.add(new Component[]{link});
                link.setEnabled(!last);
            }
        }});
    }

    public void setRootFile(File root) {
        this.rootFile.setObject((Object)root);
    }

    public void setSelection(File selection) {
        this.setDefaultModelObject(selection);
    }

    protected abstract void pathItemClicked(File var1, AjaxRequestTarget var2);

    static class BreadcrumbModel
    implements IModel {
        IModel rootFileModel;
        IModel currentFileModel;

        public BreadcrumbModel(IModel rootFileModel, IModel currentFileModel) {
            this.rootFileModel = rootFileModel;
            this.currentFileModel = currentFileModel;
        }

        public Object getObject() {
            File current;
            File root = (File)this.rootFileModel.getObject();
            ArrayList<File> files = new ArrayList<File>();
            for (current = (File)this.currentFileModel.getObject(); current != null && !current.equals(root); current = current.getParentFile()) {
                files.add(current);
            }
            if (current != null && current.equals(root)) {
                files.add(root);
            }
            Collections.reverse(files);
            return files;
        }

        public void setObject(Object object) {
            throw new UnsupportedOperationException("This model cannot be set!");
        }

        public void detach() {
        }
    }
}

