/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.wicket;

import org.apache.wicket.Component;
import org.apache.wicket.RequestCycle;
import org.apache.wicket.ResourceReference;
import org.apache.wicket.behavior.AbstractBehavior;
import org.apache.wicket.markup.html.IHeaderResponse;
import org.apache.wicket.protocol.http.WebRequest;

public class EditAreaBehavior
extends AbstractBehavior {
    public static final ResourceReference REFERENCE = new ResourceReference(EditAreaBehavior.class, "js/editarea/edit_area_full.js");
    private Component component;
    private String syntax;

    public EditAreaBehavior() {
        this("xml");
    }

    public EditAreaBehavior(String syntax) {
        this.syntax = syntax;
    }

    public void renderHead(IHeaderResponse response) {
        String renderJavaScript;
        super.renderHead(response);
        response.renderJavascriptReference(REFERENCE);
        String renderOnDomReady = this.getRenderOnDomReadyJavascript(response);
        if (renderOnDomReady != null) {
            response.renderOnDomReadyJavascript(renderOnDomReady);
        }
        if ((renderJavaScript = this.getRenderJavascript(response)) != null) {
            response.renderJavascript((CharSequence)renderJavaScript, null);
        }
    }

    protected String getRenderOnDomReadyJavascript(IHeaderResponse response) {
        if (this.component == null) {
            throw new IllegalStateException("TinyMceBehavior is not bound to a component");
        }
        if (!this.mayRenderJavascriptDirect()) {
            return this.getEditAreaInitJavascript();
        }
        return null;
    }

    private String getEditAreaInitJavascript() {
        return "editAreaLoader.init({id : \"" + this.component.getMarkupId() + "\"," + "syntax: \"" + this.syntax + "\"," + "start_highlight: true," + "allow_toggle: false," + "font_size: 8," + "min_width: 700," + "min_height: 500," + "allow_resize: true," + "cursor_position: \"begin\"});";
    }

    private boolean mayRenderJavascriptDirect() {
        return RequestCycle.get().getRequest() instanceof WebRequest && !((WebRequest)RequestCycle.get().getRequest()).isAjax();
    }

    protected String getRenderJavascript(IHeaderResponse response) {
        if (this.component == null) {
            throw new IllegalStateException("EditAreaBehavior is not bound to a component");
        }
        if (this.mayRenderJavascriptDirect()) {
            return this.getEditAreaInitJavascript();
        }
        return null;
    }

    public void bind(Component component) {
        if (this.component != null) {
            throw new IllegalStateException("TinyMceBehavior can not bind to more than one component");
        }
        super.bind(component);
        component.setOutputMarkupId(true);
        this.component = component;
    }
}

