/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.wicket;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.wicket.Component;
import org.apache.wicket.ResourceReference;
import org.apache.wicket.behavior.AbstractBehavior;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.markup.html.IHeaderResponse;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.FormComponentPanel;
import org.apache.wicket.markup.html.form.TextArea;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CodeMirrorEditor
extends FormComponentPanel<String> {
    public static final ResourceReference REFERENCE = new ResourceReference(CodeMirrorEditor.class, "js/codemirror/js/codemirror.js");
    private TextArea<String> editor;
    private WebMarkupContainer container = new WebMarkupContainer("editorContainer");

    public CodeMirrorEditor(String id, IModel<String> model) {
        super(id, model);
        this.container.setOutputMarkupId(true);
        this.add(new Component[]{this.container});
        this.editor = new TextArea("editor", (IModel)new Model((Serializable)((Object)((String)model.getObject()))));
        this.container.add(new Component[]{this.editor});
        this.editor.setOutputMarkupId(true);
        this.editor.add(new IBehavior[]{new CodeMirrorBehavior()});
    }

    protected void onBeforeRender() {
        this.editor.setModelObject(this.getModelObject());
        super.onBeforeRender();
    }

    protected void convertInput() {
        this.editor.processInput();
        this.setConvertedInput(this.editor.getConvertedInput());
    }

    public String getInput() {
        return this.editor.getInput();
    }

    public void setTextAreaMarkupId(String id) {
        this.editor.setMarkupId(id);
    }

    public String getTextAreaMarkupId() {
        return this.editor.getMarkupId();
    }

    public void reset() {
        super.validate();
        this.editor.validate();
        this.editor.clearInput();
    }

    class CodeMirrorBehavior
    extends AbstractBehavior {
        CodeMirrorBehavior() {
        }

        public void renderHead(IHeaderResponse response) {
            super.renderHead(response);
            response.renderJavascriptReference(REFERENCE);
            response.renderOnDomReadyJavascript(this.getInitJavascript());
        }

        private String getInitJavascript() {
            InputStream is = CodeMirrorEditor.class.getResourceAsStream("CodeMirrorEditor.js");
            String js = this.convertStreamToString(is);
            js = js.replaceAll("\\$componentId", CodeMirrorEditor.this.editor.getMarkupId());
            js = js.replaceAll("\\$syntax", "parsexml.js");
            js = js.replaceAll("\\$container", CodeMirrorEditor.this.container.getMarkupId());
            js = js.replaceAll("\\$stylesheet", "./resources/org.geoserver.web.wicket.CodeMirrorEditor/js/codemirror/css/xmlcolors.css");
            return js;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String convertStreamToString(InputStream is) {
            try {
                if (is != null) {
                    StringWriter writer = new StringWriter();
                    char[] buffer = new char[1024];
                    try {
                        int n;
                        BufferedReader reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
                        while ((n = reader.read(buffer)) != -1) {
                            ((Writer)writer).write(buffer, 0, n);
                        }
                    }
                    finally {
                        is.close();
                    }
                    return ((Object)writer).toString();
                }
                return "";
            }
            catch (IOException e) {
                throw new RuntimeException("Did not expect this one...", e);
            }
        }
    }
}

