/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.services;

import java.util.Iterator;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Button;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.SubmitLink;
import org.apache.wicket.markup.html.form.TextArea;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.StringResourceModel;
import org.apache.wicket.validation.IValidator;
import org.apache.wicket.validation.validator.UrlValidator;
import org.geoserver.config.ServiceInfo;
import org.geoserver.web.GeoServerHomePage;
import org.geoserver.web.GeoServerSecuredPage;
import org.geoserver.web.services.AdminPagePanel;
import org.geoserver.web.services.AdminPagePanelInfo;
import org.geoserver.web.wicket.KeywordsEditor;
import org.geoserver.web.wicket.LiveCollectionModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseServiceAdminPage<T extends ServiceInfo>
extends GeoServerSecuredPage {
    public BaseServiceAdminPage() {
        LoadableDetachableModel infoModel = new LoadableDetachableModel(){

            public Object load() {
                return BaseServiceAdminPage.this.getGeoServer().getService(BaseServiceAdminPage.this.getServiceClass());
            }
        };
        Form form = new Form("form", (IModel)new CompoundPropertyModel((Object)infoModel));
        this.add(new Component[]{form});
        form.add(new Component[]{new Label("service.enabled", (IModel)new StringResourceModel("service.enabled", (Component)this, null, new Object[]{this.getServiceName()}))});
        form.add(new Component[]{new TextField("maintainer")});
        TextField onlineResource = new TextField("onlineResource");
        onlineResource.add((IValidator)new UrlValidator());
        form.add(new Component[]{onlineResource});
        form.add(new Component[]{new CheckBox("enabled")});
        form.add(new Component[]{new CheckBox("citeCompliant")});
        form.add(new Component[]{new TextField("title")});
        form.add(new Component[]{new TextArea("abstract")});
        form.add(new Component[]{new KeywordsEditor("keywords", LiveCollectionModel.list((IModel)new PropertyModel((Object)infoModel, "keywords")))});
        form.add(new Component[]{new TextField("fees")});
        form.add(new Component[]{new TextField("accessConstraints")});
        this.build((IModel)infoModel, form);
        ListView extensionPanels = this.createExtensionPanelList("extensions", (IModel)infoModel);
        form.add(new Component[]{extensionPanels});
        SubmitLink submit = new SubmitLink("submit", (IModel)new StringResourceModel("save", (Component)null, null), (IModel)infoModel){
            final /* synthetic */ IModel val$infoModel;
            {
                this.val$infoModel = iModel;
                super(x0, x1);
            }

            public void onSubmit() {
                BaseServiceAdminPage.this.handleSubmit((ServiceInfo)this.val$infoModel.getObject());
                this.setResponsePage(GeoServerHomePage.class);
            }
        };
        form.add(new Component[]{submit});
        Button cancel = new Button("cancel", (IModel)new StringResourceModel("cancel", (Component)null, null)){

            public void onSubmit() {
                this.setResponsePage(GeoServerHomePage.class);
            }
        };
        form.add(new Component[]{cancel});
    }

    protected ListView createExtensionPanelList(String id, final IModel infoModel) {
        List<AdminPagePanelInfo> panels = this.getGeoServerApplication().getBeansOfType(AdminPagePanelInfo.class);
        Iterator<AdminPagePanelInfo> it = panels.iterator();
        while (it.hasNext()) {
            AdminPagePanelInfo panel = it.next();
            if (this.getServiceClass().equals(panel.getServiceClass())) continue;
            it.remove();
        }
        return new ListView<AdminPagePanelInfo>(id, panels){

            protected void populateItem(ListItem<AdminPagePanelInfo> item) {
                AdminPagePanelInfo info = (AdminPagePanelInfo)item.getModelObject();
                try {
                    AdminPagePanel panel = (AdminPagePanel)((Object)info.getComponentClass().getConstructor(String.class, IModel.class).newInstance("content", infoModel));
                    item.add(new Component[]{panel});
                }
                catch (Exception e) {
                    throw new WicketRuntimeException("Failed to create admin extension panel of type " + info.getComponentClass().getSimpleName(), (Throwable)e);
                }
            }
        };
    }

    protected abstract Class<T> getServiceClass();

    protected abstract void build(IModel var1, Form var2);

    protected void handleSubmit(T info) {
        this.getGeoServer().save(info);
    }

    protected abstract String getServiceName();
}

