/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.data.store.panel;

import java.io.File;
import java.io.FileFilter;
import java.io.Serializable;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.form.AjaxSubmitLink;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.form.validation.FormComponentFeedbackBorder;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.validation.IValidator;
import org.geoserver.web.data.store.panel.FileModel;
import org.geoserver.web.wicket.browser.GeoServerFileChooser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileParamPanel
extends Panel {
    TextField textField;
    ModalWindow dialog;
    IModel<? extends FileFilter> fileFilter;

    public FileParamPanel(String id, IModel paramValue, IModel paramLabelModel, boolean required, IValidator ... validators) {
        super(id, paramValue);
        Component[] componentArray = new Component[1];
        this.dialog = new ModalWindow("dialog");
        componentArray[0] = this.dialog;
        this.add(componentArray);
        String requiredMark = required ? " *" : "";
        Label label = new Label("paramName", paramLabelModel.getObject() + requiredMark);
        this.add(new Component[]{label});
        this.textField = new TextField("paramValue", (IModel)new FileModel(paramValue));
        this.textField.setRequired(required);
        this.textField.setOutputMarkupId(true);
        this.textField.setLabel(paramLabelModel);
        if (validators != null) {
            for (IValidator validator : validators) {
                this.textField.add(validator);
            }
        }
        FormComponentFeedbackBorder feedback = new FormComponentFeedbackBorder("border");
        feedback.add(new Component[]{this.textField});
        feedback.add(new Component[]{this.chooserButton((String)paramLabelModel.getObject())});
        this.add(new Component[]{feedback});
    }

    protected Component chooserButton(final String windowTitle) {
        AjaxSubmitLink link = new AjaxSubmitLink("chooser"){

            public boolean getDefaultFormProcessing() {
                return false;
            }

            public void onSubmit(AjaxRequestTarget target, Form form) {
                File file = null;
                FileParamPanel.this.textField.processInput();
                String input = (String)FileParamPanel.this.textField.getConvertedInput();
                if (input != null && !input.equals("")) {
                    file = new File(input);
                }
                GeoServerFileChooser chooser = new GeoServerFileChooser(FileParamPanel.this.dialog.getContentId(), (IModel)new Model((Serializable)file)){

                    protected void fileClicked(File file, AjaxRequestTarget target) {
                        FileParamPanel.this.textField.clearInput();
                        FileParamPanel.this.textField.setModelObject((Object)file.getAbsolutePath());
                        target.addComponent((Component)FileParamPanel.this.textField);
                        FileParamPanel.this.dialog.close(target);
                    }
                };
                chooser.setFileTableHeight(null);
                chooser.setFilter(FileParamPanel.this.fileFilter);
                FileParamPanel.this.dialog.setContent((Component)chooser);
                FileParamPanel.this.dialog.setTitle(windowTitle);
                FileParamPanel.this.dialog.show(target);
            }
        };
        return link;
    }

    public FormComponent getFormComponent() {
        return this.textField;
    }

    public void setFileFilter(IModel<? extends FileFilter> fileFilter) {
        this.fileFilter = fileFilter;
    }
}

