/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.data.store;

import java.io.IOException;
import java.io.Serializable;
import java.util.logging.Logger;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.OnChangeAjaxBehavior;
import org.apache.wicket.ajax.markup.html.form.AjaxSubmitLink;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.validation.IFormValidator;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.markup.html.panel.FeedbackPanel;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.validation.IValidator;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.catalog.ResourcePool;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.web.GeoServerApplication;
import org.geoserver.web.GeoServerSecuredPage;
import org.geoserver.web.data.store.StoreEditPanel;
import org.geoserver.web.data.store.StoreExtensionPoints;
import org.geoserver.web.data.store.StoreNameValidator;
import org.geoserver.web.data.store.StorePage;
import org.geoserver.web.data.store.panel.CheckBoxParamPanel;
import org.geoserver.web.data.store.panel.NamespacePanel;
import org.geoserver.web.data.store.panel.TextParamPanel;
import org.geoserver.web.data.store.panel.WorkspacePanel;
import org.geotools.data.DataAccessFactory;
import org.geotools.util.logging.Logging;

abstract class AbstractDataAccessPage
extends GeoServerSecuredPage {
    protected static final Logger LOGGER = Logging.getLogger((String)"org.geoserver.web.data.store");
    protected WorkspacePanel workspacePanel;
    private NamespacePanel namespacePanel;

    protected void initUI(DataStoreInfo storeInfo) throws IllegalArgumentException {
        DataAccessFactory dsFactory;
        if (storeInfo.getWorkspace() == null) {
            throw new IllegalArgumentException("Workspace not provided");
        }
        Catalog catalog = this.getCatalog();
        ResourcePool resourcePool = catalog.getResourcePool();
        try {
            dsFactory = resourcePool.getDataStoreFactory(storeInfo);
        }
        catch (IOException e) {
            String msg = new ResourceModel("AbstractDataAccessPage.cantGetDataStoreFactory").getObject();
            msg = msg + ": " + e.getMessage();
            throw new IllegalArgumentException(msg);
        }
        if (dsFactory == null) {
            String msg = new ResourceModel("AbstractDataAccessPage.cantGetDataStoreFactory").getObject();
            throw new IllegalArgumentException(msg);
        }
        CompoundPropertyModel model = new CompoundPropertyModel((Object)storeInfo);
        final Form paramsForm = new Form("dataStoreForm", (IModel)model);
        this.add(new Component[]{paramsForm});
        paramsForm.add(new Component[]{new Label("storeType", dsFactory.getDisplayName())});
        paramsForm.add(new Component[]{new Label("storeTypeDescription", dsFactory.getDescription())});
        PropertyModel wsModel = new PropertyModel((Object)model, "workspace");
        ResourceModel wsLabelModel = new ResourceModel("AbstractDataAccessPage.workspace");
        this.workspacePanel = new WorkspacePanel("workspacePanel", (IModel)wsModel, (IModel)wsLabelModel, true);
        paramsForm.add(new Component[]{this.workspacePanel});
        TextParamPanel dataStoreNamePanel = new TextParamPanel("dataStoreNamePanel", (IModel)new PropertyModel((Object)model, "name"), (IModel)new ResourceModel("AbstractDataAccessPage.dataSrcName", "Data Source Name"), true, new IValidator[0]);
        paramsForm.add(new Component[]{dataStoreNamePanel});
        paramsForm.add(new Component[]{new TextParamPanel("dataStoreDescriptionPanel", (IModel)new PropertyModel((Object)model, "description"), (IModel)new ResourceModel("description", "Description"), false, null)});
        paramsForm.add(new Component[]{new CheckBoxParamPanel("dataStoreEnabledPanel", (IModel)new PropertyModel((Object)model, "enabled"), (IModel)new ResourceModel("enabled", "Enabled"))});
        GeoServerApplication app = this.getGeoServerApplication();
        StoreEditPanel storeEditPanel = StoreExtensionPoints.getStoreEditPanel("parametersPanel", paramsForm, (StoreInfo)storeInfo, app);
        paramsForm.add(new Component[]{storeEditPanel});
        paramsForm.add(new Component[]{new FeedbackPanel("feedback")});
        String dataStoreInfoId = storeInfo.getId();
        StoreNameValidator storeNameValidator = new StoreNameValidator(this.workspacePanel.getFormComponent(), dataStoreNamePanel.getFormComponent(), dataStoreInfoId);
        paramsForm.add((IFormValidator)storeNameValidator);
        paramsForm.add(new Component[]{new BookmarkablePageLink("cancel", StorePage.class)});
        paramsForm.add(new Component[]{new AjaxSubmitLink("save", paramsForm){
            private static final long serialVersionUID = 1L;

            protected void onError(AjaxRequestTarget target, Form form) {
                super.onError(target, form);
                target.addComponent((Component)paramsForm);
            }

            protected void onSubmit(AjaxRequestTarget target, Form form) {
                try {
                    DataStoreInfo dataStore = (DataStoreInfo)form.getModelObject();
                    AbstractDataAccessPage.this.onSaveDataStore(dataStore, target);
                }
                catch (IllegalArgumentException e) {
                    paramsForm.error((Serializable)((Object)e.getMessage()));
                    target.addComponent((Component)paramsForm);
                }
            }
        }});
        this.makeNamespaceSyncUpWithWorkspace();
    }

    protected abstract void onSaveDataStore(DataStoreInfo var1, AjaxRequestTarget var2) throws IllegalArgumentException;

    private void makeNamespaceSyncUpWithWorkspace() {
        final DropDownChoice wsDropDown = (DropDownChoice)this.workspacePanel.getFormComponent();
        wsDropDown.add(new IBehavior[]{new OnChangeAjaxBehavior(){
            private static final long serialVersionUID = 1L;

            protected void onUpdate(AjaxRequestTarget target) {
                if (AbstractDataAccessPage.this.namespacePanel == null) {
                    Component paramsPanel = AbstractDataAccessPage.this.get("dataStoreForm:parametersPanel");
                    AbstractDataAccessPage.this.namespacePanel = AbstractDataAccessPage.this.findNamespacePanel((MarkupContainer)paramsPanel);
                    if (AbstractDataAccessPage.this.namespacePanel == null) {
                        return;
                    }
                }
                WorkspaceInfo ws = (WorkspaceInfo)wsDropDown.getModelObject();
                String prefix = ws.getName();
                NamespaceInfo namespaceInfo = AbstractDataAccessPage.this.getCatalog().getNamespaceByPrefix(prefix);
                AbstractDataAccessPage.this.namespacePanel.setDefaultModelObject(namespaceInfo);
                target.addComponent(AbstractDataAccessPage.this.namespacePanel.getFormComponent());
            }
        }});
    }

    private NamespacePanel findNamespacePanel(MarkupContainer c) {
        for (Component child : c) {
            NamespacePanel panel;
            if (child instanceof NamespacePanel) {
                return (NamespacePanel)child;
            }
            if (!(child instanceof MarkupContainer) || (panel = this.findNamespacePanel((MarkupContainer)child)) == null) continue;
            return panel;
        }
        return null;
    }

    protected void clone(DataStoreInfo source, DataStoreInfo target) {
        target.setDescription(source.getDescription());
        target.setEnabled(source.isEnabled());
        target.setName(source.getName());
        target.setWorkspace(source.getWorkspace());
        target.setType(source.getType());
        target.getConnectionParameters().clear();
        target.getConnectionParameters().putAll(source.getConnectionParameters());
    }
}

