/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.data.layer;

import java.io.IOException;
import java.io.Serializable;
import java.util.logging.Level;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.web.data.layer.SQLViewAbstractPage;
import org.geoserver.web.data.resource.ResourceConfigurationPage;
import org.geoserver.web.wicket.ParamResourceModel;
import org.geotools.jdbc.VirtualTable;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class SQLViewEditPage
extends SQLViewAbstractPage {
    ResourceConfigurationPage previusPage;
    String originalName;
    FeatureTypeInfo tinfo;

    public SQLViewEditPage(FeatureTypeInfo type, ResourceConfigurationPage previousPage) throws IOException {
        super(type.getStore().getWorkspace().getName(), type.getStore().getName(), type.getName(), (VirtualTable)type.getMetadata().get("JDBC_VIRTUAL_TABLE", VirtualTable.class));
        VirtualTable vt = (VirtualTable)type.getMetadata().get("JDBC_VIRTUAL_TABLE", VirtualTable.class);
        this.tinfo = type;
        this.originalName = vt.getName();
        this.previusPage = previousPage;
    }

    protected void onSave() {
        try {
            VirtualTable vt = this.buildVirtualTable();
            SimpleFeatureType rawFeatureType = this.getFeatureType(vt);
            this.tinfo.getMetadata().put("JDBC_VIRTUAL_TABLE", (Serializable)vt);
            CoordinateReferenceSystem crs = rawFeatureType.getCoordinateReferenceSystem();
            if (crs != null) {
                this.tinfo.setNativeCRS(crs);
            }
            this.tinfo.setNativeName(vt.getName());
            this.previusPage.updateResource((ResourceInfo)this.tinfo);
            this.setResponsePage((Page)this.previusPage);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Failed to create feature type", e);
            this.error((Serializable)((Object)new ParamResourceModel("creationFailure", (Component)this, this.getFirstErrorMessage(e)).getString()));
        }
    }

    protected void onCancel() {
        this.setResponsePage((Page)this.previusPage);
    }
}

