/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.admin;

import java.util.Arrays;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.form.Button;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.StringResourceModel;
import org.apache.wicket.validation.IValidator;
import org.apache.wicket.validation.validator.MinimumValidator;
import org.geoserver.config.CoverageAccessInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.web.GeoServerHomePage;
import org.geoserver.web.admin.ServerAdminPage;

public class CoverageAccessPage
extends ServerAdminPage {
    public CoverageAccessPage() {
        final IModel geoServerModel = this.getGeoServerModel();
        final IModel coverageModel = this.getCoverageAccessModel();
        Form form = new Form("form", (IModel)new CompoundPropertyModel((Object)coverageModel));
        this.add(new Component[]{form});
        TextField corePoolSize = new TextField("corePoolSize");
        corePoolSize.add((IValidator)new MinimumValidator((Comparable)Integer.valueOf(1)));
        form.add(new Component[]{corePoolSize});
        TextField maxPoolSize = new TextField("maxPoolSize");
        maxPoolSize.add((IValidator)new MinimumValidator((Comparable)Integer.valueOf(1)));
        form.add(new Component[]{maxPoolSize});
        TextField keepAliveTime = new TextField("keepAliveTime");
        keepAliveTime.add((IValidator)new MinimumValidator((Comparable)Integer.valueOf(1)));
        form.add(new Component[]{keepAliveTime});
        DropDownChoice queueType = new DropDownChoice("queueType", Arrays.asList(CoverageAccessInfo.QueueType.values()), (IChoiceRenderer)new QueueTypeRenderer());
        form.add(new Component[]{queueType});
        TextField imageIOCacheThreshold = new TextField("imageIOCacheThreshold");
        imageIOCacheThreshold.add((IValidator)new MinimumValidator((Comparable)Long.valueOf(0L)));
        form.add(new Component[]{imageIOCacheThreshold});
        Button submit = new Button("submit", (IModel)new StringResourceModel("submit", (Component)this, null)){

            public void onSubmit() {
                GeoServer gs = (GeoServer)geoServerModel.getObject();
                gs.getGlobal().setCoverageAccess((CoverageAccessInfo)coverageModel.getObject());
                gs.save(gs.getGlobal());
                this.setResponsePage(GeoServerHomePage.class);
            }
        };
        form.add(new Component[]{submit});
        Button cancel = new Button("cancel"){

            public void onSubmit() {
                this.setResponsePage(GeoServerHomePage.class);
            }
        };
        form.add(new Component[]{cancel});
    }

    private class QueueTypeRenderer
    implements IChoiceRenderer {
        private QueueTypeRenderer() {
        }

        public Object getDisplayValue(Object object) {
            return new StringResourceModel(((CoverageAccessInfo.QueueType)object).name(), (Component)CoverageAccessPage.this, null).getString();
        }

        public String getIdValue(Object object, int index) {
            return ((CoverageAccessInfo.QueueType)object).name();
        }
    }
}

