/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.wicket.protocol.http.WebRequest;
import org.geoserver.web.DefaultPageAuthorizer;
import org.geoserver.web.GeoServerBasePage;
import org.geoserver.web.GeoServerLoginPage;
import org.geoserver.web.PageAuthorizer;
import org.geoserver.web.UnauthorizedPage;
import org.springframework.security.Authentication;
import org.springframework.security.providers.anonymous.AnonymousAuthenticationToken;
import org.springframework.security.ui.ExceptionTranslationFilter;
import org.springframework.security.ui.savedrequest.SavedRequest;

public class GeoServerSecuredPage
extends GeoServerBasePage {
    public static final PageAuthorizer DEFAULT_AUTHORIZER = new DefaultPageAuthorizer();

    public GeoServerSecuredPage() {
        Authentication auth = this.getSession().getAuthentication();
        if (auth == null || !auth.isAuthenticated() || auth instanceof AnonymousAuthenticationToken) {
            HttpServletRequest httpRequest = ((WebRequest)this.getRequest()).getHttpServletRequest();
            ExceptionTranslationFilter translator = (ExceptionTranslationFilter)this.getGeoServerApplication().getBean("consoleExceptionTranslationFilter");
            SavedRequest savedRequest = new SavedRequest(httpRequest, translator.getPortResolver());
            HttpSession session = httpRequest.getSession();
            session.setAttribute("SPRING_SECURITY_SAVED_REQUEST_KEY", (Object)savedRequest);
            this.setResponsePage(GeoServerLoginPage.class);
        } else if (!this.getPageAuthorizer().isAccessAllowed(((Object)((Object)this)).getClass(), auth)) {
            this.setResponsePage(UnauthorizedPage.class);
        }
    }

    protected PageAuthorizer getPageAuthorizer() {
        return DEFAULT_AUTHORIZER;
    }
}

