/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.validation.attributes;

import java.util.HashMap;
import java.util.Map;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.validation.DefaultIntegrityValidation;
import org.geotools.validation.ValidationResults;
import org.opengis.feature.simple.SimpleFeature;

public class UniqueFIDValidation
extends DefaultIntegrityValidation {
    String typeRef;

    public int getPriority() {
        return 10;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean validate(Map layers, ReferencedEnvelope envelope, ValidationResults results) throws Exception {
        HashMap<String, String> FIDs = new HashMap<String, String>();
        boolean result = true;
        for (SimpleFeatureSource featureSource : layers.values()) {
            SimpleFeatureIterator features = featureSource.getFeatures().features();
            try {
                while (features.hasNext()) {
                    SimpleFeature feature = (SimpleFeature)features.next();
                    String fid = feature.getID();
                    if (FIDs.containsKey(fid)) {
                        results.error(feature, "FID already exists.");
                        result = false;
                        continue;
                    }
                    FIDs.put(fid, fid);
                }
            }
            finally {
                features.close();
            }
        }
        return result;
    }

    public String[] getTypeRefs() {
        if (this.typeRef == null) {
            return null;
        }
        if (this.typeRef.equals("*")) {
            return new String[0];
        }
        return new String[]{this.typeRef};
    }

    public String getTypeRef() {
        return this.typeRef;
    }

    public void setTypeRef(String typeRef) {
        this.typeRef = typeRef;
    }
}

